//
//  file_std.hpp
//
//  Copyright 2018 Franco Milicchio and Marco Oliva. All rights reserved.
//

#ifndef file_std_hpp
#define file_std_hpp

#include <fstream>
#include <mutex>

#include "file.hpp"


namespace libseq {
    
    class file_std : public file<file_std>
    {
    
    public:
        
        /// Actual name of the class
        static constexpr char name_[] = "file_std";
        
        /// Construct a memory mapped file
        file_std(path& p);
        
        /// Append a value to this file
        template <typename storage_type>
        void append_(storage_type& s) {
            // loking the mutex in this scope
            std::lock_guard<std::mutex> lock(write_mutex_);
    
            file_.write((char*) &s, sizeof(storage_type));
        }
        
        /// Flush changes to disk
        void close_();
    
    private:
        
        /// C standard fstream, wb
        std::ofstream file_;
        
        /// Actual file path
        path file_path_;
        
        /// Mutex for thread safe write
        std::mutex write_mutex_;
        
    };
    
}


#endif //file_std_hpp
