//
//  file_mmap.cpp
//
//  Copyright 2018 Franco Milicchio and Marco Oliva. All rights reserved.
//


#include <fstream>
#include <system_error>

#include "file_mmap.hpp"

using namespace libseq;

/// Forward declaration of platform-dependent code
void touch_file(const path& file_path);
int  truncate_file(const path& file_path, std::size_t size);


////////////////////////////////////////////////////////////////////////////////
file_mmap::file_mmap(path& file_path) : file_path_(file_path), byte_index_(0)
{
    touch_file(file_path_.absolute_path());
    truncate_file(file_path_.absolute_path(), 100000000);
    
    std::error_code error;
    mmap_ = mio::make_mmap_sink(file_path_.absolute_path(), error);
    if (error)
        throw std::runtime_error("Cannot open " + file_path_.absolute_path());
    size_ = mmap_.size();
}

////////////////////////////////////////////////////////////////////////////////
void file_mmap::close_()
{
    std::error_code error;
    mmap_.sync(error);
    if (error)
        throw std::runtime_error("Cannot sync " + file_path_.absolute_path());
    
    truncate_file(file_path_.absolute_path(), byte_index_);  //qui serve lo storage_type
}


////////////////////////////////////////////////////////////////////////////////
// PLATFORM DEPENDANT CODE /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

#ifdef __APPLE__

#include <unistd.h>
#include <sys/types.h>

void touch_file(const path& file_path)
{
    std::fstream fs;
    fs.open(file_path.absolute_path(), std::ios::out);
    fs.close();
}

int truncate_file(const path& file_path, std::size_t size)
{
    return ::truncate(file_path.absolute_path().c_str(), size);
}

#endif

