//
//  accelerator_string.hpp
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//


#ifndef accelerator_string_hpp
#define accelerator_string_hpp

#include <string>
#include <string_view>
#include <unordered_map>
#include <algorithm>

#include "accelerator.hpp"

namespace libseq
{
    
    class accelerator_string : public accelerator<accelerator_string, std::string>
    {
    
    public:
        
        /// Actual name of the class
        static constexpr char name_[] = "accelerator_string";
        
        /// Storage type
        using storage_type = std::string;
    
        
        /// Build the implemented representation of a kmer from a string
        storage_type to_forward(const std::string_view &s) const
        {
            return std::string(s);
        }
        
        /// Build a string from the implemented representation of a kmer
        std::string to_string(const storage_type& r, const std::size_t k) const
        {
            return r.substr(0, k);
        }
        
        /// Return the hash value of a kmer
        std::size_t hash(const storage_type& r) const
        {
            return std::hash<std::string>()(r);
        }
                
        /// Compare 2 k-mers, lexicographically
        int compare(const storage_type r, const storage_type s) const
        {
            return true;
        }
        
        /// Equal
        bool equal(const storage_type r, const storage_type s) const
        {
            return true;
        }
        
        
    };
    
}

#endif //accelerator_string_hpp
