/*!
 *  \file sequence.cpp
 *
 *  \brief THIS IS A TEST FILE. PLEASE DISCARD ANYTHING HERE.
 *
 *  \copyright Copyright (c) 2013 Franco "Sensei" Milicchio. All rights reserved.
 *
 *  \license BSD Licensed.
 */

#include <iostream>
#include <chrono>
#include <fstream>
#include <algorithm>
#include <typeinfo>
#include <atomic>
#include <functional>
#include <locale>
//#include <map>
#include <random>
#include <iomanip>

#include <boost/program_options.hpp>
#include <tbb/task_scheduler_init.h>

#include <tbb/flow_graph.h>
#include <tbb/pipeline.h>
#include <tbb/concurrent_queue.h>
#include <tbb/task_group.h>
#include <tbb/concurrent_unordered_map.h>

#include "libseq/veboas.h"
#include "libseq/ofmpm.h"

//! \brief Shorthand namespace
namespace po = boost::program_options;

//! \brief Automatic thread number
const int n_threads  = tbb::task_scheduler_init::automatic;

//! \brief Current program name
const char* prg_name = "sequence";

//! \brief Program options: help
const char* opt_help = "help";

class couple
{
public:
    std::size_t kmer;
    
    std::size_t count;
};

class maptocouple
{
public:
    typedef std::pair<std::size_t, std::size_t> from_type;
    
    typedef couple to_type;
    
    static to_type convert(from_type v)
    {
        return couple { v.first, v.second };
    }
    
    static bool is_occupied(to_type v)
    {
        return v.count != 0xFFFFFFFF;
    }
    
    static void mark_empty(to_type &v)
    {
        v.count = v.kmer = 0xFFFFFFFF;
    }

    static std::string fromtype_string(from_type v)
    {
        return "(" + std::to_string(v.first) + "," + std::to_string(v.second) + ")";
    }
    
    static std::string totype_string(to_type v)
    {
        if (!is_occupied(v))
        {
            return "/";
        }
        else
        {
            return "(" + std::to_string(v.kmer) + "," + std::to_string(v.count) + ")";
        }
    }
};

class vectortocouple
{
public:
    typedef std::size_t from_type;
    
    typedef couple to_type;
    
    static to_type convert(from_type v)
    {
        return couple { v, v };
    }
    
    static bool is_occupied(to_type v)
    {
        return v.count != 0xFFFFFFFF;
    }
    
    static void mark_empty(to_type &v)
    {
        v.count = v.kmer = 0xFFFFFFFF;
    }
    
    static std::string fromtype_string(from_type v)
    {
        return "(" + std::to_string(v) + "," + std::to_string(v) + ")";
    }
    
    static std::string totype_string(to_type v)
    {
        if (!is_occupied(v))
        {
            return "/";
        }
        else
        {
            return "(" + std::to_string(v.kmer) + "," + std::to_string(v.count) + ")";
        }
    }
};

int main(int argc, char *argv[])
{
    std::size_t i = 0, n = std::atoi(argv[1]);

    std::vector<std::size_t> m(n);
    
    while (i++ < n)
        m[i] = i;
    
    std::cout << "INITIAL SIZE " << m.size() << std::endl;
    for (auto p : m)
        std::cout << "> map: " << p << std::endl;
    
    seq::details::ofmpm<couple, vectortocouple> p(m, 1);
    
    return 0;
    
}

