/*!
 *  \file visitor.h
 *
 *  \copyright Copyright (c) 2014 Franco "Sensei" Milicchio. All rights reserved.
 *
 *  \license BSD Licensed.
 */

#ifndef sequence_visitor_h
#define sequence_visitor_h

#error DO NOT INCLUDE THIS FILE --- IT IS VESTIGIAL

#include <type_traits>
#include <iostream>

namespace seq
{
    /*
     * A file visitor traits class. A file visitor could implement some event
     * visitor functions such as:
     *   - <tt>file_open</tt>, called when the file has been successfully opened
     *   - <tt>read_available</tt>, when a DNA sequence read has been retrieved
     *   - <tt>file_close</tt>, when the file is about to be closed
     *
     * This traits class provides the above functions with an empty body, or call the
     * code of the provided class if it matches the supplied parameters.
     *
     * \verbatim
     *     // Call open_file if present as <tt>void open_file(int)</tt>
     *     seq::visitor_traits<decltype(it_does)>::open_file(it_does, 4321);
     *     // Call read_available if present as <tt>void open_file(int)</tt>
     *     seq::visitor_traits<decltype(it_does)>::read_available(it_does, "fuck");
     *     // Call open_file if present as <tt>void open_file(int)</tt>
     *     seq::visitor_traits<decltype(it_does)>::close_file(it_does);
     * \endverbatim
     */
    template <class Type>
    class visitor_traits
    {
        //! Implements a type for "true"
        typedef struct { char value;    } true_class;
        //! Implements a type for "false"
        typedef struct { char value[2]; } false_class;
        
        //! This handy macro generates actual SFINAE class members for checking and executing event callbacks
#define MAKE_EVENT(FUNCTION) \
    private: \
        \
        template <typename T, typename... Args> \
        static auto call_##FUNCTION(T&& t, int, Args&&... args) -> decltype(void(std::forward<T>(t).FUNCTION(std::forward<Args>(args)...))) \
        { \
            std::forward<T>(t).FUNCTION(std::forward<Args>(args)...); \
        } \
        \
        template <typename T, typename... Args> \
        static void call_##FUNCTION(T&& t, void*, Args&&... args) \
        { \
            std::cout << "NOP" << std::endl; \
        } \
        \
        template <class T> \
        static true_class has_##FUNCTION(decltype(&T::FUNCTION)); \
        \
        template <class T> \
        static false_class has_##FUNCTION(...); \
        \
    public: \
        template <typename T, typename... Args> \
        static void FUNCTION(T&& t, Args&&... args) \
        { \
            call_##FUNCTION(std::forward<T>(t), 0, std::forward<Args>(args)...); \
        } \
        \
        static constexpr bool can_call_##FUNCTION = sizeof(has_##FUNCTION<Type>(0)) == sizeof(true_class);
        
        MAKE_EVENT(open_file)
        MAKE_EVENT(read_available)
        MAKE_EVENT(close_file)
        
    };
    
    
    class does_match
    {
    public:
        void open_file(int i) const { std::cout << "DOES OPEN i = " << i << std::endl; };
        void read_available(std::string r) const { std::cout << "DOES READ r = " << r << std::endl; };
        void close_file() const { std::cout << "DOES CLOSE" << std::endl; };
    };
    
    class doesnt_match
    {
    public:
        void open_file(std::string i) const { std::cout << "DOESNT OPEN i = " << i << std::endl; };
        void read_available(float r) const { std::cout << "DOESNT READ r = " << r << std::endl; };
        void close_file() const { std::cout << "DOESNT CLOSE" << std::endl; };
    };
    
}



#endif
