//
//  parser.hpp
//  sequence
//
//  Created by Sensei on 9/24/15.
//  Copyright © 2015 Franco "Sensei" Milicchio. All rights reserved.
//

#ifndef dbparser_hpp
#define dbparser_hpp

#include <string>
#include <memory>

#include "lmf_graph.hpp"

#include "../libseqdb/seqdb.h"
#include "../libseqdb/h5seqdb.h"

class dbparser
{
public:
    
    dbparser(const std::string &f);
    
    void parse(lmf_graph &g);
    
private:
    
    //! \brief File name of the SeqDB archive
    std::string filename_;
    
    //! \brief Actual SeqDB archive
    std::unique_ptr<SeqDB> db_;
};

#endif /* parser_hpp */

