# Gallery

Collection of cool movies!

## [Deep convection](https://www.youtube.com/watch?v=kpUrxnKKMjI)

An idealized simulation of deep convection in the ocean. The simulation employs a resolution of 256x256x128 volumes in
a 2x2x1 km horizontally periodic domain. Heat is sucked out of the ocean surface within a cooling disk of radius 600 m
at a rate of 800 W/m² which cools the surface water and making it denser. This cold dense water then sinks into the
ocean interior, initiating a convective process that penetrates deep into the ocean.

This deep convection process can happen when a cold storm passes through warmer waters, which happens for example in
the Labrador Sea.

The video shows the temperature field and the domain is sliced in half so the convection happening under the cooling
disk is clear.

[![Watch deep convection in action](https://raw.githubusercontent.com/ali-ramadhan/ali-ramadhan.Github.io/master/img/surface_temp_3d_00130_halfsize.png)](https://www.youtube.com/watch?v=kpUrxnKKMjI)


## [Free convection](https://www.youtube.com/watch?v=yq4op9h3xcU)

An idealized simulation of free convection in the ocean. The simulation employs a resolution of 256x256x256 volumes in
a 100x100x100 m horizontally periodic domain. Heat is sucked out of the ocean surface at a rate of 75 W/m² which cools
the surface water and making it denser. This cold dense water then sinks into the ocean interior, initiating a
convective process that keeps mixing the upper layer of the ocean. This "mixed layer" has a relatively constant
temperature and keeps deepening as the surface is cooled.

The video shows the temperature field and the domain is sliced in half.

[![Watch free convection in action](https://raw.githubusercontent.com/ali-ramadhan/ali-ramadhan.Github.io/master/img/free_convection_0956.png)](https://www.youtube.com/watch?v=yq4op9h3xcU)


## [Winds blowing over the ocean](https://www.youtube.com/watch?v=IRncfbvuiy8)

An idealized simulation of a strong wind stress acting on the surface of a stratified ocean. The simulation employs a
resolution of 256x256x256 volumes in a 100x100x100 m horizontally periodic domain. A pretty strong wind stress of
0.1 N/m² is applied in the x direction which mechanically mixes the upper layer of the ocean. This leads to a "mixed
layer" of constant temperature near the surface of the ocean. You can also see the onset of Kelvin-Helmholtz
instabilities as the mechanical mixing sets in.

The video shows the temperature field in the top 25 meters and the domain is sliced in half for visualization. The line
plots show the horizontally averaged temperature profile (top right), horizontally averaged turbulent kinetic energy
(middle right), and the horizontally averaged buoyancy flux (or temperature flux).

[![Watch winds blowing over the ocean](https://raw.githubusercontent.com/ali-ramadhan/ali-ramadhan.Github.io/master/img/wind_stress_0400.png)](https://www.youtube.com/watch?v=IRncfbvuiy8)


## [Free convection with wind stress](https://www.youtube.com/watch?v=ob6OMQgPfI4)

An idealized simulation of a strong wind stress acting on the surface of a stratified ocean along with a cooling flux
that sucks heat out of the surface. The simulation employs a resolution of 256x256x256 volumes in a 100x100x100 m
horizontally periodic domain. A pretty strong wind stress of 0.1 N/m² is applied in the x direction which mechanically
mixes the upper layer of the ocean. Also, heat is sucked out of the ocean surface at a rate of 75 W/m² which cools the
surface water and making it denser. This cold dense water then sinks into the ocean interior, initiating a convective
process that keeps mixing the upper layer of the ocean. This leads to a "mixed layer" of constant temperature near the
surface of the ocean. You can also see the onset of Kelvin-Helmholtz instabilities as the mechanical mixing sets in.

The video shows the temperature field and the domain is sliced in half for visualization. The line plots show the
horizontally averaged temperature profile (top right), horizontally averaged turbulent kinetic energy (middle right),
and the horizontally averaged buoyancy flux (or temperature flux). The unusual periodic prism colormap is used to show
the fine details at the surface as it cools and the layers of different temperatures (the isopycnals) being perturbed
by internal waves.

[![Watch free convection with wind stress in action](https://raw.githubusercontent.com/ali-ramadhan/ali-ramadhan.Github.io/master/img/wind_stress_unstable_7500.png)](https://www.youtube.com/watch?v=ob6OMQgPfI4)

