import geopandas as gpd 
import matplotlib.pyplot as plt
import yaml

poly_gpkg = "../shps/polygons/study_polygons.gpkg"

ndirande_pol = gpd.read_file(poly_gpkg, layer='ndirande')
chileka_pol = gpd.read_file(poly_gpkg, layer='chileka')
chikwawa_pol = gpd.read_file(poly_gpkg, layer='chikwawa')

# Process Chikwawa

chikwawa_buildings = gpd.read_file("osm_api_buildings_sites_raw/malawi_buildings.gpkg", layer='chikwawa', driver="GPKG")
chikwawa_buildings = chikwawa_buildings.to_crs(3857) # for area calc

chikwawa_buildings = chikwawa_buildings[chikwawa_buildings['building'].isin(['yes', 'residential', 'hut'])] # drop: school, church, office, collapsed
chikwawa_buildings = chikwawa_buildings[chikwawa_buildings['landuse'].isna()] # drop: livestock
chikwawa_buildings = chikwawa_buildings[chikwawa_buildings['amenity'].isna()] # drop: toilets
chikwawa_buildings = chikwawa_buildings[chikwawa_buildings['leisure'].isna()] # drop: pitch, playground
chikwawa_buildings = chikwawa_buildings[chikwawa_buildings['shop'].isna()] # drop: kitchen, confectionery, convenience
chikwawa_buildings['area'] = chikwawa_buildings['geometry'].area

# for col in chikwawa_buildings.columns:
#     if col != 'geometry':
#         print('------------')
#         print(col)
#         print('------------')
#         print(chikwawa_buildings[col].value_counts())

new_cols = ['building', 'area', 'geometry']   

chikwawa_buildings = chikwawa_buildings[new_cols]

chikwawa_buildings['geometry'] = chikwawa_buildings.centroid
# chikwawa_buildings.plot()
# plt.show()

chikwawa_buildings = chikwawa_buildings.to_crs(4326) # back to match poly

chikwawa_buildings.to_file("osm_api_houses_sites_point_filter/malawi_buildings_filter.gpkg", layer='chikwawa', driver="GPKG")
chikwawa_buildings.to_csv('osm_api_houses_sites_point_filter/chikwawa_buildings_filter.csv')

fig, ax = plt.subplots(1, figsize=(7,9), tight_layout=True, dpi=300)
chikwawa_buildings.plot(ax=ax, facecolor=[0,0,0,0], edgecolor=[0,0,0,1], alpha=0.5, markersize=1)
chikwawa_pol.plot(ax=ax, facecolor=[0,0,0,0], edgecolor=[0,0,0,1])
fig.suptitle("OSM Filtered Polygons, Represented as Points - Chikwawa")
fig.savefig('osm_api_houses_sites_point_filter/chikwawa_filtered_polys.pdf', dpi=300)
plt.close()

print('Done Chikwawa')

# Process Chileka

chileka_buildings = gpd.read_file("osm_api_buildings_sites_raw/malawi_buildings.gpkg", layer='chileka', driver="GPKG")
chileka_buildings = chileka_buildings.to_crs(3857) # for area calc

chileka_buildings = chileka_buildings[chileka_buildings['building'].isin(['yes', 'construction'])] # drop: shed, terrace, industrial
chileka_buildings = chileka_buildings[chileka_buildings['amenity'].isna()] # drop: place_of_worship
chileka_buildings = chileka_buildings[chileka_buildings['shop'].isna()] # drop: butcher
chileka_buildings = chileka_buildings[chileka_buildings['type'].isna()] # drop: multipolygon
chileka_buildings['area'] = chileka_buildings['geometry'].area

# for col in chileka_buildings.columns:
#     if col != 'geometry':
#         print('------------')
#         print(col)
#         print('------------')
#         print(chileka_buildings[col].value_counts())

new_cols = ['building', 'area', 'geometry']   

chileka_buildings = chileka_buildings[new_cols]

chileka_buildings['geometry'] = chileka_buildings.centroid
# chileka_buildings.plot()
# plt.show()

chileka_buildings = chileka_buildings.to_crs(4326) # back to match poly

chileka_buildings.to_file("osm_api_houses_sites_point_filter/malawi_buildings_filter.gpkg", layer='chileka', driver="GPKG")
chileka_buildings.to_csv('osm_api_houses_sites_point_filter/chileka_buildings_filter.csv')

fig, ax = plt.subplots(1, figsize=(7,9), tight_layout=True, dpi=300)
chileka_buildings.plot(ax=ax, facecolor=[0,0,0,0], edgecolor=[0,0,0,1], alpha=0.5, markersize=1)
chileka_pol.plot(ax=ax, facecolor=[0,0,0,0], edgecolor=[0,0,0,1])
fig.suptitle("OSM Filtered Polygons, Represented as Points - Chileka")
fig.savefig('osm_api_houses_sites_point_filter/chileka_filtered_polys.pdf', dpi=300)
plt.close()

print('Done Chileka')

# Process Ndirande

ndirande_buildings = gpd.read_file("osm_api_buildings_sites_raw/malawi_buildings.gpkg", layer='ndirande', driver="GPKG")
ndirande_buildings = ndirande_buildings.to_crs(3857) # for area calc

ndirande_buildings = ndirande_buildings[ndirande_buildings['building'].isin(['yes', 'house', 'construction', 'residential'])] # drop: shed, commercial
ndirande_buildings = ndirande_buildings[ndirande_buildings['type'].isna()] # drop: multipolygon
ndirande_buildings['area'] = ndirande_buildings['geometry'].area

# for col in ndirande_buildings.columns:
#     if col != 'geometry':
#         print('------------')
#         print(col)
#         print('------------')
#         print(ndirande_buildings[col].value_counts())

new_cols = ['building', 'area', 'geometry']   

ndirande_buildings = ndirande_buildings[new_cols]

ndirande_buildings['geometry'] = ndirande_buildings.centroid
# ndirande_buildings.plot()
# plt.show()

ndirande_buildings = ndirande_buildings.to_crs(4326) # back to match poly

ndirande_buildings.to_file("osm_api_houses_sites_point_filter/malawi_buildings_filter.gpkg", layer='ndirande', driver="GPKG")
ndirande_buildings.to_csv('osm_api_houses_sites_point_filter/ndirande_buildings_filter.csv')

fig, ax = plt.subplots(1, figsize=(7,9), tight_layout=True, dpi=300)
ndirande_buildings.plot(ax=ax, facecolor=[0,0,0,0], edgecolor=[0,0,0,1], alpha=0.5, markersize=1)
ndirande_pol.plot(ax=ax, facecolor=[0,0,0,0], edgecolor=[0,0,0,1])
fig.suptitle("OSM Filtered Polygons, Represented as Points - Ndirande")
fig.savefig('osm_api_houses_sites_point_filter/ndirande_filtered_polys.pdf', dpi=300)
plt.close()

print('Done Ndirande')

OSM_buildings = {}
OSM_buildings['ndirande'] = len(ndirande_buildings)
OSM_buildings['chileka'] = len(chileka_buildings)
OSM_buildings['chikwawa'] = len(chikwawa_buildings)

with open("osm_building_numbers.yml", 'w') as f:
    yaml.dump(OSM_buildings, f)
