"""
generate_networks.py

Manages the creation / editing of the synthetic population
& networks
"""
from utils.parse import parse_config
from sim.simulator import Simulator

def run_simulation(config):
    """
    For the provided config file, parses the inputs and generates networks for
    each relevant site.
    """
    params = parse_config(config)
    sites = ['chikwawa', 'chileka', 'ndirande']

    # create input params for the simulations
    input_params = {key: params[key] for key in params if key not in sites}

    # loop through each site
    for site in sites:
        if params[site] == 'False':
            continue

        # create simulation for the site & all input parameters
        sim = Simulator(site, **input_params)
        sim.iterate()
