"""
Definitions for individuals
"""


class Individual():
    """
    The most general type of individual
    """
    def __init__(self, ref, gender, age, household_id):
        """
        Args:
                ref: unique reference [int]
                gender: individual's gender ['male' or 'female']
                age: individual's age [int]
        """
        self.id = ref
        self.gender = gender
        self.age = age
        self.household = household_id

    def __str__(self):
        return f"Agent {self.id}, {self.age}, {self.gender}"


class Child(Individual):
    """
    An individual that is employed
    """
    def __init__(self, ref, gender, age, household_id):
        """
        Args:
                ref: unique reference [int]
                gender: individual's gender ['male' or 'female']
                age: individual's age [int]
                school: PLACEHOLDER
        """
        super().__init__(ref, gender, age, household_id)

        self.school = None
