"""
Definition of a household
"""


class Household():
    """
    A household object, stores a family (or communal living
    establishment's occupants) and the building that they
    reside in.
    """
    def __init__(self, ref, lat, lon):
        """
        initialised with the household description from census
        (household_type) - e.g.: One family only: All aged 65 and
        over, and the average number of occupants expected to reside
        in the household.

        Args:
            ref: uniqure reference [int]
        Attributes:
            occupants: list of ids of individuals in the household [List[int]]
            lat: latitude of household [float]
            lon: longitude of household [float]

        """
        self.id = ref
        self.occupants = []
        self.lat = lat
        self.lon = lon
