"""
generate_networks.py

Manages the creation / editing of the networks
& networks
"""
from utils.parse import parse_config
from networks.network import NetworkGenerator

def create_networks(config):
    """
    For the provided config file, parses the inputs and generates networks for
    each relevant site.
    """
    params = parse_config(config)
    sites = ['chikwawa', 'chileka', 'ndirande']

    # create input params for the network generator
    input_params = {key: params[key] for key in params if key not in sites}

    # loop through each site
    for site in sites:
        if params[site] == 'False':
            continue

        # create network generator for the site & all input parameters
        generator = NetworkGenerator(site, **input_params)
        generator.create_networks()



