"""
generate_networks.py

Manages the creation / editing of the synthetic population
& networks
"""
import pickle

from utils.parse import parse_config
from model.model import Model

def create_model(config):
    """
    For the provided config file, parses the inputs and generates networks for
    each relevant site.
    """
    params = parse_config(config)
    sites = ['chikwawa', 'chileka', 'ndirande']

    # create input params for the model
    input_params = {key: params[key] for key in params if key not in sites}

    # loop through each site
    for site in sites:
        if params[site] == 'False':
            continue

        # create network generator for the site & all input parameters
        model = Model(site, **input_params)
        model.build_model()

        with open(model.save_dir+'model.p', 'wb') as f:
            pickle.dump(model, f)


