#!/usr/bin/env python

"""DRUM Simulation"""

# Condition to allow running multiprocessing in sub-modules in Windows without error.
# See, for example:
# https://stackoverflow.com/questions/20222534/python-multiprocessing-on-windows-if-name-main

if __name__ == "__main__":

    import os
    
    from utils.parse import parse_config
    from synthpop.generate_synthetic import create_synth_pop 
    from networks.generate_networks import create_networks
    from model.generate_model import create_model
    from sim.generate_sim import run_simulation
    from analysis.analyse import run_analysis


    def run():
        """Execute sub-modules based on choices in config-master.ini"""
        modules = parse_config('config-master.ini')

        # Run synth pop generation
        if modules['run_synth_pop'] == 'True':
            print('--------------')
            if os.path.isfile(modules['synth_pop_config']):
                print(f"Generating synthetic population using config: {modules['synth_pop_config']}")
                create_synth_pop(modules['synth_pop_config'])
            else:
                print("Can't generate synth pop - given config file doesn't exist.")

        # Run network generation
        if modules['run_network'] == 'True':
            print('--------------')
            if os.path.isfile(modules['network_config']):
                print(f"Generating networks using config: {modules['network_config']}")

                create_networks(modules['network_config'])

            else:
                print("Can't generate network - given config file doesn't exist.")

        # Run model generation
        if modules['run_model'] == 'True':
            print('--------------')
            if os.path.isfile(modules['model_config']):
                print(f"Building model using config: {modules['model_config']}")

                create_model(modules['model_config'])

            else:
                print("Can't build model - given config file doesn't exist.")

        # Run simulation
        if modules['run_sim'] == 'True':
            print('--------------')
            if os.path.isfile(modules['sim_config']):
                print(f"Running simulation using config: {modules['sim_config']}")

                run_simulation(modules['sim_config'])

            else:
                print("Can't run simulation - given config file doesn't exist.")


        # Run analysis
        if modules['run_analysis'] == 'True':
            print('--------------')
            if os.path.isfile(modules['analysis_config']):
                print(f"Running analysis using config: {modules['analysis_config']}")

                run_analysis(modules['analysis_config'])

            else:
                print("Can't run analysis - given config file doesn't exist.")

    run()
