"""
generate_networks.py

Manages the creation / editing of the synthetic population
& networks
"""
import pickle

from utils.parse import parse_config
from analysis.analysis_a import CreatePrevalenceEstimations
from analysis.analysis_b import CreateAnimationPlots


def run_analysis(config):
    """
    For the provided config file, parses the inputs and generates networks for
    each relevant site.
    """
    params = parse_config(config)
    print(params)
    sites = ['chikwawa', 'chileka', 'ndirande']

    # create input params for the model
    ignore = sites + ['run_no']
    input_params = {key: params[key] for key in params if key not in ignore}

    # loop through each site
    for site in sites:
        if params[site] == 'False':
            continue

        # calculate log odds
        generator = CreatePrevalenceEstimations(site, **input_params)
        for i in range(int(params['num_days'])):
            generator.create_log_odds_matrix(i, int(params['run_no']))

        # create animation plots have to be done after all log odds are calculated
        plotter = CreateAnimationPlots(site, **input_params)
        for i in range(int(params['num_days'])):
            plotter.create_animation_plot(i, int(params['run_no']))

        plotter.animate()
