## DRUM Model

The initial pass at the DRUM model.

A description of the model's functionality and code structure is presented in the PDF report found at docs/latex_doc/report/drum-model.pdf

The following notes give a summary of how the input data is produced.


## Input Data

The model has the following input data requirements (a static version is held in the data/init_raw_data/ directory):
* osm_buildings (point locations of buildings in the study sites, from OpenStreetMaps).
* strataa (point locations of buildings from STRATAA census).
* study_polygons (polygons of the study sites).
* swarmdb (a copy of the SWARM database).
* worldpop (summary of world population information for the study sites).

Methods to produce these inputs are described below.

### OSM buildings

Raw OSM data was extracted for Malawi using the OSM API (using the OSMnx Python package). A copy of this raw data is in the following location:
* misc/input_data_processing/osm_buildings/osm_api_buildings_sites_raw/

Buildings were then filtered, areas calculated, and converted to point geometries using the following script:
* misc/input_data_processing/osm_buildings/process_osm_buildings.py

The filtered data that is output from this script is saved in the following location:
* misc/input_data_processing/osm_buildings/osm_api_buildings_sites_filter/

And the malawi_buildings_filter.gpkg used as an input to the DRUM model.

### STRATAA

~~Raw copies of the STRATAA census data are stored here:
* misc/input_data_processing/STRATAA/original_data/

These are then processed by the following script, so that house locations can be generated:
* misc/input_data_processing/STRATAA/make_house_gpkg.py~~
[Redacted, please contact authors]

And house locations in geopackage format output to the following location:
* misc/input_data_processing/shps/STRATAA/

(The  *_poly.gpkg files are used as inputs to the DRUM model).

__Please note__: household locations have be randomly generated to have similar, but not identical
properties to the original STRATAA dataset.  For users wishing to access the original datasets,
please contact the package maintainer.

### Study Polygons

Copies of the study site polygons can be found here:
* misc/input_data_processing/shps/polygons/study_polygons.gpkg

### SWARM Database

The version of the SWARM database in this repository is a copy taken from Barrie's SWARM repo on 21st Dec 2020,
reduced to essential tables/columns, and data scrambled to preserve anonymity of the study participants.  Users
wishing to access the original data should contact the package maintainer.

### WorldPop Data

Summary information from WorldPop is processed using the following script:
* misc/input_data_processing/worldpop/worldpop_analysis.py

The population estimates for the study sites are output to 
* misc/input_data_processing/worldpop/world_pop_numbers.yml

These estimates are entered into the synthpop configuration file.


## Example outputs

Example output files from each stage of the DRUM model for the Chikwawa study site are provided in the following directory:
* misc/eg_outputs

The config files used to generate this set of outputs are provided in the same directory.
