#ifndef DOC_REFERENCE_CLASSES_DD4HEPGROUPS_H
#define DOC_REFERENCE_CLASSES_DD4HEPGROUPS_H


/// Generic shared objects and functions for all dd4hep areas
/**
 *  \defgroup DD4HEP dd4hep classes and objects
 *  @{
 */

/**@}*/

/// dd4hep XML utilities
/**
 *  \defgroup DD4HEP_XML dd4hep::XML classes and objects
 *  Summary of all XML utilities present in the dd4hep toolkit.
 *  @{
 */
/**@}*/


/// dd4hep geometry components, classes and functions
/**
 *  \defgroup DD4HEP_CORE dd4hep::detail components, classes and objects
 *  @{
 */

/**@}*/

/// dd4hep Simulation components, classes and functions
/**
 *  \defgroup DD4HEP_SIMULATION dd4hep::sim components, classes and objects
 *  @{
 */

/**@}*/

/// dd4hep Alignment components, classes and functions
/**
 *  \defgroup DD4HEP_ALIGN DDAlign: dd4hep Detector geometry alignment components.
 *  @{
 */

/**@}*/

/// dd4hep Detector Conditions components, classes and functions
/**
 *  \defgroup DD4HEP_CONDITIONS DDCond: dd4hep Detector Conditions components, classes and functions
 *  @{
 */

/**@}*/

/// dd4hep Event display components, classes and functions
/**
 *  \defgroup DD4HEP_EVE DDEve: dd4hep event display components, classes and objects
 *  @{
 */

/**@}*/


/// XercesC internal class. Not described here.
class ErrorHandler {};

/// XercesC internal class. Not described here.
class DOMErrorHandler {};

/// LCIO stuff
/**
 *  \defgroup LCIO LCIO components, classes and objects
 *  @{
 */

/// LCIO namespace. See http://lcio.desy.de \ingroup LCIO
namespace EVENT {}

/// LCIO namespace. See http://lcio.desy.de \ingroup LCIO
namespace IMPL {}

/// LCIO namespace. See http://lcio.desy.de \ingroup LCIO
namespace IO {}

/// LCIO namespace. See http://lcio.desy.de \ingroup LCIO
namespace UTIL {}


/**@}*/


/// Plugins of all kinds and purposes
/**
 *  \defgroup Plugins
 *  @{

 *  \defgroup Geant4Action
 \brief Plugins that are a Geant4Actions

 *  \defgroup Geant4GeneratorAction
 \brief Plugins treating the generation of primary particles

 *  \defgroup Geant4RunActions
 \brief Plugins that are a Geant4RunActions

 *  \defgroup Geant4EventReader
 \brief InputFile Reader Plugins

 *  \defgroup Geant4SDActionPlugin
 \brief Sensitive Detector Implementations

 *  \defgroup Geant4PhysicsConstructor
 \brief Extensions for PhysicsLists

 *  \defgroup SurfacePlugin
 \brief Plugins to manipulate surfaces automatically

 @}*/

#endif
