#ifndef UTILITYAPPS_SRC_MAIN_H
#define UTILITYAPPS_SRC_MAIN_H

//==========================================================================
//  AIDA Detector description implementation 
//--------------------------------------------------------------------------
// Copyright (C) Organisation europeenne pour la Recherche nucleaire (CERN)
// All rights reserved.
//
// For the licensing terms see $DD4hepINSTALL/LICENSE.
// For the list of contributors see $DD4hepINSTALL/doc/CREDITS.
//
// Author     : M.Frank
//
//==========================================================================
#include <stdexcept>
#include <iostream>

int main_wrapper(int argc, char** argv );

///  Mini wrapper to call main exception safe ....
int main(int argc, char** argv)  {
  try {
    return main_wrapper(argc,argv);
  }
  catch(const std::exception& e)  {
    std::cout << "Got uncaught exception: " << e.what() << std::endl;
  }
  catch (...)  {
    std::cout << "Got UNKNOWN uncaught exception." << std::endl;
  }
  return EINVAL;    
}

#endif
