#ifndef ROOT_WARNINGS_H
#define ROOT_WARNINGS_H

//==========================================================================
//  AIDA Detector description implementation 
//--------------------------------------------------------------------------
// Copyright (C) Organisation europeenne pour la Recherche nucleaire (CERN)
// All rights reserved.
//
// For the licensing terms see $DD4hepINSTALL/LICENSE.
// For the list of contributors see $DD4hepINSTALL/doc/CREDITS.
//
//--------------------------------------------------------------------------
//  These are the common warnings, which are generated by rootcling
//  and which cannot be avoided at all. We hence disable them in the
//  corresponding compilation units to reduce annoying warnings.
//
//  M.Frank
//==========================================================================

#if defined(__clang__)
  #pragma clang diagnostic ignored "-Wdeprecated-declarations"
  #pragma clang diagnostic ignored "-Wdeprecated"
  #pragma clang diagnostic ignored "-Wunused"
  #pragma clang diagnostic ignored "-Woverlength-strings"
#elif defined(__GNUC__) || defined(__GNUG__)
  #pragma GCC diagnostic ignored "-Wdeprecated-declarations"
  #pragma GCC diagnostic ignored "-Wdeprecated"
  #pragma GCC diagnostic ignored "-Wunused"
  #pragma GCC diagnostic ignored "-Woverlength-strings"
#endif


#if defined(__CINT__) || defined(__MAKECINT__) || defined(__CLANG__) || defined(__ROOTCLING__)
#define  DD4HEP_DICTIONARY_MODE 1
#endif

#if defined(G__DICTIONARY) && defined(G__ROOT)
#define  DD4HEP_DICTIONARY_CODE 1
#endif


#endif
