[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.6967336.svg)](https://doi.org/10.5281/zenodo.6967336)

# Urbanization and a green corridor influence reproductive success and pollinators of common milkweed

## Journal: Urban Ecosystems

## [Sophie Breitbart](https://sbreitbart.github.io/), Albert Tomchyshyn, [Helene Wagner](https://sites.utm.utoronto.ca/wagnerlab/), [Marc Johnson](https://evoecolab.wordpress.com/)

## Abstract
Urbanization exerts many pressures on species, yet little is known about how these pressures impact species interactions. Studies of urban plant-pollinator systems provide mounting evidence that urbanization impairs pollinator movement in fragmented urban landscapes, yet the consequences for pollinator-mediated plant reproduction remains unclear. In non-urban areas, habitat corridors can facilitate the movement of organisms including pollinators, but whether these corridors facilitate plant-pollinator interactions in urban areas remains understudied. To examine how urban environments and a green corridor influence plant-pollinator interactions, we measured reproductive success in the native plant common milkweed (*Asclepias syriaca*), and the community structure of its pollinators, for two years along two urban-rural transects in the Greater Toronto Area, Canada, one of which followed a green corridor. We found that urbanization decreased male fitness (i.e., pollen removal), increased fruit set (i.e., mean no. of follicles per inflorescence), and inconsistently affected female fitness (i.e., no. of follicles) in *A. syriaca*. Urbanization simultaneously decreased pollinator abundance but increased pollinator richness. Proximity to a green corridor inconsistently affected male fitness but increased reproductive effort (i.e., no. of inflorescences) in *A. syriaca*, while pollinator diversity and richness was lower in the corridor. Notably, there were no consistent relationships between pollinator community structure and reproductive success in *A. syriaca* in both the presence, and absence, of a green corridor. These results demonstrate the complexity with which urbanization, a green corridor, and pollinator communities can shape the reproductive investment and fitness of native plant populations.

## Using this code

### Rmd key

* `Q1_Q2_stats.Rmd`: Contains statistics for answering questions 1 and 2.
* `Q1_Q2_figures.Rmd`: Contains figures for questions 1 and 2. This rmd was made separate from the previous `Q1_Q2_stats.Rmd` because it was too big with all of the code in one file.
* `Q3_Q4_stats_figures.Rmd`: Contains statistics and figures for questions 3 and 4.
* `Meteorology.Rmd`: Contains weather-related analyses used to contexualize annual differences in plant reproduction/pollinator ecology.


## How to run this code
1. Open `Q1_Q2_stats.Rmd`.
2. Run the first chunk- "Set up Notebook". This code contains `library()` calls and should be run before running code from these other files:

* `Q1_Q2_figures.Rmd`
* `Q3_Q4_stats_figures.Rmd`

3. To run `Q1_Q2_figures.Rmd`, run `Q1_Q2_stats.Rmd` first.

4. Run `Q1_Q2_stats.Rmd` and `Q3_Q4_stats_figures.Rmd` as needed.
