\name{cplexConstants}
\alias{cplexConstants}
\alias{cplex_Constants}
\alias{constantsCPLEX}

\alias{CPX_ALG_AUTOMATIC}
\alias{CPX_ALG_BAROPT}
\alias{CPX_ALG_BARRIER}
\alias{CPX_ALG_CONCURRENT}
\alias{CPX_ALG_DUAL}
\alias{CPX_ALG_FEASOPT}
\alias{CPX_ALG_MIP}
\alias{CPX_ALG_NET}
\alias{CPX_ALG_NONE}
\alias{CPX_ALG_PIVOT}
\alias{CPX_ALG_PIVOTIN}
\alias{CPX_ALG_PIVOTOUT}
\alias{CPX_ALG_PRIMAL}
\alias{CPX_ALG_ROBUST}
\alias{CPX_ALG_SIFTING}
\alias{CPX_AT_LOWER}
\alias{CPX_AT_UPPER}
\alias{CPX_BARORDER_AMD}
\alias{CPX_BARORDER_AMF}
\alias{CPX_BARORDER_AUTO}
\alias{CPX_BARORDER_ND}
\alias{CPX_BASIC_SOLN}
\alias{CPX_BASIC}
\alias{CPX_BINARY}
\alias{CPX_BRANCH_DOWN}
\alias{CPX_BRANCH_GLOBAL}
\alias{CPX_BRANCH_UP}
\alias{CPX_BRDIR_AUTO}
\alias{CPX_BRDIR_DOWN}
\alias{CPX_BRDIR_UP}
\alias{CPX_CON_ABS}
% removed in CPLEX 12.9.0 begin
\alias{CPX_CON_DISJCST}
\alias{CPX_CON_INDDISJCST}
% removed in CPLEX 12.9.0 end
\alias{CPX_CON_INDICATOR}
\alias{CPX_CON_LAST_CONTYPE}
\alias{CPX_CON_LINEAR}
\alias{CPX_CON_LOWER_BOUND}
\alias{CPX_CON_MAXEXPR}
\alias{CPX_CON_MINEXPR}
\alias{CPX_CON_PWL}
\alias{CPX_CON_QUADRATIC}
% removed in CPLEX 12.9.0 begin
\alias{CPX_CON_SETVAR}
\alias{CPX_CON_SETVARCARD}
\alias{CPX_CON_SETVARDOMAIN}
\alias{CPX_CON_SETVAREQ}
\alias{CPX_CON_SETVARINTERSECT}
\alias{CPX_CON_SETVARINTERSECTION}
\alias{CPX_CON_SETVARMAX}
\alias{CPX_CON_SETVARMEMBER}
\alias{CPX_CON_SETVARMIN}
\alias{CPX_CON_SETVARNEQ}
\alias{CPX_CON_SETVARNEQCST}
\alias{CPX_CON_SETVARNULLINTERSECT}
\alias{CPX_CON_SETVARSUBSET}
\alias{CPX_CON_SETVARSUM}
\alias{CPX_CON_SETVARUNION}
% removed in CPLEX 12.9.0 end
\alias{CPX_CON_SOS}
\alias{CPX_CON_UPPER_BOUND}
\alias{CPX_CONFLICT_EXCLUDED}
\alias{CPX_CONFLICT_LB}
\alias{CPX_CONFLICT_MEMBER}
\alias{CPX_CONFLICT_POSSIBLE_LB}
\alias{CPX_CONFLICT_POSSIBLE_MEMBER}
\alias{CPX_CONFLICT_POSSIBLE_UB}
\alias{CPX_CONFLICT_UB}
\alias{CPX_CONTINUOUS}
\alias{CPX_DPRIIND_AUTO}
\alias{CPX_DPRIIND_DEVEX}
\alias{CPX_DPRIIND_FULL_STEEP}
\alias{CPX_DPRIIND_FULL}
\alias{CPX_DPRIIND_STEEP}
\alias{CPX_DPRIIND_STEEPQSTART}
\alias{CPX_DUAL_OBJ}
\alias{CPX_EXACT_KAPPA}
\alias{CPX_FEASOPT_MIN_INF}
\alias{CPX_FEASOPT_MIN_QUAD}
\alias{CPX_FEASOPT_MIN_SUM}
\alias{CPX_FEASOPT_OPT_INF}
\alias{CPX_FEASOPT_OPT_QUAD}
\alias{CPX_FEASOPT_OPT_SUM}
\alias{CPX_FREE_SUPER}
\alias{CPX_IMPLIED_INTEGER_FEASIBLE}
\alias{CPX_INFBOUND}
\alias{CPX_INTEGER_FEASIBLE}
\alias{CPX_INTEGER_INFEASIBLE}
\alias{CPX_INTEGER}
\alias{CPX_KAPPA_ATTENTION}
\alias{CPX_KAPPA_ILLPOSED}
\alias{CPX_KAPPA_MAX}
\alias{CPX_KAPPA_STABLE}
\alias{CPX_KAPPA_SUSPICIOUS}
\alias{CPX_KAPPA_UNSTABLE}
\alias{CPX_KAPPA}
\alias{CPX_MAX_COMP_SLACK}
\alias{CPX_MAX_DUAL_INFEAS}
\alias{CPX_MAX_DUAL_RESIDUAL}
\alias{CPX_MAX_INDSLACK_INFEAS}
\alias{CPX_MAX_INT_INFEAS}
\alias{CPX_MAX_PI}
\alias{CPX_MAX_PRIMAL_INFEAS}
\alias{CPX_MAX_PRIMAL_RESIDUAL}
\alias{CPX_MAX_QCPRIMAL_RESIDUAL}
\alias{CPX_MAX_QCSLACK_INFEAS}
\alias{CPX_MAX_QCSLACK}
\alias{CPX_MAX_RED_COST}
\alias{CPX_MAX_SCALED_DUAL_INFEAS}
\alias{CPX_MAX_SCALED_DUAL_RESIDUAL}
\alias{CPX_MAX_SCALED_PI}
\alias{CPX_MAX_SCALED_PRIMAL_INFEAS}
\alias{CPX_MAX_SCALED_PRIMAL_RESIDUAL}
\alias{CPX_MAX_SCALED_RED_COST}
\alias{CPX_MAX_SCALED_SLACK}
\alias{CPX_MAX_SCALED_X}
\alias{CPX_MAX_SLACK}
\alias{CPX_MAX_X}
\alias{CPX_MAX}
\alias{CPX_MIN}
\alias{CPX_MIPEMPHASIS_BALANCED}
\alias{CPX_MIPEMPHASIS_BESTBOUND}
\alias{CPX_MIPEMPHASIS_FEASIBILITY}
\alias{CPX_MIPEMPHASIS_HIDDENFEAS}
\alias{CPX_MIPEMPHASIS_OPTIMALITY}
\alias{CPX_MIPKAPPA_AUTO}
\alias{CPX_MIPKAPPA_FULL}
\alias{CPX_MIPKAPPA_OFF}
\alias{CPX_MIPKAPPA_SAMPLE}
\alias{CPX_MIPORDER_BOUNDS}
\alias{CPX_MIPORDER_COST}
\alias{CPX_MIPORDER_SCALEDCOST}
\alias{CPX_MIPSEARCH_AUTO}
\alias{CPX_MIPSEARCH_DYNAMIC}
\alias{CPX_MIPSEARCH_TRADITIONAL}
\alias{CPX_MIPSTART_AUTO}
\alias{CPX_MIPSTART_CHECKFEAS}
\alias{CPX_MIPSTART_REPAIR}
\alias{CPX_MIPSTART_SOLVEFIXED}
\alias{CPX_MIPSTART_SOLVEMIP}
\alias{CPX_NO_SOLN}
\alias{CPX_NODESEL_BESTBOUND}
\alias{CPX_NODESEL_BESTEST_ALT}
\alias{CPX_NODESEL_BESTEST}
\alias{CPX_NODESEL_DFS}
\alias{CPX_NONBASIC_SOLN}
\alias{CPX_OBJ_GAP}
\alias{CPX_OFF}
\alias{CPX_ON}
\alias{CPX_PARALLEL_AUTO}
\alias{CPX_PARALLEL_DETERMINISTIC}
\alias{CPX_PARALLEL_OPPORTUNISTIC}
\alias{CPX_PARAM_ADVIND}
\alias{CPX_PARAM_AGGCUTLIM}
\alias{CPX_PARAM_AGGFILL}
\alias{CPX_PARAM_AGGIND}
\alias{CPX_PARAM_ALL_MAX}
\alias{CPX_PARAM_ALL_MIN}
\alias{CPX_PARAM_APIENCODING}
\alias{CPX_PARAM_AUXROOTTHREADS}
\alias{CPX_PARAM_BARALG}
\alias{CPX_PARAM_BARCOLNZ}
\alias{CPX_PARAM_BARCROSSALG}
\alias{CPX_PARAM_BARDISPLAY}
\alias{CPX_PARAM_BARDSTART}
\alias{CPX_PARAM_BAREPCOMP}
\alias{CPX_PARAM_BARGROWTH}
\alias{CPX_PARAM_BARITLIM}
\alias{CPX_PARAM_BARMAXCOR}
\alias{CPX_PARAM_BAROBJRNG}
\alias{CPX_PARAM_BARORDER}
\alias{CPX_PARAM_BARPSTART}
\alias{CPX_PARAM_BARQCPEPCOMP}
\alias{CPX_PARAM_BARSTARTALG}
\alias{CPX_PARAM_BASINTERVAL}
\alias{CPX_PARAM_BBINTERVAL}
\alias{CPX_PARAM_BNDSTRENIND}
\alias{CPX_PARAM_BRDIR}
\alias{CPX_PARAM_BTTOL}
\alias{CPX_PARAM_CFILEMUL}
\alias{CPX_PARAM_CLIQUES}
\alias{CPX_PARAM_CLOCKTYPE}
\alias{CPX_PARAM_CLONELOG}
\alias{CPX_PARAM_COEREDIND}
\alias{CPX_PARAM_COLREADLIM}
\alias{CPX_PARAM_CONFLICTDISPLAY}
\alias{CPX_PARAM_COVERS}
\alias{CPX_PARAM_CRAIND}
\alias{CPX_PARAM_CUTLO}
\alias{CPX_PARAM_CUTPASS}
\alias{CPX_PARAM_CUTSFACTOR}
\alias{CPX_PARAM_CUTUP}
\alias{CPX_PARAM_DATACHECK}
\alias{CPX_PARAM_DEPIND}
\alias{CPX_PARAM_DETTILIM}
\alias{CPX_PARAM_DISJCUTS}
\alias{CPX_PARAM_DIVETYPE}
\alias{CPX_PARAM_DPRIIND}
\alias{CPX_PARAM_EACHCUTLIM}
\alias{CPX_PARAM_EPAGAP}
\alias{CPX_PARAM_EPGAP}
\alias{CPX_PARAM_EPINT}
\alias{CPX_PARAM_EPLIN}
\alias{CPX_PARAM_EPMRK}
\alias{CPX_PARAM_EPOPT_H}
\alias{CPX_PARAM_EPOPT}
\alias{CPX_PARAM_EPPER}
\alias{CPX_PARAM_EPRELAX}
\alias{CPX_PARAM_EPRHS_H}
\alias{CPX_PARAM_EPRHS}
\alias{CPX_PARAM_FASTMIP}
\alias{CPX_PARAM_FEASOPTMODE}
\alias{CPX_PARAM_FILEENCODING}
\alias{CPX_PARAM_FLOWCOVERS}
\alias{CPX_PARAM_FLOWPATHS}
\alias{CPX_PARAM_FPHEUR}
\alias{CPX_PARAM_FRACCAND}
\alias{CPX_PARAM_FRACCUTS}
\alias{CPX_PARAM_FRACPASS}
\alias{CPX_PARAM_GUBCOVERS}
\alias{CPX_PARAM_HEURFREQ}
\alias{CPX_PARAM_IMPLBD}
\alias{CPX_PARAM_INTSOLFILEPREFIX}
\alias{CPX_PARAM_INTSOLLIM}
\alias{CPX_PARAM_ITLIM}
\alias{CPX_PARAM_LBHEUR}
\alias{CPX_PARAM_LPMETHOD}
\alias{CPX_PARAM_MCFCUTS}
\alias{CPX_PARAM_MEMORYEMPHASIS}
\alias{CPX_PARAM_MIPCBREDLP}
\alias{CPX_PARAM_MIPDISPLAY}
\alias{CPX_PARAM_MIPEMPHASIS}
\alias{CPX_PARAM_MIPINTERVAL}
\alias{CPX_PARAM_MIPKAPPASTATS}
\alias{CPX_PARAM_MIPORDIND}
\alias{CPX_PARAM_MIPORDTYPE}
\alias{CPX_PARAM_MIPSEARCH}
\alias{CPX_PARAM_MIQCPSTRAT}
\alias{CPX_PARAM_MIRCUTS}
\alias{CPX_PARAM_MPSLONGNUM}
\alias{CPX_PARAM_NETDISPLAY}
\alias{CPX_PARAM_NETEPOPT}
\alias{CPX_PARAM_NETEPRHS}
\alias{CPX_PARAM_NETFIND}
\alias{CPX_PARAM_NETITLIM}
\alias{CPX_PARAM_NETPPRIIND}
\alias{CPX_PARAM_NODEFILEIND}
\alias{CPX_PARAM_NODELIM}
\alias{CPX_PARAM_NODESEL}
\alias{CPX_PARAM_NUMERICALEMPHASIS}
\alias{CPX_PARAM_NZREADLIM}
\alias{CPX_PARAM_OBJDIF}
\alias{CPX_PARAM_OBJLLIM}
\alias{CPX_PARAM_OBJULIM}
\alias{CPX_PARAM_PARALLELMODE}
\alias{CPX_PARAM_PERIND}
\alias{CPX_PARAM_PERLIM}
\alias{CPX_PARAM_POLISHAFTERDETTIME}
\alias{CPX_PARAM_POLISHAFTEREPAGAP}
\alias{CPX_PARAM_POLISHAFTEREPGAP}
\alias{CPX_PARAM_POLISHAFTERINTSOL}
\alias{CPX_PARAM_POLISHAFTERNODE}
\alias{CPX_PARAM_POLISHAFTERTIME}
\alias{CPX_PARAM_POLISHTIME}
\alias{CPX_PARAM_POPULATELIM}
\alias{CPX_PARAM_PPRIIND}
\alias{CPX_PARAM_PREDUAL}
\alias{CPX_PARAM_PREIND}
\alias{CPX_PARAM_PRELINEAR}
\alias{CPX_PARAM_PREPASS}
\alias{CPX_PARAM_PRESLVND}
\alias{CPX_PARAM_PRICELIM}
\alias{CPX_PARAM_PROBE}
\alias{CPX_PARAM_PROBEDETTIME}
\alias{CPX_PARAM_PROBETIME}
\alias{CPX_PARAM_QPMAKEPSDIND}
\alias{CPX_PARAM_QPMETHOD}
\alias{CPX_PARAM_QPNZREADLIM}
\alias{CPX_PARAM_RANDOMSEED}
\alias{CPX_PARAM_REDUCE}
\alias{CPX_PARAM_REINV}
\alias{CPX_PARAM_RELAXPREIND}
\alias{CPX_PARAM_RELOBJDIF}
\alias{CPX_PARAM_REPAIRTRIES}
\alias{CPX_PARAM_REPEATPRESOLVE}
\alias{CPX_PARAM_REVERSEIND}
\alias{CPX_PARAM_RFILEMUL}
\alias{CPX_PARAM_RINSHEUR}
\alias{CPX_PARAM_ROWREADLIM}
\alias{CPX_PARAM_SCAIND}
\alias{CPX_PARAM_SCRIND}
\alias{CPX_PARAM_SIFTALG}
\alias{CPX_PARAM_SIFTDISPLAY}
\alias{CPX_PARAM_SIFTITLIM}
\alias{CPX_PARAM_SIMDISPLAY}
\alias{CPX_PARAM_SINGLIM}
\alias{CPX_PARAM_SINGTOL}
\alias{CPX_PARAM_SOLNPOOLAGAP}
\alias{CPX_PARAM_SOLNPOOLCAPACITY}
\alias{CPX_PARAM_SOLNPOOLGAP}
\alias{CPX_PARAM_SOLNPOOLINTENSITY}
\alias{CPX_PARAM_SOLNPOOLREPLACE}
\alias{CPX_PARAM_SOLUTIONTARGET}
\alias{CPX_PARAM_STARTALG}
\alias{CPX_PARAM_STRONGCANDLIM}
\alias{CPX_PARAM_STRONGITLIM}
\alias{CPX_PARAM_SUBALG}
% removed in CPLEX 12.9.0 begin
\alias{CPX_PARAM_SUBMIPNODELIM}
% removed in CPLEX 12.9.0 end
\alias{CPX_PARAM_SYMMETRY}
\alias{CPX_PARAM_THREADS}
\alias{CPX_PARAM_TILIM}
\alias{CPX_PARAM_TRELIM}
\alias{CPX_PARAM_TUNINGDETTILIM}
\alias{CPX_PARAM_TUNINGDISPLAY}
\alias{CPX_PARAM_TUNINGMEASURE}
\alias{CPX_PARAM_TUNINGREPEAT}
\alias{CPX_PARAM_TUNINGTILIM}
\alias{CPX_PARAM_VARSEL}
\alias{CPX_PARAM_WORKDIR}
\alias{CPX_PARAM_WORKMEM}
\alias{CPX_PARAM_WRITELEVEL}
\alias{CPX_PARAM_XXXIND}
\alias{CPX_PARAM_ZEROHALFCUTS}
\alias{CPX_PARAMTYPE_DOUBLE}
\alias{CPX_PARAMTYPE_INT}
\alias{CPX_PARAMTYPE_LONG}
\alias{CPX_PARAMTYPE_NONE}
\alias{CPX_PARAMTYPE_STRING}
\alias{CPX_PPRIIND_AUTO}
\alias{CPX_PPRIIND_DEVEX}
\alias{CPX_PPRIIND_FULL}
\alias{CPX_PPRIIND_PARTIAL}
\alias{CPX_PPRIIND_STEEP}
\alias{CPX_PPRIIND_STEEPQSTART}
\alias{CPX_PRECOL_AGG}
\alias{CPX_PRECOL_FIX}
\alias{CPX_PRECOL_LOW}
\alias{CPX_PRECOL_OTHER}
\alias{CPX_PRECOL_UP}
\alias{CPX_PREREDUCE_DUALONLY}
\alias{CPX_PREREDUCE_NOPRIMALORDUAL}
\alias{CPX_PREREDUCE_PRIMALANDDUAL}
\alias{CPX_PREREDUCE_PRIMALONLY}
\alias{CPX_PREROW_AGG}
\alias{CPX_PREROW_OTHER}
\alias{CPX_PREROW_RED}
\alias{CPX_PRIMAL_OBJ}
\alias{CPX_PRIMAL_SOLN}
\alias{CPX_SEMICONT}
\alias{CPX_SEMIINT}
\alias{CPX_SOLNPOOL_DIV}
\alias{CPX_SOLNPOOL_FIFO}
\alias{CPX_SOLNPOOL_FILTER_DIVERSITY}
\alias{CPX_SOLNPOOL_FILTER_RANGE}
\alias{CPX_SOLNPOOL_OBJ}
\alias{CPX_SOLUTIONTARGET_AUTO}
\alias{CPX_SOLUTIONTARGET_FIRSTORDER}
\alias{CPX_SOLUTIONTARGET_OPTIMALCONVEX}
\alias{CPX_STAT_ABORT_DETTIME_LIM}
\alias{CPX_STAT_ABORT_DUAL_OBJ_LIM}
\alias{CPX_STAT_ABORT_IT_LIM}
\alias{CPX_STAT_ABORT_OBJ_LIM}
\alias{CPX_STAT_ABORT_PRIM_OBJ_LIM}
\alias{CPX_STAT_ABORT_TIME_LIM}
\alias{CPX_STAT_ABORT_USER}
\alias{CPX_STAT_CONFLICT_ABORT_CONTRADICTION}
\alias{CPX_STAT_CONFLICT_ABORT_DETTIME_LIM}
\alias{CPX_STAT_CONFLICT_ABORT_IT_LIM}
\alias{CPX_STAT_CONFLICT_ABORT_MEM_LIM}
\alias{CPX_STAT_CONFLICT_ABORT_NODE_LIM}
\alias{CPX_STAT_CONFLICT_ABORT_OBJ_LIM}
\alias{CPX_STAT_CONFLICT_ABORT_TIME_LIM}
\alias{CPX_STAT_CONFLICT_ABORT_USER}
\alias{CPX_STAT_CONFLICT_FEASIBLE}
\alias{CPX_STAT_CONFLICT_MINIMAL}
\alias{CPX_STAT_FEASIBLE_RELAXED_INF}
\alias{CPX_STAT_FEASIBLE_RELAXED_QUAD}
\alias{CPX_STAT_FEASIBLE_RELAXED_SUM}
\alias{CPX_STAT_FEASIBLE}
\alias{CPX_STAT_FIRSTORDER}
\alias{CPX_STAT_INFEASIBLE}
\alias{CPX_STAT_INForUNBD}
\alias{CPX_STAT_NUM_BEST}
\alias{CPX_STAT_OPTIMAL_FACE_UNBOUNDED}
\alias{CPX_STAT_OPTIMAL_INFEAS}
\alias{CPX_STAT_OPTIMAL_RELAXED_INF}
\alias{CPX_STAT_OPTIMAL_RELAXED_QUAD}
\alias{CPX_STAT_OPTIMAL_RELAXED_SUM}
\alias{CPX_STAT_OPTIMAL}
\alias{CPX_STAT_UNBOUNDED}
\alias{CPX_STR_PARAM_MAX}
\alias{CPX_SUM_COMP_SLACK}
\alias{CPX_SUM_DUAL_INFEAS}
\alias{CPX_SUM_DUAL_RESIDUAL}
\alias{CPX_SUM_INDSLACK_INFEAS}
\alias{CPX_SUM_INT_INFEAS}
\alias{CPX_SUM_PI}
\alias{CPX_SUM_PRIMAL_INFEAS}
\alias{CPX_SUM_PRIMAL_RESIDUAL}
\alias{CPX_SUM_QCPRIMAL_RESIDUAL}
\alias{CPX_SUM_QCSLACK_INFEAS}
\alias{CPX_SUM_QCSLACK}
\alias{CPX_SUM_RED_COST}
\alias{CPX_SUM_SCALED_DUAL_INFEAS}
\alias{CPX_SUM_SCALED_DUAL_RESIDUAL}
\alias{CPX_SUM_SCALED_PI}
\alias{CPX_SUM_SCALED_PRIMAL_INFEAS}
\alias{CPX_SUM_SCALED_PRIMAL_RESIDUAL}
\alias{CPX_SUM_SCALED_RED_COST}
\alias{CPX_SUM_SCALED_SLACK}
\alias{CPX_SUM_SCALED_X}
\alias{CPX_SUM_SLACK}
\alias{CPX_SUM_X}
\alias{CPX_TUNE_ABORT}
\alias{CPX_TUNE_AVERAGE}
\alias{CPX_TUNE_DETTILIM}
\alias{CPX_TUNE_MINMAX}
\alias{CPX_TUNE_TILIM}
\alias{CPX_TYPE_ANY}
\alias{CPX_TYPE_SOS1}
\alias{CPX_TYPE_SOS2}
\alias{CPX_TYPE_USER}
\alias{CPX_TYPE_VAR}
\alias{CPX_USECUT_FILTER}
\alias{CPX_USECUT_FORCE}
\alias{CPX_USECUT_PURGE}
\alias{CPX_VARSEL_DEFAULT}
\alias{CPX_VARSEL_MAXINFEAS}
\alias{CPX_VARSEL_MININFEAS}
\alias{CPX_VARSEL_PSEUDO}
\alias{CPX_VARSEL_PSEUDOREDUCED}
\alias{CPX_VARSEL_STRONG}
\alias{CPX_WRITELEVEL_ALLVARS}
\alias{CPX_WRITELEVEL_AUTO}
\alias{CPX_WRITELEVEL_DISCRETEVARS}
\alias{CPX_WRITELEVEL_NONZERODISCRETEVARS}
\alias{CPX_WRITELEVEL_NONZEROVARS}
\alias{CPXERR_NEGATIVE_SURPLUS}
\alias{CPXERR_NO_SENSIT}
\alias{CPXMIP_ABORT_FEAS}
\alias{CPXMIP_ABORT_INFEAS}
\alias{CPXMIP_ABORT_RELAXED}
\alias{CPXMIP_DETTIME_LIM_FEAS}
\alias{CPXMIP_DETTIME_LIM_INFEAS}
\alias{CPXMIP_FAIL_FEAS_NO_TREE}
\alias{CPXMIP_FAIL_FEAS}
\alias{CPXMIP_FAIL_INFEAS_NO_TREE}
\alias{CPXMIP_FAIL_INFEAS}
\alias{CPXMIP_FEASIBLE_RELAXED_INF}
\alias{CPXMIP_FEASIBLE_RELAXED_QUAD}
\alias{CPXMIP_FEASIBLE_RELAXED_SUM}
\alias{CPXMIP_FEASIBLE}
\alias{CPXMIP_INFEASIBLE}
\alias{CPXMIP_INForUNBD}
\alias{CPXMIP_MEM_LIM_FEAS}
\alias{CPXMIP_MEM_LIM_INFEAS}
\alias{CPXMIP_NODE_LIM_FEAS}
\alias{CPXMIP_NODE_LIM_INFEAS}
\alias{CPXMIP_OPTIMAL_INFEAS}
\alias{CPXMIP_OPTIMAL_POPULATED_TOL}
\alias{CPXMIP_OPTIMAL_POPULATED}
\alias{CPXMIP_OPTIMAL_RELAXED_INF}
\alias{CPXMIP_OPTIMAL_RELAXED_QUAD}
\alias{CPXMIP_OPTIMAL_RELAXED_SUM}
\alias{CPXMIP_OPTIMAL_TOL}
\alias{CPXMIP_OPTIMAL}
\alias{CPXMIP_POPULATESOL_LIM}
\alias{CPXMIP_SOL_LIM}
\alias{CPXMIP_TIME_LIM_FEAS}
\alias{CPXMIP_TIME_LIM_INFEAS}
\alias{CPXMIP_UNBOUNDED}
\alias{CPXNET_NO_DISPLAY_OBJECTIVE}
\alias{CPXNET_PENALIZED_OBJECTIVE}
\alias{CPXNET_PRICE_AUTO}
\alias{CPXNET_PRICE_MULT_PART}
\alias{CPXNET_PRICE_PARTIAL}
\alias{CPXNET_PRICE_SORT_MULT_PART}
\alias{CPXNET_TRUE_OBJECTIVE}
\alias{CPXPROB_FIXEDMILP}
\alias{CPXPROB_FIXEDMIQP}
\alias{CPXPROB_LP}
\alias{CPXPROB_MILP}
\alias{CPXPROB_MIQCP}
\alias{CPXPROB_MIQP}
\alias{CPXPROB_NODELP}
\alias{CPXPROB_NODEQCP}
\alias{CPXPROB_NODEQP}
\alias{CPXPROB_QCP}
\alias{CPXPROB_QP}
\alias{CPX_PARAM_CALCQCPDUALS}
\alias{CPX_PARAM_LANDPCUTS}
\alias{CPX_PARAM_RAMPUPDETTILIM}
\alias{CPX_PARAM_RAMPUPDURATION}
\alias{CPX_PARAM_RAMPUPTILIM}
\alias{CPX_SOLUTIONTARGET_OPTIMALGLOBAL}
\alias{CPXPARAM_Advance}
\alias{CPXPARAM_Barrier_Algorithm}
\alias{CPXPARAM_Barrier_ColNonzeros}
\alias{CPXPARAM_Barrier_ConvergeTol}
\alias{CPXPARAM_Barrier_Crossover}
\alias{CPXPARAM_Barrier_Display}
\alias{CPXPARAM_Barrier_Limits_Corrections}
\alias{CPXPARAM_Barrier_Limits_Growth}
\alias{CPXPARAM_Barrier_Limits_Iteration}
\alias{CPXPARAM_Barrier_Limits_ObjRange}
\alias{CPXPARAM_Barrier_Ordering}
\alias{CPXPARAM_Barrier_QCPConvergeTol}
\alias{CPXPARAM_Barrier_StartAlg}
\alias{CPXPARAM_ClockType}
\alias{CPXPARAM_Conflict_Display}
\alias{CPXPARAM_DetTimeLimit}
\alias{CPXPARAM_DistMIP_Rampup_DetTimeLimit}
\alias{CPXPARAM_DistMIP_Rampup_Duration}
\alias{CPXPARAM_DistMIP_Rampup_TimeLimit}
\alias{CPXPARAM_Emphasis_Memory}
\alias{CPXPARAM_Emphasis_MIP}
\alias{CPXPARAM_Emphasis_Numerical}
\alias{CPXPARAM_Feasopt_Mode}
\alias{CPXPARAM_Feasopt_Tolerance}
\alias{CPXPARAM_LPMethod}
\alias{CPXPARAM_MIP_Cuts_Cliques}
\alias{CPXPARAM_MIP_Cuts_Covers}
\alias{CPXPARAM_MIP_Cuts_Disjunctive}
\alias{CPXPARAM_MIP_Cuts_FlowCovers}
\alias{CPXPARAM_MIP_Cuts_Gomory}
\alias{CPXPARAM_MIP_Cuts_GUBCovers}
\alias{CPXPARAM_MIP_Cuts_Implied}
\alias{CPXPARAM_MIP_Cuts_LiftProj}
\alias{CPXPARAM_MIP_Cuts_MCFCut}
\alias{CPXPARAM_MIP_Cuts_MIRCut}
\alias{CPXPARAM_MIP_Cuts_PathCut}
\alias{CPXPARAM_MIP_Cuts_ZeroHalfCut}
\alias{CPXPARAM_MIP_Display}
\alias{CPXPARAM_MIP_Interval}
\alias{CPXPARAM_MIP_Limits_AggForCut}
\alias{CPXPARAM_MIP_Limits_AuxRootThreads}
\alias{CPXPARAM_MIP_Limits_CutPasses}
\alias{CPXPARAM_MIP_Limits_CutsFactor}
\alias{CPXPARAM_MIP_Limits_EachCutLimit}
\alias{CPXPARAM_MIP_Limits_GomoryCand}
\alias{CPXPARAM_MIP_Limits_GomoryPass}
\alias{CPXPARAM_MIP_Limits_Nodes}
\alias{CPXPARAM_MIP_Limits_PolishTime}
\alias{CPXPARAM_MIP_Limits_Populate}
\alias{CPXPARAM_MIP_Limits_ProbeDetTime}
\alias{CPXPARAM_MIP_Limits_ProbeTime}
\alias{CPXPARAM_MIP_Limits_RepairTries}
\alias{CPXPARAM_MIP_Limits_Solutions}
\alias{CPXPARAM_MIP_Limits_StrongCand}
\alias{CPXPARAM_MIP_Limits_StrongIt}
\alias{CPXPARAM_MIP_Limits_SubMIPNodeLim}
\alias{CPXPARAM_MIP_Limits_TreeMemory}
\alias{CPXPARAM_MIP_OrderType}
\alias{CPXPARAM_MIP_PolishAfter_AbsMIPGap}
\alias{CPXPARAM_MIP_PolishAfter_DetTime}
\alias{CPXPARAM_MIP_PolishAfter_MIPGap}
\alias{CPXPARAM_MIP_PolishAfter_Nodes}
\alias{CPXPARAM_MIP_PolishAfter_Solutions}
\alias{CPXPARAM_MIP_PolishAfter_Time}
\alias{CPXPARAM_MIP_Pool_AbsGap}
\alias{CPXPARAM_MIP_Pool_Capacity}
\alias{CPXPARAM_MIP_Pool_Intensity}
\alias{CPXPARAM_MIP_Pool_RelGap}
\alias{CPXPARAM_MIP_Pool_Replace}
\alias{CPXPARAM_MIP_Strategy_Backtrack}
\alias{CPXPARAM_MIP_Strategy_BBInterval}
\alias{CPXPARAM_MIP_Strategy_Branch}
\alias{CPXPARAM_MIP_Strategy_CallbackReducedLP}
\alias{CPXPARAM_MIP_Strategy_Dive}
\alias{CPXPARAM_MIP_Strategy_File}
\alias{CPXPARAM_MIP_Strategy_FPHeur}
\alias{CPXPARAM_MIP_Strategy_HeuristicFreq}
\alias{CPXPARAM_MIP_Strategy_KappaStats}
\alias{CPXPARAM_MIP_Strategy_LBHeur}
\alias{CPXPARAM_MIP_Strategy_MIQCPStrat}
\alias{CPXPARAM_MIP_Strategy_NodeSelect}
\alias{CPXPARAM_MIP_Strategy_Order}
\alias{CPXPARAM_MIP_Strategy_PresolveNode}
\alias{CPXPARAM_MIP_Strategy_Probe}
\alias{CPXPARAM_MIP_Strategy_RINSHeur}
\alias{CPXPARAM_MIP_Strategy_Search}
\alias{CPXPARAM_MIP_Strategy_StartAlgorithm}
\alias{CPXPARAM_MIP_Strategy_SubAlgorithm}
\alias{CPXPARAM_MIP_Strategy_VariableSelect}
\alias{CPXPARAM_MIP_Tolerances_AbsMIPGap}
\alias{CPXPARAM_MIP_Tolerances_Integrality}
\alias{CPXPARAM_MIP_Tolerances_LowerCutoff}
\alias{CPXPARAM_MIP_Tolerances_MIPGap}
\alias{CPXPARAM_MIP_Tolerances_ObjDifference}
\alias{CPXPARAM_MIP_Tolerances_RelObjDifference}
\alias{CPXPARAM_MIP_Tolerances_UpperCutoff}
\alias{CPXPARAM_Network_Display}
\alias{CPXPARAM_Network_Iterations}
\alias{CPXPARAM_Network_NetFind}
\alias{CPXPARAM_Network_Pricing}
\alias{CPXPARAM_Network_Tolerances_Feasibility}
\alias{CPXPARAM_Network_Tolerances_Optimality}
\alias{CPXPARAM_Output_CloneLog}
\alias{CPXPARAM_Output_IntSolFilePrefix}
\alias{CPXPARAM_Output_MPSLong}
\alias{CPXPARAM_Output_WriteLevel}
\alias{CPXPARAM_Parallel}
\alias{CPXPARAM_Preprocessing_Aggregator}
\alias{CPXPARAM_Preprocessing_BoundStrength}
\alias{CPXPARAM_Preprocessing_CoeffReduce}
\alias{CPXPARAM_Preprocessing_Dependency}
\alias{CPXPARAM_Preprocessing_Dual}
\alias{CPXPARAM_Preprocessing_Fill}
\alias{CPXPARAM_Preprocessing_Linear}
\alias{CPXPARAM_Preprocessing_NumPass}
\alias{CPXPARAM_Preprocessing_Presolve}
\alias{CPXPARAM_Preprocessing_QCPDuals}
\alias{CPXPARAM_Preprocessing_QPMakePSD}
\alias{CPXPARAM_Preprocessing_Reduce}
\alias{CPXPARAM_Preprocessing_Relax}
\alias{CPXPARAM_Preprocessing_RepeatPresolve}
\alias{CPXPARAM_Preprocessing_Symmetry}
\alias{CPXPARAM_QPMethod}
\alias{CPXPARAM_RandomSeed}
\alias{CPXPARAM_Read_APIEncoding}
\alias{CPXPARAM_Read_Constraints}
\alias{CPXPARAM_Read_DataCheck}
\alias{CPXPARAM_Read_FileEncoding}
\alias{CPXPARAM_Read_Nonzeros}
\alias{CPXPARAM_Read_QPNonzeros}
\alias{CPXPARAM_Read_Scale}
\alias{CPXPARAM_Read_Variables}
\alias{CPXPARAM_ScreenOutput}
\alias{CPXPARAM_Sifting_Algorithm}
\alias{CPXPARAM_Sifting_Display}
\alias{CPXPARAM_Sifting_Iterations}
\alias{CPXPARAM_Simplex_Crash}
\alias{CPXPARAM_Simplex_DGradient}
\alias{CPXPARAM_Simplex_Display}
\alias{CPXPARAM_Simplex_Limits_Iterations}
\alias{CPXPARAM_Simplex_Limits_LowerObj}
\alias{CPXPARAM_Simplex_Limits_Perturbation}
\alias{CPXPARAM_Simplex_Limits_Singularity}
\alias{CPXPARAM_Simplex_Limits_UpperObj}
\alias{CPXPARAM_Simplex_Perturbation_Constant}
\alias{CPXPARAM_Simplex_Perturbation_Indicator}
\alias{CPXPARAM_Simplex_PGradient}
\alias{CPXPARAM_Simplex_Pricing}
\alias{CPXPARAM_Simplex_Refactor}
\alias{CPXPARAM_Simplex_Tolerances_Feasibility}
\alias{CPXPARAM_Simplex_Tolerances_Markowitz}
\alias{CPXPARAM_Simplex_Tolerances_Optimality}
\alias{CPXPARAM_SolutionTarget}
\alias{CPXPARAM_Threads}
\alias{CPXPARAM_TimeLimit}
\alias{CPXPARAM_Tune_DetTimeLimit}
\alias{CPXPARAM_Tune_Display}
\alias{CPXPARAM_Tune_Measure}
\alias{CPXPARAM_Tune_Repeat}
\alias{CPXPARAM_Tune_TimeLimit}
\alias{CPXPARAM_WorkDir}
\alias{CPXPARAM_WorkMem}

% new in CPLEX 12.8.0 begin
\alias{CPXPARAM_Record}
\alias{CPXPARAM_MIP_Strategy_SubMIPScale}
\alias{CPXPARAM_MIP_Strategy_SubMIPStartAlg}
\alias{CPXPARAM_MIP_Strategy_SubMIPSubAlg}
\alias{CPXPARAM_ParamDisplay}
\alias{CPX_PARAM_PARAMDISPLAY}
\alias{CPXMI_SAMECOEFF_ROW}
\alias{CPXMI_SAMECOEFF_COL}
\alias{CPXMI_SAMECOEFF_IND}
\alias{CPXMI_SAMECOEFF_QLIN}
\alias{CPXMI_SAMECOEFF_QUAD}
\alias{CPXMI_SAMECOEFF_LAZY}
\alias{CPXMI_SAMECOEFF_UCUT}
\alias{CPXMI_SAMECOEFF_RHS}
\alias{CPXMI_SAMECOEFF_OBJ}
\alias{CPXERR_CALLBACK_INCONSISTENT}
\alias{CPXERR_CAND_NOT_RAY}
\alias{CPXERR_CAND_NOT_POINT}
\alias{CPX_CALLBACKCONTEXT_CANDIDATE}
\alias{CPX_CALLBACKCONTEXT_GLOBAL_PROGRESS}
\alias{CPX_CALLBACKCONTEXT_LOCAL_PROGRESS}
\alias{CPX_CALLBACKCONTEXT_RELAXATION}
\alias{CPX_CALLBACKCONTEXT_THREAD_DOWN}
\alias{CPX_CALLBACKCONTEXT_THREAD_UP}
% new in CPLEX 12.8.0 end

% new in CPLEX 12.9.0 begin
\alias{CPX_MAX_PWLSLACK_INFEAS}
\alias{CPX_SUM_PWLSLACK_INFEAS}
\alias{CPXPARAM_MultiObjective_Display}
\alias{CPXPARAM_Preprocessing_Folding}
\alias{CPXPARAM_Read_WarningLimit}
\alias{CPXERR_BAD_MULTIOBJ_ATTR}
\alias{CPXERR_MULTIOBJ_SUBPROB_SOLVE}
\alias{CPXERR_NOT_FOR_MULTIOBJ}
\alias{CPXERR_NO_OBJ_NAME}
% new in CPLEX 12.9.0 end


\title{
  Constants, Parameters, Return and Status Codes of IBM ILOG CPLEX
}

\description{
  This is a list containing constants used by IBM ILOG CPLEX. Cunsult the IBM
  ILOG CPLEX manual for more information, in praticular for the use of control
  parameters.
}


%------------------------------------------------------------------------------
\section{General Parameters}{
  \tabular{ll}{
      \code{CPX_INFBOUND} \tab \code{1.0E+20} \cr
      \code{CPX_STR_PARAM_MAX} \tab \code{512} \cr
  }
}

%------------------------------------------------------------------------------
\section{Types of parameters}{
  \tabular{ll}{
    \code{CPX_PARAMTYPE_NONE}   \tab \code{0} \cr
    \code{CPX_PARAMTYPE_INT}    \tab \code{1} \cr
    \code{CPX_PARAMTYPE_DOUBLE} \tab \code{2} \cr
    \code{CPX_PARAMTYPE_STRING} \tab \code{3} \cr
    \code{CPX_PARAMTYPE_LONG}   \tab \code{4} \cr
  }
}


%------------------------------------------------------------------------------
\section{Values returned for \code{stat} by solution}{
  \tabular{ll}{
    \code{CPX_STAT_OPTIMAL}                \tab \code{1} \cr
    \code{CPX_STAT_UNBOUNDED}              \tab \code{2} \cr
    \code{CPX_STAT_INFEASIBLE}             \tab \code{3} \cr
    \code{CPX_STAT_INForUNBD}              \tab \code{4} \cr
    \code{CPX_STAT_OPTIMAL_INFEAS}         \tab \code{5} \cr
    \code{CPX_STAT_NUM_BEST}               \tab \code{6} \cr
    \code{CPX_STAT_ABORT_IT_LIM}           \tab \code{10} \cr
    \code{CPX_STAT_ABORT_TIME_LIM}         \tab \code{11} \cr
    \code{CPX_STAT_ABORT_OBJ_LIM}          \tab \code{12} \cr
    \code{CPX_STAT_ABORT_USER}             \tab \code{13} \cr
    \code{CPX_STAT_FEASIBLE_RELAXED_SUM}   \tab \code{14} \cr
    \code{CPX_STAT_OPTIMAL_RELAXED_SUM}    \tab \code{15} \cr
    \code{CPX_STAT_FEASIBLE_RELAXED_INF}   \tab \code{16} \cr
    \code{CPX_STAT_OPTIMAL_RELAXED_INF}    \tab \code{17} \cr
    \code{CPX_STAT_FEASIBLE_RELAXED_QUAD}  \tab \code{18} \cr
    \code{CPX_STAT_OPTIMAL_RELAXED_QUAD}   \tab \code{19} \cr
    \code{CPX_STAT_FEASIBLE}               \tab \code{23} \cr
    \code{CPX_STAT_ABORT_DETTIME_LIM}      \tab \code{25} \cr
  }
}


%------------------------------------------------------------------------------
\section{Solution type return values from \code{CPXsolninfo}}{
  \tabular{ll}{
    \code{CPX_NO_SOLN}       \tab \code{0} \cr
    \code{CPX_BASIC_SOLN}    \tab \code{1} \cr
    \code{CPX_NONBASIC_SOLN} \tab \code{2} \cr
    \code{CPX_PRIMAL_SOLN}   \tab \code{3} \cr
  }
}


%------------------------------------------------------------------------------
\section{Values of presolve \code{stats} for columns and rows}{
  \tabular{lll}{
    \code{CPX_PRECOL_LOW}   \tab \code{-1} \tab fixed to original lb \cr
    \code{CPX_PRECOL_UP}    \tab \code{-2} \tab fixed to original ub \cr
    \code{CPX_PRECOL_FIX}   \tab \code{-3} \tab fixed to some other value \cr
    \code{CPX_PRECOL_AGG}   \tab \code{-4} \tab aggregated \eqn{y = a \times x + b}{y = a*x + b} \cr
    \code{CPX_PRECOL_OTHER} \tab \code{-5} \tab cannot be expressed by a linear combination of active variables in the presolved model crushing will fail if it has to touch such a variable \cr
    \code{CPX_PREROW_RED}   \tab \code{-1} \tab redundant row removed in presolved model \cr
    \code{CPX_PREROW_AGG}   \tab \code{-2} \tab used to aggregate a variable \cr
    \code{CPX_PREROW_OTHER} \tab \code{-3} \tab other, for example merge two inequalities into a single equation \cr
  }
}


%------------------------------------------------------------------------------
\section{Generic constants}{
  \tabular{ll}{
    \code{CPX_ON}  \tab \code{1} \cr
    \code{CPX_OFF} \tab \code{0} \cr
    \code{CPX_MAX} \tab \code{-1} \cr
    \code{CPX_MIN} \tab \code{1} \cr
  }
}


%------------------------------------------------------------------------------
\section{Primal simplex pricing algorithm}{
  \tabular{ll}{
    \code{CPX_PPRIIND_PARTIAL}     \tab \code{-1} \cr
    \code{CPX_PPRIIND_AUTO}        \tab \code{0} \cr
    \code{CPX_PPRIIND_DEVEX}       \tab \code{1} \cr
    \code{CPX_PPRIIND_STEEP}       \tab \code{2} \cr
    \code{CPX_PPRIIND_STEEPQSTART} \tab \code{3} \cr
    \code{CPX_PPRIIND_FULL}        \tab \code{4} \cr
  }
}


%------------------------------------------------------------------------------
\section{Dual simplex pricing algorithm}{
  \tabular{ll}{
    \code{CPX_DPRIIND_AUTO}        \tab \code{0} \cr
    \code{CPX_DPRIIND_FULL}        \tab \code{1} \cr
    \code{CPX_DPRIIND_STEEP}       \tab \code{2} \cr
    \code{CPX_DPRIIND_FULL_STEEP}  \tab \code{3} \cr
    \code{CPX_DPRIIND_STEEPQSTART} \tab \code{4} \cr
    \code{CPX_DPRIIND_DEVEX}       \tab \code{5} \cr
  }
}


%------------------------------------------------------------------------------
\section{PARALLELMODE values}{
  \tabular{ll}{
    \code{CPX_PARALLEL_DETERMINISTIC} \tab \code{1} \cr
    \code{CPX_PARALLEL_AUTO}          \tab \code{0} \cr
    \code{CPX_PARALLEL_OPPORTUNISTIC} \tab \code{-1} \cr
  }
}


%------------------------------------------------------------------------------
\section{Values for \code{CPX_PARAM_WRITELEVEL}}{
  \tabular{ll}{
    \code{CPX_WRITELEVEL_AUTO}                 \tab \code{0} \cr
    \code{CPX_WRITELEVEL_ALLVARS}              \tab \code{1} \cr
    \code{CPX_WRITELEVEL_DISCRETEVARS}         \tab \code{2} \cr
    \code{CPX_WRITELEVEL_NONZEROVARS}          \tab \code{3} \cr
    \code{CPX_WRITELEVEL_NONZERODISCRETEVARS}  \tab \code{4} \cr
  }
}


%------------------------------------------------------------------------------
\section{Values for \code{CPX_PARAM_SOLUTIONTARGET}}{
  \tabular{ll}{
    \code{CPX_SOLUTIONTARGET_AUTO}          \tab \code{0} \cr
    \code{CPX_SOLUTIONTARGET_OPTIMALCONVEX} \tab \code{1} \cr
    \code{CPX_SOLUTIONTARGET_FIRSTORDER}    \tab \code{2} \cr
    \code{CPX_SOLUTIONTARGET_OPTIMALGLOBAL} \tab \code{3} \cr
  }
}


%------------------------------------------------------------------------------
\section{LP/QP solution algorithms}{
Used as possible values for \code{CPX_PARAM_LPMETHOD}, \code{CPX_PARAM_QPMETHOD}, \code{CPX_PARAM_BARCROSSALG}, \code{CPXgetmethod}, \dots
  \tabular{ll}{
    \code{CPX_ALG_NONE}       \tab \code{-1} \cr
    \code{CPX_ALG_AUTOMATIC}  \tab \code{0} \cr
    \code{CPX_ALG_PRIMAL}     \tab \code{1} \cr
    \code{CPX_ALG_DUAL}       \tab \code{2} \cr
    \code{CPX_ALG_NET}        \tab \code{3} \cr
    \code{CPX_ALG_BARRIER}    \tab \code{4} \cr
    \code{CPX_ALG_SIFTING}    \tab \code{5} \cr
    \code{CPX_ALG_CONCURRENT} \tab \code{6} \cr
    \code{CPX_ALG_BAROPT}     \tab \code{7} \cr
    \code{CPX_ALG_PIVOTIN}    \tab \code{8} \cr
    \code{CPX_ALG_PIVOTOUT}   \tab \code{9} \cr
    \code{CPX_ALG_PIVOT}      \tab \code{10} \cr
    \code{CPX_ALG_FEASOPT}    \tab \code{11} \cr
    \code{CPX_ALG_MIP}        \tab \code{12} \cr
    \code{CPX_ALG_ROBUST}     \tab \code{13} \cr
  }
}


%------------------------------------------------------------------------------
\section{Basis status values}{
  \tabular{ll}{
    \code{CPX_AT_LOWER}   \tab \code{0} \cr
    \code{CPX_BASIC}      \tab \code{1} \cr
    \code{CPX_AT_UPPER}   \tab \code{2} \cr
    \code{CPX_FREE_SUPER} \tab \code{3} \cr
  }
}


%------------------------------------------------------------------------------
\section{Variable types for ctype array}{
  \tabular{ll}{
    \code{CPX_CONTINUOUS} \tab \code{"C"} \cr
    \code{CPX_BINARY}     \tab \code{"B"} \cr
    \code{CPX_INTEGER}    \tab \code{"I"} \cr
    \code{CPX_SEMICONT}   \tab \code{"S"} \cr
    \code{CPX_SEMIINT}    \tab \code{"N"} \cr
  }
}


%------------------------------------------------------------------------------
\section{PREREDUCE settings}{
  \tabular{ll}{
    \code{CPX_PREREDUCE_PRIMALANDDUAL}  \tab \code{3} \cr
    \code{CPX_PREREDUCE_DUALONLY}       \tab \code{2} \cr
    \code{CPX_PREREDUCE_PRIMALONLY}     \tab \code{1} \cr
    \code{CPX_PREREDUCE_NOPRIMALORDUAL} \tab \code{0} \cr
  }
}


%------------------------------------------------------------------------------
\section{Conflict statuses}{
  \tabular{ll}{
    \code{CPX_STAT_CONFLICT_FEASIBLE}            \tab \code{30} \cr
    \code{CPX_STAT_CONFLICT_MINIMAL}             \tab \code{31} \cr
    \code{CPX_STAT_CONFLICT_ABORT_CONTRADICTION} \tab \code{32} \cr
    \code{CPX_STAT_CONFLICT_ABORT_TIME_LIM}      \tab \code{33} \cr
    \code{CPX_STAT_CONFLICT_ABORT_IT_LIM}        \tab \code{34} \cr
    \code{CPX_STAT_CONFLICT_ABORT_NODE_LIM}      \tab \code{35} \cr
    \code{CPX_STAT_CONFLICT_ABORT_OBJ_LIM}       \tab \code{36} \cr
    \code{CPX_STAT_CONFLICT_ABORT_MEM_LIM}       \tab \code{37} \cr
    \code{CPX_STAT_CONFLICT_ABORT_USER}          \tab \code{38} \cr
    \code{CPX_STAT_CONFLICT_ABORT_DETTIME_LIM}   \tab \code{39} \cr
  }
}


%------------------------------------------------------------------------------
\section{Conflict status values}{
  \tabular{ll}{
    \code{CPX_CONFLICT_EXCLUDED}        \tab \code{-1} \cr
    \code{CPX_CONFLICT_POSSIBLE_MEMBER} \tab \code{0} \cr
    \code{CPX_CONFLICT_POSSIBLE_LB}     \tab \code{1} \cr
    \code{CPX_CONFLICT_POSSIBLE_UB}     \tab \code{2} \cr
    \code{CPX_CONFLICT_MEMBER}          \tab \code{3} \cr
    \code{CPX_CONFLICT_LB}              \tab \code{4} \cr
    \code{CPX_CONFLICT_UB}              \tab \code{5} \cr
  }
}


%------------------------------------------------------------------------------
\section{Problem Types}{
Types \code{4}, \code{9}, and \code{12} are internal, the others are for users.
  \tabular{ll}{
    \code{CPXPROB_LP}                    \tab \code{0} \cr
    \code{CPXPROB_MILP}                  \tab \code{1} \cr
    \code{CPXPROB_FIXEDMILP}             \tab \code{3} \cr
    \code{CPXPROB_NODELP}                \tab \code{4} \cr
    \code{CPXPROB_QP}                    \tab \code{5} \cr
    \code{CPXPROB_MIQP}                  \tab \code{7} \cr
    \code{CPXPROB_FIXEDMIQP}             \tab \code{8} \cr
    \code{CPXPROB_NODEQP}                \tab \code{9} \cr
    \code{CPXPROB_QCP}                   \tab \code{10} \cr
    \code{CPXPROB_MIQCP}                 \tab \code{11} \cr
    \code{CPXPROB_NODEQCP}               \tab \code{12} \cr
  }
}


%------------------------------------------------------------------------------
\section{CPLEX Parameter numbers}{
  \tabular{ll}{
    \code{CPX_PARAM_ADVIND}              \tab \code{1001} \cr
    \code{CPX_PARAM_AGGFILL}             \tab \code{1002} \cr
    \code{CPX_PARAM_AGGIND}              \tab \code{1003} \cr
    \code{CPX_PARAM_BASINTERVAL}         \tab \code{1004} \cr
    \code{CPX_PARAM_CFILEMUL}            \tab \code{1005} \cr
    \code{CPX_PARAM_CLOCKTYPE}           \tab \code{1006} \cr
    \code{CPX_PARAM_CRAIND}              \tab \code{1007} \cr
    \code{CPX_PARAM_DEPIND}              \tab \code{1008} \cr
    \code{CPX_PARAM_DPRIIND}             \tab \code{1009} \cr
    \code{CPX_PARAM_PRICELIM}            \tab \code{1010} \cr
    \code{CPX_PARAM_EPMRK}               \tab \code{1013} \cr
    \code{CPX_PARAM_EPOPT}               \tab \code{1014} \cr
    \code{CPX_PARAM_EPPER}               \tab \code{1015} \cr
    \code{CPX_PARAM_EPRHS}               \tab \code{1016} \cr
    \code{CPX_PARAM_FASTMIP}             \tab \code{1017} \cr
    \code{CPX_PARAM_SIMDISPLAY}          \tab \code{1019} \cr
    \code{CPX_PARAM_ITLIM}               \tab \code{1020} \cr
    \code{CPX_PARAM_ROWREADLIM}          \tab \code{1021} \cr
    \code{CPX_PARAM_NETFIND}             \tab \code{1022} \cr
    \code{CPX_PARAM_COLREADLIM}          \tab \code{1023} \cr
    \code{CPX_PARAM_NZREADLIM}           \tab \code{1024} \cr
    \code{CPX_PARAM_OBJLLIM}             \tab \code{1025} \cr
    \code{CPX_PARAM_OBJULIM}             \tab \code{1026} \cr
    \code{CPX_PARAM_PERIND}              \tab \code{1027} \cr
    \code{CPX_PARAM_PERLIM}              \tab \code{1028} \cr
    \code{CPX_PARAM_PPRIIND}             \tab \code{1029} \cr
    \code{CPX_PARAM_PREIND}              \tab \code{1030} \cr
    \code{CPX_PARAM_REINV}               \tab \code{1031} \cr
    \code{CPX_PARAM_REVERSEIND}          \tab \code{1032} \cr
    \code{CPX_PARAM_RFILEMUL}            \tab \code{1033} \cr
    \code{CPX_PARAM_SCAIND}              \tab \code{1034} \cr
    \code{CPX_PARAM_SCRIND}              \tab \code{1035} \cr
    \code{CPX_PARAM_SINGLIM}             \tab \code{1037} \cr
    \code{CPX_PARAM_SINGTOL}             \tab \code{1038} \cr
    \code{CPX_PARAM_TILIM}               \tab \code{1039} \cr
    \code{CPX_PARAM_XXXIND}              \tab \code{1041} \cr
    \code{CPX_PARAM_PREDUAL}             \tab \code{1044} \cr
    \code{CPX_PARAM_EPOPT_H}             \tab \code{1049} \cr
    \code{CPX_PARAM_EPRHS_H}             \tab \code{1050} \cr
    \code{CPX_PARAM_PREPASS}             \tab \code{1052} \cr
    \code{CPX_PARAM_DATACHECK}           \tab \code{1056} \cr
    \code{CPX_PARAM_REDUCE}              \tab \code{1057} \cr
    \code{CPX_PARAM_PRELINEAR}           \tab \code{1058} \cr
    \code{CPX_PARAM_LPMETHOD}            \tab \code{1062} \cr
    \code{CPX_PARAM_QPMETHOD}            \tab \code{1063} \cr
    \code{CPX_PARAM_WORKDIR}             \tab \code{1064} \cr
    \code{CPX_PARAM_WORKMEM}             \tab \code{1065} \cr
    \code{CPX_PARAM_THREADS}             \tab \code{1067} \cr
    \code{CPX_PARAM_CONFLICTDISPLAY}     \tab \code{1074} \cr
    \code{CPX_PARAM_SIFTDISPLAY}         \tab \code{1076} \cr
    \code{CPX_PARAM_SIFTALG}             \tab \code{1077} \cr
    \code{CPX_PARAM_SIFTITLIM}           \tab \code{1078} \cr
    \code{CPX_PARAM_MPSLONGNUM}          \tab \code{1081} \cr
    \code{CPX_PARAM_MEMORYEMPHASIS}      \tab \code{1082} \cr
    \code{CPX_PARAM_NUMERICALEMPHASIS}   \tab \code{1083} \cr
    \code{CPX_PARAM_FEASOPTMODE}         \tab \code{1084} \cr
    \code{CPX_PARAM_PARALLELMODE}        \tab \code{1109} \cr
    \code{CPX_PARAM_TUNINGMEASURE}       \tab \code{1110} \cr
    \code{CPX_PARAM_TUNINGREPEAT}        \tab \code{1111} \cr
    \code{CPX_PARAM_TUNINGTILIM}         \tab \code{1112} \cr
    \code{CPX_PARAM_TUNINGDISPLAY}       \tab \code{1113} \cr
    \code{CPX_PARAM_WRITELEVEL}          \tab \code{1114} \cr
    \code{CPX_PARAM_RANDOMSEED}          \tab \code{1124} \cr
    \code{CPX_PARAM_DETTILIM}            \tab \code{1127} \cr
    \code{CPX_PARAM_FILEENCODING}        \tab \code{1129} \cr
    \code{CPX_PARAM_APIENCODING}         \tab \code{1130} \cr
    \code{CPX_PARAM_SOLUTIONTARGET}      \tab \code{1131} \cr
    \code{CPX_PARAM_CLONELOG}            \tab \code{1132} \cr
    \code{CPX_PARAM_TUNINGDETTILIM}      \tab \code{1139} \cr

    \code{CPX_PARAM_ALL_MIN}             \tab \code{1000} \cr
    \code{CPX_PARAM_ALL_MAX}             \tab \code{6000} \cr
  }
}


%------------------------------------------------------------------------------
\section{Values for \code{CPX_PARAM_TUNINGMEASURE}}{
  \tabular{ll}{
    \code{CPX_TUNE_AVERAGE} \tab \code{1} \cr
    \code{CPX_TUNE_MINMAX}  \tab \code{2} \cr
  }
}


%------------------------------------------------------------------------------
\section{Values for incomplete tuning}{
  \tabular{ll}{
    \code{CPX_TUNE_ABORT}    \tab \code{1} \cr
    \code{CPX_TUNE_TILIM}    \tab \code{2} \cr
    \code{CPX_TUNE_DETTILIM} \tab \code{3} \cr
  }
}


%------------------------------------------------------------------------------
\section{Quality query identifiers}{
  \tabular{ll}{
    \code{CPX_MAX_PRIMAL_INFEAS}          \tab \code{1} \cr
    \code{CPX_MAX_SCALED_PRIMAL_INFEAS}   \tab \code{2} \cr
    \code{CPX_SUM_PRIMAL_INFEAS}          \tab \code{3} \cr
    \code{CPX_SUM_SCALED_PRIMAL_INFEAS}   \tab \code{4} \cr
    \code{CPX_MAX_DUAL_INFEAS}            \tab \code{5} \cr
    \code{CPX_MAX_SCALED_DUAL_INFEAS}     \tab \code{6} \cr
    \code{CPX_SUM_DUAL_INFEAS}            \tab \code{7} \cr
    \code{CPX_SUM_SCALED_DUAL_INFEAS}     \tab \code{8} \cr
    \code{CPX_MAX_INT_INFEAS}             \tab \code{9} \cr
    \code{CPX_SUM_INT_INFEAS}             \tab \code{10} \cr
    \code{CPX_MAX_PRIMAL_RESIDUAL}        \tab \code{11} \cr
    \code{CPX_MAX_SCALED_PRIMAL_RESIDUAL} \tab \code{12} \cr
    \code{CPX_SUM_PRIMAL_RESIDUAL}        \tab \code{13} \cr
    \code{CPX_SUM_SCALED_PRIMAL_RESIDUAL} \tab \code{14} \cr
    \code{CPX_MAX_DUAL_RESIDUAL}          \tab \code{15} \cr
    \code{CPX_MAX_SCALED_DUAL_RESIDUAL}   \tab \code{16} \cr
    \code{CPX_SUM_DUAL_RESIDUAL}          \tab \code{17} \cr
    \code{CPX_SUM_SCALED_DUAL_RESIDUAL}   \tab \code{18} \cr
    \code{CPX_MAX_COMP_SLACK}             \tab \code{19} \cr
    \code{CPX_SUM_COMP_SLACK}             \tab \code{21} \cr
    \code{CPX_MAX_X}                      \tab \code{23} \cr
    \code{CPX_MAX_SCALED_X}               \tab \code{24} \cr
    \code{CPX_MAX_PI}                     \tab \code{25} \cr
    \code{CPX_MAX_SCALED_PI}              \tab \code{26} \cr
    \code{CPX_MAX_SLACK}                  \tab \code{27} \cr
    \code{CPX_MAX_SCALED_SLACK}           \tab \code{28} \cr
    \code{CPX_MAX_RED_COST}               \tab \code{29} \cr
    \code{CPX_MAX_SCALED_RED_COST}        \tab \code{30} \cr
    \code{CPX_SUM_X}                      \tab \code{31} \cr
    \code{CPX_SUM_SCALED_X}               \tab \code{32} \cr
    \code{CPX_SUM_PI}                     \tab \code{33} \cr
    \code{CPX_SUM_SCALED_PI}              \tab \code{34} \cr
    \code{CPX_SUM_SLACK}                  \tab \code{35} \cr
    \code{CPX_SUM_SCALED_SLACK}           \tab \code{36} \cr
    \code{CPX_SUM_RED_COST}               \tab \code{37} \cr
    \code{CPX_SUM_SCALED_RED_COST}        \tab \code{38} \cr
    \code{CPX_KAPPA}                      \tab \code{39} \cr
    \code{CPX_OBJ_GAP}                    \tab \code{40} \cr
    \code{CPX_DUAL_OBJ}                   \tab \code{41} \cr
    \code{CPX_PRIMAL_OBJ}                 \tab \code{42} \cr
    \code{CPX_MAX_QCPRIMAL_RESIDUAL}      \tab \code{43} \cr
    \code{CPX_SUM_QCPRIMAL_RESIDUAL}      \tab \code{44} \cr
    \code{CPX_MAX_QCSLACK_INFEAS}         \tab \code{45} \cr
    \code{CPX_SUM_QCSLACK_INFEAS}         \tab \code{46} \cr
    \code{CPX_MAX_QCSLACK}                \tab \code{47} \cr
    \code{CPX_SUM_QCSLACK}                \tab \code{48} \cr
    \code{CPX_MAX_INDSLACK_INFEAS}        \tab \code{49} \cr
    \code{CPX_SUM_INDSLACK_INFEAS}        \tab \code{50} \cr
    \code{CPX_EXACT_KAPPA}                \tab \code{51} \cr
    \code{CPX_KAPPA_STABLE}               \tab \code{52} \cr
    \code{CPX_KAPPA_SUSPICIOUS}           \tab \code{53} \cr
    \code{CPX_KAPPA_UNSTABLE}             \tab \code{54} \cr
    \code{CPX_KAPPA_ILLPOSED}             \tab \code{55} \cr
    \code{CPX_KAPPA_MAX}                  \tab \code{56} \cr
    \code{CPX_KAPPA_ATTENTION}            \tab \code{57} \cr
  }
}


%------------------------------------------------------------------------------
\section{Solution quality symbols new in CPLEX 12.9.0}{
  \tabular{ll}{
    \code{CPX_MAX_PWLSLACK_INFEAS}        \tab \code{58} \cr
    \code{CPX_SUM_PWLSLACK_INFEAS}        \tab \code{59} \cr
  }
}


%------------------------------------------------------------------------------
\section{feasopt options}{
  \tabular{ll}{
    \code{CPX_FEASOPT_MIN_SUM}  \tab \code{0} \cr
    \code{CPX_FEASOPT_OPT_SUM}  \tab \code{1} \cr
    \code{CPX_FEASOPT_MIN_INF}  \tab \code{2} \cr
    \code{CPX_FEASOPT_OPT_INF}  \tab \code{3} \cr
    \code{CPX_FEASOPT_MIN_QUAD} \tab \code{4} \cr
    \code{CPX_FEASOPT_OPT_QUAD} \tab \code{5} \cr
  }
}


%------------------------------------------------------------------------------
\section{File: \code{barconst.h}}{
  \tabular{ll}{
    \code{CPX_STAT_OPTIMAL_FACE_UNBOUNDED} \tab \code{20} \cr
    \code{CPX_STAT_ABORT_PRIM_OBJ_LIM}     \tab \code{21} \cr
    \code{CPX_STAT_ABORT_DUAL_OBJ_LIM}     \tab \code{22} \cr
    \code{CPX_STAT_FIRSTORDER}             \tab \code{24} \cr
  }
}

\section{Barrier parameters}{
  \tabular{ll}{
    \code{CPX_PARAM_BARDSTART}           \tab \code{3001} \cr
    \code{CPX_PARAM_BAREPCOMP}           \tab \code{3002} \cr
    \code{CPX_PARAM_BARGROWTH}           \tab \code{3003} \cr
    \code{CPX_PARAM_BAROBJRNG}           \tab \code{3004} \cr
    \code{CPX_PARAM_BARPSTART}           \tab \code{3005} \cr
    \code{CPX_PARAM_BARALG}              \tab \code{3007} \cr
    \code{CPX_PARAM_BARCOLNZ}            \tab \code{3009} \cr
    \code{CPX_PARAM_BARDISPLAY}          \tab \code{3010} \cr
    \code{CPX_PARAM_BARITLIM}            \tab \code{3012} \cr
    \code{CPX_PARAM_BARMAXCOR}           \tab \code{3013} \cr
    \code{CPX_PARAM_BARORDER}            \tab \code{3014} \cr
    \code{CPX_PARAM_BARSTARTALG}         \tab \code{3017} \cr
    \code{CPX_PARAM_BARCROSSALG}         \tab \code{3018} \cr
    \code{CPX_PARAM_BARQCPEPCOMP}        \tab \code{3020} \cr
  }
}

\section{Optimizing Problems}{
  \tabular{ll}{
    \code{CPX_BARORDER_AUTO} \tab \code{0} \cr
    \code{CPX_BARORDER_AMD}  \tab \code{1} \cr
    \code{CPX_BARORDER_AMF}  \tab \code{2} \cr
    \code{CPX_BARORDER_ND}   \tab \code{3} \cr
  }
}


%------------------------------------------------------------------------------
\section{MIP emphasis settings}{
  \tabular{ll}{
    \code{CPX_MIPEMPHASIS_BALANCED}     \tab \code{0} \cr
    \code{CPX_MIPEMPHASIS_FEASIBILITY}  \tab \code{1} \cr
    \code{CPX_MIPEMPHASIS_OPTIMALITY}   \tab \code{2} \cr
    \code{CPX_MIPEMPHASIS_BESTBOUND}    \tab \code{3} \cr
    \code{CPX_MIPEMPHASIS_HIDDENFEAS}   \tab \code{4} \cr
  }
}

\section{Values for sostype and branch type}{
  \tabular{ll}{
    \code{CPX_TYPE_VAR}                 \tab \code{"0"} \cr
    \code{CPX_TYPE_SOS1}                \tab \code{"1"} \cr
    \code{CPX_TYPE_SOS2}                \tab \code{"2"} \cr
    \code{CPX_TYPE_USER}                \tab \code{"X"} \cr
    \code{CPX_TYPE_ANY}                 \tab \code{"A"} \cr
  }
}

\section{Variable selection values}{
  \tabular{ll}{
    \code{CPX_VARSEL_MININFEAS}      \tab \code{-1} \cr
    \code{CPX_VARSEL_DEFAULT}        \tab \code{0} \cr
    \code{CPX_VARSEL_MAXINFEAS}      \tab \code{1} \cr
    \code{CPX_VARSEL_PSEUDO}         \tab \code{2} \cr
    \code{CPX_VARSEL_STRONG}         \tab \code{3} \cr
    \code{CPX_VARSEL_PSEUDOREDUCED}  \tab \code{4} \cr
  }
}

\section{Node selection values}{
  \tabular{ll}{
    \code{CPX_NODESEL_DFS}           \tab \code{0} \cr
    \code{CPX_NODESEL_BESTBOUND}     \tab \code{1} \cr
    \code{CPX_NODESEL_BESTEST}       \tab \code{2} \cr
    \code{CPX_NODESEL_BESTEST_ALT}   \tab \code{3} \cr
  }
}

\section{Values for generated priority order}{
  \tabular{ll}{
    \code{CPX_MIPORDER_COST}                \tab \code{1} \cr
    \code{CPX_MIPORDER_BOUNDS}              \tab \code{2} \cr
    \code{CPX_MIPORDER_SCALEDCOST}          \tab \code{3} \cr
  }
}

\section{Values for direction array}{
  \tabular{ll}{
    \code{CPX_BRANCH_GLOBAL}                \tab \code{0} \cr
    \code{CPX_BRANCH_DOWN}                  \tab \code{-1} \cr
    \code{CPX_BRANCH_UP}                    \tab \code{1} \cr
  }
}

\section{Values for \code{CPX_PARAM_BRDIR}}{
  \tabular{ll}{
    \code{CPX_BRDIR_DOWN}                   \tab \code{-1} \cr
    \code{CPX_BRDIR_AUTO}                   \tab \code{0} \cr
    \code{CPX_BRDIR_UP}                     \tab \code{1} \cr
  }
}

\section{Values for \code{CPX_PARAM_MIPSEARCH}}{
  \tabular{ll}{
    \code{CPX_MIPSEARCH_AUTO}         \tab \code{0} \cr
    \code{CPX_MIPSEARCH_TRADITIONAL}  \tab \code{1} \cr
    \code{CPX_MIPSEARCH_DYNAMIC}      \tab \code{2} \cr
  }
}

\section{Values for \code{CPX_PARAM_MIPKAPPASTATS}}{
  \tabular{ll}{
    \code{CPX_MIPKAPPA_OFF}     \tab \code{-1} \cr
    \code{CPX_MIPKAPPA_AUTO}    \tab \code{0} \cr
    \code{CPX_MIPKAPPA_SAMPLE}  \tab \code{1} \cr
    \code{CPX_MIPKAPPA_FULL}    \tab \code{2} \cr
  }
}

\section{Effort levels for MIP starts}{
  \tabular{ll}{
    \code{CPX_MIPSTART_AUTO}          \tab \code{0} \cr
    \code{CPX_MIPSTART_CHECKFEAS}     \tab \code{1} \cr
    \code{CPX_MIPSTART_SOLVEFIXED}    \tab \code{2} \cr
    \code{CPX_MIPSTART_SOLVEMIP}      \tab \code{3} \cr
    \code{CPX_MIPSTART_REPAIR}        \tab \code{4} \cr
  }
}

\section{MIP Problem status codes}{
  \tabular{ll}{
    \code{CPXMIP_OPTIMAL}               \tab \code{101} \cr
    \code{CPXMIP_OPTIMAL_TOL}           \tab \code{102} \cr
    \code{CPXMIP_INFEASIBLE}            \tab \code{103} \cr
    \code{CPXMIP_SOL_LIM}               \tab \code{104} \cr
    \code{CPXMIP_NODE_LIM_FEAS}         \tab \code{105} \cr
    \code{CPXMIP_NODE_LIM_INFEAS}       \tab \code{106} \cr
    \code{CPXMIP_TIME_LIM_FEAS}         \tab \code{107} \cr
    \code{CPXMIP_TIME_LIM_INFEAS}       \tab \code{108} \cr
    \code{CPXMIP_FAIL_FEAS}             \tab \code{109} \cr
    \code{CPXMIP_FAIL_INFEAS}           \tab \code{110} \cr
    \code{CPXMIP_MEM_LIM_FEAS}          \tab \code{111} \cr
    \code{CPXMIP_MEM_LIM_INFEAS}        \tab \code{112} \cr
    \code{CPXMIP_ABORT_FEAS}            \tab \code{113} \cr
    \code{CPXMIP_ABORT_INFEAS}          \tab \code{114} \cr
    \code{CPXMIP_OPTIMAL_INFEAS}        \tab \code{115} \cr
    \code{CPXMIP_FAIL_FEAS_NO_TREE}     \tab \code{116} \cr
    \code{CPXMIP_FAIL_INFEAS_NO_TREE}   \tab \code{117} \cr
    \code{CPXMIP_UNBOUNDED}             \tab \code{118} \cr
    \code{CPXMIP_INForUNBD}             \tab \code{119} \cr
    \code{CPXMIP_FEASIBLE_RELAXED_SUM}  \tab \code{120} \cr
    \code{CPXMIP_OPTIMAL_RELAXED_SUM}   \tab \code{121} \cr
    \code{CPXMIP_FEASIBLE_RELAXED_INF}  \tab \code{122} \cr
    \code{CPXMIP_OPTIMAL_RELAXED_INF}   \tab \code{123} \cr
    \code{CPXMIP_FEASIBLE_RELAXED_QUAD} \tab \code{124} \cr
    \code{CPXMIP_OPTIMAL_RELAXED_QUAD}  \tab \code{125} \cr
    \code{CPXMIP_ABORT_RELAXED}         \tab \code{126} \cr
    \code{CPXMIP_FEASIBLE}              \tab \code{127} \cr
    \code{CPXMIP_POPULATESOL_LIM}       \tab \code{128} \cr
    \code{CPXMIP_OPTIMAL_POPULATED}     \tab \code{129} \cr
    \code{CPXMIP_OPTIMAL_POPULATED_TOL} \tab \code{130} \cr
    \code{CPXMIP_DETTIME_LIM_FEAS}      \tab \code{131} \cr
    \code{CPXMIP_DETTIME_LIM_INFEAS}    \tab \code{132} \cr
  }
}

\section{Valid purgeable values for adding usercuts and lazyconstraints}{
  \tabular{ll}{
    \code{CPX_USECUT_FORCE}             \tab \code{0} \cr
    \code{CPX_USECUT_PURGE}             \tab \code{1} \cr
    \code{CPX_USECUT_FILTER}            \tab \code{2} \cr
  }
}

\section{For \code{CPXgetnodeintfeas}}{
  \tabular{ll}{
    \code{CPX_INTEGER_FEASIBLE}         \tab \code{0} \cr
    \code{CPX_INTEGER_INFEASIBLE}       \tab \code{1} \cr
    \code{CPX_IMPLIED_INTEGER_FEASIBLE} \tab \code{2} \cr
  }
}

\section{MIP Parameter numbers}{
  \tabular{ll}{
    \code{CPX_PARAM_BRDIR}               \tab \code{2001} \cr
    \code{CPX_PARAM_BTTOL}               \tab \code{2002} \cr
    \code{CPX_PARAM_CLIQUES}             \tab \code{2003} \cr
    \code{CPX_PARAM_COEREDIND}           \tab \code{2004} \cr
    \code{CPX_PARAM_COVERS}              \tab \code{2005} \cr
    \code{CPX_PARAM_CUTLO}               \tab \code{2006} \cr
    \code{CPX_PARAM_CUTUP}               \tab \code{2007} \cr
    \code{CPX_PARAM_EPAGAP}              \tab \code{2008} \cr
    \code{CPX_PARAM_EPGAP}               \tab \code{2009} \cr
    \code{CPX_PARAM_EPINT}               \tab \code{2010} \cr
    \code{CPX_PARAM_MIPDISPLAY}          \tab \code{2012} \cr
    \code{CPX_PARAM_MIPINTERVAL}         \tab \code{2013} \cr
    \code{CPX_PARAM_INTSOLLIM}           \tab \code{2015} \cr
    \code{CPX_PARAM_NODEFILEIND}         \tab \code{2016} \cr
    \code{CPX_PARAM_NODELIM}             \tab \code{2017} \cr
    \code{CPX_PARAM_NODESEL}             \tab \code{2018} \cr
    \code{CPX_PARAM_OBJDIF}              \tab \code{2019} \cr
    \code{CPX_PARAM_MIPORDIND}           \tab \code{2020} \cr
    \code{CPX_PARAM_RELOBJDIF}           \tab \code{2022} \cr
    \code{CPX_PARAM_STARTALG}            \tab \code{2025} \cr
    \code{CPX_PARAM_SUBALG}              \tab \code{2026} \cr
    \code{CPX_PARAM_TRELIM}              \tab \code{2027} \cr
    \code{CPX_PARAM_VARSEL}              \tab \code{2028} \cr
    \code{CPX_PARAM_BNDSTRENIND}         \tab \code{2029} \cr
    \code{CPX_PARAM_HEURFREQ}            \tab \code{2031} \cr
    \code{CPX_PARAM_MIPORDTYPE}          \tab \code{2032} \cr
    \code{CPX_PARAM_CUTSFACTOR}          \tab \code{2033} \cr
    \code{CPX_PARAM_RELAXPREIND}         \tab \code{2034} \cr
    \code{CPX_PARAM_PRESLVND}            \tab \code{2037} \cr
    \code{CPX_PARAM_BBINTERVAL}          \tab \code{2039} \cr
    \code{CPX_PARAM_FLOWCOVERS}          \tab \code{2040} \cr
    \code{CPX_PARAM_IMPLBD}              \tab \code{2041} \cr
    \code{CPX_PARAM_PROBE}               \tab \code{2042} \cr
    \code{CPX_PARAM_GUBCOVERS}           \tab \code{2044} \cr
    \code{CPX_PARAM_STRONGCANDLIM}       \tab \code{2045} \cr
    \code{CPX_PARAM_STRONGITLIM}         \tab \code{2046} \cr
    \code{CPX_PARAM_FRACCAND}            \tab \code{2048} \cr
    \code{CPX_PARAM_FRACCUTS}            \tab \code{2049} \cr
    \code{CPX_PARAM_FRACPASS}            \tab \code{2050} \cr
    \code{CPX_PARAM_FLOWPATHS}           \tab \code{2051} \cr
    \code{CPX_PARAM_MIRCUTS}             \tab \code{2052} \cr
    \code{CPX_PARAM_DISJCUTS}            \tab \code{2053} \cr
    \code{CPX_PARAM_AGGCUTLIM}           \tab \code{2054} \cr
    \code{CPX_PARAM_MIPCBREDLP}          \tab \code{2055} \cr
    \code{CPX_PARAM_CUTPASS}             \tab \code{2056} \cr
    \code{CPX_PARAM_MIPEMPHASIS}         \tab \code{2058} \cr
    \code{CPX_PARAM_SYMMETRY}            \tab \code{2059} \cr
    \code{CPX_PARAM_DIVETYPE}            \tab \code{2060} \cr
    \code{CPX_PARAM_RINSHEUR}            \tab \code{2061} \cr
    % removed in CPLEX 12.9.0 begin
    \code{CPX_PARAM_SUBMIPNODELIM}       \tab \code{2062} \cr
    % removed in CPLEX 12.9.0 end
    \code{CPX_PARAM_LBHEUR}              \tab \code{2063} \cr
    \code{CPX_PARAM_REPEATPRESOLVE}      \tab \code{2064} \cr
    \code{CPX_PARAM_PROBETIME}           \tab \code{2065} \cr
    \code{CPX_PARAM_POLISHTIME}          \tab \code{2066} \cr
    \code{CPX_PARAM_REPAIRTRIES}         \tab \code{2067} \cr
    \code{CPX_PARAM_EPLIN}               \tab \code{2068} \cr
    \code{CPX_PARAM_EPRELAX}             \tab \code{2073} \cr
    \code{CPX_PARAM_FPHEUR}              \tab \code{2098} \cr
    \code{CPX_PARAM_EACHCUTLIM}          \tab \code{2102} \cr
    \code{CPX_PARAM_SOLNPOOLCAPACITY}    \tab \code{2103} \cr
    \code{CPX_PARAM_SOLNPOOLREPLACE}     \tab \code{2104} \cr
    \code{CPX_PARAM_SOLNPOOLGAP}         \tab \code{2105} \cr
    \code{CPX_PARAM_SOLNPOOLAGAP}        \tab \code{2106} \cr
    \code{CPX_PARAM_SOLNPOOLINTENSITY}   \tab \code{2107} \cr
    \code{CPX_PARAM_POPULATELIM}         \tab \code{2108} \cr
    \code{CPX_PARAM_MIPSEARCH}           \tab \code{2109} \cr
    \code{CPX_PARAM_MIQCPSTRAT}          \tab \code{2110} \cr
    \code{CPX_PARAM_ZEROHALFCUTS}        \tab \code{2111} \cr
    \code{CPX_PARAM_POLISHAFTEREPAGAP}   \tab \code{2126} \cr
    \code{CPX_PARAM_POLISHAFTEREPGAP}    \tab \code{2127} \cr
    \code{CPX_PARAM_POLISHAFTERNODE}     \tab \code{2128} \cr
    \code{CPX_PARAM_POLISHAFTERINTSOL}   \tab \code{2129} \cr
    \code{CPX_PARAM_POLISHAFTERTIME}     \tab \code{2130} \cr
    \code{CPX_PARAM_MCFCUTS}             \tab \code{2134} \cr
    \code{CPX_PARAM_MIPKAPPASTATS}       \tab \code{2137} \cr
    \code{CPX_PARAM_AUXROOTTHREADS}      \tab \code{2139} \cr
    \code{CPX_PARAM_INTSOLFILEPREFIX}    \tab \code{2143} \cr
    \code{CPX_PARAM_PROBEDETTIME}        \tab \code{2150} \cr
    \code{CPX_PARAM_POLISHAFTERDETTIME}  \tab \code{2151} \cr
    \code{CPX_PARAM_LANDPCUTS}           \tab \code{2152} \cr
    \code{CPX_PARAM_RAMPUPDURATION}      \tab \code{2163} \cr
    \code{CPX_PARAM_RAMPUPDETTILIM}      \tab \code{2164} \cr
    \code{CPX_PARAM_RAMPUPTILIM}         \tab \code{2165} \cr
  }
}

\section{Values for \code{CPX_PARAM_SOLNPOOLREPLACE}}{
  \tabular{ll}{
    \code{CPX_SOLNPOOL_FIFO}    \tab \code{0} \cr
    \code{CPX_SOLNPOOL_OBJ}     \tab \code{1} \cr
    \code{CPX_SOLNPOOL_DIV}     \tab \code{2} \cr

    \code{CPX_SOLNPOOL_FILTER_DIVERSITY}   \tab \code{1} \cr
    \code{CPX_SOLNPOOL_FILTER_RANGE}       \tab \code{2} \cr
  }
}


%------------------------------------------------------------------------------
\section{File: \code{gcconst.h}}{
  \tabular{ll}{
    \code{CPX_CON_LOWER_BOUND}          \tab \code{1} \cr
    \code{CPX_CON_UPPER_BOUND}          \tab \code{2} \cr
    \code{CPX_CON_LINEAR}               \tab \code{3} \cr
    \code{CPX_CON_QUADRATIC}            \tab \code{4} \cr
    \code{CPX_CON_SOS}                  \tab \code{5} \cr
    \code{CPX_CON_INDICATOR}            \tab \code{6} \cr
  }
}

\section{internal types}{
  \tabular{ll}{
    \code{CPX_CON_MINEXPR}              \tab \code{7} \cr
    \code{CPX_CON_MAXEXPR}              \tab \code{8} \cr
    \code{CPX_CON_PWL}                  \tab \code{9} \cr
    \code{CPX_CON_ABS}                  \tab \code{9} \cr
    % removed in CPLEX 12.9.0 begin
    \code{CPX_CON_DISJCST}              \tab \code{10} \cr
    \code{CPX_CON_INDDISJCST}           \tab \code{11} \cr
    \code{CPX_CON_SETVAR}               \tab \code{12} \cr
    \code{CPX_CON_SETVARMEMBER}         \tab \code{13} \cr
    \code{CPX_CON_SETVARCARD}           \tab \code{14} \cr
    \code{CPX_CON_SETVARSUM}            \tab \code{15} \cr
    \code{CPX_CON_SETVARMIN}            \tab \code{16} \cr
    \code{CPX_CON_SETVARMAX}            \tab \code{17} \cr
    \code{CPX_CON_SETVARSUBSET}         \tab \code{18} \cr
    \code{CPX_CON_SETVARDOMAIN}         \tab \code{19} \cr
    \code{CPX_CON_SETVARUNION}          \tab \code{20} \cr
    \code{CPX_CON_SETVARINTERSECTION}   \tab \code{21} \cr
    \code{CPX_CON_SETVARNULLINTERSECT}  \tab \code{22} \cr
    \code{CPX_CON_SETVARINTERSECT}      \tab \code{23} \cr
    \code{CPX_CON_SETVAREQ}             \tab \code{24} \cr
    \code{CPX_CON_SETVARNEQ}            \tab \code{25} \cr
    \code{CPX_CON_SETVARNEQCST}         \tab \code{26} \cr
    % removed in CPLEX 12.9.0 end
    \code{CPX_CON_LAST_CONTYPE}         \tab \code{27} \cr
  }
}


%------------------------------------------------------------------------------
\section{Network parameters}{
  \tabular{ll}{
    \code{CPX_PARAM_NETITLIM}            \tab \code{5001} \cr
    \code{CPX_PARAM_NETEPOPT}            \tab \code{5002} \cr
    \code{CPX_PARAM_NETEPRHS}            \tab \code{5003} \cr
    \code{CPX_PARAM_NETPPRIIND}          \tab \code{5004} \cr
    \code{CPX_PARAM_NETDISPLAY}          \tab \code{5005} \cr
  }
}

\section{NETOPT display values}{
  \tabular{ll}{
    \code{CPXNET_NO_DISPLAY_OBJECTIVE} \tab \code{0} \cr
    \code{CPXNET_TRUE_OBJECTIVE}       \tab \code{1} \cr
    \code{CPXNET_PENALIZED_OBJECTIVE}  \tab \code{2} \cr
  }
}

\section{NETOPT pricing parameters}{
  \tabular{ll}{
    \code{CPXNET_PRICE_AUTO}           \tab \code{0} \cr
    \code{CPXNET_PRICE_PARTIAL}        \tab \code{1} \cr
    \code{CPXNET_PRICE_MULT_PART}      \tab \code{2} \cr
    \code{CPXNET_PRICE_SORT_MULT_PART} \tab \code{3} \cr
  }
}


\section{Copying data}{
  \tabular{ll}{
    \code{CPX_PARAM_QPNZREADLIM}         \tab \code{4001} \cr
  }
}

\section{Specify how to calculate duals for QCPs}{
  \tabular{ll}{
    \code{CPX_PARAM_CALCQCPDUALS}        \tab \code{4003} \cr
  }
}

\section{presolve}{
  \tabular{ll}{
    \code{CPX_PARAM_QPMAKEPSDIND}        \tab \code{4010} \cr
  }
}


%------------------------------------------------------------------------------
\section{Error codes}{
Callable library miscellaneous routines
  \tabular{ll}{
    \code{CPXERR_NEGATIVE_SURPLUS}       \tab \code{1207} \cr
    \code{CPXERR_NO_SENSIT}              \tab \code{1260} \cr
  }
}


%------------------------------------------------------------------------------
\section{Error codes new in CPLEX 12.8.0}{
Callable library miscellaneous routines
  \tabular{ll}{
    \code{CPXERR_CALLBACK_INCONSISTENT}      \tab \code{1060} \cr
    \code{CPXERR_CAND_NOT_RAY}               \tab \code{3026} \cr
    \code{CPXERR_CAND_NOT_POINT}             \tab \code{3025} \cr
  }
}


%------------------------------------------------------------------------------
\section{Error codes new in CPLEX 12.9.0}{
Callable library miscellaneous routines
  \tabular{ll}{
    \code{CPXERR_BAD_MULTIOBJ_ATTR}      \tab \code{1488} \cr
    \code{CPXERR_MULTIOBJ_SUBPROB_SOLVE} \tab \code{1300} \cr
    \code{CPXERR_NO_OBJ_NAME}            \tab \code{1486} \cr
    \code{CPXERR_NOT_FOR_MULTIOBJ}       \tab \code{1070} \cr
  }
}


%------------------------------------------------------------------------------
\section{new parameter names introduced in IBM ILOG CPLEX version 12.6}{
Callable library miscellaneous routines
  \tabular{ll}{
    \code{CPXPARAM_Advance}                         \tab \code{1001} \cr
    \code{CPXPARAM_Barrier_Algorithm}               \tab \code{3007} \cr
    \code{CPXPARAM_Barrier_ColNonzeros}             \tab \code{3009} \cr
    \code{CPXPARAM_Barrier_ConvergeTol}             \tab \code{3002} \cr
    \code{CPXPARAM_Barrier_Crossover}               \tab \code{3018} \cr
    \code{CPXPARAM_Barrier_Display}                 \tab \code{3010} \cr
    \code{CPXPARAM_Barrier_Limits_Corrections}      \tab \code{3013} \cr
    \code{CPXPARAM_Barrier_Limits_Growth}           \tab \code{3003} \cr
    \code{CPXPARAM_Barrier_Limits_Iteration}        \tab \code{3012} \cr
    \code{CPXPARAM_Barrier_Limits_ObjRange}         \tab \code{3004} \cr
    \code{CPXPARAM_Barrier_Ordering}                \tab \code{3014} \cr
    \code{CPXPARAM_Barrier_QCPConvergeTol}          \tab \code{3020} \cr
    \code{CPXPARAM_Barrier_StartAlg}                \tab \code{3017} \cr
    \code{CPXPARAM_ClockType}                       \tab \code{1006} \cr
    \code{CPXPARAM_Conflict_Display}                \tab \code{1074} \cr
    \code{CPXPARAM_DetTimeLimit}                    \tab \code{1127} \cr
    \code{CPXPARAM_DistMIP_Rampup_DetTimeLimit}     \tab \code{2164} \cr
    \code{CPXPARAM_DistMIP_Rampup_Duration}         \tab \code{2163} \cr
    \code{CPXPARAM_DistMIP_Rampup_TimeLimit}        \tab \code{2165} \cr
    \code{CPXPARAM_Emphasis_Memory}                 \tab \code{1082} \cr
    \code{CPXPARAM_Emphasis_MIP}                    \tab \code{2058} \cr
    \code{CPXPARAM_Emphasis_Numerical}              \tab \code{1083} \cr
    \code{CPXPARAM_Feasopt_Mode}                    \tab \code{1084} \cr
    \code{CPXPARAM_Feasopt_Tolerance}               \tab \code{2073} \cr
    \code{CPXPARAM_LPMethod}                        \tab \code{1062} \cr
    \code{CPXPARAM_MIP_Cuts_Cliques}                \tab \code{2003} \cr
    \code{CPXPARAM_MIP_Cuts_Covers}                 \tab \code{2005} \cr
    \code{CPXPARAM_MIP_Cuts_Disjunctive}            \tab \code{2053} \cr
    \code{CPXPARAM_MIP_Cuts_FlowCovers}             \tab \code{2040} \cr
    \code{CPXPARAM_MIP_Cuts_Gomory}                 \tab \code{2049} \cr
    \code{CPXPARAM_MIP_Cuts_GUBCovers}              \tab \code{2044} \cr
    \code{CPXPARAM_MIP_Cuts_Implied}                \tab \code{2041} \cr
    \code{CPXPARAM_MIP_Cuts_LiftProj}               \tab \code{2152} \cr
    \code{CPXPARAM_MIP_Cuts_MCFCut}                 \tab \code{2134} \cr
    \code{CPXPARAM_MIP_Cuts_MIRCut}                 \tab \code{2052} \cr
    \code{CPXPARAM_MIP_Cuts_PathCut}                \tab \code{2051} \cr
    \code{CPXPARAM_MIP_Cuts_ZeroHalfCut}            \tab \code{2111} \cr
    \code{CPXPARAM_MIP_Display}                     \tab \code{2012} \cr
    \code{CPXPARAM_MIP_Interval}                    \tab \code{2013} \cr
    \code{CPXPARAM_MIP_Limits_AggForCut}            \tab \code{2054} \cr
    \code{CPXPARAM_MIP_Limits_AuxRootThreads}       \tab \code{2139} \cr
    \code{CPXPARAM_MIP_Limits_CutPasses}            \tab \code{2056} \cr
    \code{CPXPARAM_MIP_Limits_CutsFactor}           \tab \code{2033} \cr
    \code{CPXPARAM_MIP_Limits_EachCutLimit}         \tab \code{2102} \cr
    \code{CPXPARAM_MIP_Limits_GomoryCand}           \tab \code{2048} \cr
    \code{CPXPARAM_MIP_Limits_GomoryPass}           \tab \code{2050} \cr
    \code{CPXPARAM_MIP_Limits_Nodes}                \tab \code{2017} \cr
    \code{CPXPARAM_MIP_Limits_PolishTime}           \tab \code{2066} \cr
    \code{CPXPARAM_MIP_Limits_Populate}             \tab \code{2108} \cr
    \code{CPXPARAM_MIP_Limits_ProbeDetTime}         \tab \code{2150} \cr
    \code{CPXPARAM_MIP_Limits_ProbeTime}            \tab \code{2065} \cr
    \code{CPXPARAM_MIP_Limits_RepairTries}          \tab \code{2067} \cr
    \code{CPXPARAM_MIP_Limits_Solutions}            \tab \code{2015} \cr
    \code{CPXPARAM_MIP_Limits_StrongCand}           \tab \code{2045} \cr
    \code{CPXPARAM_MIP_Limits_StrongIt}             \tab \code{2046} \cr
    \code{CPXPARAM_MIP_Limits_SubMIPNodeLim}        \tab \code{2062} \cr
    \code{CPXPARAM_MIP_Limits_TreeMemory}           \tab \code{2027} \cr
    \code{CPXPARAM_MIP_OrderType}                   \tab \code{2032} \cr
    \code{CPXPARAM_MIP_PolishAfter_AbsMIPGap}       \tab \code{2126} \cr
    \code{CPXPARAM_MIP_PolishAfter_DetTime}         \tab \code{2151} \cr
    \code{CPXPARAM_MIP_PolishAfter_MIPGap}          \tab \code{2127} \cr
    \code{CPXPARAM_MIP_PolishAfter_Nodes}           \tab \code{2128} \cr
    \code{CPXPARAM_MIP_PolishAfter_Solutions}       \tab \code{2129} \cr
    \code{CPXPARAM_MIP_PolishAfter_Time}            \tab \code{2130} \cr
    \code{CPXPARAM_MIP_Pool_AbsGap}                 \tab \code{2106} \cr
    \code{CPXPARAM_MIP_Pool_Capacity}               \tab \code{2103} \cr
    \code{CPXPARAM_MIP_Pool_Intensity}              \tab \code{2107} \cr
    \code{CPXPARAM_MIP_Pool_RelGap}                 \tab \code{2105} \cr
    \code{CPXPARAM_MIP_Pool_Replace}                \tab \code{2104} \cr
    \code{CPXPARAM_MIP_Strategy_Backtrack}          \tab \code{2002} \cr
    \code{CPXPARAM_MIP_Strategy_BBInterval}         \tab \code{2039} \cr
    \code{CPXPARAM_MIP_Strategy_Branch}             \tab \code{2001} \cr
    \code{CPXPARAM_MIP_Strategy_CallbackReducedLP}  \tab \code{2055} \cr
    \code{CPXPARAM_MIP_Strategy_Dive}               \tab \code{2060} \cr
    \code{CPXPARAM_MIP_Strategy_File}               \tab \code{2016} \cr
    \code{CPXPARAM_MIP_Strategy_FPHeur}             \tab \code{2098} \cr
    \code{CPXPARAM_MIP_Strategy_HeuristicFreq}      \tab \code{2031} \cr
    \code{CPXPARAM_MIP_Strategy_KappaStats}         \tab \code{2137} \cr
    \code{CPXPARAM_MIP_Strategy_LBHeur}             \tab \code{2063} \cr
    \code{CPXPARAM_MIP_Strategy_MIQCPStrat}         \tab \code{2110} \cr
    \code{CPXPARAM_MIP_Strategy_NodeSelect}         \tab \code{2018} \cr
    \code{CPXPARAM_MIP_Strategy_Order}              \tab \code{2020} \cr
    \code{CPXPARAM_MIP_Strategy_PresolveNode}       \tab \code{2037} \cr
    \code{CPXPARAM_MIP_Strategy_Probe}              \tab \code{2042} \cr
    \code{CPXPARAM_MIP_Strategy_RINSHeur}           \tab \code{2061} \cr
    \code{CPXPARAM_MIP_Strategy_Search}             \tab \code{2109} \cr
    \code{CPXPARAM_MIP_Strategy_StartAlgorithm}     \tab \code{2025} \cr
    \code{CPXPARAM_MIP_Strategy_SubAlgorithm}       \tab \code{2026} \cr
    \code{CPXPARAM_MIP_Strategy_VariableSelect}     \tab \code{2028} \cr
    \code{CPXPARAM_MIP_Tolerances_AbsMIPGap}        \tab \code{2008} \cr
    \code{CPXPARAM_MIP_Tolerances_Integrality}      \tab \code{2010} \cr
    \code{CPXPARAM_MIP_Tolerances_LowerCutoff}      \tab \code{2006} \cr
    \code{CPXPARAM_MIP_Tolerances_MIPGap}           \tab \code{2009} \cr
    \code{CPXPARAM_MIP_Tolerances_ObjDifference}    \tab \code{2019} \cr
    \code{CPXPARAM_MIP_Tolerances_RelObjDifference} \tab \code{2022} \cr
    \code{CPXPARAM_MIP_Tolerances_UpperCutoff}      \tab \code{2007} \cr
    \code{CPXPARAM_Network_Display}                 \tab \code{5005} \cr
    \code{CPXPARAM_Network_Iterations}              \tab \code{5001} \cr
    \code{CPXPARAM_Network_NetFind}                 \tab \code{1022} \cr
    \code{CPXPARAM_Network_Pricing}                 \tab \code{5004} \cr
    \code{CPXPARAM_Network_Tolerances_Feasibility}  \tab \code{5003} \cr
    \code{CPXPARAM_Network_Tolerances_Optimality}   \tab \code{5002} \cr
    \code{CPXPARAM_Output_CloneLog}                 \tab \code{1132} \cr
    \code{CPXPARAM_Output_IntSolFilePrefix}         \tab \code{2143} \cr
    \code{CPXPARAM_Output_MPSLong}                  \tab \code{1081} \cr
    \code{CPXPARAM_Output_WriteLevel}               \tab \code{1114} \cr
    \code{CPXPARAM_Parallel}                        \tab \code{1109} \cr
    \code{CPXPARAM_Preprocessing_Aggregator}        \tab \code{1003} \cr
    \code{CPXPARAM_Preprocessing_BoundStrength}     \tab \code{2029} \cr
    \code{CPXPARAM_Preprocessing_CoeffReduce}       \tab \code{2004} \cr
    \code{CPXPARAM_Preprocessing_Dependency}        \tab \code{1008} \cr
    \code{CPXPARAM_Preprocessing_Dual}              \tab \code{1044} \cr
    \code{CPXPARAM_Preprocessing_Fill}              \tab \code{1002} \cr
    \code{CPXPARAM_Preprocessing_Linear}            \tab \code{1058} \cr
    \code{CPXPARAM_Preprocessing_NumPass}           \tab \code{1052} \cr
    \code{CPXPARAM_Preprocessing_Presolve}          \tab \code{1030} \cr
    \code{CPXPARAM_Preprocessing_QCPDuals}          \tab \code{4003} \cr
    \code{CPXPARAM_Preprocessing_QPMakePSD}         \tab \code{4010} \cr
    \code{CPXPARAM_Preprocessing_Reduce}            \tab \code{1057} \cr
    \code{CPXPARAM_Preprocessing_Relax}             \tab \code{2034} \cr
    \code{CPXPARAM_Preprocessing_RepeatPresolve}    \tab \code{2064} \cr
    \code{CPXPARAM_Preprocessing_Symmetry}          \tab \code{2059} \cr
    \code{CPXPARAM_QPMethod}                        \tab \code{1063} \cr
    \code{CPXPARAM_RandomSeed}                      \tab \code{1124} \cr
    \code{CPXPARAM_Read_APIEncoding}                \tab \code{1130} \cr
    \code{CPXPARAM_Read_Constraints}                \tab \code{1021} \cr
    \code{CPXPARAM_Read_DataCheck}                  \tab \code{1056} \cr
    \code{CPXPARAM_Read_FileEncoding}               \tab \code{1129} \cr
    \code{CPXPARAM_Read_Nonzeros}                   \tab \code{1024} \cr
    \code{CPXPARAM_Read_QPNonzeros}                 \tab \code{4001} \cr
    \code{CPXPARAM_Read_Scale}                      \tab \code{1034} \cr
    \code{CPXPARAM_Read_Variables}                  \tab \code{1023} \cr
    \code{CPXPARAM_ScreenOutput}                    \tab \code{1035} \cr
    \code{CPXPARAM_Sifting_Algorithm}               \tab \code{1077} \cr
    \code{CPXPARAM_Sifting_Display}                 \tab \code{1076} \cr
    \code{CPXPARAM_Sifting_Iterations}              \tab \code{1078} \cr
    \code{CPXPARAM_Simplex_Crash}                   \tab \code{1007} \cr
    \code{CPXPARAM_Simplex_DGradient}               \tab \code{1009} \cr
    \code{CPXPARAM_Simplex_Display}                 \tab \code{1019} \cr
    \code{CPXPARAM_Simplex_Limits_Iterations}       \tab \code{1020} \cr
    \code{CPXPARAM_Simplex_Limits_LowerObj}         \tab \code{1025} \cr
    \code{CPXPARAM_Simplex_Limits_Perturbation}     \tab \code{1028} \cr
    \code{CPXPARAM_Simplex_Limits_Singularity}      \tab \code{1037} \cr
    \code{CPXPARAM_Simplex_Limits_UpperObj}         \tab \code{1026} \cr
    \code{CPXPARAM_Simplex_Perturbation_Constant}   \tab \code{1015} \cr
    \code{CPXPARAM_Simplex_Perturbation_Indicator}  \tab \code{1027} \cr
    \code{CPXPARAM_Simplex_PGradient}               \tab \code{1029} \cr
    \code{CPXPARAM_Simplex_Pricing}                 \tab \code{1010} \cr
    \code{CPXPARAM_Simplex_Refactor}                \tab \code{1031} \cr
    \code{CPXPARAM_Simplex_Tolerances_Feasibility}  \tab \code{1016} \cr
    \code{CPXPARAM_Simplex_Tolerances_Markowitz}    \tab \code{1013} \cr
    \code{CPXPARAM_Simplex_Tolerances_Optimality}   \tab \code{1014} \cr
    \code{CPXPARAM_SolutionTarget}                  \tab \code{1131} \cr
    \code{CPXPARAM_Threads}                         \tab \code{1067} \cr
    \code{CPXPARAM_TimeLimit}                       \tab \code{1039} \cr
    \code{CPXPARAM_Tune_DetTimeLimit}               \tab \code{1139} \cr
    \code{CPXPARAM_Tune_Display}                    \tab \code{1113} \cr
    \code{CPXPARAM_Tune_Measure}                    \tab \code{1110} \cr
    \code{CPXPARAM_Tune_Repeat}                     \tab \code{1111} \cr
    \code{CPXPARAM_Tune_TimeLimit}                  \tab \code{1112} \cr
    \code{CPXPARAM_WorkDir}                         \tab \code{1064} \cr
    \code{CPXPARAM_WorkMem}                         \tab \code{1065} \cr
  }
}

%------------------------------------------------------------------------------
\section{new parameter names introduced in IBM ILOG CPLEX version 12.8.0}{
Callable library miscellaneous routines
  \tabular{ll}{
    \code{CPXPARAM_Record}                          \tab \code{1162} \cr
    \code{CPXPARAM_MIP_Strategy_SubMIPScale}        \tab \code{2207} \cr
    \code{CPXPARAM_MIP_Strategy_SubMIPStartAlg}     \tab \code{2205} \cr
    \code{CPXPARAM_MIP_Strategy_SubMIPSubAlg}       \tab \code{2206} \cr
    \code{CPXPARAM_ParamDisplay}                    \tab \code{1163} \cr
    \code{CPX_PARAM_PARAMDISPLAY}                   \tab \code{1163} \cr
    \code{CPXMI_SAMECOEFF_ROW}                      \tab \code{1049} \cr
    \code{CPXMI_SAMECOEFF_COL}                      \tab \code{1050} \cr
    \code{CPXMI_SAMECOEFF_IND}                      \tab \code{1051} \cr
    \code{CPXMI_SAMECOEFF_QLIN}                     \tab \code{1052} \cr
    \code{CPXMI_SAMECOEFF_QUAD}                     \tab \code{1053} \cr
    \code{CPXMI_SAMECOEFF_LAZY}                     \tab \code{1054} \cr
    \code{CPXMI_SAMECOEFF_UCUT}                     \tab \code{1055} \cr
    \code{CPXMI_SAMECOEFF_RHS}                      \tab \code{1056} \cr
    \code{CPXMI_SAMECOEFF_OBJ}                      \tab \code{1057} \cr
    
    \code{CPX_CALLBACKCONTEXT_CANDIDATE}            \tab \code{0x0020} \cr
    \code{CPX_CALLBACKCONTEXT_GLOBAL_PROGRESS}      \tab \code{0x0010} \cr
    \code{CPX_CALLBACKCONTEXT_LOCAL_PROGRESS}       \tab \code{0x0008} \cr
    \code{CPX_CALLBACKCONTEXT_RELAXATION}           \tab \code{0x0040} \cr
    \code{CPX_CALLBACKCONTEXT_THREAD_DOWN}          \tab \code{0x0004} \cr
    \code{CPX_CALLBACKCONTEXT_THREAD_UP}            \tab \code{0x0002} \cr
  }
}

%------------------------------------------------------------------------------
\section{new parameter names introduced in IBM ILOG CPLEX version 12.9.0}{
Callable library miscellaneous routines
  \tabular{ll}{
    \code{CPXPARAM_Read_WarningLimit}                         \tab \code{1157} \cr
    \code{CPXPARAM_MultiObjective_Display}                    \tab \code{1600} \cr
    \code{CPXPARAM_Preprocessing_Folding}                     \tab \code{1164} \cr
  }
}
    
\references{
  The IBM ILOG CPLEX home page at
  \url{https://www.ibm.com/docs/en}.
}

\author{
  Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>

  Maintainer: Mayo Roettger <mayo.roettger@hhu.de>
}


\seealso{
  \code{\link{return_codeCPLEX}}, \code{\link{status_codeCPLEX}},
  \code{\link{getParmValCPLEX}}
}

\keyword{ optimize }


