% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_export.R
\name{dataset_export}
\alias{dataset_export}
\alias{dataset_export_csv}
\title{Export a dataset}
\usage{
dataset_export(ds, file, filetype = "csv", ...)

dataset_export_csv(ds, file)
}
\arguments{
\item{ds}{A dataset object.}

\item{file}{A (path to) a file where to export the dataset object.}

\item{filetype}{Currently only \code{'csv'} is implemented.}

\item{...}{Further parameters to be passed on to exporting functions. See details.}
}
\description{
Export a dataset together with reference (DataCite and Dublin Core)
metadata.
}
\details{
This function is a wrapper around the exporting functions.It implements
file exports in a way that the resulting exported file contains reference metadata.\cr
\code{\link{dataset_export_csv}} is a wrapper around \code{utils::\link[utils:write.csv]{write.csv}}.
Use ... to pass on argument to that function.
}
\examples{
my_iris_dataset <- dataset(
     x = iris,
     Dimensions = NULL,
     Measures = c("Sepal.Length", "Sepal.Width",  "Petal.Length", "Petal.Width" ),
     Attributes = "Species",
     Title = "Iris Dataset"
)

my_iris_dataset <- dublincore_add(
     x = my_iris_dataset,
     Creator = person("Edgar", "Anderson", role = "aut"),
     Publisher = "American Iris Society",
     Source = "https://doi.org/10.1111/j.1469-1809.1936.tb02137.x",
     Date = 1935,
     Language = "en"
)

dataset_export_csv(my_iris_dataset, file = file.path(tempdir(), "my_iris.csv"))

\dontrun{
read.csv(file.path(tempdir(), "my_iris.csv"), skip=20)
read.csv(file.path(tempdir(), "my_iris.csv"))
}
}
\seealso{
dataset
}
\concept{export functions}
