% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creator.R
\name{creator}
\alias{creator}
\alias{creator<-}
\title{Get/set the Creator of the object.}
\usage{
creator(x)

creator(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{An R object, such as a data.frame, a tibble, or a data.table.}

\item{overwrite}{If the attributes should be overwritten. In case it is set to \code{FALSE},
it gives a message with the current \code{Creator} property instead of overwriting it.
Defaults to \code{TRUE} when the attribute is set to \code{value} regardless of previous
setting.}

\item{value}{The \code{Creator} as a \code{utils::\link[utils]{person}} object.}
}
\value{
The Creator attribute as a character of length 1 is added to \code{x}.
}
\description{
Add the optional \code{Creator} property as an attribute to an R object.
}
\details{
The \code{Creator}
corresponds to \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/#http://purl.org/dc/elements/1.1/creator}{dct:creator} and Creator in DataCite.
The name of the entity that holds, archives, publishes prints, distributes, releases,
issues, or produces the resource. This property will be used to formulate the citation,
so consider the prominence of the role. For software, use \code{Creator} for the
code repository. If there is an entity other than a code repository, that
"holds, archives, publishes, prints, distributes, releases, issues, or produces" the
code, use the property Contributor/contributorType/hostingInstitution for the code
repository.
}
\examples{
iris_dataset <- iris
creator(iris_dataset) <- person("Anderson", "Edgar", role = "aut")
creator(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{dataset_source}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{size}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
