## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----datacite-----------------------------------------------------------------
library(dataset)
iris_datacite  <- datacite_add(
  x = iris,
  Title = "Iris Dataset",
  Creator = person("Anderson", "Edgar", role = "aut"),
  Publisher = "American Iris Society",
  Identifier = "https://doi.org/10.1111/j.1469-1809.1936.tb02137.x",
  PublicationYear = 1935,
  Description = "This famous (Fisher's or Anderson's) iris data set gives the measurements in centimeters of the variables sepal length and width and petal length and width, respectively, for 50 flowers from each of 3 species of iris. The species are Iris setosa, versicolor, and virginica.",
  Language = "en")

## ----printdataset-------------------------------------------------------------
datacite(iris_datacite)

## ----reproducible, eval=FALSE-------------------------------------------------
#  temp_path <- file.path(tempdir(), "iris.csv")
#  write.csv(iris, file = temp_path)
#  iris_dataset <- read_dataset(
#    dataset_id = "iris_dataset",
#    obs_id = NULL,
#    dimensions = NULL,
#    measures = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
#    attributes = "Species",
#    Title = "Iris Dataset",
#    unit = list(code = "MM", label = "millimeter"),
#    .f = "utils::read.csv", file = temp_path )
#  attributes(iris_dataset)

