## ---- include = FALSE---------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(
  collapse = TRUE,
  message  = FALSE,
  comment = "#>",
  out.width = '90%'
)
library(here)
library(readxl)
library(kableExtra)

## ----setup--------------------------------------------------------------------
library(dataset)

## ----importexamplexlsx--------------------------------------------------------
example_dataset <- readxl::read_excel(
  system.file("extdata", "rdf_example.xlsx", package = "dataset"), 
  sheet = "dataset-wide")

## ----printexampledataset------------------------------------------------------
example_dataset

## ----dimreduction, echo=FALSE, message=FALSE----------------------------------
include_graphics(here("vignettes", "RDF_chart_1.png"))

## ---- message=FALSE-----------------------------------------------------------
library(tidyr)
library(dplyr)
example_long <- example_dataset %>%
  unite("uri", 
        all_of(c("rowid", "time", "geo", "sex", "value", "unit", "freq", "status")), 
        remove = FALSE) %>%
  mutate_all ( as.character) %>%
  pivot_longer(
    cols = -any_of("uri"),
    names_to = "component",
    values_to = "value"
  )

## ----dimreduction2, echo=FALSE, message=FALSE, out.width='75%'----------------
include_graphics(here("vignettes", "RDF_chart_2.png"))

## ----statcodelistsexample-----------------------------------------------------
set.seed(2022)
library(statcodelists)

example_long %>%
   filter (.data$component == "sex") %>%
   left_join(statcodelists::CL_SEX %>%
              rename ( value = .data$id ), 
            by = "value") %>%
  bind_rows (
    example_long %>%
      filter (.data$component == "freq") %>%
      left_join(statcodelists::CL_FREQ %>%
              dplyr::rename ( value = .data$id ), 
            by = "value") 
  )  %>% 
    bind_rows (
    example_long %>%
      filter (.data$component == "status") %>%
      left_join(statcodelists::CL_OBS_STATUS %>%
              dplyr::rename ( value = .data$id ), 
            by = "value") 
  ) %>%
  group_by (.data$component) %>%
  sample_frac( size = 0.3 ) %>%
  kableExtra::kbl() %>%
  kableExtra::kable_paper()


