%========================================================================
%
% AIM: Climate change impacts on power generations: 1985-2014 vs. 2071-2100
%
%      Data: Historical vs. SSP245 and 585
%
%   (1) Historical mean state of wind-solar supply (normal and variability)
%
%   (2) Changes in wind-solar supply (normal and variability)
%
%========================================================================
clc;
load Base_Energy.mat;
load /net/exo/landclim/liula/base_data/base.mat ID_ocean_1deg ID_landveg_1deg; 

% 1) Pre-stored result

CF_PVmn_glb_hist  = []; CF_Wbmn_glb_hist  = [];
CF_PVcv_glb_hist  = []; CF_Wbcv_glb_hist  = [];
dCF_PVmn_glb_25   = []; dCF_Wbmn_glb_25   = [];
dCF_PVcv_glb_25   = []; dCF_Wbcv_glb_25   = [];
dCF_PV10_glb_25   = []; dCF_Wb10_glb_25   = [];
dCF_PV90_glb_25   = []; dCF_Wb90_glb_25   = [];

% 2) Loop each model

for mdnum = 1 : size(CMIP6_name,2) 
   
     tic
   
     disp(['Now Load ',CMIP6_name{mdnum}])

   % 2.1) Load lat,lon,areaa,landfraction
     lat     = CMIP6_lata{mdnum,1};
     lon     = CMIP6_lona{mdnum,1};
     LandID  = CMIP6_ID_Landa{mdnum,1};
     OceanID = CMIP6_ID_Oceana{mdnum,1};
     area    = CMIP6_areaa{mdnum,1};
     Yr_Hist = CMIP6_histtime{mdnum,2}(:,1); 
     Yr_Hist = Yr_Hist(Yr_Hist>=1950&Yr_Hist<=2014);  
     Yr_Fut  = CMIP6_ssptime{mdnum,2}(:,1); 
   
     st_Hist = min(find(Yr_Hist==1985)); 
     ed_Hist = max(find(Yr_Hist==2014));
     len_Hist= ed_Hist-st_Hist+1;
     
     st_Fut  = min(find(Yr_Fut==2071));  
     ed_Fut  = max(find(Yr_Fut==2100)); 
     len_Fut = ed_Fut-st_Fut+1;
  
   % 2.2) Load Solar power (W/m2) and Capacity Factor (CF)        
     SPfiles = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/Solar_Power2/historical/',CMIP6_name{mdnum},'/*.nc']);
         % ncdisp([SPfiles(1).folder,'/',SPfiles(1).name])
     SP_Hist = ncread([SPfiles(1).folder,'/',SPfiles(1).name],'PV',[1 1 st_Hist],[inf inf len_Hist],[1 1 1]);
     CF_PV_Hist = reshape(double(SP_Hist),[size(SP_Hist,1)*size(SP_Hist,2) size(SP_Hist,3)])./PV_max;
       
     SPfiles = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/Solar_Power2/ssp245/',CMIP6_name{mdnum},'/*.nc']);
     SP_Fut  = ncread([SPfiles(1).folder,'/',SPfiles(1).name],'PV',[1 1 st_Fut],[inf inf len_Fut],[1 1 1]);
     CF_PV_Fut245 = reshape(double(SP_Fut),[size(SP_Fut,1)*size(SP_Fut,2) size(SP_Fut,3)])./PV_max;
     
     SPfiles = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/Solar_Power2/ssp585/',CMIP6_name{mdnum},'/*.nc']);
     SP_Fut  = ncread([SPfiles(1).folder,'/',SPfiles(1).name],'PV',[1 1 st_Fut],[inf inf len_Fut],[1 1 1]);
     CF_PV_Fut585 = reshape(double(SP_Fut),[size(SP_Fut,1)*size(SP_Fut,2) size(SP_Fut,3)])./PV_max;

   % 2.3) Load Wind power (W/m2) and Capacity Factor (CF)  
     WPfiles = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/Wind_Power/historical/',CMIP6_name{mdnum},'/*.nc']);
         % ncdisp([WPfiles(1).folder,'/',WPfiles(1).name])
     WP_150  = ncread([WPfiles(1).folder,'/',WPfiles(1).name],'pv_wind150',[1 1 st_Hist],[inf inf len_Hist],[1 1 1]);
     WP_150  = reshape(WP_150,[size(WP_150,1)*size(WP_150,2) size(WP_150,3)]);
     CF_Wb_Hist = WP_150./WP_max;
     
     WPfiles = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/Wind_Power/ssp245/',CMIP6_name{mdnum},'/*.nc']);
     WP_150  = ncread([WPfiles(1).folder,'/',WPfiles(1).name],'pv_wind150',[1 1 st_Fut],[inf inf len_Fut],[1 1 1]);
     WP_150  = reshape(WP_150,[size(WP_150,1)*size(WP_150,2) size(WP_150,3)]);
     CF_Wb_Fut245 = WP_150./WP_max; 
     
     WPfiles = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/Wind_Power/ssp585/',CMIP6_name{mdnum},'/*.nc']);
     if mdnum == 13 % In EC-Earth3, WP120m or WP150m are stored independently due to size constriant
         WPfiles  = WPfiles(2);
     end
     WP_150  = ncread([WPfiles(1).folder,'/',WPfiles(1).name],'pv_wind150',[1 1 st_Fut],[inf inf len_Fut],[1 1 1]);
     WP_150  = reshape(WP_150,[size(WP_150,1)*size(WP_150,2) size(WP_150,3)]);
     CF_Wb_Fut585 = WP_150./WP_max; 
   
   % 2.4) Average wind/solar power generations 
   
     CF_PVmn_glb_hist{mdnum,1} = mean(CF_PV_Hist,2);
     CF_Wbmn_glb_hist{mdnum,1} = mean(CF_Wb_Hist,2);
     
   % 2.5) CV of wind/solar power generations 
   
     CF_PVcv_glb_hist{mdnum,1} = std(CF_PV_Hist,1,2)./mean(CF_PV_Hist,2);
     CF_Wbcv_glb_hist{mdnum,1} = std(CF_Wb_Hist,1,2)./mean(CF_Wb_Hist,2);   

   % 2.6) Changes in Average wind/solar power generations ( eq: Future-Hist)  
   
     sub1 = mean(CF_PV_Fut245,2)-mean(CF_PV_Hist,2);
     sub2 = mean(CF_PV_Fut585,2)-mean(CF_PV_Hist,2);
     dCF_PVmn_glb_25{mdnum,1} = [sub1,sub2];
     
     sub1 = mean(CF_Wb_Fut245,2)-mean(CF_Wb_Hist,2);
     sub2 = mean(CF_Wb_Fut585,2)-mean(CF_Wb_Hist,2);
     dCF_Wbmn_glb_25{mdnum,1} = [sub1,sub2];
     
   % 2.7) Changes in CV of wind/solar power generations ( eq: Future-Hist)  
   
     sub1 = std(CF_PV_Fut245,1,2)./mean(CF_PV_Fut245,2) - CF_PVcv_glb_hist{mdnum,1};
     sub2 = std(CF_PV_Fut585,1,2)./mean(CF_PV_Fut585,2) - CF_PVcv_glb_hist{mdnum,1};
     dCF_PVcv_glb_25{mdnum,1} = [sub1,sub2];
     
     sub1 = std(CF_Wb_Fut245,1,2)./mean(CF_Wb_Fut245,2) - CF_Wbcv_glb_hist{mdnum,1};
     sub2 = std(CF_Wb_Fut585,1,2)./mean(CF_Wb_Fut585,2) - CF_Wbcv_glb_hist{mdnum,1};
     dCF_Wbcv_glb_25{mdnum,1} = [sub1,sub2];
     
   % 2.8) Changes in Wb10 or PV10 (share of very low daily supply below 10 percentil of historical)
   
      dWb10    = nan(length(area(:)),2);
      dPV10    = nan(length(area(:)),2);
      
      dWb90    = nan(length(area(:)),2);
      dPV90    = nan(length(area(:)),2);
      
        %  Historical 10percentile 
        Wb10   = prctile(CF_Wb_Hist,10,2);
        PV10   = prctile(CF_PV_Hist,10,2);
        
        Wb90   = prctile(CF_Wb_Hist,90,2);
        PV90   = prctile(CF_PV_Hist,90,2);
        
     for k = LandID'  % Location
    
     %  Historical Supply profile 
        CF_Wb_hist = CF_Wb_Hist(k,:)';
        CF_PV_hist = CF_PV_Hist(k,:)';
       
     %  Future Supply profile SSP245
        CF_Wb_fut245 = CF_Wb_Fut245(k,:)';
        CF_PV_fut245 = CF_PV_Fut245(k,:)';
        
        dWb10(k,1) = length(find(CF_Wb_fut245<Wb10(k)))./length(CF_Wb_fut245)-0.1;
        dPV10(k,1) = length(find(CF_PV_fut245<PV10(k)))./length(CF_PV_fut245)-0.1;

        dWb90(k,1) = length(find(CF_Wb_fut245>Wb90(k)))./length(CF_Wb_fut245)-0.1;
        dPV90(k,1) = length(find(CF_PV_fut245>PV90(k)))./length(CF_PV_fut245)-0.1;
        
     %  Future Supply profile SSP585
        CF_Wb_fut585 = CF_Wb_Fut585(k,:)';
        CF_PV_fut585 = CF_PV_Fut585(k,:)';
        
        dWb10(k,2) = length(find(CF_Wb_fut585<Wb10(k)))./length(CF_Wb_fut585)-0.1;
        dPV10(k,2) = length(find(CF_PV_fut585<PV10(k)))./length(CF_PV_fut585)-0.1;
        
        dWb90(k,2) = length(find(CF_Wb_fut585>Wb90(k)))./length(CF_Wb_fut585)-0.1;
        dPV90(k,2) = length(find(CF_PV_fut585>PV90(k)))./length(CF_PV_fut585)-0.1;
        
     end
     
     dWb10(Wb10==0,:) = 0;
     dPV10(PV10==0,:) = 0;
     
     dCF_Wb10_glb_25{mdnum,1} = dWb10.*100;
     dCF_PV10_glb_25{mdnum,1} = dPV10.*100;
     
     dCF_Wb90_glb_25{mdnum,1} = dWb90.*100;
     dCF_PV90_glb_25{mdnum,1} = dPV90.*100;
     
    toc
    
end

      clear dWb10 dPV10 Wb10 PV10 Wb90 PV90 sub1 sub2;
      
%  one = 1; save Result_Energy.mat one -v7.3;
     
      save Result_Energy.mat  CF_PVmn_glb_hist  CF_Wbmn_glb_hist  -append;
      save Result_Energy.mat  CF_PVcv_glb_hist  CF_Wbcv_glb_hist  -append;

      save Result_Energy.mat  dCF_PVmn_glb_25   dCF_Wbmn_glb_25  -append;
      save Result_Energy.mat  dCF_PVcv_glb_25   dCF_Wbcv_glb_25  -append;

      save Result_Energy.mat  dCF_PV10_glb_25   dCF_Wb10_glb_25  -append;
      save Result_Energy.mat  dCF_PV90_glb_25   dCF_Wb90_glb_25  -append;


% Regrid result into 1 degree

CF_PVmn_glb1deg_hist  = nan(size(CMIP6_name,2),180*360); 
CF_Wbmn_glb1deg_hist  = nan(size(CMIP6_name,2),180*360); 

CF_PVcv_glb1deg_hist  = nan(size(CMIP6_name,2),180*360); 
CF_Wbcv_glb1deg_hist  = nan(size(CMIP6_name,2),180*360); 

dCF_PVmn_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 
dCF_Wbmn_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 

dCF_PVcv_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 
dCF_Wbcv_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 

dCF_PV10_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 
dCF_Wb10_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 

dCF_PV90_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 
dCF_Wb90_glb1deg_25   = nan(size(CMIP6_name,2),180*360,2); 

for mdnum  =  1  : size(CMIP6_name,2) 
    
   disp(['Now Load ',CMIP6_name{mdnum}])

   % Load lat,lon,areaa,landfraction
       lata   = double(CMIP6_lata{mdnum,1});
       lona   = double(CMIP6_lona{mdnum,1});
           
  % Load CF wind/pv
       CF_PVmn  = CF_PVmn_glb_hist{mdnum,1};
       CF_Wbmn  = CF_Wbmn_glb_hist{mdnum,1};

       CF_PVcv  = CF_PVcv_glb_hist{mdnum,1};
       CF_Wbcv  = CF_Wbcv_glb_hist{mdnum,1};
  
       dCF_PVmn = dCF_PVmn_glb_25{mdnum,1};
       dCF_Wbmn = dCF_Wbmn_glb_25{mdnum,1};

       dCF_PVcv = dCF_PVcv_glb_25{mdnum,1};
       dCF_Wbcv = dCF_Wbcv_glb_25{mdnum,1};
       
       dCF_PV10 = dCF_PV10_glb_25{mdnum,1};
       dCF_Wb10 = dCF_Wb10_glb_25{mdnum,1};
       
       dCF_PV90 = dCF_PV90_glb_25{mdnum,1};
       dCF_Wb90 = dCF_Wb90_glb_25{mdnum,1};
       
  % Interpolation
       lona2 = lona; lona2(lona2<0) = lona2(lona2<0) + 360; 
       [X,Y] = meshgrid([-89.5:1:89.5],[0.5:1:359.5]);
       
      % Historical 
          sub   = reshape(CF_PVmn,size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          CF_PVmn_glb1deg_hist(mdnum,:) = Vq(:); 

          sub   = reshape(CF_Wbmn,size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          CF_Wbmn_glb1deg_hist(mdnum,:) = Vq(:);  
          
          sub   = reshape(CF_PVcv,size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          CF_PVcv_glb1deg_hist(mdnum,:) = Vq(:); 

          sub   = reshape(CF_Wbcv,size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          CF_Wbcv_glb1deg_hist(mdnum,:) = Vq(:);  
                        
      % SSP245 and SSP585
      for num = 1 : 2 

              sub   = reshape(dCF_PVmn(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_PVmn_glb1deg_25(mdnum,:,num) = Vq(:); 

              sub   = reshape(dCF_Wbmn(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_Wbmn_glb1deg_25(mdnum,:,num) = Vq(:);  

              sub   = reshape(dCF_PVcv(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_PVcv_glb1deg_25(mdnum,:,num) = Vq(:); 

              sub   = reshape(dCF_Wbcv(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_Wbcv_glb1deg_25(mdnum,:,num) = Vq(:);  
              
              sub   = reshape(dCF_PV10(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_PV10_glb1deg_25(mdnum,:,num) = Vq(:); 

              sub   = reshape(dCF_Wb10(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_Wb10_glb1deg_25(mdnum,:,num) = Vq(:);  
              
              sub   = reshape(dCF_PV90(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_PV90_glb1deg_25(mdnum,:,num) = Vq(:); 

              sub   = reshape(dCF_Wb90(:,num),size(lata,1),size(lata,2));
              sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
              Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
              dCF_Wb90_glb1deg_25(mdnum,:,num) = Vq(:);  
              
      end
   
end

CF_PVmn_glb1deg_hist(:,ID_ocean_1deg) = nan;
CF_Wbmn_glb1deg_hist(:,ID_ocean_1deg) = nan;
CF_PVcv_glb1deg_hist(:,ID_ocean_1deg) = nan;
CF_Wbcv_glb1deg_hist(:,ID_ocean_1deg) = nan;

dCF_PVmn_glb1deg_25(:,ID_ocean_1deg,:) = nan;
dCF_Wbmn_glb1deg_25(:,ID_ocean_1deg,:) = nan;
dCF_PVcv_glb1deg_25(:,ID_ocean_1deg,:) = nan;
dCF_Wbcv_glb1deg_25(:,ID_ocean_1deg,:) = nan;

dCF_PV10_glb1deg_25(:,ID_ocean_1deg,:) = nan;
dCF_Wb10_glb1deg_25(:,ID_ocean_1deg,:) = nan;
dCF_PV90_glb1deg_25(:,ID_ocean_1deg,:) = nan;
dCF_Wb90_glb1deg_25(:,ID_ocean_1deg,:) = nan;


     save Result_Energy.mat CF_PVmn_glb1deg_hist  CF_Wbmn_glb1deg_hist  -append;
     save Result_Energy.mat CF_PVcv_glb1deg_hist  CF_Wbcv_glb1deg_hist  -append;

     save Result_Energy.mat dCF_PVmn_glb1deg_25   dCF_Wbmn_glb1deg_25  -append;
     save Result_Energy.mat dCF_PVcv_glb1deg_25   dCF_Wbcv_glb1deg_25  -append;

     save Result_Energy.mat dCF_PV10_glb1deg_25   dCF_Wb10_glb1deg_25  -append;
     save Result_Energy.mat dCF_PV90_glb1deg_25   dCF_Wb90_glb1deg_25  -append;




