%========================================================================
%
% AIM: Climate change impacts on demand under SSP585
%     
%========================================================================
clc;
load Base_Energy.mat;

% Pre-stored result

Demandmn_glb_585   = [];
Demandcv_glb_hist  = [];
Demandcv_glb_585   = [];

% Loop each model
for mdnum  = [1 : size(CMIP6_name,2)] %1 : size(CMIP6_name,2) 
    
     tic
     disp(['Now Load ',CMIP6_name{mdnum}])

   % Load lat,lon,areaa,landfraction
     lat     = CMIP6_lata{mdnum,1};
     lon     = CMIP6_lona{mdnum,1};
     LandID  = CMIP6_ID_Landa{mdnum,1};
     OceanID = CMIP6_ID_Oceana{mdnum,1};
     area    = CMIP6_areaa{mdnum,1};
     Yr_Hist = CMIP6_histtime{mdnum,2}(:,1); 
     Yr_Hist = Yr_Hist(Yr_Hist>=1950&Yr_Hist<=2014);  
     Yr_Fut  = CMIP6_ssptime{mdnum,2}(:,1); 
   
     st_Hist = min(find(Yr_Hist==1985)); 
     ed_Hist = max(find(Yr_Hist==2014));
     len_Hist= ed_Hist-st_Hist+1;
     st_Fut  = min(find(Yr_Fut==2071)); 
     ed_Fut  = max(find(Yr_Fut==2100));    
     len_Fut = ed_Fut-st_Fut+1;

   % Load Air Temperature
      filelist = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/tas/historical/',CMIP6_name{mdnum},'/*.nc']);
        % ncdisp([filelist(1).folder,'/',filelist(1).name])
      A   = ncread([filelist(1).folder,'/',filelist(1).name],'tas',[1 1 st_Hist],[inf inf len_Hist],[1 1 1]);
      Ta_Hist = reshape(A,size(A,1)*size(A,2),[]) - 273.15;   
      
      filelist = dir(['/net/exo/landclim/liula/wind_solar/Global/Output/tas/ssp585/',CMIP6_name{mdnum},'/*.nc']);
      A   = ncread([filelist(1).folder,'/',filelist(1).name],'tas',[1 1 st_Fut],[inf inf len_Fut],[1 1 1]);
      Ta_Fut = reshape(A,size(A,1)*size(A,2),[]) - 273.15;   

    % Pre-store globally [Final output] 
    
      Demand_Futmn   = nan(length(area(:)),2);
      Demand_Histcv  = nan(length(area(:)),2);
      Demand_Futcv   = nan(length(area(:)),2);
      ed  = min([size(Ta_Hist,2),size(Ta_Fut,2)]); 

      for k =  LandID'  % Location

         %  Historical Demand profile 
            % # Generate historical demand profile according to Ta inter-day variations, assuming historical time-mean demand = 1
                  
            Ta_hist    = Ta_Hist(k,1:ed)';
            [Demand_High_hist,Demand_Low_hist,S_High,S_Low] = Demandfix_Ta_Liu(1,Ta_hist);

            Demand_Histcv(k,1:2) = [std(Demand_High_hist)./mean(Demand_High_hist),
                                    std(Demand_Low_hist)./mean(Demand_Low_hist)]; 

         %  Based on Historical system, generate Future Demand profile
            % Ajust demand profile due to climate change 
            Ta_fut    =  Ta_Fut(k,1:ed)';
            [Demand_High_fut,~] = Demandmin_Ta_Liu(Ta_fut,S_High);
            [~, Demand_Low_fut] = Demandmin_Ta_Liu(Ta_fut,S_Low);      

            Demand_Futmn(k,1:2) = [mean(Demand_High_fut),mean(Demand_Low_fut)];
            Demand_Futcv(k,1:2) = [std(Demand_High_fut)./mean(Demand_High_fut),
                                   std(Demand_Low_fut)./mean(Demand_Low_fut)]; 
      end
  
      Demandmn_glb_585{mdnum,1}  = Demand_Futmn; 
      Demandcv_glb_hist{mdnum,1} = Demand_Histcv; 
      Demandcv_glb_585{mdnum,1}  = Demand_Futcv; 
      
end

 clear Demand_Histmn Demand_Futmn Demand_Histcv Demand_Futcv

    save Result_Energy.mat Demandmn_glb_585 Demandcv_glb_hist Demandcv_glb_585 -append;
  
   
% Regrid result into 1 degree   

  Demandmn_glb1deg_585  = nan(size(CMIP6_name,2),180*360,2); 
  Demandcv_glb1deg_hist = nan(size(CMIP6_name,2),180*360,2); 
  Demandcv_glb1deg_585  = nan(size(CMIP6_name,2),180*360,2); 

for mdnum  =  1: size(CMIP6_name,2)
    
   disp(['Now Load ',CMIP6_name{mdnum}])

   % Load lat,lon,areaa,landfraction
   lata  = double(CMIP6_lata{mdnum,1});
   lona  = double(CMIP6_lona{mdnum,1});
   
   % Load Reliability in Variaility Scenario
   demandmn  = Demandmn_glb_585{mdnum,1};
   demandcv_hist = Demandcv_glb_hist{mdnum,1};
   demandcv_585  = Demandcv_glb_585{mdnum,1};
   
      % Interpolation
      lona2 = lona; lona2(lona2<0) = lona2(lona2<0) + 360; 
      [X,Y] = meshgrid([-89.5:1:89.5],[0.5:1:359.5]);
                   
      for m = 1 :2
          
          sub   = reshape(demandmn(:,m),size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          Demandmn_glb1deg_585(mdnum,:,m) = Vq(:);  
          
          sub   = reshape(demandcv_hist(:,m),size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          Demandcv_glb1deg_hist(mdnum,:,m) = Vq(:); 
          
          sub   = reshape(demandcv_585(:,m),size(lata,1),size(lata,2));
          sub   = [sub(fix(size(sub,1)/2)+1:end,:);sub(1:fix(size(sub,1)/2),:)];
          Vq    = rot90(griddata(lata,lona2,sub,X,Y,'linear'));
          Demandcv_glb1deg_585(mdnum,:,m) = Vq(:); 
          
      end
      
end

   save Result_Energy.mat Demandmn_glb1deg_585 ...
        Demandcv_glb1deg_hist Demandcv_glb1deg_585 -append;


     
     
     
     
     
