%========================================================================
%
% AIM: Solar Power density from Photovolatic system 
%
% Modified by Laibao Liu; T
%
%   According to : Gernaat et al., 2021 Climate change  impacts on renewable energy supply 
%
%========================================================================


function [Power_pv] = Power_PV_Liu2(I,ABT,Wind_speed)

% ! Input

    % I           % Global radiation at the titled surface (W/m2)
    % ABT         % Ambient_temperature (°C)
    % Wind_speed  % Wind speed (m/s)
   
% ! Output

    % Power_pv    % Solar PV radiation (W/m2)

% ! Pre-stored constant

Lamda_LPV = 0.47; % land-use factor or packing factor

PR = 0.85;  % Performance ratio expressing the difference between performace under standard test conditions and the actual output
            % of the system due to losses from sub-optimal angles, as well as cable and inverter losses 

% Lamda_PV: PV panel efficiency corrected for atmospheric variables 
  
Lamda_panel = 0.17; % Assumed Panel effeciency under standard conditions 
            
gamma  = -0.005; % Unit: °C -1 

T_stc  = 25; % Standard test conditions temperature

c1 = 4.3;    % Unit: °C 

c2 = 0.943;  % Unit:  1

c3 = 0.028;  % Unit: °C m2 W-1

c4 = -1.528; % Unit: °C s m-1

T  = c1 + c2.*ABT + c3.*I + c4.*Wind_speed;

Lamda_PV = Lamda_panel.*(1 + gamma.*(T-T_stc));

Power_pv = I.*Lamda_LPV.*Lamda_PV.*PR; 

end






