function analysePFUs()

%%

    data = [46875	187 ; ...
        9375	177 ; ...
        1875	153 ; ...
        375	98 ; ...
        75	9 ; ...
        15	0 ; ...
        3	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        15625	169 ; ...
        3125	185 ; ...
        625	175 ; ...
        125	123 ; ...
        25	16 ; ...
        5	0 ; ...
        1	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        78125	190 ; ...
        15625	176 ; ...
        3125	149 ; ...
        625	103 ; ...
        125	49 ; ...
        25	0 ; ...
        5	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        62500	196 ; ...
        12500	177 ; ...
        2500	159 ; ...
        500	109 ; ...
        100	14 ; ...
        20	0 ; ...
        4	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        15625	198 ; ...
        3125	164 ; ...
        625	170 ; ...
        125	122 ; ...
        25	40 ; ...
        5	0 ; ...
        1	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        62500	199 ; ...
        12500	169 ; ...
        2500	163 ; ...
        500	121 ; ...
        100	17 ; ...
        20	0 ; ...
        4	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        62500	192 ; ...
        12500	200 ; ...
        2500	146 ; ...
        500	118 ; ...
        100	70 ; ...
        20	0 ; ...
        4	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        46875	163 ; ...
        9375	177 ; ...
        1875	167 ; ...
        375	145 ; ...
        75	20 ; ...
        15	0 ; ...
        3	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0 ; ...
        0	0];

    PFU = log10(1+data(:,1));
    Area = 1+data(:,2);

    %%

    q = plot(PFU,Area,'.k','markersize',30);
    xlabel('log_{10}(PFU)')
    ylabel('Area (px^2)')
    hold on

    X = (0.01:0.1:.1+max(PFU(:)))';
    Y = (0.01:0.1:.1+max(Area(:)))';
    model1 = @(p,x)x.^1./abs(p(1));
    fit1 = fitnlm(PFU,Area,@(p,x)model1(p,x),[1])

    model2 = @(p,x)(p(2)*abs(x-abs(p(3))).^abs(p(1)))./(p(4)+abs(x-abs(p(3))).^abs(p(1)));
    fit2 = fitnlm(PFU,Area,@(p,x)model2(p,x),[0.2 150 1.5 1])

    [beta,R,J] = nlinfit(PFU,Area,@(p,x)model2(p,x),[0.2 150 1.5 1]);
    [ypred,delta] = nlpredci(@(p,x)model2(p,x),X,beta,R,'Jacobian',J);

    p1 = plot(X,fit1.predict(X));
    p2 = plot(X,fit2.predict(X),'-k');
    p3 = plot(X,ypred-delta,'--k');
    plot(X,ypred+delta,'--k');
    axis tight

    legend([q,p1,p2,p3],{'data',['linear adj R^2 \approx ',num2str(fit1.Rsquared.Adjusted,3)],['saturating adj R^2 \approx ',num2str(fit2.Rsquared.Adjusted,3)],'saturating 95% CI'});
    legend('location','northwest')

    %%

    export_fig('./figures/AreaPFU.pdf')

end