(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    610472,      12292]
NotebookOptionsPosition[    603177,      12174]
NotebookOutlinePosition[    603544,      12190]
CellTagsIndexPosition[    603501,      12187]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Data Analysis ",
 FontSize->24,
 Background->RGBColor[1, 0.9, 0.8]]], "Text",
 CellChangeTimes->{{3.8110893947447557`*^9, 3.811089405660748*^9}, {
   3.8110894360871887`*^9, 3.811089456752411*^9}, {3.813650913766994*^9, 
   3.8136509319598513`*^9}, {3.813912538036376*^9, 3.813912539004418*^9}, {
   3.86730722757028*^9, 3.8673072345557613`*^9}, 
   3.867308742659964*^9},ExpressionUUID->"a2f50c5e-5bcb-49ba-abe4-\
29bf7c75ddf1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"conenumber", "=", "\"\<28\>\""}], ";", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "This", " ", "label", " ", "represents", "\[IndentingNewLine]", "3", 
      RowBox[{"D", ":", " ", 
       RowBox[{
       "is", " ", "the", " ", "position", " ", "of", " ", "the", " ", "data", 
        " ", "in", " ", "Table", " ", "II"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"e", ".", "g", ".", " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Pi]", "16"], ",", 
         FractionBox["\[Pi]", "2"]}], ")"}]}], "is", " ", "\"\<1\>\""}], ",", 
     " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"25", "\[Pi]"}], "256"], ",", 
        FractionBox["\[Pi]", "2"]}], ")"}], "is", " ", "\"\<2\>\""}], ",", 
     " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["\[Pi]", "4"], ",", 
        FractionBox["\[Pi]", "2"]}], ")"}], "is", " ", "\"\<13\>\""}], ",", 
     " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", "\[Pi]"}], "3"], ",", 
        FractionBox["\[Pi]", "2"]}], ")"}], "is", " ", "\"\<31\>\""}], ",", 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{"etc", "..."}], "\[IndentingNewLine]", "2", 
       RowBox[{"D", ":", " ", 
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", ",", "conenumber"}], ")"}], "}"}]}]}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", "/", "8"}], ",", "32"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "33"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", "/", "8"}], ",", "34"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", "/", "4"}], ",", "35"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{"1", ",", "36"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{"4", "/", "3"}]], ",", "37"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{
          SqrtBox["2"], ",", "38"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{"8", "/", "3"}]], ",", "39"}], ")"}]}], "}"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"path", "=", 
    RowBox[{"ToString", "[", "\"\< \>\"", " ", "]"}]}], ";", " ", 
   RowBox[{"(*", 
    RowBox[{"Your", " ", "path", " ", "to", " ", "the", " ", "data"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"labels", "=", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
      "h"}], "}"}]}], ";", " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "auxiliary", " ", "labels", " ", "for", " ", "each", " ", "batch", " ", 
      "of", " ", "independent", " ", "samples"}], ",", " ", 
     RowBox[{
     "each", " ", "letter", " ", "contains", " ", "10000", " ", "samples"}]}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"volumelabels", "=", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "65", ",", "131", 
      ",", "262", ",", "524"}], "}"}]}], 
   RowBox[{"(*", 
    RowBox[{
    "auxiliary", " ", "labels", " ", "for", " ", "each", " ", "graph", " ", 
     "volume"}], "*)"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"Data", " ", 
      RowBox[{"names", ":", 
       RowBox[{
        RowBox[{"(", "labels", ")"}], "_", 
        FormBox[
         RowBox[{"(", "cone"}],
         TraditionalForm]}]}]}], ")"}], " ", "_", " ", 
    RowBox[{
     RowBox[{"(", "volumelabels", ")"}], ".", "txt"}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.86730710687663*^9, 3.8673071366294537`*^9}, {
   3.867307653409446*^9, 3.867307734343804*^9}, {3.8673079772731524`*^9, 
   3.867307982379381*^9}, {3.867308061485512*^9, 3.8673080666651297`*^9}, {
   3.867310267971101*^9, 3.867310301580917*^9}, {3.8673121351042023`*^9, 
   3.867312143329193*^9}, {3.867318059054001*^9, 3.867318060119678*^9}, {
   3.867318111943804*^9, 3.8673182282270403`*^9}, {3.867318572915945*^9, 
   3.867318573446456*^9}, {3.8673189616166363`*^9, 3.867318992967676*^9}, {
   3.867319384766602*^9, 3.86731940047112*^9}, {3.8673208230454903`*^9, 
   3.867320824580509*^9}, {3.867321149604048*^9, 3.867321150298975*^9}, {
   3.8673790134672422`*^9, 3.867379194086688*^9}, 3.867379278631507*^9, {
   3.867379338432226*^9, 3.867379461640047*^9}, {3.867379505696891*^9, 
   3.867379640697968*^9}, {3.8673966696977177`*^9, 3.867396737147389*^9}, {
   3.867396777573484*^9, 
   3.8673969443113956`*^9}},ExpressionUUID->"c733e1bc-43f9-4833-9713-\
88cb864c0175"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Volumes", " ", "have", " ", "to", " ", "be", " ", "adjusted", " ", 
      "for", " ", "2", "D", " ", "\[Gamma]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "/", "8."}], " ", 
       RowBox[{"USE", ":", "\n", "volumelabels"}]}], "=", 
      RowBox[{"{", 
       RowBox[{
       "\"\<05\>\"", ",", "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", 
        "32", ",", "65"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"referencevolume", "=", "65536"}], ";", "\[IndentingNewLine]", 
    RowBox[{"volumescomplete", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "512", ",", "1024", ",", "2048", ",", "4096", ",", "8192", ",", 
         "16384", ",", "32768", ",", "referencevolume"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Length", "[", "histogramsdatacomplete", "]"}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"volumes", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "512", ",", "1024", ",", "2048", ",", "4096", ",", "8192", ",", 
         "16384", ",", "32768"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Length", "[", "histograms", "]"}], "}"}]}], "]"}]}], ";"}], 
   "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.867379592278185*^9, 3.8673795972667*^9}, {
  3.867394005682933*^9, 3.8673940260234327`*^9}, {3.867394328957644*^9, 
  3.8673943302788773`*^9}},ExpressionUUID->"74106458-cb39-48e5-8ab4-\
3b0fd48c82b7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Import", " ", "all", " ", "the", " ", "data"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"histogramsdatacomplete", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Import", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"path", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"labels", "[", 
                RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "}"}], ",", 
            "\"\<_\>\"", ",", "conenumber", ",", "\"\<_\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"volumelabels", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\"\<.txt\>\""}], 
           "]"}], ",", "\"\<List\>\""}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "volumelabels", "]"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "labels", "]"}]}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellLabel->
  "In[161]:=",ExpressionUUID->"dcb28844-6d0d-43fb-8df3-86495089fccc"],

Cell[CellGroupData[{

Cell["Reference volume data", "Subsubsection",
 CellChangeTimes->{{3.812204397232032*^9, 3.812204406487068*^9}, {
  3.867308751413471*^9, 3.867308752510065*^9}, {3.867318319702961*^9, 
  3.8673183203649683`*^9}},ExpressionUUID->"d0b1bb97-3f8f-492c-88d6-\
1f3d201da664"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"referencevolume", "=", "524288"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "reference", " ", "volume", " ", "to", " ", "collapse", " ", 
    "histograms"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"referencedata", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"histogramsdatacomplete", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"-", "1"}], ";;"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "histogramsdatacomplete", "]"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reference", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", 
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], "-", "1"}]}], "]"}], ",", 
        RowBox[{"#", "/", 
         RowBox[{"Total", "[", "#", "]"}]}]}], "}"}], "]"}], "&"}], "/@", 
    "referencedata"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intpfunsref", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Interpolation", "[", 
      RowBox[{"reference", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "reference", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", "x", "]"}], "&"}], "/@", "intpfunsref"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8110903588250313`*^9, 3.811090411889104*^9}, {
   3.811090505763731*^9, 3.811090526638356*^9}, {3.811158440439834*^9, 
   3.811158488174408*^9}, {3.811158657975309*^9, 3.811158667416431*^9}, {
   3.8111586984659853`*^9, 3.811158698839851*^9}, {3.811159196632476*^9, 
   3.811159241148445*^9}, {3.811159272960634*^9, 3.8111592894111757`*^9}, {
   3.811159385514584*^9, 3.811159458724127*^9}, {3.8111595773367977`*^9, 
   3.811159607808546*^9}, 3.8111601011422462`*^9, {3.811161640127383*^9, 
   3.8111617821385736`*^9}, {3.811165284275145*^9, 3.8111653311796007`*^9}, {
   3.811165365619192*^9, 3.811165368498005*^9}, 3.811165468842907*^9, {
   3.812103492288807*^9, 3.81210350187848*^9}, {3.812105409275519*^9, 
   3.8121054419944277`*^9}, {3.812111062504752*^9, 3.812111066271645*^9}, {
   3.812111608665391*^9, 3.812111609996293*^9}, {3.81211167350279*^9, 
   3.81211167743729*^9}, {3.812111759551029*^9, 3.812111764521029*^9}, {
   3.8121118767166843`*^9, 3.81211188319433*^9}, {3.812205379064947*^9, 
   3.812205464959284*^9}, {3.812205534449078*^9, 3.8122055517876587`*^9}, {
   3.8673183227044992`*^9, 3.867318346765484*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"1f49fab2-86c5-433d-ada6-b2b76369bd09"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN1Hc41e8fMHBZKSo7SbKSJCHZ53O/7c0ZKjMjm2xCiCgzITtZIRwNM40j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       "]], LineBox[CompressedData["
1:eJxN1Xk01V/UMHBJUlRkSCIyhSRK5nvOzjy7uFfmhIyRMUOEJERCkmQs861I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       "]], LineBox[CompressedData["
1:eJxN13k01N8bOHAJUdqsLSqEEEKSbe597GMbZsa+JYTsW9n3FJGQbAmVfSop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       "]], 
      LineBox[CompressedData["
1:eJxN13k4VV/UOHBjKXwzF6kQQjI0mO/eK/PMde8VoTImMlNRimRIyFQiITNX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       "]], 
      LineBox[CompressedData["
1:eJxN1nk0ld8fL3AJIco8lGQOSZRkOnt/zDNnQISSTBEiZMhUKlFC5kKZOU1E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       "]], LineBox[CompressedData["
1:eJxN13c4lW/8OHAjUiTZSX2QTVay3ffb3gfnqJCVMjKSlZGdJCQrUWYyj4aU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       "]], LineBox[CompressedData["
1:eJxN1nk0Vd//P3AJEUmmJCQzISQZz35lvOZ7LzKWqJB5rlBRZhIyhAzJfFXm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       "]], LineBox[CompressedData["
1:eJxN13k0Vd8bMHCEKJrMkswhmZL5nv1kHi/3XoSITInMs2RKyBQSvpIhGS+Z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       "]]},
     Annotation[#, "Charting`Private`Tag$53663#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.811090532870706*^9, 3.8111592460714893`*^9, {3.811159438963142*^9, 
   3.811159459626992*^9}, 3.811159609249689*^9, 3.8111600412885017`*^9, {
   3.811160103348082*^9, 3.811160116820189*^9}, 3.811160183334951*^9, {
   3.811161658301366*^9, 3.8111617826909246`*^9}, 3.811164529473672*^9, {
   3.8111654626842203`*^9, 3.811165469531844*^9}, 3.8121027127642603`*^9, 
   3.812103502433165*^9, {3.8121054371284113`*^9, 3.812105442459313*^9}, 
   3.8121110678893147`*^9, {3.812111377944718*^9, 3.812111381048959*^9}, 
   3.8121116783171253`*^9, 3.8121117654160643`*^9, 3.8121118844551277`*^9, {
   3.8122054408527*^9, 3.812205465924611*^9}, {3.812205540043322*^9, 
   3.812205552306856*^9}, 3.812359256773479*^9, 3.81235944040959*^9, 
   3.8123606947728233`*^9, 3.812795438010902*^9, 3.8127974412962837`*^9, 
   3.812797819635002*^9, 3.812798232176013*^9, 3.812798541851615*^9, 
   3.812799419906528*^9, {3.81279966723094*^9, 3.812799680386602*^9}, 
   3.813323410924588*^9, 3.813323861634457*^9, 3.813324427048142*^9, 
   3.813568070475561*^9, 3.813568475046073*^9, 3.813569097712584*^9, 
   3.813571544461218*^9, 3.813650504714614*^9, 3.813912550136261*^9, 
   3.814177793272769*^9, 3.8147810255352488`*^9, 3.8159126763960047`*^9, 
   3.8202280819762917`*^9, 3.833609160866269*^9, 3.867308269928192*^9, 
   3.867312178491518*^9, 3.867318368337832*^9, 3.867318576378943*^9, 
   3.867318907210868*^9, 3.867319006495376*^9, 3.867320542517706*^9, 
   3.8673208300297403`*^9, 3.867321159765892*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"b22dc400-2ffd-4e52-a1e6-7637a0fc2aaf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complete Data", "Subsubsection",
 CellChangeTimes->{{3.812204457880973*^9, 
  3.812204470141396*^9}},ExpressionUUID->"5bb7ab99-35df-4644-afa3-\
b4a0d373b7de"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"list", " ", "of", " ", "all", " ", "volumes"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"volumescomplete", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "2048", ",", "4096", ",", "8192", ",", "16384", ",", "32768", ",", 
         "65536", ",", "131072", ",", "262144", ",", "referencevolume"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Length", "[", "histogramsdatacomplete", "]"}], "}"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Visualize", " ", "histograms", " ", "for", " ", "each", " ", 
     "sampling"}], "*)"}], 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "=", "1"}], "}"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Range", "[", 
             RowBox[{"0", ",", 
              RowBox[{
               RowBox[{"Length", "[", "#", "]"}], "-", "1"}]}], "]"}], ",", 
            RowBox[{"#", "/", 
             RowBox[{"Total", "[", "#", "]"}]}]}], "}"}], "]"}], "&"}], "/@", 
        
        RowBox[{"histogramsdatacomplete", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "60"}], "}"}], ",", "All"}], "}"}]}], ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"volumescomplete", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.812204487269101*^9, 3.812204524568578*^9}, {
   3.812204574519312*^9, 3.812204583024159*^9}, {3.812204744577429*^9, 
   3.812204770052148*^9}, {3.812204841534045*^9, 3.812204861899934*^9}, 
   3.812205799855543*^9, 3.812206239142148*^9, {3.8123592001648006`*^9, 
   3.812359249922738*^9}, {3.812359413654903*^9, 3.81235943662298*^9}, {
   3.812360655144754*^9, 3.812360689477961*^9}, {3.812797392732017*^9, 
   3.812797435680854*^9}, {3.812797780374511*^9, 3.812797814238636*^9}, {
   3.812798030478706*^9, 3.812798061580186*^9}, {3.812798512718256*^9, 
   3.8127985381259117`*^9}, {3.812799383395599*^9, 3.812799413646282*^9}, {
   3.812799639701624*^9, 3.81279966249649*^9}, {3.8127999487983923`*^9, 
   3.81279999005021*^9}, {3.81332329230617*^9, 3.8133234049887733`*^9}, {
   3.813323827969552*^9, 3.813323856341833*^9}, {3.8133240610463142`*^9, 
   3.8133240771609077`*^9}, {3.813324394754818*^9, 3.813324422443688*^9}, {
   3.813568052637918*^9, 3.813568061522698*^9}, {3.81356843186068*^9, 
   3.813568470633565*^9}, {3.813569083990219*^9, 3.813569089398933*^9}, {
   3.813648998646447*^9, 3.813649000741145*^9}, {3.813649118701702*^9, 
   3.8136491463703203`*^9}, {3.813649239870059*^9, 3.8136492767241993`*^9}, {
   3.813649561060574*^9, 3.813649595844714*^9}, {3.813649661080927*^9, 
   3.813649673885125*^9}, {3.813649794352985*^9, 3.813649803264736*^9}, {
   3.813649870300312*^9, 3.813649966072215*^9}, {3.8136504031708193`*^9, 
   3.8136504802847643`*^9}, {3.814177124746635*^9, 3.814177136634705*^9}, {
   3.814780496466793*^9, 3.8147804985201387`*^9}, {3.814780533471734*^9, 
   3.814780582625637*^9}, {3.8147810218385763`*^9, 3.814781022161109*^9}, {
   3.815912651597493*^9, 3.815912673076478*^9}, {3.833617630076087*^9, 
   3.833617640331023*^9}, {3.8673077689585247`*^9, 3.867307783586713*^9}, {
   3.867308208032971*^9, 3.867308265880723*^9}, 3.867308362372966*^9, {
   3.8673121513815527`*^9, 3.8673121747173653`*^9}, {3.8673183783962507`*^9, 
   3.867318405398465*^9}, {3.867318580694055*^9, 3.867318580821661*^9}, 
   3.8673189269217243`*^9, {3.867319010145434*^9, 3.867319028216489*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"79dcd6cb-0013-4e82-97d1-760cfbed61c0"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0F9ojXEcx/FvUpS0kTKhNltLJy2zmZ2d45yvvxvG2MGGjceYXWhzpVyg
b+1GuVguxhCdC7vQ6UQRucBvSrlQp6i1UOdkTWo3ilK78K/zO+l5nzo9vXr3
6dvzVPWd6+yfJyKZv/9/z/BPk8Xnt6S1vby0emowWQot52cexXNXvBfq8Nz1
aG/krne5lk3+jr7NZ72X6dkgM/9q9TPvCg0ernySXfrKe5W2juQ//nj/2rtS
Gz5ZbuRxyWu0PJb6Gr824V2jdZ9j9bOJp961emfJ+POJm/e912ruZ2p6vGzM
O6JfkvfyLyaHvddpZDo/0NNcep86rVk05rKxlPd6HVp+a7bxXZN3vZ758Gt0
tHaF9wZdcPFyRVV8LlF0g87cHhxq75jybtTFmQvV39888N5Y/B43BrybNPyd
N8HNcBRugWNwHN4MJ+AkrGEbLFvQYdmKDss2dFi2o8OyAx2WneiwtKLD0oYO
yy50WHajw7IHHZZ2dFj2osOyDx2WDnRY9oetsMEOlgPYwwY7WDqxhw12sKSw
hw12sBzEHjbYwXIIe9hgB8th7GGDHSxd2MMGO1i6sYcNdrAcwR422MFyFHvY
YAfLMexhgx0sPdjDBjtYerGHDXawHMceNtjBcgJ72GAHSxB2JaxwABuchh1c
gOUk7sMKB7DBadjBBVj6cB9WOIANTsMOLsByCvdhhQPY4DTs4AIsp3EfVjiA
DU7DDi7A0o/7sP73Hxle5wc=
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0VlIVGEYh/GXEBIKGkMiM8FE0iRKbbFymbc0U6vJpUzLZbKEIsiLLrQN
PhMrKBKJFgyGuQiNhLBlICjh0yiIgrKbDCImWiUv0hIqMir8IOY5cDj8+PPw
XpwFDU3ljdNEpPfv++8b+aR7p75fvK15nSnFL2qdRQN1ix57PrY4R2tCR9zV
M21nnT167Nmt6omnAedYnXzZEdsZ3+s8V/Xkj/Hj6SHn+Ro/nDbQcKTfOVGl
qTWq3TPonKQXRoejo3LuOyerJ7vi06/AgPNCHZ8572dP6K5zqt47dC3/wJOb
zmk6njzS9aik23mxzrkSd7q7+aLzEr0eOPc6y3fCOV3f+Ub8k80HnTP0zdDD
mP1D9c6Z2n6jPXH6+yLnZXqnqqxt36VM5+Vak5vS33Q03nmF5mR8flDqi3Je
qbf7ehJ+d43mTTlLDw/OnpV6+bnzKn0V45tR9y3kvFoHl0587U4677xGK8cK
P3R6W5yzdWzv21Oh7wXOORr5H3PhPNgLa6QNLGuxw7IOOyz52GEpwA7Leuyw
FGKHZQN2WIqww1KMHZYS7LBsxA7LJuywbMYOiw87LFuww1IaaYUNbGEpQw8b
2MJSjh42sIWlAj1sYAvLVvSwgS0s29DDBrawVKKHDWxh2Y4eNrCFpQo9bGAL
SzV62MAWlh3oYQNbWHaihw1sYalBDxvYwlKLHjawhaUOPWxgC0s9etjAFhZ/
pBNhhf2wgYOwhcOw7MJ9WGE/bOAgbOEwLA24Dyvshw0chC0chmU37sMK+2ED
B2ELh2HZg/uwwn7YwEHYwmFYGnEf1v/+A79P/QE=
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxdz2tozXEcx/EvimlLVtJWYuNYI4RtLjvY15zZhQ1znd2OMY01e6SUrJ8H
NNOGWqzZyXFJGm2mpLnUr01uK7YHk/boLEwpIreVJrTfYu9/nf69evc533Ni
SypzS8eKyPU/n7/v0U9MyvD7U8qPg6GmyLfZzqIXBxcNtAyVOYdpYiAQUfeo
ynmy/uz6+LSz6JTzFL319WL4e0+Tc5S2Rx+w715ddZ6mx8fF5unQTecYnZTV
sM+78I7zTL2bM2t+b/99Z48W1lx/Nt1nneP0zYP9pR2VI47X1tRnG5qbHzjP
1V8ZkdFTB0a+b57+GJNRcSmtzXmBtnfcK/A1jPyehXro3MnBnKFG50WaGTBx
HU9qnRfr3vIjZ7pbRv5vgrYlHHtefqXCOVF9l73VgTn5zklalTQhbOBauvMS
DT/c1996IsF5qZZkeXq64mc4L9POo6fn+cdOdF6uvS/O12yJ+rJq2Mna/WF2
bU9yn7NX6/dfqHsc8dB5hTa2lSV7o284r9S0by/ttolnnVdp/ffxxQ3rDzqn
6Oey19W3Bz3OqvL/Y2BZjQ5LKjosa9Bh8aHDkoYOy1p0WNLRYclAhyUTHZYs
dFjWocOyHh2WbHRYctBh2YAOy8bRVtjAFpZN2MMGtrDkYg8b2MKyGXvYwBaW
LdjDBrawbMUeNrCFZRv2sIEtLNuxhw1sYdmBPWxgC0se9rCBLSw7sYcNbGHJ
xx42sIWlAHvYwBaWQuxhA1tYirCHDWxhKcYeNrCFxT/aMbDCftjAQdjCIVh2
4T6ssB82cBC2cAiWEtyHFfbDBg7CFg7Bshv3YYX9sIGDsIVDsOzBfVhhP2zg
IGzhECyluA/rP/8GHIAOIw==
         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0GtozXEcx/HvYTQiW5ymjDYtY64bM+xyvttc5n6fmdnObvFgNjyYyWW/
knKKcrS14oHTSGn2gFgjD37J9REtCUVnWyMUhpUnhPY76bxPnf69evc539M/
uaphS+0IEen4+/33jP7E+YafX30/fj1v+vAu11n0wcG1Hcmenc6xGj9tX+L1
nnrnOJ36ZMB3OdjsPEnzRtmm0cHTzpP1sL5q6TjX5pyoR9JbJnZOaHdO0pI+
T+3EL1edp+vbjuIZZYeuO6fosbIpaQ9HdznP0KG4M5/1/W3nmRr/6E733Oy7
zmnaML6uVasjnqONdTF93pw7zvO0t3n2q+CKyO8t0PV7Uk9U10TupevY+P2x
3qmR/5Oh9Zc8d0/2h5wXamPgY6enqNV5kd5vKWpvWxNwztRxj8u//D571Hmx
2qfd+5NuRt5Xlt6bP/T9SlWF8xItfJ/ZGHi9wXmpeoOV3oblkfe/TM80XzzQ
a9OcszUrkO8f2JTgnKNZWVdS5wyOdM7V2GuJpTXZg3nDztMLpV0vEsa8cfbp
78HyWxm9j5xV6xPOf1rUc2PYRnXWs9RvKR/Ou56v1zpfVjRuPO56vg7u7T91
6+c21wucY1wvUIn6FEbbwLIcHZYV6LCsRIdlFTosReiwrEaHZQ06LGvRYVmH
Dst6dFg2oMOyER2WTdFW2MAWls3Ywwa2sGzBHjawhWUr9rCBLSzbsIcNbGHZ
jj1sYAtLMfawgS0sO7CHDWxhKcEeNrCFZSf2sIEtLKXYwwa2sOzCHjawhaUM
e9jAFpbd2MMGtrCUYw8b2MJSgT1sYAuLP9pJsMJ+2MAh2MJhWCpxH1bYDxs4
BFs4DEsV7sMK+2EDh2ALh2Gpxn1YYT9s4BBs4TAsNbgPK+yHDRyCLRyGpRb3
Yf3vP7h5GXY=
         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0n9MzHEcx/E3q9ZI+aPQDzrW/GiS6qKkeitRKCelUOcqpTaTxNiwffy+
MhrLylg7wvq1yY8rbOxjJsOajf6wot1GGjbLhLL+IPc2vL7b7bvHnnvde7vd
9PzS9MKxRNT86zP6hife+RqI785MHk75GiIm3lNzfCjNJUXsziVvrPYhh1k8
kaseeWR0tJeKvdl459DLsz37xFN4crJppNbNKg7gzN6T27tbTosN/OOcycrl
58Qz2N1gr3gRUi8O4oGLVw0TTjSKZ/LUKt+GfVGt4tkcWp+9raL2hjiYPX3e
jOwvaxPP5ae3vbO+Jt8Sz+OcxydPmO798Xzeen1Z7GBTuziMleeXvsI4uzic
LZ1jDg73XxNH8K5A1XVlS4vYyK3+bSFNfFkcydGfqj0nGerEC/jbp6rvH9ZU
ixfy7p4j7+4YK8VRvCPilXoWqcTR7FrScfF9arl4Eftt0/3HoovEMRz28aEp
rStbvJh3mgtqGnpXiGO5c1qx69GRGHEch74OcjsQOVccz3VBuRHDRf5i5rde
bnV7vcY5rZjHmwd9LvkOxTn7kt+/35n9fU6rJTyr6O6UJxXPpSfwzcA5Mx4E
35OeIN/fLD2RKzsf2S/kn5eeyHl+R6usc05JX8qOwwkuAQlHpC/llob7Ro/A
MulJnBeeOT+4MVF6En8uHv0DDsY6+zKmfx8FpuXQwZQMHUwp0MG0AjqYVkIH
0yroYEqFDqY06GBaDR1Mpv/NYAXWYFoDe7ACazClwx6swBpMa2EPVmANpgzY
gxVYgykT9mAF1mBaB3uwAmswZcEerMAaTNmwByuwBtN62IMVWINpA+zBCqzB
tBH2YAXWYMqBPViBNZhyYQ9WYA0mM+zBCqzBtAn2YAXWYLL8bwOYwRawAtvA
GuwAUx7cBzPYAlZgG1iDHWDKh/tgBlvACmwDa7ADTAVwH8xgC1iBbWANdoBp
M9wHM9gCVmAbWIMdYCqE+2D+658LaDVz
         "]]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0glIVFEUxvFDlAZWmhSpZGq0mG22aI2pcyZTW2wy281ytEyjxFDCQMub
kUQT0TqVbVOYFRW2jUUbt2ihBQmLxCJ40QYpldkKWSkeifkeDI8f//nmwnBD
MvNSsjoRkav10/Z2fz7Hyts8vvmUiT8HmiXwx5rnuX18TeKu3O/XhvXvP1jF
PuxZvM4v5Fa6uBfbW7J+vGlaKfZj/4I63/yRa8R92VJ+LudKY6k4mCMsT9cq
/y3i/lx9JPNA0Led4gFcXmP1yDbvFw/iHV2SjOpPR8ShHDP4et7ph5XiMM5x
dD6x/Psp8TCO716ZcbnsrHgEz2498Mzd8+JwdgX4/vBbfVE8ir2WeFmepbjE
o/lG+L6wVVEdHsO7y2Me1w7p+P5Y7vHzd3imueP3IrihwNW7oaRKHMkB9soL
T36fFI/j1n8reurmCvF4VqX23q6ww2ITr7i0KMd60yGO4sNBCV2rPLeJJ7Dx
4mu2uX6jOJpvD7x3sPZdsTiGj8ZXN7dszRfH8rZRhcNDRmaLzRw8wGuvnpAm
ZjZ5FT1/dSe53Yo58P5bc0VBnHQLN5bl2kc3REi38KNQx8LUwFDpE9lulAyt
nxkgfSK3XZ/wxG7S4zjgpaUxKeRP+/1ScezjcajIu0/HfZvEOxwPXvS0GtIn
td+n6Brp8Xz1cdrx7Y4r0uOZ63cNvfbwmPQEHhQZVFe2ebv0BP5yNnlFeWGx
9ERuynm9yfVzqfRE9n721/RoT6L0ydI7S5/M5PZMcbcC01ToYJoGHUxJ0ME0
HTqYrNDBNAM6mJLdzWAF1mCaCXuwAmswpcAerMAaTLNgD1ZgDabZsAcrsAbT
HNiDFViDaS7swQqswTQP9mAF1mCaD3uwAmswLYA9WIE1mFJhD1ZgDaaFsAcr
sAZTGuzBCqzBtAj2YAXWYFoMe7ACazClwx6swBpMNncHgxlsAyuwE6zBBpgy
4Hwwg21gBXaCNdgAUyacD2awDazATrAGG2BaAueDGWwDK7ATrMEGmJbC+WAG
28AK7ARrsAGmLDgfzGAbWIGdYA02wLQMzgcz2AZW//0PFC1Tfg==
         "]]}, {
        Hue[0.08640786499873876, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0gtM1WUcxvFXVOamInlJmtnIlIndUDkgoPBwk5vIzUQS8C+3MFdqzGaF
8cacNo9CUd5i5R8TBpRoGMNS5FVIszLUvMzN6sywGeG0Wngazm78aPmc7ey/
z77nOb/t7Dyctyq90EMpderv9z/Pe1+u8IHnrYjTVcrR0js6QgK+vZk6/vo4
f/EI7O2+EOLZGy72RkdBo7WoM0U8HjmbP/jiqDtb7IPI1h2BJxKKxQ+i3nE6
zGtcidgXMc9vnLS6tFQ8BZ8cP5zdmb9BPBW1Cf7XF/tvEfsh8kjTMutylXg6
/uxafvRK+U7xDFTeOWZ+89wtfgyXv76dkeT7vvgJ5HkvCfmqr04cgGuvbtqz
85tG8UwMr28o7HihSTwLs3xfaavuPCCeDfS9fHto90fiQFy8mqHeeLFZ7ED7
+a7qKSsGHQSf6JCz7xwa/HwwJkw+da1y7eD3zYH7gYleV8r3iUNwp3/LyAhn
gzgUT6a1Odbl1orD4Lg5J3ZVco14LtIvDEvLnF4tnoey5Iv1l5rfFofjtWb/
TJ+mCnEEzg7//fHZfhvFQGLuu/kILxuwBh59NmB0h3Ot9Ehc/Wlb86hJz0mP
RM+wwPuC0vKlRwGb/vjVIzpLehTG2nXb98WnSo/GwVFrPnS2xEiP/vf3Ozk0
VHoM3godkrzBESA9BpVbcaRpzFTpsajwvHV//Bkf6bHYvs2v1l7qJX0+vss6
fCOqxEP6fKwuvbFrWmSf/J/jsOfjYPfxgp4B6zhoq+Kh9tbvpcdjRua6HU73
OenxONhT0jKh/zPpCWjoV3uD1nwqPQE17pk/Nk07ID0RtW3HJvpl1EpPxJiR
LXUvndwlPQn7R9xtrZrslJ6E6ru9cZs/19IXYO7K1pziphLpC9BYuHL9m2eK
pCejy64pK3cWSk9G1Zdl8e3rc6QvRFh30aEhu1OkL0Rz/iPe+38Olp6Cc/0n
Lr2XNVZ6Cn4p/uH1Fvf5eQM9Fer/L5A12ZBVGu3JmmzIKp32ZE02ZJVBe7Im
G7JaRHuyJhuyeor2ZE02ZLWY9mRNNmSVSXuyJhuyWkJ7siYbssqiPVmTDVk9
TXuyJhuyWkp7siYbssqmPVmTDVnl0J6syYascmlP1mRDVstoT9ZkQ1bWvfYl
g2yRNdkmG7KLrJbTfTLIFlmTbbIhu8gqj+6TQbbImmyTDdlFVvl0nwyyRdZk
m2zILrIqoPtkkC2yJttkQ3aRVSHdJ4NskTXZJhuyi6yK6D4ZZIusyTbZkF1k
9QzdJ4NskTXZJhuyi6yK6T4ZZIusyTbZkF1kteI//wVueacL
         "]]}, {
        Hue[0.3224758424985268, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd039M1HUcx/FPtGmFOmbipLDxw7CIgYgEaHBvOLjj18GJKKgFFz+VOagG
2Q9wHwcTxAoRQw13fZHTSyVTUBYrtw+ybHMmrl+4wHkOmtbkh0SO5GLR7s3K
12237x573uvef9zON68so9BNCPHD7Pvf56Ov6zGu57hOZHXk+4//zRZ09+l3
D5R7eulcfIJWNzh71Fgw24OsL5bn5H+nYy+hrprK650zqexltOnT059np2ez
vWkitq/I87l8tg81lXV1hzbvYPuRM3xz267acvYKCj+853avrGQHUN/F2pS0
yGr2C/R+UZJ8GLuXHUiZQ8dbPojYzw6iH6tExrqCg+xgev49r28CfY+wV9Gq
gorTd7Za2aGkv5J+6s+/WtmraVmf1mq8aWOHUXVpyPapL+3sNaS7PHhhsPAU
O5yOjT6+/+fudvbL9OtTY2/11J1hR1D1npknrSe/YEfSO0eP+R8RZ9lRNG5e
cne6eq6vJe2ZkJtno+b262jeDaO9NHLu+18he2PzlSH7SXY0hT1bcGCk+wQ7
hjomW90ztDa2juL37bjjXq+xiX57KTHsTESLy5JoJNDmPD/8MfdYavh2QeaD
6EbuseR3In7xwpZ67nE0Mt5fsNCvhnscGRtuDay5V8VdTx39X+l2DVZw11PM
7MBWWsY9nn4KSBvdaSjiHk+X1k/8ftQ3l3sCLX1wvje3YiP3BLqV/uGh0jgT
dwPlGs4Nfv+1nruB6iYH+ncb13I3UmBjfEibIZS7kUzFK6vb3gjgnkgPJ9zu
tfV6c0+k2tv+eclBi7knUXDU6MFFXfO4J5F1zH45JcLJ/49k2mKdv7PYdN9l
mUydC95s3zcwzD2FbE7bL/ahG9xTqFk/+wNMX+WeSu45k542rx7uqXTOvnzm
k/ZO7iYKSgxbaiq2czdRq8djtebjVu5pZLh2yfr2VBP3NArt8hjWavZyT6f6
punl9W5V3NNpt/6zjM75JdzNZPrjow3lK7JcJjNdTahcWXQxkT9vpmzva86S
RT4uKzPd3zZUd2FqONq1X0/i/y8CS7ACiwzYgyVYgcUG2IMlWIFFJuzBEqzA
YiPswRKswGIT7MESrMAiC/ZgCVZgkQ17sAQrsNgMe7AEK7DYAnuwBCuw2Ap7
sAQrsHgV9mAJVmDxGuzBEqzAIgf2YAlWYJELe7AEK7CwPGofMIEtYAnWwArs
AIvX4T6YwBawBGtgBXaARR7cBxPYApZgDazADrDIh/tgAlvAEqyBFdgBFgVw
H0xgC1iCNbACO8CiEO6DCWwBS7AGVmAHWBTBfTCBLWAJ1sAK7ACLYrgPJrAF
LMEaWIEdYLEN7oMJbAFLsAZWYAdYbIf7YAJbwBKsgRXYARYlcB9M//kfVGbF
Zg==
         "]]}, {
        Hue[0.5585438199983166, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd0wtMVXUcB/A/YKkZjkiS6dUpNNOrEi+hkMePlwICFy4WD4GOPBQx0QlG
6Iw/JAPRXjwsNOUgZSNUHMyKjehP5EyqWdiWGNQZvjAyY21gpiMdP1Z+z3Z3
9tn3fs/37Nx7FmZstWbbCiEG7n8enB8+VODE+c+grn2dpd6Xb7IFdQ1uu5Zo
Nz1ogtMoL9qSNHh1PtuBhmLCzfvPPsueRYUN7bGu4/5sZ2q06XikKj6CbaJ7
pQOntrgmsBfQzSP+y2qaU9ku9O0Pl8dG67PYT1NLSI8lt/Vl9iKaX2m7++im
fPZiWt56+FbhB0VsM4XUHgxIqpXsZWRXO3Kre3oZ243Oxz66Otmvku1ObqZp
58xOb7M9qDOmePSLzdVsT/JLe+rJv+a+y/aiuVlV79yafYjtTeM9UdVzouvZ
K2io7/idi+cb2D50bWhkV9lYI9uXvmmflbhl6jH2c+T9hI//iesfsZ+nzOK+
gBu7m9h+tKz+alFl28fsleQYOyP9s/xmtj8Fpm7vt7RMOoCa+uxOOGuTDqTu
I6/cHq+Y7AfRsMmuNW3F5PWJCpacNHvs5H1J1DR649VF2z7kPJhGci5XLPHk
+5fBlDkjeKb5F53zEHIvWVf4q+kw5yGUtaP5umh9j/NQMhoWf/9TXQ3nodTg
YFP+/tDk8w6jL+8ElZes3cd5GBV3JJ748czk7xVOA4/7GsPzSjgPp6AHN1i1
k/NVFOk2vnBeVgHnq+jKpTiPvLE8zleT5/HBN/aHbeR8NTW6tt8tt6znPIJs
sxNObitN5jyC0uXuAnOdlfNIcvHttr/dH8V5JOlOzq1+nqGcR1Hb6c6IHK+V
nEfRlMEd90qf8eJ8DZUfpfqvr5o5X0MbPnfu2fuHC+fRVFGWcqGjbQ7n0ZTi
qB87cMaR8xgqNdW4X/B5jPMYmmlpqckmW85j6XfvXmvR0r8n3lcZS3mzDw57
O47w+2uhTzPu/6Har3FuoU8cruh76gY4j6ND53x/7r/YO2GKo/KvAg4EFpzl
78eRTZcp4LWtHRNWcdQ2NaVkYfMp7sdTtZ9NzB77Ru7HU9tv+aed/qnmfjyt
mvaWz5tJr3M/npau2HX/EW7nvpXUlLyB7xLSuG+lm/ad7nXmCO5bKdc50OVY
mCf3rXS3aaQ3JsOB+wm0PNQ0POhzKWCin0Di/4cEK7BY+7AJLMEKLF6APliC
FVi8CH2wBCuwSIQ+WIIVWCRBHyzBCiySoQ+WYAUWKdAHS7ACi3XQB0uwAotU
6IMlWIFFGvTBEqzAIh36YAlWYPES9MESrMBCe9gLwATWwBKsgxXYAIv1sA8m
sAaWYB2swAZYZMA+mMAaWIJ1sAIbYJEJ+2ACa2AJ1sEKbIBFFuyDCayBJVgH
K7ABFtmwDyawBpZgHazABlhsgH0wgTWwBOtgBTbAYiPsgwmsgSVYByuwARY5
sA8msAaWYB2swAZYbIJ9MIE1sATrYAU2wCIX9sEE1sASrIMV2ACLzbAPJrAG
lv/5X53n5Vg=
         "]]}}, {{
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[1.6]]}}, {{
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"\"", TraditionalForm], 
       FormBox["\"\"", TraditionalForm]}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {{0, 60}, {0, 0.1705308984375}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "2048", "4096", "8192", "16384", "32768", "65536", "131072", "262144", 
       "524288"}, "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #8}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.647624, 0.37816, 0.614037], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.647624, 0.37816, 0.614037], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #9}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.772079`", ",", "0.431554`", ",", "0.102387`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.24259866666666668`, 0.412334, 0.521566], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.363898`", ",", "0.618501`", ",", "0.782349`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.363898, 0.618501, 0.782349]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.363898, 0.618501, 0.782349], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.75, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0.5, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.75`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.75, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.75, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.647624, 0.37816, 0.614037], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.4317493333333333, 0.2521066666666667, 
                    0.40935800000000006`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.647624`", ",", "0.37816`", ",", "0.614037`"}], 
                    "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.647624, 0.37816, 0.614037]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.647624, 0.37816, 0.614037], Editable -> False, 
                    Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8, ",", #9}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.81220452530167*^9, 3.812204586872164*^9, 3.812204771373581*^9, {
   3.8122048564948387`*^9, 3.812204862616476*^9}, 3.812205800503653*^9, 
   3.812206240001006*^9, 3.812359253133102*^9, 3.812359437588376*^9, 
   3.812360690563757*^9, 3.812795434265747*^9, 3.812797436833387*^9, 
   3.812797815465004*^9, 3.812798229687523*^9, 3.81279853929827*^9, 
   3.812799416206314*^9, 3.81279966375992*^9, 3.81279999147997*^9, 
   3.813323407123335*^9, 3.813323857903058*^9, 3.8133244234643927`*^9, {
   3.813568063634242*^9, 3.813568073263052*^9}, 3.813568472053249*^9, 
   3.813569092854075*^9, 3.813571542527513*^9, 3.813649004264482*^9, 
   3.813649123078073*^9, 3.813649247434414*^9, 3.8136492787812653`*^9, 
   3.813649575680925*^9, {3.813649677058951*^9, 3.8136497009724197`*^9}, 
   3.8136498159008007`*^9, 3.813650499489839*^9, 3.813912547363796*^9, {
   3.8141777867900143`*^9, 3.8141777913856277`*^9}, {3.81478101379701*^9, 
   3.8147810229745626`*^9}, {3.81591266970263*^9, 3.815912673979782*^9}, 
   3.820228079034336*^9, 3.8336091564135427`*^9, {3.833617632502823*^9, 
   3.833617641855626*^9}, {3.8673082446509447`*^9, 3.867308266791995*^9}, 
   3.867308363388358*^9, 3.86731030498108*^9, {3.8673121528901663`*^9, 
   3.867312175749599*^9}, {3.867318276071069*^9, 3.867318293598374*^9}, 
   3.867318408361724*^9, {3.867318579209988*^9, 3.867318581850502*^9}, 
   3.867319029381338*^9, 3.867320544792035*^9, 3.867320832144026*^9, 
   3.86732116190765*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"3232afe0-7789-47e1-9e45-8a090309d680"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Organise data to fit", "Subsubsection",
 CellChangeTimes->{{3.8122044272498503`*^9, 3.812204428094318*^9}, {
  3.8673087589080772`*^9, 
  3.867308795537327*^9}},ExpressionUUID->"196e456e-fba0-4577-aed4-\
fedc692ab272"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"histogramsdata", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"histogramsdatacomplete", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Length", "[", 
            RowBox[{"histogramsdatacomplete", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], ")"}], "-", "1"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "histogramsdatacomplete", "]"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"histograms", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", 
            RowBox[{
             RowBox[{"Length", "[", "#", "]"}], "-", "1"}]}], "]"}], ",", 
          RowBox[{"#", "/", 
           RowBox[{"Total", "[", "#", "]"}]}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"histogramsdata", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "histogramsdata", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"volumes", " ", "to", " ", "collapse", " ", 
    RowBox[{"w", ".", "r", ".", "t", ".", " ", "reference"}], " ", "volume"}],
    "*)"}], 
  RowBox[{
   RowBox[{"volumes", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "2048", ",", "4096", ",", "8192", ",", "16384", ",", "32768", ",", 
        "65536", ",", "131072", ",", "262144"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Length", "[", "histograms", "]"}], "}"}]}], "]"}]}], 
   ";"}]}]}], "Input",
 CellChangeTimes->{{3.811089702755865*^9, 3.8110897262661753`*^9}, {
   3.81108984508473*^9, 3.8110898874474792`*^9}, {3.811090387924899*^9, 
   3.811090426055694*^9}, {3.811161808701955*^9, 3.811161831817453*^9}, {
   3.811164667678537*^9, 3.811164708477138*^9}, {3.811165617674163*^9, 
   3.811165694551339*^9}, {3.811165727396926*^9, 3.811165769246729*^9}, {
   3.811165813108753*^9, 3.811165819591936*^9}, {3.811165894134129*^9, 
   3.811165914016708*^9}, {3.81210332469488*^9, 3.812103377194274*^9}, 
   3.8121034867824497`*^9, {3.812111070725506*^9, 3.81211109319571*^9}, {
   3.812111681491548*^9, 3.812111701926893*^9}, {3.812111768512086*^9, 
   3.812111801889812*^9}, {3.8121118876798773`*^9, 3.812111908448876*^9}, {
   3.812204263291568*^9, 3.812204325930344*^9}, {3.8122044489847593`*^9, 
   3.812204449834144*^9}, {3.8122055951620607`*^9, 3.812205602177889*^9}, {
   3.8122058209978123`*^9, 3.812205935699766*^9}, {3.812206034718336*^9, 
   3.812206074875147*^9}, {3.812206105031266*^9, 3.812206181139656*^9}, {
   3.813323450045043*^9, 3.813323467916237*^9}, 3.813323514035946*^9, 
   3.813323613005336*^9, {3.813323865651513*^9, 3.8133238671681547`*^9}, 
   3.813568522729244*^9, 3.813568560123209*^9, {3.867318430725367*^9, 
   3.8673184458324966`*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"15b2fc5c-9e48-4b9f-a354-a0ec18d3e082"]
}, Open  ]],

Cell[CellGroupData[{

Cell["COLLAPSE", "Subsection",
 CellChangeTimes->{{3.812198533826956*^9, 
  3.812198549496366*^9}},ExpressionUUID->"e885cef6-58bc-4222-a801-\
999f1b5c3535"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "first", " ", "fit", " ", "with", " ", "independent", " ", "shifts", " ", 
    SubscriptBox["s", "n"]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"fitshifts", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"hist1", "=", 
           RowBox[{"histograms", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"hist2", "=", 
               RowBox[{"hist1", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{
              SubscriptBox["s", "n"], "/.", 
              RowBox[{
               RowBox[{"NonlinearModelFit", "[", 
                RowBox[{
                 RowBox[{"Select", "[", 
                  RowBox[{"hist2", ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ">", 
                    RowBox[{"0.2", " ", 
                    RowBox[{"Max", "[", 
                    RowBox[{"hist2", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}]}], 
                    "&"}]}], "]"}], ",", 
                 RowBox[{"k", " ", 
                  RowBox[{
                   RowBox[{"intpfunsref", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"k", " ", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SubscriptBox["s", "n"]}], ")"}]}], "-", 
                    SubscriptBox["s", "n"]}], "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["s", "n"], ",", "0"}], "}"}]}], "}"}], ",", 
                 "x"}], "]"}], "[", "\"\<BestFitParameters\>\"", "]"}]}]}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"histograms", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "histograms", "]"}]}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"s", "=", 
    RowBox[{"Mean", "/@", "fitshifts"}]}], " ", 
   RowBox[{"(*", 
    RowBox[{"compute", " ", "the", " ", "average", " ", "shift"}], "*)"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.811162518439781*^9, 3.811162531448669*^9}, {
   3.811162591458488*^9, 3.811162819134028*^9}, {3.811162898016183*^9, 
   3.811162903278179*^9}, {3.811163933839891*^9, 3.811163961058456*^9}, {
   3.811163996889563*^9, 3.811164002447205*^9}, {3.8111641022628508`*^9, 
   3.811164117789119*^9}, {3.8111641689375763`*^9, 3.811164201354003*^9}, {
   3.811164282534849*^9, 3.811164292148828*^9}, {3.811164336711494*^9, 
   3.811164338574651*^9}, {3.8111644513771477`*^9, 3.811164484303857*^9}, {
   3.811165454290245*^9, 3.811165454402707*^9}, {3.8111655065323753`*^9, 
   3.811165524823503*^9}, {3.811165595437111*^9, 3.811165599064518*^9}, {
   3.812102732990752*^9, 3.812102921038598*^9}, {3.812102995823277*^9, 
   3.812103029130525*^9}, {3.812103067356485*^9, 3.812103067638418*^9}, {
   3.8127985564673767`*^9, 3.812798562621388*^9}, {3.867318453024482*^9, 
   3.8673184947636147`*^9}, {3.8673187155789423`*^9, 3.867318767299313*^9}, 
   3.867319042039403*^9},
 CellLabel->
  "In[172]:=",ExpressionUUID->"250edcf0-dea7-48e7-8db8-c6e1e01e6edf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.7857182112252914`", ",", "1.6427454240627695`", ",", 
   "1.7883897710886476`", ",", "1.868218030380069`", ",", 
   "1.7609714409593993`", ",", "1.649562143259135`", ",", 
   "1.7660065445781208`", ",", "1.7020129277544014`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.811164487540908*^9, {3.811164519413259*^9, 3.8111645366984453`*^9}, 
   3.8111647262944*^9, {3.8111654557144403`*^9, 3.811165476107236*^9}, {
   3.812102901570146*^9, 3.812102927032584*^9}, {3.8121030253129683`*^9, 
   3.8121030298740396`*^9}, 3.8121030686910257`*^9, 3.812111097603538*^9, 
   3.812111400485435*^9, 3.812111708539482*^9, 3.812111808850792*^9, 
   3.812111912594843*^9, 3.81220556683313*^9, 3.812206186619616*^9, 
   3.812359265935445*^9, 3.812359445516374*^9, 3.812360699381188*^9, 
   3.812795443741467*^9, 3.812797446064753*^9, 3.8127978263236113`*^9, 
   3.812798236308179*^9, {3.8127985467986794`*^9, 3.8127985677397738`*^9}, 
   3.812799424199037*^9, 3.812799684510909*^9, 3.813323870676375*^9, 
   3.813324432111425*^9, 3.813569101800243*^9, 3.813571548515319*^9, 
   3.813650530685936*^9, 3.8139125546468143`*^9, 3.814177798025856*^9, 
   3.814781029555134*^9, 3.8159126804022713`*^9, 3.820228086384838*^9, 
   3.833609166394586*^9, 3.867308277089342*^9, 3.867312185532138*^9, 
   3.867318540403112*^9, 3.867318587389639*^9, {3.867318745730048*^9, 
   3.867318768732285*^9}, {3.8673190402541323`*^9, 3.8673190430285473`*^9}, 
   3.867320551081403*^9, 3.867320836721364*^9, 3.867321166441128*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"81c90c77-dabf-4976-a01f-8955facf44c8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"referencek", "=", "2"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "fit", " ", "with", " ", "average", " ", "shifts", " ", "s", " ", "and", 
    " ", "obtain", " ", "a", " ", "list", " ", "of", " ", "k", " ", "for", 
    " ", "each", " ", "volume", " ", "n"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fitsk", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hist1", "=", 
         RowBox[{"histograms", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"hist2", "=", 
             RowBox[{"hist1", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"k", "/.", 
            RowBox[{
             RowBox[{"NonlinearModelFit", "[", 
              RowBox[{
               RowBox[{"Select", "[", 
                RowBox[{"hist2", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ">", 
                   RowBox[{"0.2", " ", 
                    RowBox[{"Max", "[", 
                    RowBox[{"hist2", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}]}], 
                  "&"}]}], "]"}], ",", 
               RowBox[{"k", " ", 
                RowBox[{
                 RowBox[{"intpfunsref", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"k", " ", 
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{"s", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
                  RowBox[{"s", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"k", ",", "referencek"}], "}"}], "}"}], ",", "x"}], 
              "]"}], "[", "\"\<BestFitParameters\>\"", "]"}]}]}], "]"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Length", "[", 
            RowBox[{"histograms", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "histograms", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kn", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"volumes", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "/", "referencevolume"}], ",", 
         RowBox[{
          RowBox[{"fitsk", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "[", 
          RowBox[{"volumes", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "volumes", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8121030882471323`*^9, 3.812103122769206*^9}, {
  3.812103285353072*^9, 3.812103291922182*^9}, {3.8121114722239523`*^9, 
  3.812111531190876*^9}, {3.867318518475347*^9, 3.867318537326589*^9}, {
  3.867318760479026*^9, 3.867318776507703*^9}, {3.867319051855937*^9, 
  3.86731905335245*^9}, {3.867319785525237*^9, 3.867319815102098*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"1703cb29-6cf1-4b01-bd03-33c7aeb367e3"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.8673197936383247`*^9},ExpressionUUID->"c214a0e8-4abf-443f-89b2-\
ea0c1e3ca669"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Rough", " ", 
    SubscriptBox["d", "H"], " ", "behaviour", " ", 
    RowBox[{"w", ".", "r", ".", "t"}], " ", "the", " ", "volume", " ", 
    "ratio", " ", "for", " ", "each", " ", "sample"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dims", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k1", "=", 
           RowBox[{"fitsk", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"k2", "=", 
               RowBox[{"k1", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Log", "[", 
                RowBox[{"2", ",", 
                 RowBox[{
                  RowBox[{"volumes", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
               FractionBox[
                RowBox[{"Log", "[", 
                 RowBox[{"referencevolume", "/", 
                  RowBox[{
                   RowBox[{"volumes", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{"[", "j", "]"}], "]"}]}], "]"}], 
                RowBox[{"Log", "[", "k2", "]"}]]}], "}"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"volumes", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "volumes", "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"dims", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["2", "x"], ",", 
        SubscriptBox["d", "H"]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"11", ",", "18"}], "]"}], ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
       "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8121035132399387`*^9, 3.812103525708997*^9}, {
   3.812103674231082*^9, 3.812103804411871*^9}, {3.812105475969843*^9, 
   3.8121054795787973`*^9}, {3.812105525068491*^9, 3.812105546331921*^9}, {
   3.8121055810232553`*^9, 3.812105581218354*^9}, {3.81210561768541*^9, 
   3.8121056376138077`*^9}, 3.812111112012024*^9, {3.8673191000789337`*^9, 
   3.8673191755682573`*^9}, {3.8673192246723127`*^9, 3.867319257106834*^9}, {
   3.8673193052116337`*^9, 3.8673193394298563`*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"d8324816-946b-489b-b962-7be51fb1b298"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.753449838496273}, {12., 4.754450411574153}, {13., 
         4.753234444783022}, {14., 4.761781176368598}, {15., 
         4.755327815114116}, {16., 4.757791245846421}, {17., 
         4.75432586921161}, {18., 4.770937670276252}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.715467009873206}, {12., 4.717097849544775}, {13., 
         4.721579025551485}, {14., 4.720196861602447}, {15., 
         4.723840263872828}, {16., 4.727988018966239}, {17., 
         4.739035626701914}, {18., 4.716751208301887}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.755562618955215}, {12., 4.7560774400196815`}, {13., 
         4.754837345092771}, {14., 4.759140880175726}, {15., 
         4.753315788375531}, {16., 4.760496113744712}, {17., 
         4.758179337540048}, {18., 4.745828254960727}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.778273867463593}, {12., 4.778961995260807}, {13., 
         4.7735911510128295`}, {14., 4.7761115681783695`}, {15., 
         4.7749023244586795`}, {16., 4.7665852303215654`}, {17., 
         4.767667222917156}, {18., 4.765947126621713}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.744697199633606}, {12., 4.746106121917646}, {13., 
         4.7442227390720655`}, {14., 4.74440543884434}, {15., 
         4.748133703947399}, {16., 4.739952003806481}, {17., 
         4.757077838222434}, {18., 4.729147288839014}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.718506103551344}, {12., 4.71921638886161}, {13., 
         4.7227837040329}, {14., 4.724391073359882}, {15., 
         4.7319457706565595`}, {16., 4.733941396422816}, {17., 
         4.729276768755273}, {18., 4.737476999809885}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.745578785246015}, {12., 4.746802876754572}, {13., 
         4.741691325730362}, {14., 4.74262329893222}, {15., 
         4.744676898004009}, {16., 4.753401409202931}, {17., 
         4.742482511328531}, {18., 4.737772272686956}}]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.732174478058896}, {12., 4.732301953444341}, {13., 
         4.733457459375443}, {14., 4.733743222506677}, {15., 
         4.7388817739197275`}, {16., 4.736868372718131}, {17., 
         4.737033426544133}, {18., 4.728071591898803}}]}}, {{
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox[
        SuperscriptBox["2", "x"], TraditionalForm], 
       FormBox[
        SubscriptBox["d", "H"], TraditionalForm]}, 
     AxesOrigin -> {10.854166666666668`, 4.711939510685006}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{10.854166666666668`, 18.}, {4.711939510685006, 
      4.778961995260807}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {{{11, 
         FormBox["11", TraditionalForm]}, {12, 
         FormBox["12", TraditionalForm]}, {13, 
         FormBox["13", TraditionalForm]}, {14, 
         FormBox["14", TraditionalForm]}, {15, 
         FormBox["15", TraditionalForm]}, {16, 
         FormBox["16", TraditionalForm]}, {17, 
         FormBox["17", TraditionalForm]}, {18, 
         FormBox["18", TraditionalForm]}}, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"a", "b", "c", "d", "e", "f", "g"}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.772079`", ",", "0.431554`", ",", "0.102387`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.24259866666666668`, 0.412334, 0.521566], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.363898`", ",", "0.618501`", ",", "0.782349`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.363898, 0.618501, 0.782349]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.363898, 0.618501, 0.782349], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.75, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0.5, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.75`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.75, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.75, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, 
               ",", #7}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "False", ",", "False", ",", "False", ",", "False", ",", 
                 "False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8673193137836113`*^9, 3.8673205551857758`*^9, 
  3.867320844448698*^9, 3.867321170282233*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"d27141ff-8da8-4d48-8d42-f75305b2f2f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["systematical error analysis", "Subsubsection",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.813405357347909*^9, 3.813405368139921*^9}, 
   3.814001000411968*^9, 
   3.814096640904847*^9},ExpressionUUID->"1642f197-58b0-4b03-a4c2-\
f8afba1c61b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"first", " ", "rough", " ", 
    SubscriptBox["d", "H"], " ", "estimate", " ", "according", " ", "to", " ",
     "the", " ", "previous", " ", "table"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dfit", "=", "4.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"fit", " ", "acoording", " ", "to", " ", "equation", " ", 
      RowBox[{"(", "45", ")"}], " ", "in", " ", "the", " ", "paper"}], ",", 
     " ", 
     RowBox[{"\[Delta]", " ", "\[Tilde]", 
      RowBox[{"1", "/", "dfit"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dc", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FindFit", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"kn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"-", "5"}], ";;"}], "]"}], "]"}], ",", 
           RowBox[{
            SuperscriptBox["x", 
             RowBox[{"-", 
              FractionBox["1", "d"]}]], 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               SuperscriptBox["x", 
                RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"d", ",", "dfit"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
             RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
       RowBox[{"(*", 
        RowBox[{
        "fitting", " ", "only", " ", "the", " ", "5", " ", "biggest", " ", 
         "volumes"}], "*)"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FindFit", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"kn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
           RowBox[{
            SuperscriptBox["x", 
             RowBox[{"-", 
              FractionBox["1", "d"]}]], 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               SuperscriptBox["x", 
                RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"d", ",", "dfit"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
             RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
       RowBox[{"(*", 
        RowBox[{
        "fitting", " ", "only", " ", "the", " ", "6", " ", "biggest", " ", 
         "volumes"}], "*)"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FindFit", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"kn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"-", "7"}], ";;"}], "]"}], "]"}], ",", 
           RowBox[{
            SuperscriptBox["x", 
             RowBox[{"-", 
              FractionBox["1", "d"]}]], 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               SuperscriptBox["x", 
                RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"d", ",", "dfit"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
             RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
       RowBox[{"(*", 
        RowBox[{
        "fitting", " ", "only", " ", "the", " ", "7", " ", "biggest", " ", 
         "volumes"}], "*)"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FindFit", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"kn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"-", "8"}], ";;"}], "]"}], "]"}], ",", 
           RowBox[{
            SuperscriptBox["x", 
             RowBox[{"-", 
              FractionBox["1", "d"]}]], 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               SuperscriptBox["x", 
                RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"d", ",", "dfit"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
             RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}]}], 
      RowBox[{"(*", 
       RowBox[{"fitting", " ", "all", " ", "volumes"}], "*)"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "THIS", " ", "IS", " ", "THE", " ", "DATA", " ", "WE", " ", "USE"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"dimfit", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"d", "/.", 
       RowBox[{
        RowBox[{
         RowBox[{"dc", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"dc", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
   RowBox[{"(*", 
    RowBox[{"list", " ", "of", " ", 
     SubscriptBox["d", "H"], " ", "fitting", " ", "only", " ", "the", " ", 
     "6", " ", "biggest", " ", "volumes"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"errordc", "=", 
    RowBox[{"StandardDeviation", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"d", "/.", 
          RowBox[{
           RowBox[{
            RowBox[{"dc", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", 
            RowBox[{"dc", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "[", "dc", "]"}]}], "}"}]}], "]"}], "]"}], 
    RowBox[{"(*", 
     RowBox[{"standard", " ", "deviation", " ", 
      RowBox[{"w", ".", "r", ".", "t", ".", " ", "the"}], " ", "variation", 
      " ", "of", " ", "number", " ", "of", " ", "volumes", " ", "to", " ", 
      "fit"}], "*)"}]}]}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.812103926885001*^9, 3.8121039946761923`*^9}, {
   3.812105300714753*^9, 3.812105363226886*^9}, {3.8121112694713287`*^9, 
   3.812111317125071*^9}, {3.8121119409296503`*^9, 3.812111941464081*^9}, {
   3.812206223108333*^9, 3.812206229640663*^9}, {3.8122819936645527`*^9, 
   3.812281996152114*^9}, {3.8123588312603903`*^9, 3.8123588545473757`*^9}, {
   3.812359303329427*^9, 3.8123593047463303`*^9}, {3.812359512647485*^9, 
   3.812359514205587*^9}, {3.812360522400282*^9, 3.812360559141459*^9}, {
   3.812795556178874*^9, 3.812795556522043*^9}, {3.812795647815346*^9, 
   3.812795655800891*^9}, {3.812795964526335*^9, 3.8127959656173477`*^9}, {
   3.812796175691972*^9, 3.812796292795827*^9}, {3.812797474204486*^9, 
   3.812797479503508*^9}, {3.812797849933364*^9, 3.8127978548996*^9}, {
   3.8127986028296833`*^9, 3.8127986056524*^9}, {3.812799456173283*^9, 
   3.812799457166873*^9}, {3.812799701796918*^9, 3.812799711960773*^9}, {
   3.81332389299021*^9, 3.8133239224898233`*^9}, {3.8133244591174927`*^9, 
   3.813324524712453*^9}, {3.8133926651251802`*^9, 3.813392789676968*^9}, {
   3.8133933952745543`*^9, 3.8133933998022137`*^9}, {3.813393571627495*^9, 
   3.813393637151286*^9}, {3.813402864632832*^9, 3.813402865645093*^9}, 
   3.813405665606392*^9, {3.813405759657415*^9, 3.813405763693605*^9}, {
   3.813569115579999*^9, 3.813569121656625*^9}, {3.813570522850958*^9, 
   3.813570528674893*^9}, {3.813571248706854*^9, 3.813571249301935*^9}, {
   3.813998530331615*^9, 3.8139985424597*^9}, 3.814001000412601*^9, 
   3.814096640905293*^9, {3.814177222235881*^9, 3.814177290273889*^9}, {
   3.814177342429022*^9, 3.814177371728331*^9}, 3.814781091793857*^9, {
   3.86731961370909*^9, 3.867319747615457*^9}, {3.867319838874453*^9, 
   3.867319936973851*^9}, {3.867320252597207*^9, 3.867320284476557*^9}, {
   3.8673203423035583`*^9, 3.8673203443779182`*^9}, {3.867320491397812*^9, 
   3.8673205028411293`*^9}, {3.867320855462429*^9, 3.867320856785513*^9}, {
   3.8673211747654953`*^9, 3.867321176729473*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"c1aeaebd-a16e-41ce-9ac6-991908d0382b"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,180,71,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.812103929590205*^9, {3.812103965066885*^9, 3.812103995836873*^9}, 
   3.8121040625049553`*^9, {3.8121053502649403`*^9, 3.8121053639054623`*^9}, 
   3.812111124324623*^9, {3.812111287271562*^9, 3.8121113176910763`*^9}, 
   3.81211145192483*^9, 3.812111500122641*^9, 3.81211172769489*^9, 
   3.812111851901269*^9, {3.812111932274577*^9, 3.812111942804874*^9}, {
   3.8122062067690983`*^9, 3.8122062302819757`*^9}, 3.812281997430952*^9, {
   3.8123588328574467`*^9, 3.812358854955584*^9}, 3.8123593054576178`*^9, 
   3.812359471824277*^9, {3.812360524890835*^9, 3.8123605595671663`*^9}, 
   3.8123607193272753`*^9, 3.8127954773657303`*^9, {3.812795547680065*^9, 
   3.81279555697663*^9}, 3.812795657798877*^9, 3.812795966080802*^9, {
   3.8127962001191683`*^9, 3.8127962251064367`*^9}, 3.812796293338064*^9, {
   3.8127974675849457`*^9, 3.8127974800167522`*^9}, {3.812797850814516*^9, 
   3.8127978554320927`*^9}, 3.812798253275388*^9, 3.812798606264804*^9, 
   3.812799457730843*^9, {3.812799702661631*^9, 3.8127997125432653`*^9}, {
   3.813323894528167*^9, 3.8133239230273848`*^9}, {3.81332445450716*^9, 
   3.8133245252236357`*^9}, {3.813392743600672*^9, 3.813392790246841*^9}, 
   3.8133934002738113`*^9, {3.813393572077828*^9, 3.813393626027626*^9}, 
   3.813402866998049*^9, 3.813405667570114*^9, 3.813405764558012*^9, {
   3.813569113791806*^9, 3.813569122340904*^9}, 3.813570529225918*^9, 
   3.8135710906754417`*^9, 3.81357118470124*^9, 3.813571249961713*^9, {
   3.813998545516741*^9, 3.813998557349373*^9}, 3.814001000412736*^9, 
   3.8140966409055634`*^9, 3.8140967613499537`*^9, 3.8140970899902077`*^9, 
   3.814097135108499*^9, 3.814176057222219*^9, 3.8141771832530622`*^9, 
   3.814177272987707*^9, 3.8141773078836184`*^9, 3.8141773779531193`*^9, 
   3.814177825527256*^9, 3.81478104620068*^9, 3.814781092386746*^9, 
   3.81591269685174*^9, 3.8202281015155373`*^9, 3.8336091913117247`*^9, 
   3.8673197486527853`*^9, 3.867319820755382*^9, 3.8673199064634457`*^9, 
   3.867319938055821*^9, 3.867320503490046*^9, 3.867320565465063*^9, 
   3.8673208624408407`*^9, 3.8673211772849817`*^9},
 CellLabel->
  "During evaluation of \
In[179]:=",ExpressionUUID->"45910635-fbe5-4122-8793-e4d5712399ec"],

Cell[BoxData[
 TemplateBox[{
  "FindFit", "cvmit", 
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"", 2, 180, 72, 23618813676784072814, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.812103929590205*^9, {3.812103965066885*^9, 3.812103995836873*^9}, 
   3.8121040625049553`*^9, {3.8121053502649403`*^9, 3.8121053639054623`*^9}, 
   3.812111124324623*^9, {3.812111287271562*^9, 3.8121113176910763`*^9}, 
   3.81211145192483*^9, 3.812111500122641*^9, 3.81211172769489*^9, 
   3.812111851901269*^9, {3.812111932274577*^9, 3.812111942804874*^9}, {
   3.8122062067690983`*^9, 3.8122062302819757`*^9}, 3.812281997430952*^9, {
   3.8123588328574467`*^9, 3.812358854955584*^9}, 3.8123593054576178`*^9, 
   3.812359471824277*^9, {3.812360524890835*^9, 3.8123605595671663`*^9}, 
   3.8123607193272753`*^9, 3.8127954773657303`*^9, {3.812795547680065*^9, 
   3.81279555697663*^9}, 3.812795657798877*^9, 3.812795966080802*^9, {
   3.8127962001191683`*^9, 3.8127962251064367`*^9}, 3.812796293338064*^9, {
   3.8127974675849457`*^9, 3.8127974800167522`*^9}, {3.812797850814516*^9, 
   3.8127978554320927`*^9}, 3.812798253275388*^9, 3.812798606264804*^9, 
   3.812799457730843*^9, {3.812799702661631*^9, 3.8127997125432653`*^9}, {
   3.813323894528167*^9, 3.8133239230273848`*^9}, {3.81332445450716*^9, 
   3.8133245252236357`*^9}, {3.813392743600672*^9, 3.813392790246841*^9}, 
   3.8133934002738113`*^9, {3.813393572077828*^9, 3.813393626027626*^9}, 
   3.813402866998049*^9, 3.813405667570114*^9, 3.813405764558012*^9, {
   3.813569113791806*^9, 3.813569122340904*^9}, 3.813570529225918*^9, 
   3.8135710906754417`*^9, 3.81357118470124*^9, 3.813571249961713*^9, {
   3.813998545516741*^9, 3.813998557349373*^9}, 3.814001000412736*^9, 
   3.8140966409055634`*^9, 3.8140967613499537`*^9, 3.8140970899902077`*^9, 
   3.814097135108499*^9, 3.814176057222219*^9, 3.8141771832530622`*^9, 
   3.814177272987707*^9, 3.8141773078836184`*^9, 3.8141773779531193`*^9, 
   3.814177825527256*^9, 3.81478104620068*^9, 3.814781092386746*^9, 
   3.81591269685174*^9, 3.8202281015155373`*^9, 3.8336091913117247`*^9, 
   3.8673197486527853`*^9, 3.867319820755382*^9, 3.8673199064634457`*^9, 
   3.867319938055821*^9, 3.867320503490046*^9, 3.867320565465063*^9, 
   3.8673208624408407`*^9, 3.867321177298192*^9},
 CellLabel->
  "During evaluation of \
In[179]:=",ExpressionUUID->"c4f0c11c-a3d7-434a-a084-bb58f3377f72"],

Cell[BoxData[
 TemplateBox[{
  "FindFit", "cvmit", 
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"", 2, 180, 73, 23618813676784072814, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.812103929590205*^9, {3.812103965066885*^9, 3.812103995836873*^9}, 
   3.8121040625049553`*^9, {3.8121053502649403`*^9, 3.8121053639054623`*^9}, 
   3.812111124324623*^9, {3.812111287271562*^9, 3.8121113176910763`*^9}, 
   3.81211145192483*^9, 3.812111500122641*^9, 3.81211172769489*^9, 
   3.812111851901269*^9, {3.812111932274577*^9, 3.812111942804874*^9}, {
   3.8122062067690983`*^9, 3.8122062302819757`*^9}, 3.812281997430952*^9, {
   3.8123588328574467`*^9, 3.812358854955584*^9}, 3.8123593054576178`*^9, 
   3.812359471824277*^9, {3.812360524890835*^9, 3.8123605595671663`*^9}, 
   3.8123607193272753`*^9, 3.8127954773657303`*^9, {3.812795547680065*^9, 
   3.81279555697663*^9}, 3.812795657798877*^9, 3.812795966080802*^9, {
   3.8127962001191683`*^9, 3.8127962251064367`*^9}, 3.812796293338064*^9, {
   3.8127974675849457`*^9, 3.8127974800167522`*^9}, {3.812797850814516*^9, 
   3.8127978554320927`*^9}, 3.812798253275388*^9, 3.812798606264804*^9, 
   3.812799457730843*^9, {3.812799702661631*^9, 3.8127997125432653`*^9}, {
   3.813323894528167*^9, 3.8133239230273848`*^9}, {3.81332445450716*^9, 
   3.8133245252236357`*^9}, {3.813392743600672*^9, 3.813392790246841*^9}, 
   3.8133934002738113`*^9, {3.813393572077828*^9, 3.813393626027626*^9}, 
   3.813402866998049*^9, 3.813405667570114*^9, 3.813405764558012*^9, {
   3.813569113791806*^9, 3.813569122340904*^9}, 3.813570529225918*^9, 
   3.8135710906754417`*^9, 3.81357118470124*^9, 3.813571249961713*^9, {
   3.813998545516741*^9, 3.813998557349373*^9}, 3.814001000412736*^9, 
   3.8140966409055634`*^9, 3.8140967613499537`*^9, 3.8140970899902077`*^9, 
   3.814097135108499*^9, 3.814176057222219*^9, 3.8141771832530622`*^9, 
   3.814177272987707*^9, 3.8141773078836184`*^9, 3.8141773779531193`*^9, 
   3.814177825527256*^9, 3.81478104620068*^9, 3.814781092386746*^9, 
   3.81591269685174*^9, 3.8202281015155373`*^9, 3.8336091913117247`*^9, 
   3.8673197486527853`*^9, 3.867319820755382*^9, 3.8673199064634457`*^9, 
   3.867319938055821*^9, 3.867320503490046*^9, 3.867320565465063*^9, 
   3.8673208624408407`*^9, 3.86732117730643*^9},
 CellLabel->
  "During evaluation of \
In[179]:=",ExpressionUUID->"13da8371-f073-489e-be95-e8f091393a09"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"FindFit\\\", \
\\\"::\\\", \\\"cvmit\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 180, 74, 23618813676784072814, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.812103929590205*^9, {3.812103965066885*^9, 3.812103995836873*^9}, 
   3.8121040625049553`*^9, {3.8121053502649403`*^9, 3.8121053639054623`*^9}, 
   3.812111124324623*^9, {3.812111287271562*^9, 3.8121113176910763`*^9}, 
   3.81211145192483*^9, 3.812111500122641*^9, 3.81211172769489*^9, 
   3.812111851901269*^9, {3.812111932274577*^9, 3.812111942804874*^9}, {
   3.8122062067690983`*^9, 3.8122062302819757`*^9}, 3.812281997430952*^9, {
   3.8123588328574467`*^9, 3.812358854955584*^9}, 3.8123593054576178`*^9, 
   3.812359471824277*^9, {3.812360524890835*^9, 3.8123605595671663`*^9}, 
   3.8123607193272753`*^9, 3.8127954773657303`*^9, {3.812795547680065*^9, 
   3.81279555697663*^9}, 3.812795657798877*^9, 3.812795966080802*^9, {
   3.8127962001191683`*^9, 3.8127962251064367`*^9}, 3.812796293338064*^9, {
   3.8127974675849457`*^9, 3.8127974800167522`*^9}, {3.812797850814516*^9, 
   3.8127978554320927`*^9}, 3.812798253275388*^9, 3.812798606264804*^9, 
   3.812799457730843*^9, {3.812799702661631*^9, 3.8127997125432653`*^9}, {
   3.813323894528167*^9, 3.8133239230273848`*^9}, {3.81332445450716*^9, 
   3.8133245252236357`*^9}, {3.813392743600672*^9, 3.813392790246841*^9}, 
   3.8133934002738113`*^9, {3.813393572077828*^9, 3.813393626027626*^9}, 
   3.813402866998049*^9, 3.813405667570114*^9, 3.813405764558012*^9, {
   3.813569113791806*^9, 3.813569122340904*^9}, 3.813570529225918*^9, 
   3.8135710906754417`*^9, 3.81357118470124*^9, 3.813571249961713*^9, {
   3.813998545516741*^9, 3.813998557349373*^9}, 3.814001000412736*^9, 
   3.8140966409055634`*^9, 3.8140967613499537`*^9, 3.8140970899902077`*^9, 
   3.814097135108499*^9, 3.814176057222219*^9, 3.8141771832530622`*^9, 
   3.814177272987707*^9, 3.8141773078836184`*^9, 3.8141773779531193`*^9, 
   3.814177825527256*^9, 3.81478104620068*^9, 3.814781092386746*^9, 
   3.81591269685174*^9, 3.8202281015155373`*^9, 3.8336091913117247`*^9, 
   3.8673197486527853`*^9, 3.867319820755382*^9, 3.8673199064634457`*^9, 
   3.867319938055821*^9, 3.867320503490046*^9, 3.867320565465063*^9, 
   3.8673208624408407`*^9, 3.867321177313614*^9},
 CellLabel->
  "During evaluation of \
In[179]:=",ExpressionUUID->"181c58d7-1bb8-4b4b-885f-1910e72453f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.762724017352581`", ",", "4.801162315703667`", ",", "4.761582208930644`", 
   ",", "4.781385397679151`", ",", "4.813011105078474`", ",", 
   "4.894950765525675`", ",", "4.935623714725309`", ",", 
   "4.862219974558272`"}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.81210392960189*^9, {3.8121039650760813`*^9, 3.812103995850068*^9}, 
   3.812104062520833*^9, {3.812105350289813*^9, 3.812105363940044*^9}, 
   3.812111124365129*^9, {3.812111287313698*^9, 3.812111317711556*^9}, 
   3.812111451948617*^9, 3.8121115001470346`*^9, 3.812111727735121*^9, 
   3.812111851940835*^9, {3.812111932315754*^9, 3.812111942839595*^9}, {
   3.812206206809494*^9, 3.812206230319475*^9}, 3.8122819974698973`*^9, {
   3.812358832889287*^9, 3.812358854992714*^9}, 3.8123593054932117`*^9, 
   3.812359471848062*^9, {3.812360524909378*^9, 3.8123605596032763`*^9}, 
   3.812360719369061*^9, 3.812795477522538*^9, {3.8127955477215357`*^9, 
   3.812795557015812*^9}, 3.812795657840596*^9, 3.8127959661247463`*^9, {
   3.812796200163353*^9, 3.812796225140594*^9}, 3.81279629337646*^9, {
   3.8127974676265383`*^9, 3.812797480052169*^9}, {3.812797850853149*^9, 
   3.8127978554670067`*^9}, 3.812798253318223*^9, 3.812798606302885*^9, 
   3.8127994577711973`*^9, {3.81279970268878*^9, 3.812799712580134*^9}, {
   3.8133238945745573`*^9, 3.8133239230658607`*^9}, {3.813324454555119*^9, 
   3.813324525266521*^9}, {3.813392743816689*^9, 3.813392790329955*^9}, 
   3.813393400383966*^9, {3.813393572164805*^9, 3.8133936261031103`*^9}, 
   3.813402867146859*^9, 3.813405667653664*^9, 3.813405764644916*^9, {
   3.813569113883007*^9, 3.813569122423541*^9}, 3.813570529315637*^9, 
   3.81357109071414*^9, 3.8135711847425137`*^9, 3.813571250046237*^9, {
   3.813998545559272*^9, 3.8139985573872013`*^9}, 3.814001000413096*^9, 
   3.8140966409063463`*^9, 3.814096761387534*^9, 3.814097090083517*^9, 
   3.8140971351463747`*^9, 3.8141760572575817`*^9, 3.81417718333958*^9, 
   3.8141772730829163`*^9, 3.814177307964373*^9, 3.814177378034197*^9, 
   3.8141778256191587`*^9, 3.8147810463332853`*^9, 3.814781092537705*^9, 
   3.81591269704286*^9, 3.820228101700588*^9, 3.833609191460141*^9, 
   3.867319748635784*^9, 3.8673198209012623`*^9, 3.8673199066166363`*^9, 
   3.867319938200018*^9, 3.867320503649314*^9, 3.867320565625011*^9, 
   3.8673208625889378`*^9, 3.8673211774426327`*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"886e9bee-05c2-43ac-b07c-aa8aca80a3e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.02106938930218247`", ",", "0.11156764723546818`", ",", 
   "0.025128141605826777`", ",", "0.0734591083418157`", ",", 
   "0.06043826630456315`", ",", "0.06873887078385087`", ",", 
   "0.11776722210070319`", ",", "0.04848499996525822`"}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.81210392960189*^9, {3.8121039650760813`*^9, 3.812103995850068*^9}, 
   3.812104062520833*^9, {3.812105350289813*^9, 3.812105363940044*^9}, 
   3.812111124365129*^9, {3.812111287313698*^9, 3.812111317711556*^9}, 
   3.812111451948617*^9, 3.8121115001470346`*^9, 3.812111727735121*^9, 
   3.812111851940835*^9, {3.812111932315754*^9, 3.812111942839595*^9}, {
   3.812206206809494*^9, 3.812206230319475*^9}, 3.8122819974698973`*^9, {
   3.812358832889287*^9, 3.812358854992714*^9}, 3.8123593054932117`*^9, 
   3.812359471848062*^9, {3.812360524909378*^9, 3.8123605596032763`*^9}, 
   3.812360719369061*^9, 3.812795477522538*^9, {3.8127955477215357`*^9, 
   3.812795557015812*^9}, 3.812795657840596*^9, 3.8127959661247463`*^9, {
   3.812796200163353*^9, 3.812796225140594*^9}, 3.81279629337646*^9, {
   3.8127974676265383`*^9, 3.812797480052169*^9}, {3.812797850853149*^9, 
   3.8127978554670067`*^9}, 3.812798253318223*^9, 3.812798606302885*^9, 
   3.8127994577711973`*^9, {3.81279970268878*^9, 3.812799712580134*^9}, {
   3.8133238945745573`*^9, 3.8133239230658607`*^9}, {3.813324454555119*^9, 
   3.813324525266521*^9}, {3.813392743816689*^9, 3.813392790329955*^9}, 
   3.813393400383966*^9, {3.813393572164805*^9, 3.8133936261031103`*^9}, 
   3.813402867146859*^9, 3.813405667653664*^9, 3.813405764644916*^9, {
   3.813569113883007*^9, 3.813569122423541*^9}, 3.813570529315637*^9, 
   3.81357109071414*^9, 3.8135711847425137`*^9, 3.813571250046237*^9, {
   3.813998545559272*^9, 3.8139985573872013`*^9}, 3.814001000413096*^9, 
   3.8140966409063463`*^9, 3.814096761387534*^9, 3.814097090083517*^9, 
   3.8140971351463747`*^9, 3.8141760572575817`*^9, 3.81417718333958*^9, 
   3.8141772730829163`*^9, 3.814177307964373*^9, 3.814177378034197*^9, 
   3.8141778256191587`*^9, 3.8147810463332853`*^9, 3.814781092537705*^9, 
   3.81591269704286*^9, 3.820228101700588*^9, 3.833609191460141*^9, 
   3.867319748635784*^9, 3.8673198209012623`*^9, 3.8673199066166363`*^9, 
   3.867319938200018*^9, 3.867320503649314*^9, 3.867320565625011*^9, 
   3.8673208625889378`*^9, 3.867321177444214*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"a56e70ae-e62d-455e-9c1b-d6f9421e2d8d"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "5"}], "}"}], 
   RowBox[{"(*", 
    RowBox[{
    "visualize", " ", "a", " ", "batch", " ", "of", " ", "10000", " ", 
     "samples"}], "*)"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"table", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["x", "d"]}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "\[Delta]"}], " ", "x"}], "]"}]}]}], "]"}], "+", 
          FractionBox["x", "dfit"]}], "/.", 
         RowBox[{
          RowBox[{"dc", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"Length", "[", "dc", "]"}]}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"table", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"Log", "[", 
           FractionBox["1", "256"], "]"}], ",", 
          RowBox[{"Log", "[", 
           FractionBox["1", "2"], "]"}]}], "}"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", 
           RowBox[{"-", "6"}], ",", 
           RowBox[{"-", "7"}], ",", 
           RowBox[{"-", "8"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"ListLogLogPlot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], 
              RowBox[{"1", "/", "dfit"}]]}]}], "}"}], "&"}], "/@", 
         RowBox[{"kn", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<(\!\(\*FractionBox[\(n\), \(n0\)]\))\>\"", ",", 
         "\"\<\[LeftAngleBracket]r\[RightAngleBracket] (\!\(\*FractionBox[\(n\
\), \(n0\)]\)\!\(\*SuperscriptBox[\()\), \(1/d\)]\)\>\""}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"-", 
           RowBox[{"Range", "[", 
            RowBox[{"1", ",", "8"}], "]"}]}]], ",", "Automatic"}], "}"}]}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.813403079824582*^9, 3.813403116907382*^9}, {
   3.8134032320143833`*^9, 3.813403379865623*^9}, {3.8134034576012707`*^9, 
   3.813403461840353*^9}, {3.813403496258937*^9, 3.813403530503923*^9}, {
   3.813403821000741*^9, 3.813403898131549*^9}, {3.8134039557179832`*^9, 
   3.8134039910444107`*^9}, {3.8134040741898613`*^9, 3.813404081353929*^9}, {
   3.8134041160935717`*^9, 3.813404126895303*^9}, {3.813404237413735*^9, 
   3.813404292812155*^9}, {3.813404323068637*^9, 3.813404323933943*^9}, {
   3.813404355351511*^9, 3.813404380476624*^9}, {3.813404415806086*^9, 
   3.813404427752576*^9}, {3.813404469202096*^9, 3.8134046326753607`*^9}, {
   3.813405291595302*^9, 3.813405320578026*^9}, {3.813405461270893*^9, 
   3.813405480334784*^9}, {3.813405697931694*^9, 3.813405815945381*^9}, {
   3.813405851056218*^9, 3.813405861984654*^9}, {3.813569261936655*^9, 
   3.8135692772196693`*^9}, {3.813570431638982*^9, 3.81357050186056*^9}, {
   3.813570548907691*^9, 3.813570566130917*^9}, {3.813571306902583*^9, 
   3.813571307027145*^9}, {3.813998560752989*^9, 3.813998575293128*^9}, 
   3.814001000413576*^9, 3.814096640906661*^9, {3.814176127444868*^9, 
   3.814176127555702*^9}, {3.814176179766695*^9, 3.814176185529461*^9}, {
   3.8141772076356373`*^9, 3.81417720827801*^9}, {3.814781051571899*^9, 
   3.8147810519445963`*^9}, {3.8159127107462063`*^9, 3.815912711323896*^9}, {
   3.867319941857482*^9, 3.867319956028816*^9}, {3.8673200919093027`*^9, 
   3.867320098524456*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"d9b78150-5743-428d-8601-369d7611b549"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsDM6yai3syOP8ZPQd+8
LBbARm7spRbKjj+ykC3GNisWwJj83cZOx44/iBIGlCooFsDm5kJgv8GOPzQW
ty8SIhbAPqMD8aG2jj+OHRln4RUWwGw53olsoI4/QSzd1X/9FcD+POSUF3SO
P6dJZbO8zBXAntad78Qbjj8IemlnAmMVwHhfqU/SXY0/ERGqvkkAFcBgLcBN
YK6MP7uTudWAnxTA1b5NiigEjD/7C73lgzYUwG/6IaKATYs/4ur8mIjUE8Dr
j13d5KSKP16/MEVZahPApRw0DC/wiT98fzOxGQITwP2k+gDMQIk/QaZywNug
EsBLDIi7/56IP5zCpchpNxLA6cchq4Hxhz+eRRV0+dQRwPPO8C5eUYc/QbRT
33h0EcCYun8NFbaGP3oYhkPECxHANGs4SX4Phj9a4/RKEaoQwDrkpq7SdYU/
0KNXSypAEMCvPnq8K9GEP8+fEhdmsA/AkWKvi3YxhD9Nxe7deu4OwBgjVUM8
noM/9tWyliccDsDTPd1GagCDP+6z75XXVw3AsCw4odlugj8RfRSHH4MMwAEC
ibEB04E/dh3X90ayC8CM/OdJ5juBPyqLEq9x7wrA3C1fVJ6wgD8J5DVYNBwK
wO/3QGdwG4A/NwrSR/pWCcCGiuIbuyN/P6gHDLeflQjASkDN8CwZfj9E8C0Y
3cMHwJIrBMqN+3w/LqbIvx0AB8AqYuw+VPR7P0NHS1n2KwbAFlMzVaPaej+b
v2tyrlsFwK4x/061yXk/QgUF0mmZBMB7XC3aWs54PxQ2hiO9xgPAByR06kLB
dz80NIC7EwIDwO1QO9FSyXY/lwkY00lBAsDYCdgWTtl1PyXKl9wXcAHA5csU
ZT7YdD8CWJAs6awAwENztUuP63M/FKLh3KSy/7+kbYXpZ+5yP8EulO19J/6/
zRJJozcFcj/0aYL9FaT8v0/2smyVI3E/fXtA8d3/+r+NbCNMKTJwP6Mn8HGs
d/m/1ltKguKnbj8fqm/Wqs73v3oLRij9zGw/IdsqOmgt9r/ugp8+hAFrP8Cm
1yosqPS/Yu3EyupaaT+1SFT/HwLzv9okQKs2l2c/SIXCYBp48b94t8+PmPdl
P8Dg2IKn6++/l47b5NNlZD+dY8wLeqXsv2HlzlVBuGI/tBujrlmX6b/2Y85t
UC1hP5AduVS1iem/MHzW1nkmYT9rH8/6EHzpv6VK5rCjH2E/IiP7Rshg6b8U
WhK4+BFhP48qU982Kum/yiFREqj2YD9qOQMQFL3ovyHfEPQbwGA/IFdjcc7i
579+GthZWFNgP/xYeRcq1ee//BGm3o9MYD/XWo+9hcfnv0kHJtTHRWA/jl67
CT2s57+AQTEROThgP/tlE6Krdee/ygcq0yAdYD/WdMPSiAjnv2qfm+gKzl8/
snbZeOT65r+quPUFiMBfP4147x5A7ea/bEFeBAazXz9EfBtr99HmvzxIRaQE
mF8/soNzA2ab5r/EctVvDGJfP46FianBjea/9G8NlZBUXz9ph59PHYDmvzIc
KZsVR18/IIvLm9Rk5r/iMfZJIixfP/uM4UEwV+a/MOmc8qkeXz/Wjvfni0nm
vzr3EXwyEV8/spANjuc75r+uAlDmuwNfP42SIzRDLua/KrZRMUb2Xj/KwVnP

           "]]}, Annotation[#, "Charting`Private`Tag$55727#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsDo0M+ypDeNP8ZPQd+8
LBbALJ61Xj01jT+ykC3GNisWwHTlghzWMo0/iBIGlCooFsCvN9LNBy6NPzQW
ty8SIhbALkk4B2wkjT+OHRln4RUWwAcUxdQ3EY0/QSzd1X/9FcCEUvnX3OqM
P6dJZbO8zBXA6PSTZ1yejD8IemlnAmMVwJhOlyhx+Ys/ERGqvkkAFcAcRNwU
oGCLP7uTudWAnxTAe4VpUubLij/7C73lgzYUwIKWOAnJK4o/4ur8mIjUE8AX
W/nhfZeJP16/MEVZahPATs4YVAP4iD98fzOxGQITwOJ2jRauXIg/QaZywNug
EsBvno+X4syHP5zCpchpNxLApyj5iyYyhz+eRRV0+dQRwKEFMhnPooY/QbRT
33h0EcAs1FOlUheGP3oYhkPECxHAryr45CGBhT9a4/RKEaoQwK/t+k4R9oQ/
0KNXSypAEMBGUIDwfWCEP8+fEhdmsA/ARM5N3NLOgz9Nxe7deu4OwFq8dC4D
SIM/9tWyliccDsB2DGts7LaCP+6z75XXVw3AiNatx40wgj8RfRSHH4MMwH8i
ikAYoIE/dh3X90ayC8BK9radaROBPyqLEq9x7wrA3cq1DDCRgD8J5DVYNBwK
wHlJIbAZBYA/NwrSR/pWCcDeAXj5qwZ/P6gHDLeflQjAfYqhrSgKfj9E8C0Y
3cMHwHcfxiVb+nw/LqbIvx0AB8DQM0Q3tP57P0NHS1n2KwbAcOGCkR7wej+b
v2tyrlsFwBrNN3al6Hk/QgUF0mmZBMASFAul0/R4PxQ2hiO9xgPA+6Kga4Hu
dz80NIC7EwIDwKkzXieV+3Y/lwkY00lBAsCFmQK5Qg92PyXKl9wXcAHALWCN
mtkQdT8CWJAs6awAwCqlfiVeJXQ/FKLh3KSy/7+OfA3jIihzP8EulO19J/6/
nKkPkJU9cj/0aYL9FaT8v8W9IKBoWXE/fXtA8d3/+r9Lbq7G4mNwP6Mn8HGs
d/m/GtBrHSsBbz8fqm/Wqs73v7wN/vqHGG0/IdsqOmgt9r/oOdaJ0jxrP8Cm
1yosqPS/N1QGuKKEaT+1SFT/HwLzv6qMEPs1q2c/SIXCYBp48b9B3Q3u1fRl
P8Dg2IKn6++/eZ2in3FKZD+dY8wLeqXsvyXenK2Tf2I/tBujrlmX6b8v5P7R
49ZgP5AduVS1iem/StyWI4PPYD9rH8/6EHzpv7E+BrgiyGA/IiP7Rshg6b/s
FGSpYrlgP48qU982Kum/Ae7preWbYD9qOQMQFL3ov40vjTz4YGA/IFdjcc7i
57/iwFfHntZfP/xYeRcq1ee/gsdyGe7HXz/XWo+9hcfnv5IoyvA9uV8/jl67
CT2s5786px8v35tfP/tlE6Krdee/a6kB6idhXz/WdMPSiAjnv4UVglXS614/
snbZeOT65r9GM7b5Kd1eP4147x5A7ea/wpDtIoLOXj9EfBtr99Hmvzu+VwQ0
sV4/soNzA2ab5r9fALYCnnZeP46FianBjea/di2gzvlnXj9ph59PHYDmvw4Q
cR9WWV4/IIvLm9Rk5r8HvLhPEDxeP/uM4UEwV+a/fGAoL24tXj/Wjvfni0nm
v5p8cJPMHl4/spANjuc75r/Uf418KxBeP42SIzRDLua/mdl76ooBXj9MOVeT

           "]]}, Annotation[#, "Charting`Private`Tag$55727#2"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwV1nk0VV0bAHCRuUx3H0JRKUqUIhXVTiSSlJLMmUmEzEPGe4+KktKElKmk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           "]]}, 
         Annotation[#, "Charting`Private`Tag$55727#3"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwVlnk01fkbx7kSUo1r31tUIgwlVMMjW0yLGZJk+t57iVw0ZZe5Ych6bSmh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           "]]}, 
         Annotation[#, "Charting`Private`Tag$55727#4"]& ]}}, {}}, {{}, {{{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         PointBox[{{-5.545177444479562, 
          0.013465200741716312`}, {-4.852030263919617, 
          0.011478476635122694`}, {-4.1588830833596715`, 
          0.010186560917857471`}, {-3.4657359027997265`, 
          0.008460669671941836}, {-2.772588722239781, 
          0.006309668021960483}, {-2.0794415416798357`, 
          0.005488201571765226}, {-1.3862943611198906`, 
          0.00260588681674582}, {-0.6931471805599453, 
          0.002163504767029606}}]}}, {{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]]}, {}}, {{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]]}, {}}}, {{}, {}}}}, {AxesLabel -> {
       FormBox[
       "\"(\\!\\(\\*FractionBox[\\(n\\), \\(n0\\)]\\))\"", TraditionalForm], 
       FormBox[
       "\"\[LeftAngleBracket]r\[RightAngleBracket] (\\!\\(\\*FractionBox[\\(n\
\\), \\(n0\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(1/d\\)]\\)\"", 
        TraditionalForm]}, Ticks -> {{{
         NCache[
          Rational[1, 2], 0.5], 
         FormBox[
          FractionBox["1", "2"], TraditionalForm]}, {
         NCache[
          Rational[1, 4], 0.25], 
         FormBox[
          FractionBox["1", "4"], TraditionalForm]}, {
         NCache[
          Rational[1, 8], 0.125], 
         FormBox[
          FractionBox["1", "8"], TraditionalForm]}, {
         NCache[
          Rational[1, 16], 0.0625], 
         FormBox[
          FractionBox["1", "16"], TraditionalForm]}, {
         NCache[
          Rational[1, 32], 0.03125], 
         FormBox[
          FractionBox["1", "32"], TraditionalForm]}, {
         NCache[
          Rational[1, 64], 0.015625], 
         FormBox[
          FractionBox["1", "64"], TraditionalForm]}, {
         NCache[
          Rational[1, 128], 0.0078125], 
         FormBox[
          FractionBox["1", "128"], TraditionalForm]}, {
         NCache[
          Rational[1, 256], 0.00390625], 
         FormBox[
          FractionBox["1", "256"], TraditionalForm]}}, Automatic}, 
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {-5.545177444479562, 0.0015849110912399254`}, 
     FrameTicks -> {{Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-5.545177444479562, 0.0015849110912399254`}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> 
     NCache[{{-Log[256], -Log[2]}, {0.0015849110912399254`, 
        0.015039195369231616`}}, {{-5.545177444479562, -0.6931471805599453}, {
       0.0015849110912399254`, 0.015039195369231616`}}], PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{"-", "5"}], 
       RowBox[{"-", "6"}], 
       RowBox[{"-", "7"}], 
       RowBox[{"-", "8"}]}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.813403119275064*^9, {3.813403239554159*^9, 3.813403303392666*^9}, {
   3.813403361924633*^9, 3.8134033809494143`*^9}, 3.813403463182539*^9, 
   3.813403499908786*^9, 3.813403531319541*^9, {3.813403822234193*^9, 
   3.813403833741747*^9}, 3.813403899965954*^9, 3.813403993071478*^9, {
   3.81340406051154*^9, 3.813404082075097*^9}, {3.813404118524254*^9, 
   3.813404127852963*^9}, {3.8134044107115297`*^9, 3.813404428496372*^9}, {
   3.8134044766068163`*^9, 3.813404491554731*^9}, {3.813404523977553*^9, 
   3.8134045446826887`*^9}, {3.813404612387587*^9, 3.813404633434305*^9}, 
   3.813405292688744*^9, 3.813405323029873*^9, {3.813405462141695*^9, 
   3.813405481044531*^9}, 3.8134056869687023`*^9, {3.813405735786654*^9, 
   3.813405744325964*^9}, {3.813405775108506*^9, 3.813405816586175*^9}, {
   3.813405851949738*^9, 3.813405862606451*^9}, 3.8135691385369787`*^9, {
   3.813569262642037*^9, 3.8135692777909927`*^9}, {3.813570432417272*^9, 
   3.8135705024576273`*^9}, {3.8135705413810463`*^9, 3.813570566879197*^9}, 
   3.813571307811542*^9, {3.813998567416362*^9, 3.813998576127549*^9}, 
   3.814001000413848*^9, 3.814096640906872*^9, 3.814096764672286*^9, 
   3.814097044689657*^9, 3.814097092211051*^9, 3.8140971373472*^9, 
   3.814176060880052*^9, 3.8141761282390013`*^9, {3.814176180657058*^9, 
   3.814176186446772*^9}, {3.814177196967437*^9, 3.814177208910205*^9}, 
   3.8141778300244217`*^9, 3.814781052523596*^9, 3.8147810984509907`*^9, 
   3.815912711901566*^9, 3.82022810544142*^9, 3.833609200541052*^9, 
   3.8673198289498787`*^9, {3.867319940174906*^9, 3.8673199457671833`*^9}, 
   3.867320506389535*^9, 3.867320573343577*^9, 3.867320864882802*^9, 
   3.867321180132497*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"6aaaa642-c796-4cd8-bab6-9db59087c5b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ddelta", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", "dfit"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.1"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "fitting", " ", "with", " ", "reference", " ", "value", " ", 
        "\[Delta]"}], "=", "0.1"}], "*)"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", "dfit"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.2"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "fitting", " ", "with", " ", "reference", " ", "value", " ", 
        "\[Delta]"}], "=", "0.2"}], "*)"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", "dfit"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "fitting", " ", "with", " ", "reference", " ", "value", " ", 
        "\[Delta]"}], "=", "0.3"}], "*)"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", "dfit"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.4"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}]}], 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "fitting", " ", "with", " ", "reference", " ", "value", " ", 
       "\[Delta]"}], "=", "0.4"}], "*)"}], "}"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.8134053978283253`*^9, 3.81340544001481*^9}, {
   3.8134056042985477`*^9, 3.813405604641135*^9}, {3.813405929991736*^9, 
   3.813405935161028*^9}, {3.813569170563765*^9, 3.813569175663199*^9}, {
   3.8139985832286587`*^9, 3.81399859803612*^9}, 3.814001000414246*^9, 
   3.814096640906999*^9, {3.867319980396708*^9, 3.867320023547666*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"0013fd79-592e-4027-ba0a-64f09882d31f"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,184,75,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813571323233376*^9, 3.813571350156508*^9}, 
   3.8139985997085133`*^9, 3.8140010004144297`*^9, 3.8140966409071302`*^9, 
   3.814096778612632*^9, 3.814097070933708*^9, 3.814097142035982*^9, 
   3.814176094675062*^9, 3.814177834193144*^9, 3.81478106577074*^9, 
   3.814781101039961*^9, 3.815912713816667*^9, 3.820228107242363*^9, 
   3.83360920294831*^9, {3.86732001975583*^9, 3.867320023944413*^9}, 
   3.867320508657222*^9, 3.867320575149544*^9, 3.867320866749197*^9, 
   3.867321183230977*^9},
 CellLabel->
  "During evaluation of \
In[184]:=",ExpressionUUID->"45ee7b2e-21a3-42b8-b4c7-dae3f0869556"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,184,76,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813571323233376*^9, 3.813571350156508*^9}, 
   3.8139985997085133`*^9, 3.8140010004144297`*^9, 3.8140966409071302`*^9, 
   3.814096778612632*^9, 3.814097070933708*^9, 3.814097142035982*^9, 
   3.814176094675062*^9, 3.814177834193144*^9, 3.81478106577074*^9, 
   3.814781101039961*^9, 3.815912713816667*^9, 3.820228107242363*^9, 
   3.83360920294831*^9, {3.86732001975583*^9, 3.867320023944413*^9}, 
   3.867320508657222*^9, 3.867320575149544*^9, 3.867320866749197*^9, 
   3.867321183243005*^9},
 CellLabel->
  "During evaluation of \
In[184]:=",ExpressionUUID->"248f103b-8443-4b09-ae7d-2301a4250719"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,184,77,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813571323233376*^9, 3.813571350156508*^9}, 
   3.8139985997085133`*^9, 3.8140010004144297`*^9, 3.8140966409071302`*^9, 
   3.814096778612632*^9, 3.814097070933708*^9, 3.814097142035982*^9, 
   3.814176094675062*^9, 3.814177834193144*^9, 3.81478106577074*^9, 
   3.814781101039961*^9, 3.815912713816667*^9, 3.820228107242363*^9, 
   3.83360920294831*^9, {3.86732001975583*^9, 3.867320023944413*^9}, 
   3.867320508657222*^9, 3.867320575149544*^9, 3.867320866749197*^9, 
   3.8673211832514467`*^9},
 CellLabel->
  "During evaluation of \
In[184]:=",ExpressionUUID->"0b3b14ef-41dc-49ba-a315-fa0d1001f5c0"],

Cell[BoxData[
 TemplateBox[{
  "General","stop",
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"FindFit\\\", \
\\\"::\\\", \\\"cvmit\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"",2,184,78,23618813676784072814,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813571323233376*^9, 3.813571350156508*^9}, 
   3.8139985997085133`*^9, 3.8140010004144297`*^9, 3.8140966409071302`*^9, 
   3.814096778612632*^9, 3.814097070933708*^9, 3.814097142035982*^9, 
   3.814176094675062*^9, 3.814177834193144*^9, 3.81478106577074*^9, 
   3.814781101039961*^9, 3.815912713816667*^9, 3.820228107242363*^9, 
   3.83360920294831*^9, {3.86732001975583*^9, 3.867320023944413*^9}, 
   3.867320508657222*^9, 3.867320575149544*^9, 3.867320866749197*^9, 
   3.86732118326*^9},
 CellLabel->
  "During evaluation of \
In[184]:=",ExpressionUUID->"97bff93c-3d0f-4828-946e-59b9b29381d4"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "8"}], "}"}], 
   RowBox[{"(*", 
    RowBox[{
    "visualize", " ", "a", " ", "batch", " ", "of", " ", "10000", " ", 
     "samples"}], "*)"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"table", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["x", "d"]}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "\[Delta]"}], " ", "x"}], "]"}]}]}], "]"}], "+", 
          FractionBox["x", "dfit"]}], "/.", 
         RowBox[{
          RowBox[{"ddelta", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"Length", "[", "ddelta", "]"}]}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"table", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"Log", "[", 
           FractionBox["1", "256"], "]"}], ",", 
          RowBox[{"Log", "[", 
           FractionBox["1", "2"], "]"}]}], "}"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", "0.2", ",", "0.3", ",", "0.4"}], "}"}]}]}], 
       "]"}], ",", 
      RowBox[{"ListLogLogPlot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], 
              RowBox[{"1", "/", "dfit"}]]}]}], "}"}], "&"}], "/@", 
         RowBox[{"kn", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<(\!\(\*FractionBox[\(n\), \(n0\)]\))\>\"", ",", 
         "\"\<\[LeftAngleBracket]r\[RightAngleBracket] (\!\(\*FractionBox[\(n\
\), \(n0\)]\)\!\(\*SuperscriptBox[\()\), \(1/d\)]\)\>\""}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"-", 
           RowBox[{"Range", "[", 
            RowBox[{"1", ",", "8"}], "]"}]}]], ",", "Automatic"}], "}"}]}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.813405500912602*^9, 3.813405575973257*^9}, {
   3.8134056339043417`*^9, 3.813405642259263*^9}, {3.813405903656139*^9, 
   3.81340594790552*^9}, {3.813406006677416*^9, 3.813406042941147*^9}, {
   3.8135693056897717`*^9, 3.813569315046632*^9}, {3.81357074461902*^9, 
   3.813570744740912*^9}, {3.8139986089963017`*^9, 3.8139986166228333`*^9}, 
   3.814001000415709*^9, 3.814096640907593*^9, {3.8141761021005*^9, 
   3.814176102251587*^9}, {3.814176209236497*^9, 3.814176209421084*^9}, {
   3.814177848110643*^9, 3.814177848297019*^9}, {3.814781107213888*^9, 
   3.814781107503304*^9}, {3.815912716614749*^9, 3.815912721028452*^9}, 
   3.867320107898615*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"7df2f5b2-63f4-4dce-a6b3-188bc00d2d0b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwVlHs01HkYxsdIbpEZM4SGKe1yxiWnFdVu5x2UkrWd1WWoDmMm2UklrTSu
/SKhYcxIbKw1pdyiXLpsRd+vajWVzbpXsgY1Y2xR1pJLa3/7x3ve8znv+7zP
89e7QhAVGE6lUCgBZP3f+0x3ffJ2tcCKIPvy8QdyaNnuNdDobIFVGy98ONQs
h3qZS4uHkwUmbIZ9RpEcMuiL8ziOFpi/e1L/baMc3C1ur6avtMB4xHJx3y05
SFlWEYNMch7X+EpZJQcv5/7uk5+ZWKH1GbmaK4dyv/CGxlYmpvQUV+UI5GAQ
L4qgCpmYG3NY9XhWBjRa1X0/ChMTtqcXSQplcO/cnW6ihIH5AVPKjm9kMGfc
9DbVg0H6VVqi6zkwNDr/U0aXOSaKeZzqSSmEILfNwQdJzl3rdthJCoknv6qz
opJ8LlQbGpENXmXHcJ+Cjik6OhMDdVnw84MrSpEnHfMLl6TnjUngl83MmJku
GuYyIaphvQS8buwYEMfQMI46YnU/8yzELzvj88iY5Je1vJDWTNgzPLmNVmWG
8RxWs1mZ8Ecpz5/DNcMq31WrnvAzoK2Ebnmgdikm0qc7MyrTIeC3sf74MVPM
7RmX2VLSYaq7Pt9huSlW7WmSUbedgbGG8fO9PBOs8JcU519MA1oSI90udQlW
jK549Pu70xDL6p32rTfGijUto0s3ngaOhH49etwIqyKt4+sKU8Hwzdog9+Uk
3+jS7n+XAp5GHVtmdxti7nXb/O3+KVChv+R2yXkDzHYsmJi8dgo2fXBZ1v9Q
H6uS4aiN/ilwLVMiFkUf88V6KV8eIsBni3/wlNNiTDj1MlhZJ6EIRR67tlcP
419r8lr8ksFbT69DdGERJkw4bmfZScDwOGPf1KKLsXtd9PRgAri7E/fMqbqY
2OyU69AYDwWGyzr9vKhY8TThbkpJHHzxtOC15VEdrNjk6CE+IgZqkMxZW03B
OKTTM2nXCWBcGnx9uX4BEXvD1g07xkKza977JId/ERG79vK8+XGYFKV8Zl6e
R6rkmkAbgxhISuB+7F+YRdxn9wsvaI9BqcOH6OoTM4jY9+hPk6FosKuK6ql6
Po3YnwIHGpRHYUUfZ8MPLlMIl387dCk6CnBZL8e5YhIRca9G1iUfhptbdy7Y
Uf9G7C0BzbtFkbA17QHfWvwR8VuXyvQJEWDVi5Tyv8YRW3Cn3bIiAoqFrcbx
V94h7j+z3/XUhsMNm9JrwQVaRKz0Hc8aFoKMdWfnzUwtUtjekp7rE0KkXdus
WaIWqWpetBV2CmGl/Zyvkk/yyPeeVx8KIYezY8CDQ+6v6yvqLBXCwfW6Zoym
EaRKTG723i8ENk8Y/XxIg/j9qLbwrQDmg+IsOd0axD3ok3ezXwC9e3Ka0h5r
EEWzz7q9WwDSkHuGG6s1SLX6iKlRiwDmws0vXT2uQUR2e35qmQB6Yh52ZBho
ELvkhev5CAHUx74Uv5lVI0olHe6GCiBbPG7Lfa9GuGnnxABPAJsSbSKn29VI
cdHE22UruZ/6o+6BIjXiB1qntzmSfmmZlc3ZasR9sq92hi0AUXrJdhahRuwT
qsRVVgJgS54Vde0n9TTlQoIhmSdr0MuNR+oDNtyq0CHzSKc1Ej81IoKNzHpm
wsh/ZCLVfE36h4LJookwyM61d/dxJe9nqGrWjIbBf5iYZKY=
           "]]}, 
         Annotation[#, "Charting`Private`Tag$56223#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsBgVIVxq+mRP8ZPQd+8
LBbAW3vZGBbokT+ykC3GNisWwGffMM+A5pE/iBIGlCooFsCLguhoVuORPzQW
ty8SIhbAAzh1UALdkT+OHRln4RUWwHht1O9c0JE/QSzd1X/9FcBafSpuHbeR
P6dJZbO8zBXAFC46XcuEkT8IemlnAmMVwD9DwHt9GJE/ERGqvkkAFcBGIKr2
WbSQP7uTudWAnxTATdpEoxlTkD/7C73lgzYUwKyIF4dF1Y8/4ur8mIjUE8BC
JhNHNhSPP16/MEVZahPA6tkdtxRFjj98fzOxGQITwOZRUAPWe40/QaZywNug
EsDQpaUf/sGMP5zCpchpNxLAVDTUtYL6iz+eRRV0+dQRwBRv8s8wQos/QbRT
33h0EcCKRjIoR4+KP3oYhkPECxHA4qcu2iTPiT9a4/RKEaoQwLjnQJy5HYk/
0KNXSypAEMD2Vj+FbV+IP8+fEhdmsA/ANN0kJaWmhz9Nxe7deu4OwMqjO/of
/IY/9tWyliccDsCIQSsXJUWGP+6z75XXVw3A6rzBEzKchT8RfRSHH4MMwBao
ccsf54Q/dh3X90ayC8CWN5PoXDeEPyqLEq9x7wrAOp3UpC+Vgz8J5DVYNBwK
wFxaAI1M54I/NwrSR/pWCcBDDFSOxEaCP6gHDLeflQjAbwOf4xargT9E8C0Y
3cMHwLyZJBYZBIE/LqbIvx0AB8Bvdz8tCWqAP0NHS1n2KwbA1H1kWvmJfz+b
v2tyrlsFwKDyG/PISX4/QgUF0mmZBMDgKJ1TlyJ9PxQ2hiO9xgPAejCPSDjm
ez80NIC7EwIDwJ5rztFmwno/lwkY00lBAsCAEfyBm6d5PyXKl9wXcAHAkpDV
QWd4eD8CWJAs6awAwHgWuWjtYHc/FKLh3KSy/78qwRULrDV2P8EulO19J/6/
VkPLcLUhdT/0aYL9FaT8v1aMdxZmFnQ/fXtA8d3/+r9mf0qUEPhyP6Mn8HGs
d/m/NimAojXwcT8fqm/Wqs73v4eqlGTz1XA/IdsqOmgt9r+E+kHyEolvP8Cm
1yosqPS/Dq8ICo+RbT+1SFT/HwLzv1Dfk8e/dms/SIXCYBp48b8yjRKvaIZp
P8Dg2IKn6++/tH2nnBKmZz+dY8wLeqXsv0QKm4Tmo2U/tBujrlmX6b/Fz6lM
oMpjP5AduVS1iem/WnznR23CYz9rH8/6EHzpv+GuBMA6umM/IiP7Rshg6b+3
8tQm16ljP48qU982Kum/YQ+QzhWJYz9qOQMQFL3ov1CFiYSqR2M/IFdjcc7i
578JIVJ7McViP/xYeRcq1ee//DJKDg69Yj/XWo+9hcfnvww+3B3rtGI/jl67
CT2s57+Ai8WypqRiP/tlE6Krdee/lzpwsyOEYj/WdMPSiAjnv5NyPw41Q2I/
snbZeOT65r8Xb9JpGTtiP4147x5A7ea/WabcQf4yYj9EfBtr99Hmv5kVTmfJ
ImI/soNzA2ab5r9/LWiHZQJiP46FianBjea/0DZ4xk36YT9ph59PHYDmv3Ue
7oE28mE/IIvLm9Rk5r+C1wJuCeJhP/uM4UEwV+a/LVGdnvPZYT/Wjvfni0nm
v6f7lEve0WE/spANjuc75r/zqud0yclhP42SIzRDLua//zCTGrXBYT/8BFTA

           "]]}, Annotation[#, "Charting`Private`Tag$56223#2"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwVlH04E3gcwLVV5qWysVF5qXbd7hnJPS2e6nq+FimV63nSee1t26Hx9IS8
zPti5n02CeU6d/KWRImc4n4/r7kSJbMueUTdZmVWx0MxnPvj83z++fz92cq9
eCKAoKen57HC/x5e/9OXA/Y0vJ2rP7lXK4Pu4+zRFjsaLiAWTZZqZFAv3dHt
aEvDxuEzOsNJGaRT1uYzv6PhXQEbPIYnZMCiNe2kbKPh8/zO6vhxGUisNgaN
UWl4ZPuYf7tcBmy7EXnSIhWzRIV5vi0yqHQPuN/SS8VP7mZDU4YMSLH8IAKP
isUsdXmXpQzI5Oo/3fVWeoJKSv1DCo+uNMuFJWa4gdWS7OUlhQWj1n9SHM3w
C4tbmzpf58L4B11R+qApfllzo3/UIhfOIIeDvsGm+HpzTZHmsATik3bd20gw
xZs862LmEnOAXRGOh3+j4G/3V9wTd2bDL+3lPXwnCq6pcD4p0GXBrwepEV8H
yTj7jguh1iUL2A2eo4IIMm53WGaclmZCrIXYpdOIjO0fJspe92eA37uZI+Rq
E7y1csyTbp0Bz296H2U6m2D/C5FzeWfTob+EYh54dwPWaEVv8ivSwKNraiR2
aj3OhsarEwtimJXXFzAs12MLhp1Pn6sYpu5rryq812EUFXrtcXEqkBPM0mxS
jDF1OvfsLaUIoqwUc271RpjofNr/naMImFmUujCtIU5sO0V4mJ8CBu93+7As
DbFb3KkHY8pkcDIcODTvZYC7da3WfLdkqNI3biq5SsLmfqHdfdWXwfXTDouR
Dn1cZ93YryZeBvuKHmSlp48fKJ5MTfOF4HLoqO+s7Vo8lF6PjTKToBiFhNf6
r8FRQ37jG48kwoE1awb411bjuMRnQjo9AcwcxfTWbiLOKzhGWq2KAxZL+MiU
QMRfDF62hXTEQqGBxUt3NgG/KkswlVfFwPYnhW/MQ1dh+yacNhgjAIKP1E5d
o4erWpYCRdxoMCsde1NWv4xIuQaZQU5R0Gafr0lgLKFMsdYvgx4JM/zkRWqZ
DjVr7ESHLCIgIc7588jyPFJ8eh4//TUcbjI+hdVEf0XT5e4M43/DwKb64lB1
3xwSpf/w8bYiFLYOM/ee3zGLHNV8wTfZFwFXKJh2VTOod/GYjp5/ARoPn1y2
IUyj3ef8CGWCEDic2n5uk+AzGrhjRE9M4wN++yq58qMWNbiZ1O2qCIIbvF6j
2PJJxH76PelZaQA0bL5Z61uoRgvnC3wdenggtWo+2ZihRi/ImZOziAchNv3z
JvFq5JKU8KW1iQfb6AtuPefUiFXmHedRyYNcpueoI1ON5KRUu3AxD4L3EE3M
WieQ6yJ974ArD7Z488L6xlVIV3RJM9nGBZ1PjDlTrkLBtbnX25u5oPDLbU19
rEKRsqO46B4XJGceGeyvUSFGZ0Gk2+9cWAgwLb0dqUIxREZapZALQxEdA+kk
FSrzkLoIgQv1UX8L3s8rEUXLjjntxIUcgdbaWaNEPtE8xr6dXHCN3xwy90KJ
NMc+TM5Zr/Qpl4iBxUr048H7ltFLHJCkZtxqy1Gi3mAp1WeWA/y0kuNWQiWa
kHSJ90xxYEvW0+LBn5Vo1aDtwOIIBxayx9gO3kp0QudV81bOgSHJnCrLXYnm
bfuWOp5xVn60TqLap0TJgZK/Krs4kJNHZ7nYK1HYnXzj7FYO/AeAT2yO
           "]]}, 
         Annotation[#, "Charting`Private`Tag$56223#3"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsBkfwkFwPaRP8ZPQd+8
LBbAsbp/XiT1kT+ykC3GNisWwFDu3ciI85E/iBIGlCooFsAYO1DQUfCRPzQW
ty8SIhbAI1X+qeTpkT+OHRln4RUWwIbnD4gN3ZE/QSzd1X/9FcDqD4Tra8OR
P6dJZbO8zBXA+nmXM1uQkT8IemlnAmMVwFkKOsuIIpE/ERGqvkkAFcBQ9kko
GL2QP7uTudWAnxTAYm9256takD/7C73lgzYUwJ71In4Y4o8/4ur8mIjUE8BW
Ku2NEh+PP16/MEVZahPA3CVBeQVOjj98fzOxGQITwDgegHoXg40/QaZywNug
EsCMVzPA2MeMP5zCpchpNxLA4oAZJgX/iz+eRRV0+dQRwBKK4teZRYs/QbRT
33h0EcA8oaSfv5GKP3oYhkPECxHAQp2Ehb3QiT9a4/RKEaoQwOhA7TyiHok/
0KNXSypAEMA8TGysuF+IP8+fEhdmsA/Awt4YD3Wmhz9Nxe7deu4OwO5qNtmW
+4Y/9tWyliccDsBlFDBeVUSGP+6z75XXVw3AfiyeyzabhT8RfRSHH4MMwAbe
5FsL5oQ/dh3X90ayC8BUkH7LQzaEPyqLEq9x7wrAgB0hCCKUgz8J5DVYNBwK
wLx69Ypa5oI/NwrSR/pWCcDtdvSO+EWCP6gHDLeflQjAAiLgzHmqgT9E8C0Y
3cMHwGreE6u3A4E/LqbIvx0AB8BAmazR5WmAP0NHS1n2KwbAqHLX6UKKfz+b
v2tyrlsFwOJlCOGlSn4/QgUF0mmZBMDuWeUt/yN9PxQ2hiO9xgPAQr95eTTo
ez80NIC7EwIDwIqt/rznxHo/lwkY00lBAsCGTuzblap5PyXKl9wXcAHAXGgg
A9h7eD8CWJAs6awAwEB6FLq8ZHc/FKLh3KSy/7/Hw+nHzDl2P8EulO19J/6/
GGwG/QomdT/0aYL9FaT8v65wxX7WGnQ/fXtA8d3/+r9oGQ7CfvxyP6Mn8HGs
d/m/BMd7E4H0cT8fqm/Wqs73v+vUnAby2XA/IdsqOmgt9r8aBY8GI5BvP8Cm
1yosqPS/qyT4dW6XbT+1SFT/HwLzv207/Svzems/SIXCYBp48b9sAAaeqohp
P8Dg2IKn6++/8v+UfwumZz+dY8wLeqXsv11yLmfxoGU/tBujrlmX6b/KLxdl
fcRjP5AduVS1iem/+NMwLDu8Yz9rH8/6EHzpv9ICKWf5s2M/IiP7Rshg6b8e
46Q4d6NjP48qU982Kum/sr1ZSXiCYz9qOQMQFL3ov6Q6MR6QQGM/IFdjcc7i
579+5Wh5Fr1iP/xYeRcq1ee/nS6GtOK0Yj/XWo+9hcfnv8c0AWOvrGI/jl67
CT2s57/2bAAaSpxiP/tlE6Krdee/YRez74R7Yj/WdMPSiAjnvyBHZjYQOmI/
snbZeOT65r/rvn2l4zFiP4147x5A7ea/cL2yh7cpYj9EfBtr99Hmv3RSZaVg
GWI/soNzA2ab5r/AjHxFuPhhP46FianBjea/6BYQTY/wYT9ph59PHYDmv0Ya
ocdm6GE/IIvLm9Rk5r8EjasVF9hhP/uM4UEwV+a/d/sc6e/PYT/Wjvfni0nm
v0rfey/Jx2E/spANjuc75r/mOMToor9hP42SIzRDLua/rgjyFH23YT+JuF9n

           "]]}, 
         Annotation[#, "Charting`Private`Tag$56223#4"]& ]}}, {}}, {{}, {{{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         PointBox[{{-5.545177444479562, 
          0.016557951501810504`}, {-4.852030263919617, 
          0.014460588011560626`}, {-4.1588830833596715`, 
          0.012180254818243605`}, {-3.4657359027997265`, 
          0.010106012733514056`}, {-2.772588722239781, 
          0.007449705104397428}, {-2.0794415416798357`, 
          0.005773792146439544}, {-1.3862943611198906`, 
          0.0038389975091344757`}, {-0.6931471805599453, 
          0.0021968511328406067`}}]}}, {{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]]}, {}}, {{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]]}, {}}}, {{}, {}}}}, {AxesLabel -> {
       FormBox[
       "\"(\\!\\(\\*FractionBox[\\(n\\), \\(n0\\)]\\))\"", TraditionalForm], 
       FormBox[
       "\"\[LeftAngleBracket]r\[RightAngleBracket] (\\!\\(\\*FractionBox[\\(n\
\\), \\(n0\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(1/d\\)]\\)\"", 
        TraditionalForm]}, Ticks -> {{{
         NCache[
          Rational[1, 2], 0.5], 
         FormBox[
          FractionBox["1", "2"], TraditionalForm]}, {
         NCache[
          Rational[1, 4], 0.25], 
         FormBox[
          FractionBox["1", "4"], TraditionalForm]}, {
         NCache[
          Rational[1, 8], 0.125], 
         FormBox[
          FractionBox["1", "8"], TraditionalForm]}, {
         NCache[
          Rational[1, 16], 0.0625], 
         FormBox[
          FractionBox["1", "16"], TraditionalForm]}, {
         NCache[
          Rational[1, 32], 0.03125], 
         FormBox[
          FractionBox["1", "32"], TraditionalForm]}, {
         NCache[
          Rational[1, 64], 0.015625], 
         FormBox[
          FractionBox["1", "64"], TraditionalForm]}, {
         NCache[
          Rational[1, 128], 0.0078125], 
         FormBox[
          FractionBox["1", "128"], TraditionalForm]}, {
         NCache[
          Rational[1, 256], 0.00390625], 
         FormBox[
          FractionBox["1", "256"], TraditionalForm]}}, Automatic}, 
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {-5.545177444479562, 0.0021626894954929953`}, 
     FrameTicks -> {{Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-5.545177444479562, 0.0021626894954929953`}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> 
     NCache[{{-Log[256], -Log[2]}, {0.0021626894954929953`, 
        0.017542839343490782`}}, {{-5.545177444479562, -0.6931471805599453}, {
       0.0021626894954929953`, 0.017542839343490782`}}], PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"0.1`", "0.2`", "0.3`", "0.4`"}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.813405525635022*^9, 3.813405576638364*^9}, 
   3.813405918435788*^9, 3.813405948603415*^9, {3.813406007479032*^9, 
   3.813406044093932*^9}, 3.813569184542095*^9, {3.81356930644629*^9, 
   3.813569315703718*^9}, 3.813570506740679*^9, 3.813570608300452*^9, 
   3.813570745374921*^9, 3.813571353366034*^9, 3.813998617430208*^9, 
   3.81400100041765*^9, 3.814096640907679*^9, 3.81409678255687*^9, 
   3.814097074724373*^9, 3.81409714455905*^9, 3.8141761028680277`*^9, 
   3.814176210004849*^9, {3.814177838722213*^9, 3.814177849005414*^9}, {
   3.8147811043250237`*^9, 3.8147811080291986`*^9}, {3.815912717773716*^9, 
   3.815912721526745*^9}, 3.820228110385454*^9, 3.8336092060889874`*^9, 
   3.8673205113090687`*^9, 3.8673205771569443`*^9, 3.867320869291494*^9, 
   3.8673211851293583`*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"1ac87bc5-d0a6-4e7d-bbc6-be2e75546815"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", 
             RowBox[{"dfit", "-", "0.05"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"fitting", " ", "with", " ", "reference", " ", "value", " ", 
        SubscriptBox["d", "H"]}], "=", 
       RowBox[{"dfit", "-", "0.05"}]}], "*)"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", "dfit"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"fitting", " ", "with", " ", "reference", " ", "value", " ", 
        SubscriptBox["d", "H"]}], "=", "dfit"}], "*)"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", 
             RowBox[{"dfit", "+", "0.05"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}], 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"fitting", " ", "with", " ", "reference", " ", "value", " ", 
        SubscriptBox["d", "H"]}], "=", 
       RowBox[{"dfit", "+", "0.05"}]}], "*)"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FindFit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"kn", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "6"}], ";;"}], "]"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["x", 
           RowBox[{"-", 
            FractionBox["1", "d"]}]], 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"-", "\[Delta]"}]]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"d", ",", 
             RowBox[{"dfit", "+", "0.1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.3"}], "}"}], ",", "a", ",", 
           RowBox[{"{", "b", "}"}]}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "kn", "]"}]}], "}"}]}], "]"}]}], 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"fitting", " ", "with", " ", "reference", " ", "value", " ", 
       SubscriptBox["d", "H"]}], "=", 
      RowBox[{"dfit", "+", "0.1"}]}], "*)"}], "}"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.8134053978283253`*^9, 3.81340544001481*^9}, {
   3.8134056042985477`*^9, 3.813405604641135*^9}, {3.813405929991736*^9, 
   3.813405935161028*^9}, {3.813569170563765*^9, 3.813569175663199*^9}, {
   3.813570637059455*^9, 3.813570670878484*^9}, {3.813998642054158*^9, 
   3.8139986629014072`*^9}, {3.8139987195459757`*^9, 3.813998724202684*^9}, 
   3.81400100041817*^9, 3.814096640907756*^9, {3.8140968249770603`*^9, 
   3.814096853854968*^9}, {3.814097125213233*^9, 3.814097127857232*^9}, {
   3.867320032920134*^9, 3.86732007957753*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"2889b2f0-1c84-4253-9c0e-c8d467af6f36"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,186,79,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813570666822879*^9, 3.813570671580351*^9}, 
   3.813571366619813*^9, 3.8139986668681297`*^9, 3.813998804713266*^9, 
   3.814001000418419*^9, 3.814096640907857*^9, 3.814096789933507*^9, 
   3.814096854610551*^9, 3.8140971070310097`*^9, 3.814097162932887*^9, 
   3.814176212928619*^9, 3.814177857226816*^9, 3.814781110471366*^9, 
   3.815912723502242*^9, 3.820228112123652*^9, 3.8336092084864483`*^9, 
   3.8673200800221043`*^9, 3.867320513022152*^9, 3.867320578841979*^9, 
   3.867320871080924*^9, 3.8673211868752127`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8fd7224d-201b-4cba-bf45-dae4e05b33b6"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,186,80,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813570666822879*^9, 3.813570671580351*^9}, 
   3.813571366619813*^9, 3.8139986668681297`*^9, 3.813998804713266*^9, 
   3.814001000418419*^9, 3.814096640907857*^9, 3.814096789933507*^9, 
   3.814096854610551*^9, 3.8140971070310097`*^9, 3.814097162932887*^9, 
   3.814176212928619*^9, 3.814177857226816*^9, 3.814781110471366*^9, 
   3.815912723502242*^9, 3.820228112123652*^9, 3.8336092084864483`*^9, 
   3.8673200800221043`*^9, 3.867320513022152*^9, 3.867320578841979*^9, 
   3.867320871080924*^9, 3.867321186889061*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8a8a6382-8d7f-41b9-be39-73f05de95d20"],

Cell[BoxData[
 TemplateBox[{
  "FindFit","cvmit",
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"",2,186,81,23618813676784072814,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813570666822879*^9, 3.813570671580351*^9}, 
   3.813571366619813*^9, 3.8139986668681297`*^9, 3.813998804713266*^9, 
   3.814001000418419*^9, 3.814096640907857*^9, 3.814096789933507*^9, 
   3.814096854610551*^9, 3.8140971070310097`*^9, 3.814097162932887*^9, 
   3.814176212928619*^9, 3.814177857226816*^9, 3.814781110471366*^9, 
   3.815912723502242*^9, 3.820228112123652*^9, 3.8336092084864483`*^9, 
   3.8673200800221043`*^9, 3.867320513022152*^9, 3.867320578841979*^9, 
   3.867320871080924*^9, 3.8673211868975363`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7ae527bd-c0ca-4b8e-a427-27bd0046e696"],

Cell[BoxData[
 TemplateBox[{
  "General","stop",
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"FindFit\\\", \
\\\"::\\\", \\\"cvmit\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"",2,186,82,23618813676784072814,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.81340542296342*^9, 3.8134054408113327`*^9}, 
   3.813405605494657*^9, 3.8134059356989737`*^9, 3.813569176742115*^9, 
   3.813570603441284*^9, {3.813570666822879*^9, 3.813570671580351*^9}, 
   3.813571366619813*^9, 3.8139986668681297`*^9, 3.813998804713266*^9, 
   3.814001000418419*^9, 3.814096640907857*^9, 3.814096789933507*^9, 
   3.814096854610551*^9, 3.8140971070310097`*^9, 3.814097162932887*^9, 
   3.814176212928619*^9, 3.814177857226816*^9, 3.814781110471366*^9, 
   3.815912723502242*^9, 3.820228112123652*^9, 3.8336092084864483`*^9, 
   3.8673200800221043`*^9, 3.867320513022152*^9, 3.867320578841979*^9, 
   3.867320871080924*^9, 3.86732118690598*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1449b36a-98c9-4f70-a4d4-326765fc3ea0"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "8"}], "}"}], 
   RowBox[{"(*", 
    RowBox[{
    "visualize", " ", "a", " ", "batch", " ", "of", " ", "10000", " ", 
     "samples"}], "*)"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"table", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["x", "d"]}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "\[Delta]"}], " ", "x"}], "]"}]}]}], "]"}], "+", 
          FractionBox["x", "dfit"]}], "/.", 
         RowBox[{
          RowBox[{"dd", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"Length", "[", "dd", "]"}]}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"table", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"Log", "[", 
           FractionBox["1", "256"], "]"}], ",", 
          RowBox[{"Log", "[", 
           FractionBox["1", "2"], "]"}]}], "}"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"dfit", "-", "0.05"}], ",", "dfit", ",", 
           RowBox[{"dfit", "+", "0.05"}], ",", 
           RowBox[{"dfit", "+", "0.1"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"ListLogLogPlot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], 
              RowBox[{"1", "/", "dfit"}]]}]}], "}"}], "&"}], "/@", 
         RowBox[{"kn", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<(\!\(\*FractionBox[\(n\), \(n0\)]\))\>\"", ",", 
         "\"\<\[LeftAngleBracket]r\[RightAngleBracket] (\!\(\*FractionBox[\(n\
\), \(n0\)]\)\!\(\*SuperscriptBox[\()\), \(1/d\)]\)\>\""}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"-", 
           RowBox[{"Range", "[", 
            RowBox[{"1", ",", "8"}], "]"}]}]], ",", "Automatic"}], "}"}]}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.813405500912602*^9, 3.813405575973257*^9}, {
   3.8134056339043417`*^9, 3.813405642259263*^9}, {3.813405903656139*^9, 
   3.81340594790552*^9}, {3.813406006677416*^9, 3.813406042941147*^9}, {
   3.8135693056897717`*^9, 3.813569315046632*^9}, {3.8135706803824263`*^9, 
   3.8135707239077787`*^9}, {3.813571385600316*^9, 3.813571385668406*^9}, {
   3.813998671182419*^9, 3.8139987391314774`*^9}, 3.8140010004198303`*^9, 
   3.81409664090837*^9, {3.814096862457157*^9, 3.814096874675353*^9}, {
   3.8141778777375307`*^9, 3.8141778781857357`*^9}, {3.8147811143152447`*^9, 
   3.814781114717011*^9}, {3.815912726612975*^9, 3.815912726944165*^9}, {
   3.867320111561308*^9, 3.8673201172191257`*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"b85bb17e-c3b2-4470-8c3c-ee70797ee6ab"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsAopG8+TO+RP8ZPQd+8
LBbAjRKvMLTtkT+ykC3GNisWwPbxvjIc7JE/iBIGlCooFsCrsE5m7OiRPzQW
ty8SIhbA/N4ki43ikT+OHRln4RUWwLqaYcvS1ZE/QSzd1X/9FcD5sskjabyR
P6dJZbO8zBXAb8LBIcWJkT8IemlnAmMVwD2djB7QHJE/ERGqvkkAFcB87JEi
HbiQP7uTudWAnxTA/ohWfVtWkD/7C73lgzYUwBHRWv3I2o8/4ur8mIjUE8Dj
Ixh04BiPP16/MEVZahPAEst9JupIjj98fzOxGQITwOeDg4Hwfo0/QaZywNug
EsBEVZTafMSMP5zCpchpNxLA5f1Izmv8iz+eRRV0+dQRwJLKvFyfQ4s/QbRT
33h0EcBk1/7DTJCKP3oYhkPECxHAQAUWpMjPiT9a4/RKEaoQwAR5g0cQHok/
0KNXSypAEMCA430Ff1+IP8+fEhdmsA/AeHysVYCmhz9Nxe7deu4OwC4pI8PT
+4Y/9tWyliccDsAKGbxyuUSGP+6z75XXVw3A8Buv2LKbhT8RfRSHH4MMwIE/
DfyU5oQ/dh3X90ayC8BZqtyDzzaEPyqLEq9x7wrAQTjE06aUgz8J5DVYNBwK
wJNJR2PP5oI/NwrSR/pWCcAIveC1V0aCP6gHDLeflQjAQgUYWr6qgT9E8C0Y
3cMHwEkx8InaA4E/LqbIvx0AB8DMDaXK5WmAP0NHS1n2KwbAcWL6AfKJfz+b
v2tyrlsFwB8GGK0CSn4/QgUF0mmZBMBoFreqDiN9PxQ2hiO9xgPAQsdvvPHm
ez80NIC7EwIDwK8aUsRbw3o/lwkY00lBAsAJUexAx6h5PyXKl9wXcAHAdNqc
68h5eD8CWJAs6awAwGUvZbF6Ync/FKLh3KSy/7/ih8msXzd2P8EulO19J/6/
2FZ/+oIjdT/0aYL9FaT8vzCVuFhCGHQ/fXtA8d3/+r+uccdP7/lyP6Mn8HGs
d/m//k/ckwjycT8fqm/Wqs73v6Ey85mo13A/IdsqOmgt9r+xnd56HYxvP8Cm
1yosqPS/3iX01BuUbT+1SFT/HwLzv0eg+p6ZeGs/SIXCYBp48b8k7lawcIdp
P8Dg2IKn6++/2jaTRCKmZz+dY8wLeqXsv+R6dCq2omU/tBujrlmX6b+IwjtE
E8hjP5AduVS1iem/QtnbuNm/Yz9rH8/6EHzpv2HTZKagt2M/IiP7Rshg6b/Z
WyXsL6djP48qU982Kum/4zQMIlSGYz9qOQMQFL3ov5yfzDSzRGM/IFdjcc7i
578Czvjgy8FiP/xYeRcq1ee/KjDcbKG5Yj/XWo+9hcfnv03rR3F3sWI/jl67
CT2s578eWKzjJKFiP/tlE6Krdee/NLhUboWAYj/WdMPSiAjnv3LwgBhdP2I/
snbZeOT65r9kU4ArOjdiP4147x5A7ea/2t/XthcvYj9EfBtr99Hmv7ZpgzbU
HmI/soNzA2ab5r8o/XfZUv5hP46FianBjea/hGbkrjP2YT9ph59PHYDmv+Dm
kPwU7mE/IIvLm9Rk5r9dJZ4A2d1hP/uM4UEwV+a/xN/4trvVYT/Wjvfni0nm
v7aph+WezWE/spANjuc75r8yg0eMgsVhP42SIzRDLua/Mmg1q2a9YT+lT2x4

           "]]}, Annotation[#, "Charting`Private`Tag$56719#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwVlH04E3gcwLVV5qWysVF5qXbd7hnJPS2e6nq+FimV63nSee1t26Hx9IS8
zPti5n02CeU6d/KWRImc4n4/r7kSJbMueUTdZmVWx0MxnPvj83z++fz92cq9
eCKAoKen57HC/x5e/9OXA/Y0vJ2rP7lXK4Pu4+zRFjsaLiAWTZZqZFAv3dHt
aEvDxuEzOsNJGaRT1uYzv6PhXQEbPIYnZMCiNe2kbKPh8/zO6vhxGUisNgaN
UWl4ZPuYf7tcBmy7EXnSIhWzRIV5vi0yqHQPuN/SS8VP7mZDU4YMSLH8IAKP
isUsdXmXpQzI5Oo/3fVWeoJKSv1DCo+uNMuFJWa4gdWS7OUlhQWj1n9SHM3w
C4tbmzpf58L4B11R+qApfllzo3/UIhfOIIeDvsGm+HpzTZHmsATik3bd20gw
xZs862LmEnOAXRGOh3+j4G/3V9wTd2bDL+3lPXwnCq6pcD4p0GXBrwepEV8H
yTj7jguh1iUL2A2eo4IIMm53WGaclmZCrIXYpdOIjO0fJspe92eA37uZI+Rq
E7y1csyTbp0Bz296H2U6m2D/C5FzeWfTob+EYh54dwPWaEVv8ivSwKNraiR2
aj3OhsarEwtimJXXFzAs12MLhp1Pn6sYpu5rryq812EUFXrtcXEqkBPM0mxS
jDF1OvfsLaUIoqwUc271RpjofNr/naMImFmUujCtIU5sO0V4mJ8CBu93+7As
DbFb3KkHY8pkcDIcODTvZYC7da3WfLdkqNI3biq5SsLmfqHdfdWXwfXTDouR
Dn1cZ93YryZeBvuKHmSlp48fKJ5MTfOF4HLoqO+s7Vo8lF6PjTKToBiFhNf6
r8FRQ37jG48kwoE1awb411bjuMRnQjo9AcwcxfTWbiLOKzhGWq2KAxZL+MiU
QMRfDF62hXTEQqGBxUt3NgG/KkswlVfFwPYnhW/MQ1dh+yacNhgjAIKP1E5d
o4erWpYCRdxoMCsde1NWv4xIuQaZQU5R0Gafr0lgLKFMsdYvgx4JM/zkRWqZ
DjVr7ESHLCIgIc7588jyPFJ8eh4//TUcbjI+hdVEf0XT5e4M43/DwKb64lB1
3xwSpf/w8bYiFLYOM/ee3zGLHNV8wTfZFwFXKJh2VTOod/GYjp5/ARoPn1y2
IUyj3ef8CGWCEDic2n5uk+AzGrhjRE9M4wN++yq58qMWNbiZ1O2qCIIbvF6j
2PJJxH76PelZaQA0bL5Z61uoRgvnC3wdenggtWo+2ZihRi/ImZOziAchNv3z
JvFq5JKU8KW1iQfb6AtuPefUiFXmHedRyYNcpueoI1ON5KRUu3AxD4L3EE3M
WieQ6yJ974ArD7Z488L6xlVIV3RJM9nGBZ1PjDlTrkLBtbnX25u5oPDLbU19
rEKRsqO46B4XJGceGeyvUSFGZ0Gk2+9cWAgwLb0dqUIxREZapZALQxEdA+kk
FSrzkLoIgQv1UX8L3s8rEUXLjjntxIUcgdbaWaNEPtE8xr6dXHCN3xwy90KJ
NMc+TM5Zr/Qpl4iBxUr048H7ltFLHJCkZtxqy1Gi3mAp1WeWA/y0kuNWQiWa
kHSJ90xxYEvW0+LBn5Vo1aDtwOIIBxayx9gO3kp0QudV81bOgSHJnCrLXYnm
bfuWOp5xVn60TqLap0TJgZK/Krs4kJNHZ7nYK1HYnXzj7FYO/AeAT2yO
           "]]}, 
         Annotation[#, "Charting`Private`Tag$56719#2"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsCcHzT1P++RP8ZPQd+8
LBbAzqhJ4KftkT+ykC3GNisWwMOOMtsP7JE/iBIGlCooFsD7G30A4OiRPzQW
ty8SIhbAYODrCIHikT+OHRln4RUWwKVH5RDG1ZE/QSzd1X/9FcC/hfH6W7yR
P6dJZbO8zBXAUL/DJLeJkT8IemlnAmMVwOQn33vAHJE/ERGqvkkAFcCDKdUj
DLiQP7uTudWAnxTA1xxgUklWkD/7C73lgzYUwA5t4XOi2o8/4ur8mIjUE8Cf
zV4ruBiPP16/MEVZahPAn9GzSsBIjj98fzOxGQITwHx1dmjFfo0/QaZywNug
EsBH6//bUMSMP5zCpchpNxLAe2ZQGz/8iz+eRRV0+dQRwNUvGD5yQ4s/QbRT
33h0EcBJUmZxH5CKP3oYhkPECxHA9ZR4UZvPiT9a4/RKEaoQwBZbXSbjHYk/
0KNXSypAEMBLJyBMUl+IP8+fEhdmsA/A448qMVSmhz9Nxe7deu4OwI0uD1Co
+4Y/9tWyliccDsCH7J7mjkSGP+6z75XXVw3AMzYKRYmbhT8RfRSHH4MMwFo5
2pVs5oQ/dh3X90ayC8A5/JJiqDaEPyqLEq9x7wrApQZA+ICUgz8J5DVYNBwK
wLMLO/6q5oI/NwrSR/pWCcCuB0m/NEaCP6gHDLeflQjAf3Gg15yqgT9E8C0Y
3cMHwNLNXaa6A4E/LqbIvx0AB8AC68hxx2mAP0NHS1n2KwbANC6osbiJfz+b
v2tyrlsFwFJusrHMSX4/QgUF0mmZBMA3GQPI2yJ9PxQ2hiO9xgPAMKMCLMLm
ez80NIC7EwIDwLKMID8vw3o/lwkY00lBAsBc6sSknah5PyXKl9wXcAHAXcX5
XKJ5eD8CWJAs6awAwCPURN1WYnc/FKLh3KSy/78JK3imPjd2P8EulO19J/6/
2Kb5Z2QjdT/0aYL9FaT8v8xv0wAmGHQ/fXtA8d3/+r/xlQ8r1flyP6Mn8HGs
d/m/Eu49Q/DxcT8fqm/Wqs73v8kNLgCS13A/IdsqOmgt9r9BGSwP84tvP8Cm
1yosqPS/VEdlcfOTbT+1SFT/HwLzv/2RrMdyeGs/SIXCYBp48b+tgaOjSodp
P8Dg2IKn6++/NUaSWPylZz+dY8wLeqXsv+3HHp6PomU/tBujrlmX6b9K+Dxh
68djP5AduVS1iem/Ze4tzrG/Yz9rH8/6EHzpv6KO+LN4t2M/IiP7Rshg6b+K
sw7qB6djP48qU982Kum/nqDp/yuGYz9qOQMQFL3ovwQcs8+KRGM/IFdjcc7i
57+6F2DqosFiP/xYeRcq1ee/TJunbHi5Yj/XWo+9hcfnv+PgZ2dOsWI/jl67
CT2s57/Jj0bG+6BiP/tlE6Krdee/DN0nKVyAYj/WdMPSiAjnvyr61IAzP2I/
snbZeOT65r+OqD2JEDdiP4147x5A7ea/rbvuCe4uYj9EfBtr99Hmv5jwHXSq
HmI/soNzA2ab5r9UC1zrKP5hP46FianBjea/QTqztQn2YT9ph59PHYDmv36h
Ovjq7WE/IIvLm9Rk5r/DB87lrt1hP/uM4UEwV+a/FP3TkJHVYT/Wjvfni0nm
v04Z/rN0zWE/spANjuc75r91VUlPWMVhP42SIzRDLua/gLCyYjy9YT+uDWRf

           "]]}, Annotation[#, "Charting`Private`Tag$56719#3"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA2w5V+EIuFsC04Z6Ra/CRP8ZPQd+8
LBbAmom28tLukT+ykC3GNisWwCOMymM67ZE/iBIGlCooFsB1MuZ1CeqRPzQW
ty8SIhbAdfvhWajjkT+OHRln4RUWwI9DmyDp1pE/QSzd1X/9FcAoH5Omdr2R
P6dJZbO8zBXAzLaQgMGKkT8IemlnAmMVwIhMnZOpHZE/ERGqvkkAFcBIkkSu
2LiQP7uTudWAnxTAPkM/IPxWkD/7C73lgzYUwIREXA/V248/4ur8mIjUE8Dk
AdyEvxmPP16/MEVZahPAOaNeRZ1Jjj98fzOxGQITwCZgdyF9f40/QaZywNug
EsAVqPSC6cSMP5zCpchpNxLA3YSY37n8iz+eRRV0+dQRwFR9/X3UQ4s/QbRT
33h0EcCbV6SmbJCKP3oYhkPECxHAe5Qb2tTPiT9a4/RKEaoQwD+qShsNHok/
0KNXSypAEMBK6/0ybl+IP8+fEhdmsA/ANMs79WSmhz9Nxe7deu4OwH9mZuSw
+4Y/9tWyliccDsDBJSnPkESGP+6z75XXVw3A61qi2YabhT8RfRSHH4MMwMQu
GFpn5oQ/dh3X90ayC8ARK/UXojaEPyqLEq9x7wrALmkkC3uUgz8J5DVYNBwK
wMgLJcGm5oI/NwrSR/pWCcAOqVQhM0aCP6gHDLeflQjAIk0Zn56qgT9E8C0Y
3cMHwOY3KN7AA4E/LqbIvx0AB8BZM9ha0mmAP0NHS1n2KwbAcQHyiNmJfz+b
v2tyrlsFwOS+19z4SX4/QgUF0mmZBMCbNjupEiN9PxQ2hiO9xgPAP2SufgTn
ez80NIC7EwIDwBzImcl7w3o/lwkY00lBAsBZP79886h5PyXKl9wXcAHAWt2I
MQF6eD8CWJAs6awAwL5bJ8G8Ync/FKLh3KSy/78isqZuqjd2P8EulO19J/6/
VnIov9MjdT/0aYL9FaT8v2IUkr6WGHQ/fXtA8d3/+r9y8wbMRPpyP6Mn8HGs
d/m/EOZDHFzycT8fqm/Wqs73v+wPjXX213A/IdsqOmgt9r9+AOYzpoxvP8Cm
1yosqPS/gau7QYuUbT+1SFT/HwLzv16BSLzkeGs/SIXCYBp48b/ULywCkYdp
P8Dg2IKn6++/BJEryA+mZz+dY8wLeqXsv5LJTBRiomU/tBujrlmX6b+Wyxib
d8djP5AduVS1iem/oNWhuDy/Yz9rH8/6EHzpv4QqQk4Ct2M/IiP7Rshg6b+w
8rvhjqZjP48qU982Kum/Bqs6qa2FYz9qOQMQFL3ov8qImrcBRGM/IFdjcc7i
578zMJa7A8FiP/xYeRcq1ee/Lq7b1de4Yj/XWo+9hcfnv9aH0messGI/jl67
CT2s57+/h8fyVqBiP/tlE6Krdee/9cV1pLF/Yj/WdMPSiAjnvwbzGnR9PmI/
snbZeOT65r8gbvgHWTZiP4147x5A7ea/YmVUEzUuYj9EfBtr99Hmv7kQe5Du
HWI/soNzA2ab5r/IciokZ/1hP46FianBjea/btuic0b1YT9ph59PHYDmv75Z
gDom7WE/IIvLm9Rk5r8x3F0u59xhP/uM4UEwV+a/n4dXW8jUYT/Wjvfni0nm
v0iXqf+pzGE/spANjuc75r+42VAbjMRhP42SIzRDLua/ZiVKrm68YT/hDWJb

           "]]}, 
         Annotation[#, "Charting`Private`Tag$56719#4"]& ]}}, {}}, {{}, {{{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         PointBox[{{-5.545177444479562, 
          0.016557951501810504`}, {-4.852030263919617, 
          0.014460588011560626`}, {-4.1588830833596715`, 
          0.012180254818243605`}, {-3.4657359027997265`, 
          0.010106012733514056`}, {-2.772588722239781, 
          0.007449705104397428}, {-2.0794415416798357`, 
          0.005773792146439544}, {-1.3862943611198906`, 
          0.0038389975091344757`}, {-0.6931471805599453, 
          0.0021968511328406067`}}]}}, {{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]]}, {}}, {{
         Directive[
          PointSize[0.012833333333333334`], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]]}, {}}}, {{}, {}}}}, {AxesLabel -> {
       FormBox[
       "\"(\\!\\(\\*FractionBox[\\(n\\), \\(n0\\)]\\))\"", TraditionalForm], 
       FormBox[
       "\"\[LeftAngleBracket]r\[RightAngleBracket] (\\!\\(\\*FractionBox[\\(n\
\\), \\(n0\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(1/d\\)]\\)\"", 
        TraditionalForm]}, Ticks -> {{{
         NCache[
          Rational[1, 2], 0.5], 
         FormBox[
          FractionBox["1", "2"], TraditionalForm]}, {
         NCache[
          Rational[1, 4], 0.25], 
         FormBox[
          FractionBox["1", "4"], TraditionalForm]}, {
         NCache[
          Rational[1, 8], 0.125], 
         FormBox[
          FractionBox["1", "8"], TraditionalForm]}, {
         NCache[
          Rational[1, 16], 0.0625], 
         FormBox[
          FractionBox["1", "16"], TraditionalForm]}, {
         NCache[
          Rational[1, 32], 0.03125], 
         FormBox[
          FractionBox["1", "32"], TraditionalForm]}, {
         NCache[
          Rational[1, 64], 0.015625], 
         FormBox[
          FractionBox["1", "64"], TraditionalForm]}, {
         NCache[
          Rational[1, 128], 0.0078125], 
         FormBox[
          FractionBox["1", "128"], TraditionalForm]}, {
         NCache[
          Rational[1, 256], 0.00390625], 
         FormBox[
          FractionBox["1", "256"], TraditionalForm]}}, Automatic}, 
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {-5.545177444479562, 0.0021650468573325863`}, 
     FrameTicks -> {{Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
        Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-5.545177444479562, 0.0021650468573325863`}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> 
     NCache[{{-Log[256], -Log[2]}, {0.0021650468573325863`, 
        0.01751869274423408}}, {{-5.545177444479562, -0.6931471805599453}, {
       0.0021650468573325863`, 0.01751869274423408}}], PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"4.75`", "4.8`", "4.85`", "4.8999999999999995`"}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.813405525635022*^9, 3.813405576638364*^9}, 
   3.813405918435788*^9, 3.813405948603415*^9, {3.813406007479032*^9, 
   3.813406044093932*^9}, 3.813569184542095*^9, {3.81356930644629*^9, 
   3.813569315703718*^9}, 3.813570506740679*^9, 3.813570608300452*^9, {
   3.813570683038971*^9, 3.813570724800173*^9}, {3.813571376274737*^9, 
   3.8135713863781853`*^9}, {3.813998702236845*^9, 3.8139987397885447`*^9}, 
   3.8139988077685823`*^9, 3.814001000420425*^9, 3.8140966409084473`*^9, 
   3.8140967959875393`*^9, 3.814096875605824*^9, 3.8140971104916573`*^9, 
   3.81409716522829*^9, 3.8141762181245947`*^9, {3.814177861036405*^9, 
   3.814177878911798*^9}, 3.8147811152180977`*^9, 3.815912727458315*^9, 
   3.820228114814245*^9, 3.83360921140349*^9, {3.867320114895198*^9, 
   3.867320117712016*^9}, 3.867320515185458*^9, 3.867320581433221*^9, 
   3.867320872904852*^9, 3.867321189494512*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"b080f3a0-b747-4ef6-86b0-d082ee480149"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Collapse check", "Subsubsection",
 CellChangeTimes->{{3.813570921087677*^9, 
  3.813570929343872*^9}},ExpressionUUID->"a69c5d58-85f4-4caf-9064-\
7d7ddc5c4d7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "visualize", " ", "the", " ", "collapse", " ", "of", " ", "a", " ", 
    "batch", " ", "of", " ", "10000", " ", "samples"}], "*)"}], 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", "=", "8"}], "}"}], ",", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "4", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "5", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "5", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "6", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "6", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "7", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "7", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"fitsk", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "8", "]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"s", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], "-", 
             RowBox[{"s", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", 
             RowBox[{
              RowBox[{"fitsk", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"histograms", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"[", "8", "]"}], "]"}]}], ",", 
        RowBox[{"reference", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "60"}], "}"}], ",", "All"}], "}"}]}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "2048", ",", "4096", ",", "8192", ",", "16384", ",", "32768", ",", 
         "65536", ",", "131072", ",", "262144", ",", "524288"}], "}"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812106517612191*^9, 3.8121068644314547`*^9}, {
  3.8121070186807117`*^9, 3.812107036149363*^9}, {3.812107173206072*^9, 
  3.812107173896922*^9}, {3.812111502660681*^9, 3.812111503935069*^9}, {
  3.813323938050315*^9, 3.813323938573197*^9}, {3.813912681278654*^9, 
  3.813912682614725*^9}, {3.814177885719387*^9, 3.814177886015765*^9}, {
  3.814781118575954*^9, 3.814781122018202*^9}, {3.815912730271824*^9, 
  3.815912730635603*^9}, {3.833609249484404*^9, 3.833609251116733*^9}, {
  3.833609390475604*^9, 3.8336094035978937`*^9}, {3.833609450169951*^9, 
  3.8336095054100122`*^9}, {3.833609603223589*^9, 3.833609636508*^9}, {
  3.8336099609244003`*^9, 3.8336099644196177`*^9}, {3.86732014760131*^9, 
  3.867320197328164*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"50ef0e17-9d61-4e51-9a60-57107c0a8e86"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFzXs403scB/C5hEirXB4iQmFOikpzOe33s7UoKXchxVpRy8h1R0xECR0h
kuRWS81QluqJLiohyiVNDpNqihaRrMupnHOe5zzfz/t53s/7ef31NmKEe+yR
JxAIVf/2v10m7LVM856Pi6U6v948M8HsjfdqzNXUx1eRnpuKEjywiJnJlkru
Mtx/0eeRwQds7GH/SiWXaQtcOqxoncpPwdR2rTP+IrTCu4/LLn2Py8Vs3L2b
nCfW4LWPmqtbtUuxXbTooCJzMj5w1X1dUcBF7LhN3qyUYY8r6Eewx2f5mNCs
rmT9ufX4lJ5y1YJBPjaRNVrSwsJxg1h5TbdmHqagxGFPqlBx2amtGWMjxZhO
kjJF9yIN96Nb9m37mI1Zfi1Qp9LoOHUzITjdiItRD5qK9w9vxJnTqy/tEIVi
vu/rBXmJzrhBUuFg9W4PLGw3PaFx8Wb8m7JvwYJ3tljKYK/LyA0XPDbb5H2V
xBA77c3Um+/tip82FgRHdClggqfT79d92oofiysb+uwwSnl13lFc6+SG15zj
t9uVtFJYQXPpG7Td8RUn80zls/gUmX634IXEHc/8KQuV5+dQDvcXaoYJPXA5
pVradVcmRa0gKEEuxRMn/J98D3NJvpsX8lLipIuFoTcyv/2G8M442CY9Sc+z
0Qf57ganI+8yfJE3yRGlh/y2I/feFnksMPdD3hlfcuuCDDy2bq+xXbM/ctS0
ZcaTvADkX7UzU8GMHcjpB277yawCkTVIaU0Zs+BzI1tIhk93IptXaOYIi3ch
+61i/zhvE4Rcou5hNVEMlkhtmLaKwcikx7qFKSww+9LP9o4esPDoq1ltewby
V2bzmuByMIV2OaRKZTfyEaMTZ2fCwa2zEZ1YH1h9yEshg8JE9my0JffywIVF
+iwD9T3IYg6hNDQabOwr6akbAIfatCr9pO5FrtYQ2DvxwZ+mstk5C0OQyV1R
FQMccGKNr2j5MPh+loNqhFMosjLLkHKrBrxlk0KkovY+5Byzd7ytiWDRnPb+
QglYT1Kj/sZlP3LQ/VxHSyH4YllsTNxiFrKU63+5KRlsFUgRq42BYxyMF/q4
HUBu0FWil90AE76Ocd4bhCHTRU8Ea4+CM65dHeaOgztz8zXbvNjIWgf/cNZo
BPtvC0wINAlHLrV0vFKZAR5RWy6ZmgJrxijOK1kRgUxmypbTgsD+nqPYaB44
gfqX34kWcKl1R9Tqv8FNS++c6Ft5EFlCvFKZwAArz5Y3GRWASRN5A4/awFvE
aTOsn2B2RxxxoXUkck7DPtJ1JvgaP4AWUAgWnXENJHSAv6VjcbxZsD7HOmfz
mihkSohJ1ce94GAfreZTReAjdOWXdk/BF9d++zokF43cZiJdlGoDli4SryDt
A8+X79z4tBhsPXUvKKoL7DlcF6+jGIMc23nh1G0yuPBOQQ2DBW6oTm9VLgUP
Fce/FvSACVkHfrgrxSKbHNqp/cUOTN/vZlUcBg71o252LAdnOq9lvu0FV5NN
uZkqcchdpjqFVr+Dp7VU656Hg7Xm/GiPPw+2/Tw+YtgH9n/zcvahKgc5sadb
dz8FXNb0YA0xEnz/Sr3rNR54pLQyxK8frJx9JvnXvD+QLbiZZ8/jYNewxHrn
aHD4jvDO8UpwrkvwWO4AuN7eU8GWGI/cR6IvEVPB33XI5JRYsL4Kyd2MD8a+
LGZ1iMGMt/PSDi48hJz6/FeJNh1c+XDyZgMH/Fj4uidIAP5Q0fthzjCYmPtI
qUojAdk6+eZSNyewVwTffiYeHLer2KuoBnxm659s7DW4cf3hdIlWIvLQisiK
45vAcvrMxpWJ4GVqPqJnV8AbvztNciTgfWN2qgY6XOSsF78te+ACrmlZQglN
AndfJ25XF4KneXKRdW/B2vnTmb6Lk5DtUkd4P1zBAVF9d8uTwVxGW//GenC5
e8O0dBTMKBMddZ5/GP5Od2romYPTslvLxh3B2seaLO8FgCu5t27lxoDtYoVO
e7LBj8MEveTL4IA9vGDVB+DxHSUTg4NgrtfpQ7UyMHHLSZWUBcnIZbTj+V4W
4NUOKcZmG8D/AEPdxig=
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFyQlQzH0cBvBtSREd0uGNqNAhpOjQ2v9PKl1iV2mTZKvVuR3bgW6VImX1
poNKWCQZxEqUJKsmlcgbu+ggRSSt7XiT6n3fmXd+32fmmWc+82h5h9JZZBKJ
VP5v/9t96fL+FIYsCpoS8x+PqBIRX68Mj9LVkP7C7rVBHBuiyI73up+ihcTt
BmOqn5nEjIaET3+xCmVSet/fH4gimD+scmp9DNFKz1sK+7XSCCazyTx30ghN
qUREeETnEMqOYl3HpybI1PYD7TvrHCHYsFhNimuKwkKm7nquuExEaW6Zc49h
gVK2/Lgg9bWMWCUbMBqsTUFqK+pD4s6VE0LxqU/ag1R049PBKL5jGSFgvw8Y
fIuQVxev0rCHRxR7hzEbCStkcjU9L3nsLBHtNtv94qWt6OfrYVathEs4OxXs
jJ9rg7hF9i+U2pIIvS2GdowQW0Sp413eIAklSKZ1hMmrbUhtjuHwbpEHITJw
MZM3t0dvVuyu8ubZEhXLvqwdKHJAnLpxZxnaeiJjUdwqgZQTmom/efiURJ3w
mauoWXJgO0pTT2HJSUiE5TRPJabZGZE9lK6N9PVRMyYK0wzUd6IHQ8KUtsjn
1HEJi1zwbCdqCvXt7p2+Q/UZWpcgHU9DyWIL0bzkPGrbl4kJzjo64rj0KH10
5VApvU+iej7QkWqX92bVbFvq1c4s8fbTuxDp/ywSurGrbV2wj7RrDehNgL+3
fPPNK3fFdm+82zNr327shseJe8MV3bCNa+yFXfXgc5XKLk5RDGy5is62+7ru
2AfLSx1134J7L4c3ns7cg73jvOVWMuGBXXNW+lGoGKyX27apk7cX+zT3TKXD
bk9sqQwf4yrZfdjs1DU3VlaDRQnj+jlsL2xeTQ+dpLgf/vtPFc0CwAr3rj1n
14Nt+NzMSxpM7NiKSId3keDbN9xlFz4HfymnNtjpemNrlumkJiaBXa7IWlWK
wBm87zODxj7YdefbH+pkgseL78Xu6QOvKSyyyKb6YvsUHBlvzAefyT1wd3oY
3PanY8RGBxa29Cmj9cE8sGWWyo+Lv8HhGb+ui1wPYJemdwcq3gR3pgr0tsn6
YSsnl/XHM8EOiScv8R+Ak+IivL8p+2NXHmYs12aDB6M3dzEawNqR2kXcZQHY
jHCZPQ2HwNyQQbWpl+CnQS87TFYHYk/6V+YEpoLXHyikXegE+/kkKQhNg7CL
97Na5U+BX3k6nLAZAM/zWGcfZxWMjRiLZO4UgqNdJwQDI+Dr9K7k5c5s7I87
niC3UrD69qvTWaQQ7B0OWTUCd/DRbZyYydvgams3c+P5odjiLZQxfxZYl9Di
l9SC12rOsvgmF4bdVDSan2YO9tX4MqbFAs+ceev6MBt8Vr2Vz6gFm+Y/Uh75
Cn6pcpvDVQvHDj596aWBNVhGOd+oIQx8Mfs4l1kM3qwYN/S7CSw8GbK9YAwc
sYB53USHgy2fuUuubQe4bJ5tYGAc2Pq4eZN0GbhbZrXehQ5wTNrSdAo5AltV
WrH/zVpwRQrZJsID7EQe5ckfA39O+ky+xgcnz4iYNh/ASxNa6noWRGJX/a5d
FrcJvCu2IkHNDzw0weu8nQM+fiiP4lwHXjF+rHBgEPwoKvZX6uIobI8Rtvty
W/AYZ39VNQecLaaruZWADcNson82gxuHzDqy/gZ7sw026K+Mxp76tiRHQAMX
BCr89EoAmwxI0SavgZ/7jdzMewMO6O+XN559EHs2S8RuNQKX9Da3+HuCLb1r
V8/OAL/uuZVRUgkO9+INbOoFz+/KtXutcAi7dO+x0nAK2OpdzJwFAeBOdzbr
ai74kNBLsLUerOxG1+keAt/osE6O0TiMbe9i9kHFDvypXR9VRIITaUtKnC6A
NV7IT39uBVc6S3mm/ALTWiXVmrox2IOO/X882AVOfyY87JoE1rZvFg5fBz9s
fGiWKQIzbG/l6c6JxZYILo7WG4NPbs112ecF1q9PvzNxAixAMQtzq8Bej4LD
jfrAk5u9XjQrxWHn1dDW+VHB6y2tT5KDwC33Tb8X54P9zPWdLARg8j2N8r+G
wcUb5eeFLY3HNueTAuQcwK+MJY1XosEhFX2rrHjguUbCo51t4H8AxELb7w==

         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFxwk41Hkcx3Eh6XCWJikd0jARkasH/1+To3HnjgxpalCiXCMkRNlYHa7I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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxF0Hs01PkfBvDZqU25M6xqhXGphMglKs33MxhUwhjjtuQSUaNxSURFckk5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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFyQk41HkcBnA5mxKhLaqRM7SWsDkz/58rkyPMOIYcGfcaMRNa5Ri15NhQ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         "]]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFxwk01Hsfx/FJZAsRnijbY03Xvi/N75dlqknTmHDnCpORNSXrJZE1UbIk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         "]]}, {
        Hue[0.08640786499873876, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFxwk01esexnHT3TKcRMiQruFmLIRiG/7vi8iU7L0jY2XIEEUDopNQyVSG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         "]]}, {
        Hue[0.3224758424985268, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFxwk01P8exnH7mpASkSUp2YrWYfy+X9n3bWwla9bSUBKKLCmhpGRLiYxl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         "]]}, {
        Hue[0.5585438199983166, 0.6, 0.6], 
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd031MVWUcB/Anh4q5mi0k1pTE3pQKTEICBH7cC8hFFO65xVXy5aC8esWG
bysM95CigvxhoWKIeDQiLuTLUjOT8JEU8oVlNcxm2VGDudp1hZYkTovdH2t8
z3Z39tn3fs/37p49QYve1HKGCSF+/u8zcB96qVjv/Y+4m5mW2Bv/eNiCbk3/
PNr1xKg4L33J+Vb15r77gewxVGbxGWe5HMr2I5+gucrHP4YdQJVjAgvHuZLZ
4+jh2+XTz4Q72BMo11Xy3oUT89gTyXPJ99TvzdnsZyjXJmtqvlrKfo6G5Tj2
b1m1gj2JxvecG33h0NvsYMrr7ZyWVifZL9LIz1IOCv8ydgjFXW8rVbYK9hSK
GpF9YHTgFvbLdPRbcWXB6ir2VFrS78xof76aHUZbT9p73392J/sVWhea2lCc
uZsdTl+6k8tOd+1hT6PdX1fVr+r/kB1BK3eEhrb5NrBfpdYfe9qn9nzMjqT1
dZ1NYcVudhRFVl9r0vY1saPp1MKq8E8LmtnTyXGjpT1q76BjqGZh50M99kHH
0hdGa07SmsF+HMndRVf9ggefT9Q/r/B0XxHvS6JSa6N23PUR5/Hk7hf1y8P4
98t4qm+7ZKm9bnBuoYasvk0HQ3ZxbqExI+rWrGvfwbmVyo/0+Zn7tnJupV35
zqD59wb/7wRaEHIt+ljxZs4TqLhjctTd7sH3lUiHV18uux9WynkiabZdcoS7
mPMkco7y3/j04pWcJ9FY57aS6o5lnM8gLWtpUOOdXM5nUN7a8JGNt3TOk+nP
/Oubjpyaw3kyXXwQed7psXNuI7rSnNHQYuPcRhVzQzf0ahbOU2jWnltPHvdE
cp5Cnkdap3yQOJXzmbTthZZzibWTOZ9Jy+4eemqyGcR5KkVOymrw9Adwnkp1
8dYHPq7HOJ9Fxzq+2xji68v5LEoMrnzJp1xwPpsO3v8mq/Wdv73nVc6mgeO0
veomn980creMv3rY/JXzNLrTsabrbMJPnKfTWG2t5nn8e68pnXZO+C1WuM/w
99Mpomj5Cav9pNcqncz1Awf+KPftVPjgbEqVtp/7dnr39NXzB3r2ct9OVP9L
66O11dy30/ANnyz7q7aS+xo/X3Jfo+GN7hxXSRH3NUqNKI/Xu3Xua1RQedHe
5WPnvoMqurdnWK/Fct9Byen3Alb8MJH7Du/77bsd4+07SAy5XhtqAkuwAovX
oQ+WYAUWGdAHS7ACCyf0wRKswGIO9MESrMBiLvTBEqzAIhP6YAlWYPEG9MES
rMBiHvTBEqzAYj70wRKswGIB9MESrMBiIfTBEqzAQh/qCWAC62AJNsAKbIJF
FuyDCayDJdgAK7AJFotgH0xgHSzBBliBTbBYDPtgAutgCTbACmyCRTbsgwms
gyXYACuwCRY5sA8msA6WYAOswCZY5MI+mMA6WIINsAKbYJEH+2AC62AJNsAK
bIJFPuyDCayDJdgAK7AJFgWwDyawDpZgA6zAJlgsgX0wgXWwBBtgBTbBwgX7
YALrYPm//wU7jfaI
         "]]}}, {{
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[1.6]]}}, {{
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.004583333333333334], 
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 60}, {0, 0.05403826768347659}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "2048", "4096", "8192", "16384", "32768", "65536", "131072", "262144", 
       "524288"}, "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #8}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.647624, 0.37816, 0.614037], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.647624, 0.37816, 0.614037], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #9}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.772079`", ",", "0.431554`", ",", "0.102387`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.24259866666666668`, 0.412334, 0.521566], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.363898`", ",", "0.618501`", ",", "0.782349`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.363898, 0.618501, 0.782349]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.363898, 0.618501, 0.782349], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.75, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0.5, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.75`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.75, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.75, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.004583333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.647624, 0.37816, 0.614037], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.4317493333333333, 0.2521066666666667, 
                    0.40935800000000006`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.647624`", ",", "0.37816`", ",", "0.614037`"}], 
                    "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.647624, 0.37816, 0.614037]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.647624, 0.37816, 0.614037], Editable -> False, 
                    Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8, ",", #9}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8336099949214993`*^9, 3.867320123085103*^9, 
  3.867320185644889*^9, 3.86732051834204*^9, 3.867320583584888*^9, 
  3.8673208750563307`*^9, 3.867321191413741*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"d9465db0-5aa3-484b-a543-aa454870da62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"List", " ", "of", " ", 
    SubscriptBox["d", 
     RowBox[{"H", " "}]], "measurements", " ", "with", " ", "only", " ", 
    "the", " ", "6", " ", "biggest", " ", "volumes", " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", ",", "\[Beta]", ",", 
      SubscriptBox["d", "H"]}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Pi]", "/", "2"}], ",", 
      RowBox[{"\[Pi]", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"dimfit", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "\[PlusMinus]", 
       RowBox[{"errordc", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "dimfit", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8122823725617437`*^9, 3.812282471871275*^9}, {
  3.8122825047932167`*^9, 3.812282539609117*^9}, {3.81279631050548*^9, 
  3.812796321202735*^9}, {3.812798178660777*^9, 3.812798183598084*^9}, {
  3.812798271578971*^9, 3.812798372220471*^9}, {3.812798616107245*^9, 
  3.812798616476924*^9}, {3.812799538917892*^9, 3.8127995394794893`*^9}, {
  3.812799748707597*^9, 3.812799749355486*^9}, {3.814177899062817*^9, 
  3.814177925105682*^9}, {3.814781141549432*^9, 3.814781153893929*^9}, {
  3.820228120153284*^9, 3.820228122557143*^9}, {3.8673202174483633`*^9, 
  3.867320241735331*^9}, {3.867320291905182*^9, 3.867320301979869*^9}, {
  3.867320364579379*^9, 3.867320391729347*^9}, {3.86732061296434*^9, 
  3.8673206130793533`*^9}, {3.8673211945397263`*^9, 3.8673211946745157`*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"1f4956af-b90a-4d42-a6b9-83fbf8729819"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.762724017352581`", "\[PlusMinus]", "0.02106938930218247`"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.801162315703667`", "\[PlusMinus]", "0.11156764723546818`"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{
     "4.761582208930644`", "\[PlusMinus]", "0.025128141605826777`"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.781385397679151`", "\[PlusMinus]", "0.0734591083418157`"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.813011105078474`", "\[PlusMinus]", "0.06043826630456315`"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.894950765525675`", "\[PlusMinus]", "0.06873887078385087`"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.935623714725309`", "\[PlusMinus]", "0.11776722210070319`"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"4.862219974558272`", "\[PlusMinus]", "0.04848499996525822`"}]}],
     "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.812282540414571*^9, 3.812359313596221*^9, 3.812795563478176*^9, 
   3.8127956676733847`*^9, {3.812796310937776*^9, 3.8127963220635223`*^9}, 
   3.812797489745367*^9, 3.8127978602456512`*^9, {3.812798269228998*^9, 
   3.812798276941811*^9}, {3.812798362071553*^9, 3.8127983728335114`*^9}, {
   3.812798614456972*^9, 3.8127986169369097`*^9}, 3.812799463447226*^9, 
   3.8127995400422792`*^9, 3.8127997498957987`*^9, 3.8133239426269712`*^9, 
   3.813324532610592*^9, 3.813571603705575*^9, 3.813650820344701*^9, 
   3.813912685885252*^9, {3.814177922426373*^9, 3.814177925564383*^9}, {
   3.814781144508911*^9, 3.814781154433197*^9}, 3.815912735096884*^9, 
   3.820228123164958*^9, 3.867320392465382*^9, 3.8673204516074657`*^9, 
   3.867320521233499*^9, 3.867320587473608*^9, 3.867320877319757*^9, 
   3.8673211951607437`*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"5a2cda40-af39-4d36-9eeb-17eff84ca1c1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Mean", " ", "\[PlusMinus]", " ", 
   RowBox[{"Error", " ", "reported", " ", "in", " ", "paper"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8673204003358297`*^9, 
  3.867320439532192*^9}},ExpressionUUID->"a38bfbda-6efd-41ad-90c7-\
32be10e9a66a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", "dimfit", "]"}], "\[PlusMinus]", 
  RowBox[{"StandardDeviation", "[", "dimfit", "]"}]}]], "Input",
 CellChangeTimes->{{3.8673204105875397`*^9, 3.8673204257178173`*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"835423ed-de20-460f-94e3-b7a752634b65"],

Cell[BoxData[
 RowBox[{"4.826582437444221`", "\[PlusMinus]", 
  "0.0643764886826248`"}]], "Output",
 CellChangeTimes->{3.820228125942999*^9, 3.867320453487541*^9, 
  3.867320523413431*^9, 3.867320591748561*^9, 3.867320879123251*^9, 
  3.867321198902129*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"076a03ba-1312-489b-8827-a2cd9eceb74a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DimensC", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dims", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"dims", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[PlusMinus]", 
          RowBox[{"errordc", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "[", 
          RowBox[{"dims", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "dims", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"DimensC", ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["2", "x"], ",", 
      SubscriptBox["d", "H"]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"11", ",", "18"}], "]"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "dimfit"}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
      "h"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.812795804361302*^9, 3.812795835645898*^9}, {
  3.812795868064048*^9, 3.812795912272303*^9}, {3.8127961124944057`*^9, 
  3.812796124671679*^9}, {3.812796772276849*^9, 3.812796778229855*^9}, {
  3.8127983849854593`*^9, 3.812798407901867*^9}, {3.8127992117698174`*^9, 
  3.812799216092692*^9}, {3.812799468670179*^9, 3.812799476616253*^9}, {
  3.812799739849991*^9, 3.812799743187764*^9}, {3.8133239508716297`*^9, 
  3.813323951363852*^9}, {3.813324535798545*^9, 3.8133245362112427`*^9}, {
  3.813404096304866*^9, 3.813404103613545*^9}, {3.8135716198542013`*^9, 
  3.8135716209401493`*^9}, {3.813650824642763*^9, 3.813650837338193*^9}, {
  3.8139127380708733`*^9, 3.8139127425946903`*^9}, {3.814177935661811*^9, 
  3.81417793602429*^9}, {3.814781168099058*^9, 3.8147811815646973`*^9}, {
  3.815912741004043*^9, 3.815912741350988*^9}, {3.867320462752034*^9, 
  3.867320470254216*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"4882de0e-1c15-4107-a40a-de35bb816d5b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{11., 4.732380449194091}, {11., 4.753449838496273}}], 
          LineBox[{{11., 4.753449838496273}, {11., 4.774519227798455}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{12., 4.7333810222719706`}, {12., 4.754450411574153}}], 
          LineBox[{{12., 4.754450411574153}, {12., 4.775519800876335}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{13., 4.73216505548084}, {13., 4.753234444783022}}], 
          LineBox[{{13., 4.753234444783022}, {13., 4.774303834085204}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{14., 4.740711787066416}, {14., 4.761781176368598}}], 
          LineBox[{{14., 4.761781176368598}, {14., 4.78285056567078}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{15., 4.734258425811934}, {15., 4.755327815114116}}], 
          LineBox[{{15., 4.755327815114116}, {15., 4.776397204416298}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{16., 4.736721856544238}, {16., 4.757791245846421}}], 
          LineBox[{{16., 4.757791245846421}, {16., 4.778860635148603}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{17., 4.733256479909428}, {17., 4.75432586921161}}], 
          LineBox[{{17., 4.75432586921161}, {17., 4.775395258513792}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], {}, {
          LineBox[{{18., 4.74986828097407}, {18., 4.770937670276252}}], 
          
          LineBox[{{18., 4.770937670276252}, {18., 
           4.7920070595784345`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{11., 4.603899362637738}, {11., 4.715467009873206}}], 
          LineBox[{{11., 4.715467009873206}, {11., 4.8270346571086735`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{12., 4.605530202309307}, {12., 4.717097849544775}}], 
          LineBox[{{12., 4.717097849544775}, {12., 4.828665496780243}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{13., 4.610011378316017}, {13., 4.721579025551485}}], 
          LineBox[{{13., 4.721579025551485}, {13., 4.8331466727869525`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{14., 4.608629214366979}, {14., 4.720196861602447}}], 
          LineBox[{{14., 4.720196861602447}, {14., 4.831764508837915}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{15., 4.61227261663736}, {15., 4.723840263872828}}], 
          LineBox[{{15., 4.723840263872828}, {15., 4.8354079111082955`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{16., 4.616420371730771}, {16., 4.727988018966239}}], 
          LineBox[{{16., 4.727988018966239}, {16., 4.839555666201707}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{17., 4.627467979466446}, {17., 4.739035626701914}}], 
          LineBox[{{17., 4.739035626701914}, {17., 4.850603273937382}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], {}, {
          LineBox[{{18., 4.605183561066419}, {18., 4.716751208301887}}], 
          LineBox[{{18., 4.716751208301887}, {18., 4.828318855537355}}]}}}, {{
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{11., 4.730434477349388}, {11., 4.755562618955215}}], 
          LineBox[{{11., 4.755562618955215}, {11., 4.7806907605610425`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{12., 4.730949298413854}, {12., 4.7560774400196815`}}], 
          LineBox[{{12., 4.7560774400196815`}, {12., 4.781205581625509}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{13., 4.7297092034869435`}, {13., 4.754837345092771}}], 
          LineBox[{{13., 4.754837345092771}, {13., 4.779965486698598}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{14., 4.7340127385698985`}, {14., 4.759140880175726}}], 
          LineBox[{{14., 4.759140880175726}, {14., 4.784269021781553}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{15., 4.728187646769704}, {15., 4.753315788375531}}], 
          LineBox[{{15., 4.753315788375531}, {15., 4.778443929981358}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{16., 4.735367972138885}, {16., 4.760496113744712}}], 
          LineBox[{{16., 4.760496113744712}, {16., 4.785624255350539}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{17., 4.7330511959342205`}, {17., 4.758179337540048}}], 
          LineBox[{{17., 4.758179337540048}, {17., 4.783307479145875}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], {}, {
          LineBox[{{18., 4.7207001133549}, {18., 4.745828254960727}}], 
          LineBox[{{18., 4.745828254960727}, {18., 4.770956396566554}}]}}}, {{
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{11., 4.704814759121777}, {11., 4.778273867463593}}], 
          LineBox[{{11., 4.778273867463593}, {11., 4.851732975805409}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{12., 4.705502886918991}, {12., 4.778961995260807}}], 
          LineBox[{{12., 4.778961995260807}, {12., 4.852421103602623}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{13., 4.700132042671013}, {13., 4.7735911510128295`}}], 
          LineBox[{{13., 4.7735911510128295`}, {13., 4.847050259354646}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{14., 4.702652459836553}, {14., 4.7761115681783695`}}], 
          LineBox[{{14., 4.7761115681783695`}, {14., 4.849570676520186}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{15., 4.701443216116863}, {15., 4.7749023244586795`}}], 
          LineBox[{{15., 4.7749023244586795`}, {15., 4.848361432800496}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{16., 4.693126121979749}, {16., 4.7665852303215654`}}], 
          LineBox[{{16., 4.7665852303215654`}, {16., 4.840044338663382}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{17., 4.69420811457534}, {17., 4.767667222917156}}], 
          LineBox[{{17., 4.767667222917156}, {17., 4.841126331258972}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], {}, {
          LineBox[{{18., 4.692488018279897}, {18., 4.765947126621713}}], 
          LineBox[{{18., 4.765947126621713}, {18., 4.839406234963529}}]}}}, {{
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{11., 4.684258933329043}, {11., 4.744697199633606}}], 
          LineBox[{{11., 4.744697199633606}, {11., 4.805135465938169}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{12., 4.685667855613083}, {12., 4.746106121917646}}], 
          LineBox[{{12., 4.746106121917646}, {12., 4.806544388222209}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{13., 4.683784472767503}, {13., 4.7442227390720655`}}], 
          LineBox[{{13., 4.7442227390720655`}, {13., 4.804661005376628}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{14., 4.683967172539777}, {14., 4.74440543884434}}], 
          LineBox[{{14., 4.74440543884434}, {14., 4.804843705148903}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{15., 4.687695437642836}, {15., 4.748133703947399}}], 
          LineBox[{{15., 4.748133703947399}, {15., 4.808571970251962}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{16., 4.679513737501918}, {16., 4.739952003806481}}], 
          LineBox[{{16., 4.739952003806481}, {16., 4.800390270111044}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{17., 4.6966395719178715`}, {17., 4.757077838222434}}], 
          LineBox[{{17., 4.757077838222434}, {17., 4.817516104526997}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], {}, {
          LineBox[{{18., 4.668709022534451}, {18., 4.729147288839014}}], 
          LineBox[{{18., 4.729147288839014}, {18., 4.789585555143577}}]}}}, {{
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{11., 4.649767232767493}, {11., 4.718506103551344}}], 
          LineBox[{{11., 4.718506103551344}, {11., 4.787244974335195}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{12., 4.650477518077759}, {12., 4.71921638886161}}], 
          LineBox[{{12., 4.71921638886161}, {12., 4.787955259645461}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{13., 4.654044833249049}, {13., 4.7227837040329}}], 
          LineBox[{{13., 4.7227837040329}, {13., 4.791522574816751}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{14., 4.655652202576031}, {14., 4.724391073359882}}], 
          LineBox[{{14., 4.724391073359882}, {14., 4.793129944143733}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{15., 4.6632068998727085`}, {15., 4.7319457706565595`}}], 
          LineBox[{{15., 4.7319457706565595`}, {15., 
           4.8006846414404105`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{16., 4.665202525638965}, {16., 4.733941396422816}}], 
          LineBox[{{16., 4.733941396422816}, {16., 4.802680267206667}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{17., 4.660537897971422}, {17., 4.729276768755273}}], 
          LineBox[{{17., 4.729276768755273}, {17., 4.798015639539124}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], {}, {
          LineBox[{{18., 4.668738129026034}, {18., 4.737476999809885}}], 
          LineBox[{{18., 4.737476999809885}, {18., 4.806215870593736}}]}}}, {{
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{11., 4.627811563145312}, {11., 4.745578785246015}}], 
          LineBox[{{11., 4.745578785246015}, {11., 4.863346007346718}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{12., 4.629035654653869}, {12., 4.746802876754572}}], 
          LineBox[{{12., 4.746802876754572}, {12., 4.864570098855275}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{13., 4.623924103629659}, {13., 4.741691325730362}}], 
          LineBox[{{13., 4.741691325730362}, {13., 4.859458547831065}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{14., 4.6248560768315174`}, {14., 4.74262329893222}}], 
          LineBox[{{14., 4.74262329893222}, {14., 4.860390521032923}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{15., 4.626909675903306}, {15., 4.744676898004009}}], 
          LineBox[{{15., 4.744676898004009}, {15., 4.862444120104712}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{16., 4.635634187102228}, {16., 4.753401409202931}}], 
          LineBox[{{16., 4.753401409202931}, {16., 4.871168631303634}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{17., 4.6247152892278285`}, {17., 4.742482511328531}}], 
          LineBox[{{17., 4.742482511328531}, {17., 4.860249733429234}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], {}, {
          LineBox[{{18., 4.620005050586253}, {18., 4.737772272686956}}], 
          LineBox[{{18., 4.737772272686956}, {18., 4.855539494787659}}]}}}, {{
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{11., 4.683689478093638}, {11., 4.732174478058896}}], 
          LineBox[{{11., 4.732174478058896}, {11., 4.7806594780241545`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{12., 4.683816953479083}, {12., 4.732301953444341}}], 
          LineBox[{{12., 4.732301953444341}, {12., 4.780786953409599}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{13., 4.684972459410185}, {13., 4.733457459375443}}], 
          LineBox[{{13., 4.733457459375443}, {13., 4.781942459340701}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{14., 4.685258222541418}, {14., 4.733743222506677}}], 
          LineBox[{{14., 4.733743222506677}, {14., 4.782228222471935}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{15., 4.690396773954469}, {15., 4.7388817739197275`}}], 
          LineBox[{{15., 4.7388817739197275`}, {15., 4.787366773884986}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{16., 4.688383372752873}, {16., 4.736868372718131}}], 
          LineBox[{{16., 4.736868372718131}, {16., 4.78535337268339}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{17., 4.688548426578874}, {17., 4.737033426544133}}], 
          LineBox[{{17., 4.737033426544133}, {17., 4.785518426509391}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], {}, {
          LineBox[{{18., 4.679586591933544}, {18., 4.728071591898803}}], 
          
          LineBox[{{18., 4.728071591898803}, {18., 
           4.776556591864061}}]}}}}, {{{Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.774519227798455}, 
             Offset[{3, 0}, {11., 4.774519227798455}]}, {{11., 
             4.774519227798455}, 
             Offset[{-3, 0}, {11., 4.774519227798455}]}, {{11., 
             4.732380449194091}, 
             Offset[{3, 0}, {11., 4.732380449194091}]}, {{11., 
             4.732380449194091}, 
             Offset[{-3, 0}, {11., 4.732380449194091}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.775519800876335}, 
             Offset[{3, 0}, {12., 4.775519800876335}]}, {{12., 
             4.775519800876335}, 
             Offset[{-3, 0}, {12., 4.775519800876335}]}, {{12., 
             4.7333810222719706`}, 
             Offset[{3, 0}, {12., 4.7333810222719706`}]}, {{12., 
             4.7333810222719706`}, 
             Offset[{-3, 0}, {12., 4.7333810222719706`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.774303834085204}, 
             Offset[{3, 0}, {13., 4.774303834085204}]}, {{13., 
             4.774303834085204}, 
             Offset[{-3, 0}, {13., 4.774303834085204}]}, {{13., 
             4.73216505548084}, 
             Offset[{3, 0}, {13., 4.73216505548084}]}, {{13., 
             4.73216505548084}, 
             Offset[{-3, 0}, {13., 4.73216505548084}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.78285056567078}, 
             Offset[{3, 0}, {14., 4.78285056567078}]}, {{14., 
             4.78285056567078}, 
             Offset[{-3, 0}, {14., 4.78285056567078}]}, {{14., 
             4.740711787066416}, 
             Offset[{3, 0}, {14., 4.740711787066416}]}, {{14., 
             4.740711787066416}, 
             Offset[{-3, 0}, {14., 4.740711787066416}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.776397204416298}, 
             Offset[{3, 0}, {15., 4.776397204416298}]}, {{15., 
             4.776397204416298}, 
             Offset[{-3, 0}, {15., 4.776397204416298}]}, {{15., 
             4.734258425811934}, 
             Offset[{3, 0}, {15., 4.734258425811934}]}, {{15., 
             4.734258425811934}, 
             Offset[{-3, 0}, {15., 4.734258425811934}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.778860635148603}, 
             Offset[{3, 0}, {16., 4.778860635148603}]}, {{16., 
             4.778860635148603}, 
             Offset[{-3, 0}, {16., 4.778860635148603}]}, {{16., 
             4.736721856544238}, 
             Offset[{3, 0}, {16., 4.736721856544238}]}, {{16., 
             4.736721856544238}, 
             Offset[{-3, 0}, {16., 4.736721856544238}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.775395258513792}, 
             Offset[{3, 0}, {17., 4.775395258513792}]}, {{17., 
             4.775395258513792}, 
             Offset[{-3, 0}, {17., 4.775395258513792}]}, {{17., 
             4.733256479909428}, 
             Offset[{3, 0}, {17., 4.733256479909428}]}, {{17., 
             4.733256479909428}, 
             Offset[{-3, 0}, {17., 4.733256479909428}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.7920070595784345`}, 
             Offset[{3, 0}, {18., 4.7920070595784345`}]}, {{18., 
             4.7920070595784345`}, 
             Offset[{-3, 0}, {18., 4.7920070595784345`}]}, {{18., 
             4.74986828097407}, 
             Offset[{3, 0}, {18., 4.74986828097407}]}, {{18., 
             4.74986828097407}, 
             Offset[{-3, 0}, {18., 4.74986828097407}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.8270346571086735`}, 
             Offset[{3, 0}, {11., 4.8270346571086735`}]}, {{11., 
             4.8270346571086735`}, 
             Offset[{-3, 0}, {11., 4.8270346571086735`}]}, {{11., 
             4.603899362637738}, 
             Offset[{3, 0}, {11., 4.603899362637738}]}, {{11., 
             4.603899362637738}, 
             Offset[{-3, 0}, {11., 4.603899362637738}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.828665496780243}, 
             Offset[{3, 0}, {12., 4.828665496780243}]}, {{12., 
             4.828665496780243}, 
             Offset[{-3, 0}, {12., 4.828665496780243}]}, {{12., 
             4.605530202309307}, 
             Offset[{3, 0}, {12., 4.605530202309307}]}, {{12., 
             4.605530202309307}, 
             Offset[{-3, 0}, {12., 4.605530202309307}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.8331466727869525`}, 
             Offset[{3, 0}, {13., 4.8331466727869525`}]}, {{13., 
             4.8331466727869525`}, 
             Offset[{-3, 0}, {13., 4.8331466727869525`}]}, {{13., 
             4.610011378316017}, 
             Offset[{3, 0}, {13., 4.610011378316017}]}, {{13., 
             4.610011378316017}, 
             Offset[{-3, 0}, {13., 4.610011378316017}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.831764508837915}, 
             Offset[{3, 0}, {14., 4.831764508837915}]}, {{14., 
             4.831764508837915}, 
             Offset[{-3, 0}, {14., 4.831764508837915}]}, {{14., 
             4.608629214366979}, 
             Offset[{3, 0}, {14., 4.608629214366979}]}, {{14., 
             4.608629214366979}, 
             Offset[{-3, 0}, {14., 4.608629214366979}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.8354079111082955`}, 
             Offset[{3, 0}, {15., 4.8354079111082955`}]}, {{15., 
             4.8354079111082955`}, 
             Offset[{-3, 0}, {15., 4.8354079111082955`}]}, {{15., 
             4.61227261663736}, 
             Offset[{3, 0}, {15., 4.61227261663736}]}, {{15., 
             4.61227261663736}, 
             Offset[{-3, 0}, {15., 4.61227261663736}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.839555666201707}, 
             Offset[{3, 0}, {16., 4.839555666201707}]}, {{16., 
             4.839555666201707}, 
             Offset[{-3, 0}, {16., 4.839555666201707}]}, {{16., 
             4.616420371730771}, 
             Offset[{3, 0}, {16., 4.616420371730771}]}, {{16., 
             4.616420371730771}, 
             Offset[{-3, 0}, {16., 4.616420371730771}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.850603273937382}, 
             Offset[{3, 0}, {17., 4.850603273937382}]}, {{17., 
             4.850603273937382}, 
             Offset[{-3, 0}, {17., 4.850603273937382}]}, {{17., 
             4.627467979466446}, 
             Offset[{3, 0}, {17., 4.627467979466446}]}, {{17., 
             4.627467979466446}, 
             Offset[{-3, 0}, {17., 4.627467979466446}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.828318855537355}, 
             Offset[{3, 0}, {18., 4.828318855537355}]}, {{18., 
             4.828318855537355}, 
             Offset[{-3, 0}, {18., 4.828318855537355}]}, {{18., 
             4.605183561066419}, 
             Offset[{3, 0}, {18., 4.605183561066419}]}, {{18., 
             4.605183561066419}, 
             Offset[{-3, 0}, {18., 4.605183561066419}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.7806907605610425`}, 
             Offset[{3, 0}, {11., 4.7806907605610425`}]}, {{11., 
             4.7806907605610425`}, 
             Offset[{-3, 0}, {11., 4.7806907605610425`}]}, {{11., 
             4.730434477349388}, 
             Offset[{3, 0}, {11., 4.730434477349388}]}, {{11., 
             4.730434477349388}, 
             Offset[{-3, 0}, {11., 4.730434477349388}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.781205581625509}, 
             Offset[{3, 0}, {12., 4.781205581625509}]}, {{12., 
             4.781205581625509}, 
             Offset[{-3, 0}, {12., 4.781205581625509}]}, {{12., 
             4.730949298413854}, 
             Offset[{3, 0}, {12., 4.730949298413854}]}, {{12., 
             4.730949298413854}, 
             Offset[{-3, 0}, {12., 4.730949298413854}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.779965486698598}, 
             Offset[{3, 0}, {13., 4.779965486698598}]}, {{13., 
             4.779965486698598}, 
             Offset[{-3, 0}, {13., 4.779965486698598}]}, {{13., 
             4.7297092034869435`}, 
             Offset[{3, 0}, {13., 4.7297092034869435`}]}, {{13., 
             4.7297092034869435`}, 
             Offset[{-3, 0}, {13., 4.7297092034869435`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.784269021781553}, 
             Offset[{3, 0}, {14., 4.784269021781553}]}, {{14., 
             4.784269021781553}, 
             Offset[{-3, 0}, {14., 4.784269021781553}]}, {{14., 
             4.7340127385698985`}, 
             Offset[{3, 0}, {14., 4.7340127385698985`}]}, {{14., 
             4.7340127385698985`}, 
             Offset[{-3, 0}, {14., 4.7340127385698985`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.778443929981358}, 
             Offset[{3, 0}, {15., 4.778443929981358}]}, {{15., 
             4.778443929981358}, 
             Offset[{-3, 0}, {15., 4.778443929981358}]}, {{15., 
             4.728187646769704}, 
             Offset[{3, 0}, {15., 4.728187646769704}]}, {{15., 
             4.728187646769704}, 
             Offset[{-3, 0}, {15., 4.728187646769704}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.785624255350539}, 
             Offset[{3, 0}, {16., 4.785624255350539}]}, {{16., 
             4.785624255350539}, 
             Offset[{-3, 0}, {16., 4.785624255350539}]}, {{16., 
             4.735367972138885}, 
             Offset[{3, 0}, {16., 4.735367972138885}]}, {{16., 
             4.735367972138885}, 
             Offset[{-3, 0}, {16., 4.735367972138885}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.783307479145875}, 
             Offset[{3, 0}, {17., 4.783307479145875}]}, {{17., 
             4.783307479145875}, 
             Offset[{-3, 0}, {17., 4.783307479145875}]}, {{17., 
             4.7330511959342205`}, 
             Offset[{3, 0}, {17., 4.7330511959342205`}]}, {{17., 
             4.7330511959342205`}, 
             Offset[{-3, 0}, {17., 4.7330511959342205`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.770956396566554}, 
             Offset[{3, 0}, {18., 4.770956396566554}]}, {{18., 
             4.770956396566554}, 
             Offset[{-3, 0}, {18., 4.770956396566554}]}, {{18., 
             4.7207001133549}, 
             Offset[{3, 0}, {18., 4.7207001133549}]}, {{18., 4.7207001133549}, 
             Offset[{-3, 0}, {18., 4.7207001133549}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.851732975805409}, 
             Offset[{3, 0}, {11., 4.851732975805409}]}, {{11., 
             4.851732975805409}, 
             Offset[{-3, 0}, {11., 4.851732975805409}]}, {{11., 
             4.704814759121777}, 
             Offset[{3, 0}, {11., 4.704814759121777}]}, {{11., 
             4.704814759121777}, 
             Offset[{-3, 0}, {11., 4.704814759121777}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.852421103602623}, 
             Offset[{3, 0}, {12., 4.852421103602623}]}, {{12., 
             4.852421103602623}, 
             Offset[{-3, 0}, {12., 4.852421103602623}]}, {{12., 
             4.705502886918991}, 
             Offset[{3, 0}, {12., 4.705502886918991}]}, {{12., 
             4.705502886918991}, 
             Offset[{-3, 0}, {12., 4.705502886918991}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.847050259354646}, 
             Offset[{3, 0}, {13., 4.847050259354646}]}, {{13., 
             4.847050259354646}, 
             Offset[{-3, 0}, {13., 4.847050259354646}]}, {{13., 
             4.700132042671013}, 
             Offset[{3, 0}, {13., 4.700132042671013}]}, {{13., 
             4.700132042671013}, 
             Offset[{-3, 0}, {13., 4.700132042671013}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.849570676520186}, 
             Offset[{3, 0}, {14., 4.849570676520186}]}, {{14., 
             4.849570676520186}, 
             Offset[{-3, 0}, {14., 4.849570676520186}]}, {{14., 
             4.702652459836553}, 
             Offset[{3, 0}, {14., 4.702652459836553}]}, {{14., 
             4.702652459836553}, 
             Offset[{-3, 0}, {14., 4.702652459836553}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.848361432800496}, 
             Offset[{3, 0}, {15., 4.848361432800496}]}, {{15., 
             4.848361432800496}, 
             Offset[{-3, 0}, {15., 4.848361432800496}]}, {{15., 
             4.701443216116863}, 
             Offset[{3, 0}, {15., 4.701443216116863}]}, {{15., 
             4.701443216116863}, 
             Offset[{-3, 0}, {15., 4.701443216116863}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.840044338663382}, 
             Offset[{3, 0}, {16., 4.840044338663382}]}, {{16., 
             4.840044338663382}, 
             Offset[{-3, 0}, {16., 4.840044338663382}]}, {{16., 
             4.693126121979749}, 
             Offset[{3, 0}, {16., 4.693126121979749}]}, {{16., 
             4.693126121979749}, 
             Offset[{-3, 0}, {16., 4.693126121979749}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.841126331258972}, 
             Offset[{3, 0}, {17., 4.841126331258972}]}, {{17., 
             4.841126331258972}, 
             Offset[{-3, 0}, {17., 4.841126331258972}]}, {{17., 
             4.69420811457534}, 
             Offset[{3, 0}, {17., 4.69420811457534}]}, {{17., 
             4.69420811457534}, 
             Offset[{-3, 0}, {17., 4.69420811457534}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.839406234963529}, 
             Offset[{3, 0}, {18., 4.839406234963529}]}, {{18., 
             4.839406234963529}, 
             Offset[{-3, 0}, {18., 4.839406234963529}]}, {{18., 
             4.692488018279897}, 
             Offset[{3, 0}, {18., 4.692488018279897}]}, {{18., 
             4.692488018279897}, 
             Offset[{-3, 0}, {18., 4.692488018279897}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.805135465938169}, 
             Offset[{3, 0}, {11., 4.805135465938169}]}, {{11., 
             4.805135465938169}, 
             Offset[{-3, 0}, {11., 4.805135465938169}]}, {{11., 
             4.684258933329043}, 
             Offset[{3, 0}, {11., 4.684258933329043}]}, {{11., 
             4.684258933329043}, 
             Offset[{-3, 0}, {11., 4.684258933329043}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.806544388222209}, 
             Offset[{3, 0}, {12., 4.806544388222209}]}, {{12., 
             4.806544388222209}, 
             Offset[{-3, 0}, {12., 4.806544388222209}]}, {{12., 
             4.685667855613083}, 
             Offset[{3, 0}, {12., 4.685667855613083}]}, {{12., 
             4.685667855613083}, 
             Offset[{-3, 0}, {12., 4.685667855613083}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.804661005376628}, 
             Offset[{3, 0}, {13., 4.804661005376628}]}, {{13., 
             4.804661005376628}, 
             Offset[{-3, 0}, {13., 4.804661005376628}]}, {{13., 
             4.683784472767503}, 
             Offset[{3, 0}, {13., 4.683784472767503}]}, {{13., 
             4.683784472767503}, 
             Offset[{-3, 0}, {13., 4.683784472767503}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.804843705148903}, 
             Offset[{3, 0}, {14., 4.804843705148903}]}, {{14., 
             4.804843705148903}, 
             Offset[{-3, 0}, {14., 4.804843705148903}]}, {{14., 
             4.683967172539777}, 
             Offset[{3, 0}, {14., 4.683967172539777}]}, {{14., 
             4.683967172539777}, 
             Offset[{-3, 0}, {14., 4.683967172539777}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.808571970251962}, 
             Offset[{3, 0}, {15., 4.808571970251962}]}, {{15., 
             4.808571970251962}, 
             Offset[{-3, 0}, {15., 4.808571970251962}]}, {{15., 
             4.687695437642836}, 
             Offset[{3, 0}, {15., 4.687695437642836}]}, {{15., 
             4.687695437642836}, 
             Offset[{-3, 0}, {15., 4.687695437642836}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.800390270111044}, 
             Offset[{3, 0}, {16., 4.800390270111044}]}, {{16., 
             4.800390270111044}, 
             Offset[{-3, 0}, {16., 4.800390270111044}]}, {{16., 
             4.679513737501918}, 
             Offset[{3, 0}, {16., 4.679513737501918}]}, {{16., 
             4.679513737501918}, 
             Offset[{-3, 0}, {16., 4.679513737501918}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.817516104526997}, 
             Offset[{3, 0}, {17., 4.817516104526997}]}, {{17., 
             4.817516104526997}, 
             Offset[{-3, 0}, {17., 4.817516104526997}]}, {{17., 
             4.6966395719178715`}, 
             Offset[{3, 0}, {17., 4.6966395719178715`}]}, {{17., 
             4.6966395719178715`}, 
             Offset[{-3, 0}, {17., 4.6966395719178715`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.789585555143577}, 
             Offset[{3, 0}, {18., 4.789585555143577}]}, {{18., 
             4.789585555143577}, 
             Offset[{-3, 0}, {18., 4.789585555143577}]}, {{18., 
             4.668709022534451}, 
             Offset[{3, 0}, {18., 4.668709022534451}]}, {{18., 
             4.668709022534451}, 
             Offset[{-3, 0}, {18., 4.668709022534451}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.787244974335195}, 
             Offset[{3, 0}, {11., 4.787244974335195}]}, {{11., 
             4.787244974335195}, 
             Offset[{-3, 0}, {11., 4.787244974335195}]}, {{11., 
             4.649767232767493}, 
             Offset[{3, 0}, {11., 4.649767232767493}]}, {{11., 
             4.649767232767493}, 
             Offset[{-3, 0}, {11., 4.649767232767493}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.787955259645461}, 
             Offset[{3, 0}, {12., 4.787955259645461}]}, {{12., 
             4.787955259645461}, 
             Offset[{-3, 0}, {12., 4.787955259645461}]}, {{12., 
             4.650477518077759}, 
             Offset[{3, 0}, {12., 4.650477518077759}]}, {{12., 
             4.650477518077759}, 
             Offset[{-3, 0}, {12., 4.650477518077759}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.791522574816751}, 
             Offset[{3, 0}, {13., 4.791522574816751}]}, {{13., 
             4.791522574816751}, 
             Offset[{-3, 0}, {13., 4.791522574816751}]}, {{13., 
             4.654044833249049}, 
             Offset[{3, 0}, {13., 4.654044833249049}]}, {{13., 
             4.654044833249049}, 
             Offset[{-3, 0}, {13., 4.654044833249049}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.793129944143733}, 
             Offset[{3, 0}, {14., 4.793129944143733}]}, {{14., 
             4.793129944143733}, 
             Offset[{-3, 0}, {14., 4.793129944143733}]}, {{14., 
             4.655652202576031}, 
             Offset[{3, 0}, {14., 4.655652202576031}]}, {{14., 
             4.655652202576031}, 
             Offset[{-3, 0}, {14., 4.655652202576031}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.8006846414404105`}, 
             Offset[{3, 0}, {15., 4.8006846414404105`}]}, {{15., 
             4.8006846414404105`}, 
             Offset[{-3, 0}, {15., 4.8006846414404105`}]}, {{15., 
             4.6632068998727085`}, 
             Offset[{3, 0}, {15., 4.6632068998727085`}]}, {{15., 
             4.6632068998727085`}, 
             Offset[{-3, 0}, {15., 4.6632068998727085`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.802680267206667}, 
             Offset[{3, 0}, {16., 4.802680267206667}]}, {{16., 
             4.802680267206667}, 
             Offset[{-3, 0}, {16., 4.802680267206667}]}, {{16., 
             4.665202525638965}, 
             Offset[{3, 0}, {16., 4.665202525638965}]}, {{16., 
             4.665202525638965}, 
             Offset[{-3, 0}, {16., 4.665202525638965}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.798015639539124}, 
             Offset[{3, 0}, {17., 4.798015639539124}]}, {{17., 
             4.798015639539124}, 
             Offset[{-3, 0}, {17., 4.798015639539124}]}, {{17., 
             4.660537897971422}, 
             Offset[{3, 0}, {17., 4.660537897971422}]}, {{17., 
             4.660537897971422}, 
             Offset[{-3, 0}, {17., 4.660537897971422}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.806215870593736}, 
             Offset[{3, 0}, {18., 4.806215870593736}]}, {{18., 
             4.806215870593736}, 
             Offset[{-3, 0}, {18., 4.806215870593736}]}, {{18., 
             4.668738129026034}, 
             Offset[{3, 0}, {18., 4.668738129026034}]}, {{18., 
             4.668738129026034}, 
             Offset[{-3, 0}, {18., 4.668738129026034}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.863346007346718}, 
             Offset[{3, 0}, {11., 4.863346007346718}]}, {{11., 
             4.863346007346718}, 
             Offset[{-3, 0}, {11., 4.863346007346718}]}, {{11., 
             4.627811563145312}, 
             Offset[{3, 0}, {11., 4.627811563145312}]}, {{11., 
             4.627811563145312}, 
             Offset[{-3, 0}, {11., 4.627811563145312}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.864570098855275}, 
             Offset[{3, 0}, {12., 4.864570098855275}]}, {{12., 
             4.864570098855275}, 
             Offset[{-3, 0}, {12., 4.864570098855275}]}, {{12., 
             4.629035654653869}, 
             Offset[{3, 0}, {12., 4.629035654653869}]}, {{12., 
             4.629035654653869}, 
             Offset[{-3, 0}, {12., 4.629035654653869}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.859458547831065}, 
             Offset[{3, 0}, {13., 4.859458547831065}]}, {{13., 
             4.859458547831065}, 
             Offset[{-3, 0}, {13., 4.859458547831065}]}, {{13., 
             4.623924103629659}, 
             Offset[{3, 0}, {13., 4.623924103629659}]}, {{13., 
             4.623924103629659}, 
             Offset[{-3, 0}, {13., 4.623924103629659}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.860390521032923}, 
             Offset[{3, 0}, {14., 4.860390521032923}]}, {{14., 
             4.860390521032923}, 
             Offset[{-3, 0}, {14., 4.860390521032923}]}, {{14., 
             4.6248560768315174`}, 
             Offset[{3, 0}, {14., 4.6248560768315174`}]}, {{14., 
             4.6248560768315174`}, 
             Offset[{-3, 0}, {14., 4.6248560768315174`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.862444120104712}, 
             Offset[{3, 0}, {15., 4.862444120104712}]}, {{15., 
             4.862444120104712}, 
             Offset[{-3, 0}, {15., 4.862444120104712}]}, {{15., 
             4.626909675903306}, 
             Offset[{3, 0}, {15., 4.626909675903306}]}, {{15., 
             4.626909675903306}, 
             Offset[{-3, 0}, {15., 4.626909675903306}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.871168631303634}, 
             Offset[{3, 0}, {16., 4.871168631303634}]}, {{16., 
             4.871168631303634}, 
             Offset[{-3, 0}, {16., 4.871168631303634}]}, {{16., 
             4.635634187102228}, 
             Offset[{3, 0}, {16., 4.635634187102228}]}, {{16., 
             4.635634187102228}, 
             Offset[{-3, 0}, {16., 4.635634187102228}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.860249733429234}, 
             Offset[{3, 0}, {17., 4.860249733429234}]}, {{17., 
             4.860249733429234}, 
             Offset[{-3, 0}, {17., 4.860249733429234}]}, {{17., 
             4.6247152892278285`}, 
             Offset[{3, 0}, {17., 4.6247152892278285`}]}, {{17., 
             4.6247152892278285`}, 
             Offset[{-3, 0}, {17., 4.6247152892278285`}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.855539494787659}, 
             Offset[{3, 0}, {18., 4.855539494787659}]}, {{18., 
             4.855539494787659}, 
             Offset[{-3, 0}, {18., 4.855539494787659}]}, {{18., 
             4.620005050586253}, 
             Offset[{3, 0}, {18., 4.620005050586253}]}, {{18., 
             4.620005050586253}, 
             Offset[{-3, 0}, {18., 4.620005050586253}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{11., 4.7806594780241545`}, 
             Offset[{3, 0}, {11., 4.7806594780241545`}]}, {{11., 
             4.7806594780241545`}, 
             Offset[{-3, 0}, {11., 4.7806594780241545`}]}, {{11., 
             4.683689478093638}, 
             Offset[{3, 0}, {11., 4.683689478093638}]}, {{11., 
             4.683689478093638}, 
             Offset[{-3, 0}, {11., 4.683689478093638}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{12., 4.780786953409599}, 
             Offset[{3, 0}, {12., 4.780786953409599}]}, {{12., 
             4.780786953409599}, 
             Offset[{-3, 0}, {12., 4.780786953409599}]}, {{12., 
             4.683816953479083}, 
             Offset[{3, 0}, {12., 4.683816953479083}]}, {{12., 
             4.683816953479083}, 
             Offset[{-3, 0}, {12., 4.683816953479083}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{13., 4.781942459340701}, 
             Offset[{3, 0}, {13., 4.781942459340701}]}, {{13., 
             4.781942459340701}, 
             Offset[{-3, 0}, {13., 4.781942459340701}]}, {{13., 
             4.684972459410185}, 
             Offset[{3, 0}, {13., 4.684972459410185}]}, {{13., 
             4.684972459410185}, 
             Offset[{-3, 0}, {13., 4.684972459410185}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{14., 4.782228222471935}, 
             Offset[{3, 0}, {14., 4.782228222471935}]}, {{14., 
             4.782228222471935}, 
             Offset[{-3, 0}, {14., 4.782228222471935}]}, {{14., 
             4.685258222541418}, 
             Offset[{3, 0}, {14., 4.685258222541418}]}, {{14., 
             4.685258222541418}, 
             Offset[{-3, 0}, {14., 4.685258222541418}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{15., 4.787366773884986}, 
             Offset[{3, 0}, {15., 4.787366773884986}]}, {{15., 
             4.787366773884986}, 
             Offset[{-3, 0}, {15., 4.787366773884986}]}, {{15., 
             4.690396773954469}, 
             Offset[{3, 0}, {15., 4.690396773954469}]}, {{15., 
             4.690396773954469}, 
             Offset[{-3, 0}, {15., 4.690396773954469}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{16., 4.78535337268339}, 
             Offset[{3, 0}, {16., 4.78535337268339}]}, {{16., 
             4.78535337268339}, 
             Offset[{-3, 0}, {16., 4.78535337268339}]}, {{16., 
             4.688383372752873}, 
             Offset[{3, 0}, {16., 4.688383372752873}]}, {{16., 
             4.688383372752873}, 
             Offset[{-3, 0}, {16., 4.688383372752873}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{17., 4.785518426509391}, 
             Offset[{3, 0}, {17., 4.785518426509391}]}, {{17., 
             4.785518426509391}, 
             Offset[{-3, 0}, {17., 4.785518426509391}]}, {{17., 
             4.688548426578874}, 
             Offset[{3, 0}, {17., 4.688548426578874}]}, {{17., 
             4.688548426578874}, 
             Offset[{-3, 0}, {17., 4.688548426578874}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[1, 0.75, 0]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{18., 4.776556591864061}, 
             Offset[{3, 0}, {18., 4.776556591864061}]}, {{18., 
             4.776556591864061}, 
             Offset[{-3, 0}, {18., 4.776556591864061}]}, {{18., 
             4.679586591933544}, 
             Offset[{3, 0}, {18., 4.679586591933544}]}, {{18., 
             4.679586591933544}, 
             Offset[{-3, 0}, {18., 4.679586591933544}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]}}}}, {{{
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.753449838496273}, {12., 4.754450411574153}, {13., 
         4.753234444783022}, {14., 4.761781176368598}, {15., 
         4.755327815114116}, {16., 4.757791245846421}, {17., 
         4.75432586921161}, {18., 4.770937670276252}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.715467009873206}, {12., 4.717097849544775}, {13., 
         4.721579025551485}, {14., 4.720196861602447}, {15., 
         4.723840263872828}, {16., 4.727988018966239}, {17., 
         4.739035626701914}, {18., 4.716751208301887}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.755562618955215}, {12., 4.7560774400196815`}, {13., 
         4.754837345092771}, {14., 4.759140880175726}, {15., 
         4.753315788375531}, {16., 4.760496113744712}, {17., 
         4.758179337540048}, {18., 4.745828254960727}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.778273867463593}, {12., 4.778961995260807}, {13., 
         4.7735911510128295`}, {14., 4.7761115681783695`}, {15., 
         4.7749023244586795`}, {16., 4.7665852303215654`}, {17., 
         4.767667222917156}, {18., 4.765947126621713}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.744697199633606}, {12., 4.746106121917646}, {13., 
         4.7442227390720655`}, {14., 4.74440543884434}, {15., 
         4.748133703947399}, {16., 4.739952003806481}, {17., 
         4.757077838222434}, {18., 4.729147288839014}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.718506103551344}, {12., 4.71921638886161}, {13., 
         4.7227837040329}, {14., 4.724391073359882}, {15., 
         4.7319457706565595`}, {16., 4.733941396422816}, {17., 
         4.729276768755273}, {18., 4.737476999809885}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.745578785246015}, {12., 4.746802876754572}, {13., 
         4.741691325730362}, {14., 4.74262329893222}, {15., 
         4.744676898004009}, {16., 4.753401409202931}, {17., 
         4.742482511328531}, {18., 4.737772272686956}}]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[1.6]], 
        PointBox[{{11., 4.732174478058896}, {12., 4.732301953444341}, {13., 
         4.733457459375443}, {14., 4.733743222506677}, {15., 
         4.7388817739197275`}, {16., 4.736868372718131}, {17., 
         4.737033426544133}, {18., 4.728071591898803}}]}}, {{
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[
         1.6]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox[
        SuperscriptBox["2", "x"], TraditionalForm], 
       FormBox[
        SubscriptBox["d", "H"], TraditionalForm]}, 
     AxesOrigin -> {10.854166666666668`, 4.711939510685006}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0, 0}, {4.762724017352581, 4.801162315703667, 
       4.761582208930644, 4.781385397679151, 4.813011105078474, 
       4.894950765525675, 4.935623714725309, 4.862219974558272}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{10.854166666666668`, 18.}, {4.711939510685006, 
      4.778961995260807}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {{{11, 
         FormBox["11", TraditionalForm]}, {12, 
         FormBox["12", TraditionalForm]}, {13, 
         FormBox["13", TraditionalForm]}, {14, 
         FormBox["14", TraditionalForm]}, {15, 
         FormBox["15", TraditionalForm]}, {16, 
         FormBox["16", TraditionalForm]}, {17, 
         FormBox["17", TraditionalForm]}, {18, 
         FormBox["18", TraditionalForm]}}, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"a", "b", "c", "d", "e", "f", "g", "h"}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.75, 0], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #8}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.772079`", ",", "0.431554`", ",", "0.102387`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.363898, 0.618501, 0.782349], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.24259866666666668`, 0.412334, 0.521566], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.363898`", ",", "0.618501`", ",", "0.782349`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.363898, 0.618501, 0.782349]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.363898, 0.618501, 0.782349], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.75, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0.5, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.75`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.75, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.75, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "False", ",", "False", ",", "False", ",", "False", ",", 
                 "False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.812796782374979*^9, 3.812797491755533*^9, 3.812797862546385*^9, {
   3.812798392941297*^9, 3.812798408669777*^9}, 3.812799216843869*^9, {
   3.812799466442729*^9, 3.812799477261676*^9}, 3.81279975207369*^9, {
   3.813323945736116*^9, 3.813323952132827*^9}, 3.813324536852858*^9, {
   3.813404096658668*^9, 3.813404104264806*^9}, {3.813571606077394*^9, 
   3.813571621728977*^9}, {3.813650831511335*^9, 3.813650838332032*^9}, 
   3.8139127434554987`*^9, {3.814177929515377*^9, 3.814177936709586*^9}, {
   3.8147811775358343`*^9, 3.814781182219974*^9}, {3.815912738462613*^9, 
   3.815912741969459*^9}, 3.8202281276381903`*^9, 3.8336092245110188`*^9, 
   3.867320471088861*^9, 3.867320617468533*^9, 3.8673212043269672`*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"3c416941-729f-4a70-8a35-fead9accaa57"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1248, 762},
WindowMargins->{{Automatic, 56}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 453, 8, 69, "Text",ExpressionUUID->"a2f50c5e-5bcb-49ba-abe4-29bf7c75ddf1"],
Cell[1014, 30, 4760, 128, 401, "Input",ExpressionUUID->"c733e1bc-43f9-4833-9713-88cb864c0175"],
Cell[5777, 160, 1589, 40, 233, "Input",ExpressionUUID->"74106458-cb39-48e5-8ab4-3b0fd48c82b7"],
Cell[7369, 202, 1223, 33, 202, "Input",ExpressionUUID->"dcb28844-6d0d-43fb-8df3-86495089fccc"],
Cell[CellGroupData[{
Cell[8617, 239, 269, 4, 67, "Subsubsection",ExpressionUUID->"d0b1bb97-3f8f-492c-88d6-1f3d201da664"],
Cell[CellGroupData[{
Cell[8911, 247, 3020, 73, 202, "Input",ExpressionUUID->"1f49fab2-86c5-433d-ada6-b2b76369bd09"],
Cell[11934, 322, 136579, 2265, 351, "Output",ExpressionUUID->"b22dc400-2ffd-4e52-a1e6-7637a0fc2aaf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[148562, 2593, 164, 3, 67, "Subsubsection",ExpressionUUID->"5bb7ab99-35df-4644-afa3-b4a0d373b7de"],
Cell[CellGroupData[{
Cell[148751, 2600, 4067, 84, 295, "Input",ExpressionUUID->"79dcd6cb-0013-4e82-97d1-760cfbed61c0"],
Cell[152821, 2686, 55056, 1123, 375, "Output",ExpressionUUID->"3232afe0-7789-47e1-9e45-8a090309d680"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[207926, 3815, 224, 4, 68, "Subsubsection",ExpressionUUID->"196e456e-fba0-4577-aed4-fedc692ab272"],
Cell[208153, 3821, 3364, 80, 237, "Input",ExpressionUUID->"15b2fc5c-9e48-4b9f-a354-a0ec18d3e082"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211554, 3906, 156, 3, 81, "Subsection",ExpressionUUID->"e885cef6-58bc-4222-a801-999f1b5c3535"],
Cell[CellGroupData[{
Cell[211735, 3913, 3850, 90, 301, "Input",ExpressionUUID->"250edcf0-dea7-48e7-8db8-c6e1e01e6edf"],
Cell[215588, 4005, 1617, 26, 51, "Output",ExpressionUUID->"81c90c77-dabf-4976-a01f-8955facf44c8"]
}, Open  ]],
Cell[217220, 4034, 3872, 102, 332, "Input",ExpressionUUID->"1703cb29-6cf1-4b01-bd03-33c7aeb367e3"],
Cell[221095, 4138, 130, 3, 45, "Input",ExpressionUUID->"c214a0e8-4abf-443f-89b2-ea0c1e3ca669"],
Cell[CellGroupData[{
Cell[221250, 4145, 3152, 80, 261, "Input",ExpressionUUID->"d8324816-946b-489b-b962-7be51fb1b298"],
Cell[224405, 4227, 40285, 846, 366, "Output",ExpressionUUID->"d27141ff-8da8-4d48-8d42-f75305b2f2f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264727, 5078, 282, 5, 67, "Subsubsection",ExpressionUUID->"1642f197-58b0-4b03-a4c2-f8afba1c61b9",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[265012, 5085, 9431, 230, 640, "Input",ExpressionUUID->"c1aeaebd-a16e-41ce-9ac6-991908d0382b",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[274446, 5317, 2539, 40, 34, "Message",ExpressionUUID->"45910635-fbe5-4122-8793-e4d5712399ec",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[276988, 5359, 2544, 40, 41, "Message",ExpressionUUID->"c4f0c11c-a3d7-434a-a084-bb58f3377f72",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[279535, 5401, 2543, 40, 41, "Message",ExpressionUUID->"13da8371-f073-489e-be95-e8f091393a09",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[282081, 5443, 2588, 40, 41, "Message",ExpressionUUID->"181c58d7-1bb8-4b4b-885f-1910e72453f7",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[284672, 5485, 2529, 39, 51, "Output",ExpressionUUID->"886e9bee-05c2-43ac-b07c-aa8aca80a3e1",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[287204, 5526, 2543, 39, 51, "Output",ExpressionUUID->"a56e70ae-e62d-455e-9c1b-d6f9421e2d8d",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[289750, 5567, 4456, 105, 254, "Input",ExpressionUUID->"d9b78150-5743-428d-8601-369d7611b549",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[294209, 5674, 35827, 706, 359, "Output",ExpressionUUID->"6aaaa642-c796-4cd8-bab6-9db59087c5b6",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[330039, 6382, 5202, 148, 389, "Input",ExpressionUUID->"0013fd79-592e-4027-ba0a-64f09882d31f",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[335244, 6532, 1079, 20, 34, "Message",ExpressionUUID->"45ee7b2e-21a3-42b8-b4c7-dae3f0869556",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[336326, 6554, 1079, 20, 34, "Message",ExpressionUUID->"248f103b-8443-4b09-ae7d-2301a4250719",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[337408, 6576, 1081, 20, 34, "Message",ExpressionUUID->"0b3b14ef-41dc-49ba-a315-fa0d1001f5c0",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[338492, 6598, 1119, 20, 34, "Message",ExpressionUUID->"97bff93c-3d0f-4828-946e-59b9b29381d4",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[339614, 6620, 3550, 91, 286, "Input",ExpressionUUID->"7df2f5b2-63f4-4dce-a6b3-188bc00d2d0b",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[343167, 6713, 30283, 615, 359, "Output",ExpressionUUID->"1ac87bc5-d0a6-4e7d-bbc6-be2e75546815",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[373453, 7330, 5619, 153, 389, "Input",ExpressionUUID->"2889b2f0-1c84-4253-9c0e-c8d467af6f36",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[379075, 7485, 1106, 20, 34, "Message",ExpressionUUID->"8fd7224d-201b-4cba-bf45-dae4e05b33b6",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[380184, 7507, 1104, 20, 34, "Message",ExpressionUUID->"8a8a6382-8d7f-41b9-be39-73f05de95d20",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[381291, 7529, 1106, 20, 34, "Message",ExpressionUUID->"7ae527bd-c0ca-4b8e-a427-27bd0046e696",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[382400, 7551, 1147, 20, 34, "Message",ExpressionUUID->"1449b36a-98c9-4f70-a4d4-326765fc3ea0",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[383550, 7573, 3680, 93, 295, "Input",ExpressionUUID->"b85bb17e-c3b2-4470-8c3c-ee70797ee6ab",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[387233, 7668, 30398, 616, 359, "Output",ExpressionUUID->"b080f3a0-b747-4ef6-86b0-d082ee480149",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[417668, 8289, 165, 3, 67, "Subsubsection",ExpressionUUID->"a69c5d58-85f4-4caf-9064-7d7ddc5c4d7f"],
Cell[CellGroupData[{
Cell[417858, 8296, 10232, 272, 605, "Input",ExpressionUUID->"50ef0e17-9d61-4e51-9a60-57107c0a8e86"],
Cell[428093, 8570, 64672, 1283, 352, "Output",ExpressionUUID->"d9465db0-5aa3-484b-a543-aa454870da62"]
}, Open  ]],
Cell[CellGroupData[{
Cell[492802, 9858, 1712, 36, 78, "Input",ExpressionUUID->"1f4956af-b90a-4d42-a6b9-83fbf8729819"],
Cell[494517, 9896, 2612, 66, 154, "Output",ExpressionUUID->"5a2cda40-af39-4d36-9eeb-17eff84ca1c1"]
}, Open  ]],
Cell[497144, 9965, 294, 7, 46, "Input",ExpressionUUID->"a38bfbda-6efd-41ad-90c7-32be10e9a66a"],
Cell[CellGroupData[{
Cell[497463, 9976, 298, 6, 46, "Input",ExpressionUUID->"835423ed-de20-460f-94e3-b7a752634b65"],
Cell[497764, 9984, 340, 7, 52, "Output",ExpressionUUID->"076a03ba-1312-489b-8827-a2cd9eceb74a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[498141, 9996, 2824, 70, 146, "Input",ExpressionUUID->"4882de0e-1c15-4107-a40a-de35bb816d5b"],
Cell[500968, 10068, 102169, 2101, 366, "Output",ExpressionUUID->"3c416941-729f-4a70-8a35-fead9accaa57"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

