********************************************************************************
*
*						Table A9 - Replication
*
********************************************************************************


***********************************************
* BASELINE SPECIFICATIONS WITH ALTERNATIVE DEFINITIONS OF CTR WORKERS 
***********************************************


*-------------------------------------------------------------------------------
*					    Columns 1 and 4 
*-------------------------------------------------------------------------------


use  "${data}\baseline_panel.dta", clear


*Keep imprese open thoughout the period
drop if sample_period_p_ft!= $sample_period 


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp
gen treat_norm2 = dyear_2_firm_ft_p/bl_emp
gen treat_norm4 = dyear_4_firm_ft_p/bl_emp
gen treat_norm5 = dyear_5_firm_ft_p/bl_emp 

*gen treat interaction
replace treat_norm = 0 if treat_norm == .
replace treat_norm2 = 0 if treat_norm2 == .
replace treat_norm4 = 0 if treat_norm4 == .
replace treat_norm5 = 0 if treat_norm5 == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm
gen treat_post2 = post*treat_norm2
gen treat_post4 = post*treat_norm4
gen treat_post5 = post*treat_norm5

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7 


*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global out_did cambiamento_medio 


*With baseline controls
foreach ss in 2 4 5 {
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach q in ft_p {
foreach y of global out_did {


	reghdfe `y'_`q' treat_post`ss' if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline} )  vce(cluster codice_fiscale)
	estimates store Ec`sr'`q'`ss'`y'
	
	sum `y'_`q' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y'_`q' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm`ss' if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}
}

	global aff_sample & aff_`ss'_firm_ft_p>0 & aff_`ss'_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}
}




*** gen tables
#delimit ;
	estout Ecft_p2cambiamento_medio Ec_srft_p2cambiamento_medio Ecft_p4cambiamento_medio Ec_srft_p4cambiamento_medio Ecft_p5cambiamento_medio Ec_srft_p5cambiamento_medio
	using "${directory_out}\table_app_9_col_1_4.tex", replace style(tex) label
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr
estimates clear



*-------------------------------------------------------------------------------
*					    Columns 2, 3, 5, and 6 
*-------------------------------------------------------------------------------


use "${data}\baseline_panel.dta", clear


*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\emp_by_qual.dta", keepusing(emp_bc_2011 emp_wc_2011 emp_mng_2011)
drop if _merge == 2
drop _merge

*flags for at least two units
gen flag_sample_wc = (emp_bc_2011>0 & emp_wc_2011>0)
gen flag_sample_mng = ((emp_bc_2011>0 & emp_mng_2011>0) | (emp_wc_2011>0 & emp_mng_2011>0)) 


*Keep imprese open thoughout the period
drop if sample_period_p_ft != $sample_period 

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)


*gen treatment normalized
foreach i in 2 4 5 {
gen treat_norm_bc`i' = dyear_`i'_firm_bc_ft_p/bl_emp
gen treat_norm_wc`i' = dyear_`i'_firm_wc_ft_p/bl_emp 
gen treat_norm_mng`i' = dyear_`i'_firm_mng_ft_p/bl_emp 
gen treat_norm_bcwc`i' = (dyear_`i'_firm_bc_ft_p + dyear_`i'_firm_wc_ft_p)/bl_emp 
}

*gen treat interaction
foreach s in 2 4 5 {
replace treat_norm_bc`s'   = 0  if treat_norm_bc`s' == .
replace treat_norm_wc`s'   = 0  if treat_norm_wc`s' == .
replace treat_norm_mng`s'  = 0  if treat_norm_mng`s' == .
replace treat_norm_bcwc`s' = 0 if treat_norm_bcwc`s' == .

gen dpost_bc`s'    = post*treat_norm_bc`s'
gen dpost_wc`s'    = post*treat_norm_wc`s'
gen dpost_bcwc`s'  = post*treat_norm_bcwc`s'
gen dpost_mng`s'   = post*treat_norm_mng`s'
}

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_post_wc2 dpost_bc2 dpost_wc2
global treat_post_mng2 dpost_bcwc2 dpost_mng2
global treat_post_wc4 dpost_bc4 dpost_wc4
global treat_post_mng4 dpost_bcwc4 dpost_mng4
global treat_post_wc5 dpost_bc5 dpost_wc5
global treat_post_mng5 dpost_bcwc5 dpost_mng5


*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global out_wc      up_qualifica_wc_naf_ft_p 
global out_mng     up_qualifica_dir_naf_ft_p 
global out_did_wc  up_qualifica_wc_naf
global out_did_mng up_qualifica_dir_naf


foreach ss in 2 4 5 {

local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample}
local sample_restr 

forvalues i = 1(1)2 {   //with and without sample restriction

  foreach q in ft_p {
  foreach var in wc mng {

   global qual `var'

   local counter=0

   foreach y of global out_did_`var' {


	reghdfe `y'_`q' ${treat_post_`var'`ss'} if `sample_reg' & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1   ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	estimates store Ec`sample_restr'`q'`var'`ss'
	
	
	*test inequality between coeff
	if "`var'" == "wc" {
		test dpost_wc`ss' - dpost_bc`ss' = 0 
		local sign = sign(_b[dpost_wc`ss']-_b[dpost_bc`ss'])
		estadd local pval_wc = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	if "`var'" == "mng" {
		test dpost_mng`ss' - dpost_bcwc`ss' = 0 
		local sign = sign(_b[dpost_mng`ss']-_b[dpost_bcwc`ss'])
		estadd local pval_mng = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	
	global nobs = e(N)
					
								
	sum `y'_`q' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y'_`q' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	
	bys codice_fiscale: gen cc_firm = 1
	sum treat_norm_bc`ss' if e(sample) & cc_firm == 1
	estadd local sd_bc = round(r(sd), 0.01) 
	estadd local mean_bc = round(r(mean), 0.01)
	sum treat_norm_wc`ss' if e(sample) & cc_firm == 1
	estadd local sd_wc = round(r(sd), 0.01) 
	estadd local mean_wc = round(r(mean), 0.01)
	sum treat_norm_mng`ss' if e(sample) & cc_firm == 1
	estadd local sd_mng = round(r(sd), 0.01) 
	estadd local mean_mng = round(r(mean), 0.01)
	sum treat_norm_bcwc`ss' if e(sample) & cc_firm == 1
	estadd local sd_bcwc = round(r(sd), 0.01) 
	estadd local mean_bcwc = round(r(mean), 0.01)
	drop cc_firm
	
	estadd local controls "Yes"
	
}

}
}

	local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & aff_`ss'_firm_ft_p>0 & aff_`ss'_firm_ft_p!=. & ${reducing_sample}
	local sample_restr _sr

}
}



*** Gen tables
	
foreach q in ft_p {

	#delimit ;
	estout Ec`q'wc2 Ec`q'mng2 Ec_sr`q'wc2 Ec_sr`q'mng2 Ec`q'wc4 Ec`q'mng4 Ec_sr`q'wc4 Ec_sr`q'mng4 Ec`q'wc5 Ec`q'mng5 Ec_sr`q'wc5 Ec_sr`q'mng5 
	using "${directory_out}\table_app_9_col_2_3_5_6.tex", replace style(tex) label
	keep(dpost_bc2 dpost_wc2 dpost_mng2 dpost_bcwc2 dpost_bc4 dpost_wc4 dpost_mng4 dpost_bcwc4 dpost_bc5 dpost_wc5 dpost_mng5 dpost_bcwc5)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue and White Collar" "Treatment SD Blue and White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue and White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC and WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr
	
}





