********************************************************************************
*
*						Table A8 - Replication
*
********************************************************************************


***********************************************
* BASELINE SPECIFICATIONS WITH ALL NON-CTR WORKERS (NOT ONLY FULLTIME PERMANENT) 
***********************************************

use  "${data}\baseline_panel.dta", clear


merge 1:1 codice_fiscale anno_riferimento using "${data}\ow_all_REV2.dta"
drop _merge


*Keep imprese open thoughout the period
drop if sample_period_p_ft!= $sample_period


#delimit;
global out cambiamento_medio_all ; 
   
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7 
     

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale



*-------------------------------------------------------------------------------
*					    Columns 1 and 4 
*-------------------------------------------------------------------------------


global out_did cambiamento_medio 
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach q in all {
foreach y of global out_did {


	reghdfe `y'_`q' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	estimates store Ec`sr'`q'`y'
	
	sum `y'_`q' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y'_`q' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables
#delimit ;
	estout Ecallcambiamento_medio Ec_srallcambiamento_medio
	using "${directory_out}\table_app_8_col_1_4.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr
estimates clear



*-------------------------------------------------------------------------------
*					    Columns 2, 3, 5, and 6 
*-------------------------------------------------------------------------------

use "${data}\baseline_panel.dta", clear


merge 1:1 codice_fiscale anno_riferimento using "${data}\ow_all_REV2.dta"
drop _merge


*Keep imprese open thoughout the period
drop if sample_period_p_ft != $sample_period 

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)


*gen treatment normalized
gen treat_norm_bc = dyear_${sample}_firm_bc_ft_p/bl_emp
gen treat_norm_wc = dyear_${sample}_firm_wc_ft_p/bl_emp
gen treat_norm_mng = dyear_${sample}_firm_mng_ft_p/bl_emp
gen treat_norm_bcwc = (dyear_${sample}_firm_bc_ft_p + dyear_${sample}_firm_wc_ft_p)/bl_emp

*gen treat interaction
replace treat_norm_bc   = 0  if treat_norm_bc == .
replace treat_norm_wc   = 0  if treat_norm_wc == .
replace treat_norm_mng  = 0  if treat_norm_mng == .
replace treat_norm_bcwc = 0 if treat_norm_bcwc == .
forvalues i = 1(1)7 {
		gen d`i'_bc = t`i' * treat_norm_bc
		gen d`i'_wc = t`i' * treat_norm_wc
		gen d`i'_mng = t`i' * treat_norm_mng
		gen d`i'_bcwc = t`i' * treat_norm_bcwc
}
gen dpost_bc    = post*treat_norm_bc
gen dpost_wc    = post*treat_norm_wc
gen dpost_bcwc  = post*treat_norm_bcwc
gen dpost_mng   = post*treat_norm_mng

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list_wc d1_bc d2_bc d4_bc d5_bc d6_bc d7_bc d1_wc d2_wc d4_wc d5_wc d6_wc d7_wc 
global treat_list_mng d1_bcwc d2_bcwc d4_bcwc d5_bcwc d6_bcwc d7_bcwc d1_mng d2_mng d4_mng d5_mng d6_mng d7_mng 
global treat_post_wc dpost_bc dpost_wc
global treat_post_mng dpost_bcwc dpost_mng
 

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global out_wc      up_qualifica_wc_naf_all 
global out_mng     up_qualifica_dir_naf_all 
global out_did_wc  up_qualifica_wc_naf
global out_did_mng up_qualifica_dir_naf



local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample}
local sample_restr 

forvalues i = 1(1)2 {   //with and without sample restriction

  foreach q in all {
  foreach var in wc mng {

   global qual `var'

   local counter=0

   foreach y of global out_did_`var' {


	reghdfe `y'_`q' ${treat_post_`var'} if `sample_reg' & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1  ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	estimates store Ec`sample_restr'`q'`var'
	
	
	*test inequality between coeff
	if "`var'" == "wc" {
		test dpost_wc - dpost_bc = 0 
		local sign = sign(_b[dpost_wc]-_b[dpost_bc])
		estadd local pval_wc = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	if "`var'" == "mng" {
		test dpost_mng - dpost_bcwc = 0 
		local sign = sign(_b[dpost_mng]-_b[dpost_bcwc])
		estadd local pval_mng = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	
	global nobs = e(N)
					
								
	sum `y'_`q' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y'_`q' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	
	bys codice_fiscale: gen cc_firm = 1
	sum treat_norm_bc if e(sample) & cc_firm == 1
	estadd local sd_bc = round(r(sd), 0.01) 
	estadd local mean_bc = round(r(mean), 0.01)
	sum treat_norm_wc if e(sample) & cc_firm == 1
	estadd local sd_wc = round(r(sd), 0.01) 
	estadd local mean_wc = round(r(mean), 0.01)
	sum treat_norm_mng if e(sample) & cc_firm == 1
	estadd local sd_mng = round(r(sd), 0.01) 
	estadd local mean_mng = round(r(mean), 0.01)
	sum treat_norm_bcwc if e(sample) & cc_firm == 1
	estadd local sd_bcwc = round(r(sd), 0.01) 
	estadd local mean_bcwc = round(r(mean), 0.01)
	drop cc_firm
	
	estadd local controls "Yes"
	
}

}
}

	local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. & ${reducing_sample}
	local sample_restr _sr

}




*** Gen tables
	

#delimit ;
	estout Ecallwc Ecallmng Ec_srallwc Ec_srallmng 
	using "${directory_out}\table_app_8_col_2_3_5_6.tex", replace style(tex) label
	keep(dpost_bc dpost_wc dpost_mng dpost_bcwc)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue and White Collar" "Treatment SD Blue and White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue and White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC and WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr

estimates clear





 
