********************************************************************************
*
*						Table A7 - Replication
*
********************************************************************************


***********************************************
* BASELINE SPECIFICATIONS WITH ALTERNATIVE CONTROLS    
***********************************************

use  "${data}\baseline_panel.dta", clear


*merge ctr variables
merge m:1 codice_fiscale using "${data}\ctr_controls.dta"
drop if _merge == 2
drop _merge
replace bl_age_ctr = 0 if bl_age_ctr==.
replace bl_contributi_ctr = 0 if bl_contributi_ctr==.
replace bl_male_ctr = 0 if bl_male_ctr==.
*assign values to bins 
qui sum bl_sh_emp_bin_num
global bl_sh_emp_bin_num = r(mean)
forvalues i = 1(1)$bl_sh_emp_bin_num {
	replace bl_sh_emp_bin`i' = 0 if bl_sh_emp_bin`i' == .  
}


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7


#delimit;
global out cambiamento_medio_ft_p  ;
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp 

*gen share ctr
gen sh_ctr = aff_${sample}_firm_ft_p/emp_ty
replace sh_ctr = 0 if sh_ctr==.


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

#delimit;
global baseline tert_bl_emp tert_bl_age_worker tert_bl_male_sh tert_bl_firm_age
                tert_bl_firm_age2 tert_bl_mean_dwage
				tert_bl_share_young tert_bl_share_middle tert_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

#delimit;
global baseline quart_bl_emp quart_bl_age_worker quart_bl_male_sh quart_bl_firm_age
                quart_bl_firm_age2 quart_bl_mean_dwage
				quart_bl_share_young quart_bl_share_middle quart_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

#delimit;
global baseline quint_bl_emp quint_bl_age_worker quint_bl_male_sh quint_bl_firm_age
                quint_bl_firm_age2 quint_bl_mean_dwage
				quint_bl_share_young quint_bl_share_middle quint_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global for ctr_bin
qui sum bl_sh_emp_bin_num
global bl_sh_emp_bin_num = r(mean)
global ctr_bin_inter 
forvalues x = 1(1)$bl_sh_emp_bin_num {
	global ctr_bin_inter $ctr_bin_inter i.time#c.bl_sh_emp_bin`x'
}

*gen bin on share ctr 
gen bin_share_ctr = 0 if sh_ctr==0 
qui sum sh_ctr if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & aff_3_firm_ft_p>0 & aff_3_firm_ft_p!=. & ${reducing_sample} , d
global p50_sh_ctr = r(p50)
replace bin_share_ctr=1 if sh_ctr>0 & sh_ctr<$p50_sh_ctr
replace bin_share_ctr=2 if sh_ctr>=$p50_sh_ctr



*global treatment
global treat_list d1 d2 d4 d5 d6 d7 


*global baseline controls
#delimit;
global contr_baseline_quint num_quint_bl_age_worker num_quint_bl_male_sh 
				      num_quint_bl_firm_age num_bl_ateco07 num_quint_bl_emp num_quint_bl_mean_dwage
					  num_quint_bl_share_young num_quint_bl_share_middle num_quint_bl_share_old ;
#delimit cr

#delimit;
global contr_baseline_quart num_quart_bl_age_worker num_quart_bl_male_sh 
				      num_quart_bl_firm_age num_bl_ateco07 num_quart_bl_emp num_quart_bl_mean_dwage
					  num_quart_bl_share_young num_quart_bl_share_middle num_quart_bl_share_old ;
#delimit cr
              
#delimit;
global contr_baseline_tert num_tert_bl_age_worker num_tert_bl_male_sh 
				      num_tert_bl_firm_age num_bl_ateco07 num_tert_bl_emp num_tert_bl_mean_dwage
					  num_tert_bl_share_young num_tert_bl_share_middle num_tert_bl_share_old ;
#delimit cr

#delimit;
global contr_baseline_share num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old i.time#c.sh_ctr ;
#delimit cr

#delimit;
global contr_baseline_ctr num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old i.time#c.sh_ctr 
					  i.time#c.bl_age_ctr i.time#c.bl_contributi_ctr i.time#c.bl_male_ctr ;
#delimit cr

#delimit;
global contr_baseline_ctr_bin num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old $ctr_bin_inter ;
#delimit cr

#delimit;
global contr_baseline_ctr_hvsl num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old i.time#i.bin_share_ctr ;
#delimit cr

#delimit;
global contr_baseline_prov_sec num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old i.time#i.bl_prov#i.bl_ateco07 ;
#delimit cr



*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


**** DID REGRESSIONS


*-------------------------------------------------------------------------------
*					    Columns 1 and 4 
*-------------------------------------------------------------------------------


global out_did cambiamento_medio
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach contr in tert quart quint ctr_hvsl share ctr ctr_bin prov_sec {
foreach y of global out_did {


	reghdfe `y'_ft_p treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline_`contr'})  vce(cluster codice_fiscale)
	estimates store Ec`sr'_`contr'
	
	sum `y'_ft_p if e(sample)
	estadd local ymean = round(r(mean), 0.001)
	
					
	sum `y'_ft_p if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.001)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.001) 
	estadd local mean_treat = round(r(mean), 0.001) 
	drop cc_firm
	
	estadd local controls "`contr'"
	estadd local ss "${samp}"

	
}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}



*** gen tables


#delimit ;
	estout Ec_tert Ec_quart Ec_quint Ec_ctr_hvsl Ec_share Ec_ctr Ec_ctr_bin Ec_prov_sec
	using "${directory_out}\table_app_7_col_1.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr


#delimit ;
	estout Ec_sr_tert Ec_sr_quart Ec_sr_quint Ec_sr_ctr_hvsl Ec_sr_share Ec_sr_ctr Ec_sr_ctr_bin Ec_sr_prov_sec
	using "${directory_out}\table_app_7_col_4.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr




*-------------------------------------------------------------------------------
*					    Columns 2, 3, 5, and 6 
*-------------------------------------------------------------------------------

**QUALIFICATION 
*gen treatment normalized
gen treat_norm_bc = dyear_${sample}_firm_bc_ft_p/bl_emp
gen treat_norm_wc = dyear_${sample}_firm_wc_ft_p/bl_emp
gen treat_norm_mng = dyear_${sample}_firm_mng_ft_p/bl_emp
gen treat_norm_bcwc = (dyear_${sample}_firm_bc_ft_p + dyear_${sample}_firm_wc_ft_p)/bl_emp

*gen treat interaction
replace treat_norm_bc = 0 if treat_norm_bc == .
replace treat_norm_wc = 0 if treat_norm_wc == .
replace treat_norm_mng = 0 if treat_norm_mng == .
replace treat_norm_bcwc = 0 if treat_norm_bcwc == .

gen dpost_bc = post*treat_norm_bc
gen dpost_wc = post*treat_norm_wc
gen dpost_bcwc = post*treat_norm_bcwc
gen dpost_mng = post*treat_norm_mng


*global treatment
global treat_post_wc dpost_bc dpost_wc
global treat_post_mng dpost_bcwc dpost_mng
global out_did_wc up_qualifica_wc_naf
global out_did_mng up_qualifica_dir_naf



local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample}
local sample_restr 

forvalues i = 1(1)2 {   //with and without sample restriction

  foreach q in tert quart quint share ctr ctr_bin ctr_hvsl prov_sec {
  foreach var in wc mng {

   global qual `var'

   local counter=0

   foreach y of global out_did_`var' {


	reghdfe `y'_ft_p ${treat_post_`var'} if `sample_reg' & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1  ///
	, absorb(i.codice_fiscale i.time ${contr_baseline_`q'})  vce(cluster codice_fiscale)
	estimates store Ec`sample_restr'_`var'_`q'
	
	
	*test inequality between coeff
	if "`var'" == "wc" {
		test dpost_wc - dpost_bc = 0 
		local sign = sign(_b[dpost_wc]-_b[dpost_bc])
		estadd local pval_wc = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	if "`var'" == "mng" {
		test dpost_mng - dpost_bcwc = 0 
		local sign = sign(_b[dpost_mng]-_b[dpost_bcwc])
		estadd local pval_mng = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	
	global nobs = e(N)
					
								
	sum `y'_ft_p if e(sample)
	estadd local ymean = round(r(mean), 0.001)
	
					
	sum `y'_ft_p if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.001)
	
	
	bys codice_fiscale: gen cc_firm = 1
	sum treat_norm_bc if e(sample) & cc_firm == 1
	estadd local sd_bc = round(r(sd), 0.001) 
	estadd local mean_bc = round(r(mean), 0.001)
	sum treat_norm_wc if e(sample) & cc_firm == 1
	estadd local sd_wc = round(r(sd), 0.001) 
	estadd local mean_wc = round(r(mean), 0.001)
	sum treat_norm_mng if e(sample) & cc_firm == 1
	estadd local sd_mng = round(r(sd), 0.001) 
	estadd local mean_mng = round(r(mean), 0.001)
	sum treat_norm_bcwc if e(sample) & cc_firm == 1
	estadd local sd_bcwc = round(r(sd), 0.001) 
	estadd local mean_bcwc = round(r(mean), 0.001)
	drop cc_firm
	
	estadd local controls "`q'"
	
}

}
}

	local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. & ${reducing_sample}
	local sample_restr _sr

}




*** Gen tables
#delimit ;
	estout Ec_wc_tert Ec_wc_quart Ec_wc_quint Ec_wc_ctr_hvsl Ec_wc_share Ec_wc_ctr Ec_wc_ctr_bin  Ec_wc_prov_sec
	using "${directory_out}\table_app_7_col_2.tex", replace style(tex) label
	keep(dpost_bc dpost_wc dpost_mng dpost_bcwc)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue&White Collar" "Treatment SD Blue&White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue&White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC&WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr


#delimit ;
	estout Ec_mng_tert Ec_mng_quart Ec_mng_quint Ec_mng_ctr_hvsl Ec_mng_share Ec_mng_ctr Ec_mng_ctr_bin Ec_mng_prov_sec
	using "${directory_out}\table_app_7_col_3.tex", replace style(tex) label
	keep(dpost_bc dpost_wc dpost_mng dpost_bcwc)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue&White Collar" "Treatment SD Blue&White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue&White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC&WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr


#delimit ;
	estout Ec_sr_wc_tert Ec_sr_wc_quart Ec_sr_wc_quint Ec_sr_wc_ctr_hvsl Ec_sr_wc_share Ec_sr_wc_ctr Ec_sr_wc_ctr_bin Ec_sr_wc_prov_sec
	using "${directory_out}\table_app_7_col_5.tex", replace style(tex) label
	keep(dpost_bc dpost_wc dpost_mng dpost_bcwc)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue&White Collar" "Treatment SD Blue&White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue&White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC&WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr


#delimit ;
	estout Ec_sr_mng_tert Ec_sr_mng_quart Ec_sr_mng_quint Ec_sr_mng_ctr_hvsl Ec_sr_mng_share Ec_sr_mng_ctr Ec_sr_mng_ctr_bin Ec_sr_mng_prov_sec
	using "${directory_out}\table_app_7_col_6.tex", replace style(tex) label
	keep(dpost_bc dpost_wc dpost_mng dpost_bcwc)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue&White Collar" "Treatment SD Blue&White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue&White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC&WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr
