********************************************************************************
*
*						Table A6 - Replication
*
********************************************************************************


***********************************************
* PLACEBO REFORMS   
***********************************************


use  "${data}\baseline_panel.dta", clear


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7


#delimit;
global out cambiamento_medio_ft_p up_qualifica_wc_naf_ft_p up_qualifica_dir_naf_ft_p;
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)


*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp 


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
    

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}


*Placebo - solo prima e trattamento nel 2010
gen post = (anno_riferimento>=2010)
gen treat_post = post*treat_norm



*-------------------------------------------------------------------------------
*					    Panel A 
*-------------------------------------------------------------------------------

global aff_sample 
global sr
local counter=0

forvalues i = 1(1)2 {
 
foreach y of varlist  cambiamento_medio_ft_p up_qualifica_wc_naf_ft_p up_qualifica_dir_naf_ft_p {

	global controls no_ctrl
	local counter=`counter'+1
	if `counter'==1 local command replace
	if `counter'!=1 local command append

	reghdfe `y' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty==1 ///
	                      & anno_riferimento<=2011, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	
	outreg2 using "${directory_out}\table_app_6_panel_A.xls", `command' dec(3)

}


  global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
  global sr _sr
 }




*-------------------------------------------------------------------------------
*					    Panel B 
*-------------------------------------------------------------------------------

gen post_2011 = (anno_riferimento>=2011)
gen treat_post_2011 = post_2011*treat_norm

 
global aff_sample 
global sr
local counter=0

forvalues i = 1(1)2 {
 
foreach y of varlist cambiamento_medio_ft_p up_qualifica_wc_naf_ft_p up_qualifica_dir_naf_ft_p {

	global controls no_ctrl
	local counter=`counter'+1
	if `counter'==1 local command replace
	if `counter'!=1 local command append


reghdfe `y' treat_post_2011 if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty==1 ///
	& anno_riferimento<=2011, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	
	outreg2 using "${directory_out}\table_app_6_panel_B.xls", `command' dec(3)
	

}


  global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
  global sr _sr
 }

