********************************************************************************
*
*						Table A5 - Replication
*
********************************************************************************


***********************************************
* ANALYSIS OF RETIREMENT DELAYS AND FIRM EXIT    
***********************************************



use  "${data}\baseline_panel.dta", clear

*keep only firms that were present pre-reform 			
keep if flag_present_pre_reform==1

*create exit variable 
merge m:1 codice_fiscale using "${data}\shutdown_date.dta", keep(1 3) nogen 
gen exit=0
replace exit=1 if anno_riferimento==closure_year_firm & closure_year_firm>=2012 & closure_year_firm<=2015 


#delimit;
global out exit;     
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7 


*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale



global out_did exit


*With baseline controls
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach y of global out_did {


	reghdfe `y' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline} )  vce(cluster codice_fiscale)
	estimates store Ec`sr'`y'
	
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento > 2011
	estadd local ymean_postreform = round(r(mean), 0.0001)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}


	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables

#delimit ;
	estout Ecexit Ec_srexit
	using "${directory_out}\table_app_5.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(5)) se(par fmt(5)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_postreform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (post 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr
estimates clear

