********************************************************************************
*
*						Table A4 - Replication
*
********************************************************************************


***********************************************
* CORRELATION OF PRE-REFORM CHARACTERISTICS AND TREATMENT   
***********************************************



*-------------------------------------------------------------------------------
*					    Columns 1 to 4
*-------------------------------------------------------------------------------


use  "${data}\baseline_panel.dta", clear

* merge further covariates at baseline
merge m:1 codice_fiscale using "${data}\firm_emp_ft_perm_2009.dta", keep(1 3) ///
keepusing(y_emp_ft y_emp_oe)
drop _merge

merge m:1 codice_fiscale using "${data}\firm_baseline_controls.dta", keep(1 3) ///
keepusing(bl_emp_pos*)
drop _merge


/*REMOVE AFTER DATA ADJUSTMENT 
*merge tenure and experience
merge m:1 codice_fiscale anno_riferimento using "${data}\final_panel_firm_core_REV.dta", keep(1 3) ///
keepusing(bl_experience* )
drop _merge
*/
						
* gen covariates 
gen bl_emp_y_sh = bl_emp_y / bl_emp
gen bl_emp_m_sh = bl_emp_m / bl_emp
gen bl_emp_o_sh = bl_emp_o / bl_emp
gen bl_temporary_sh = 1 - y_emp_oe/bl_emp
gen bl_fulltime_sh = y_emp_ft/bl_emp
gen bl_blue_sh = bl_emp_pos2/bl_emp
gen bl_white_sh = bl_emp_pos34/bl_emp
gen bl_mngm_sh = bl_emp_pos56/bl_emp
gen bl_primary_sec = (bl_ateco07_2d < 10)
gen bl_manufacturing_sec = (bl_ateco07_2d >= 10 & bl_ateco07_2d <= 39)
gen bl_services_sec = (bl_ateco07_2d >= 41)
gen bl_sh_aff = aff_${sample}_firm_ft_p/bl_emp 

** 1. all covariates at baseline
global bl_covariates bl_firm_age bl_emp bl_age_worker bl_mean_dwage bl_male_sh bl_fulltime_sh ///
bl_blue_sh bl_white_sh bl_mngm_sh bl_emp_y_sh bl_emp_m_sh bl_emp_o_sh  bl_experience

*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}
			

egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp // normalized treatment
replace treat_norm = 0 if treat_norm == .

cap tostring bl_prov, gen(bl_prov_s)
cap tostring bl_sector, gen(bl_sector_s)
egen cluster_var = concat(bl_prov_s bl_sector_s)



global aff_sample 
global sr col_1_2
forvalues i = 1(1)2 {
local counter=0
foreach x of global bl_covariates {

	local counter=`counter'+1
	if `counter'==1 local command replace
	if `counter'!=1 local command append
	  
	  reg `x' treat_norm if bl_emp >=${lb_emp} & bl_emp <= ${ub_emp} & anno_riferimento==2009 & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 , vce(cluster cluster_var)    
      sum `x' if e(sample) == 1
      global ymean = round(r(mean), 0.01)	
	  
	  outreg2 using "${directory_out}\table_app_4_${sr}.xls", addstat(Mean outcome, $ymean) dec(3) `command'	  
	
}
 global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
 global sr col_3_4
}



*-------------------------------------------------------------------------------
*					    Columns 5 to 8 
*-------------------------------------------------------------------------------

use  "${data}\baseline_panel.dta", clear

* merge further covariates at baseline
merge m:1 codice_fiscale using "${data}\firm_emp_ft_perm_2009.dta", keep(1 3) ///
keepusing(y_emp_ft y_emp_oe)
drop _merge

merge m:1 codice_fiscale using "${data}\firm_baseline_controls.dta", keep(1 3) ///
keepusing(bl_emp_pos*)
drop _merge

/*REMOVE AFTER DATA ADJUSTMENT
*merge tenure and experience
merge m:1 codice_fiscale anno_riferimento using "${data}\final_panel_firm_core_REV.dta", keep(1 3) ///
keepusing(bl_tenure* bl_experience* bl_tot_dwage*)
drop _merge
*/
				
* gen covariates 
gen bl_emp_y_sh = bl_emp_y / bl_emp
gen bl_emp_m_sh = bl_emp_m / bl_emp
gen bl_emp_o_sh = bl_emp_o / bl_emp
gen bl_temporary_sh = 1 - y_emp_oe/bl_emp
gen bl_fulltime_sh = y_emp_ft/bl_emp
gen bl_blue_sh = bl_emp_pos2/bl_emp
gen bl_white_sh = bl_emp_pos34/bl_emp
gen bl_mngm_sh = bl_emp_pos56/bl_emp
gen bl_primary_sec = (bl_ateco07_2d < 10)
gen bl_manufacturing_sec = (bl_ateco07_2d >= 10 & bl_ateco07_2d <= 39)
gen bl_services_sec = (bl_ateco07_2d >= 41)
gen bl_sh_aff = aff_${sample}_firm_ft_p/bl_emp 

** 1. all covariates at baseline
global bl_covariates bl_firm_age bl_emp bl_age_worker bl_mean_dwage bl_male_sh bl_fulltime_sh ///
bl_blue_sh bl_white_sh bl_mngm_sh bl_emp_y_sh bl_emp_m_sh bl_emp_o_sh  bl_experience


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global baseline controls
#delimit;
global contr_baseline num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old  ;
#delimit cr

			
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


gen treat_norm = dyear_${sample}_firm_ft_p/aff_${sample}_firm_ft_p // normalized treatment
replace treat_norm = 0 if treat_norm == .

cap tostring bl_prov, gen(bl_prov_s)
cap tostring bl_sector, gen(bl_sector_s)
egen cluster_var = concat(bl_prov_s bl_sector_s)



global aff_sample 
global sr col_5_6
forvalues i = 1(1)2 {
local counter=0
foreach x of global bl_covariates {

	local counter=`counter'+1
	if `counter'==1 local command replace
	if `counter'!=1 local command append
	  
	  reg `x' treat_norm if bl_emp >=${lb_emp} & bl_emp <= ${ub_emp} & anno_riferimento==2009 & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 , vce(cluster cluster_var)    
      sum `x' if e(sample) == 1
      global ymean = round(r(mean), 0.01)	
	  
	  outreg2 using "${directory_out}\table_app_4_${sr}.xls", addstat(Mean outcome, $ymean) dec(3) `command'	  
	
}
 global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
 global sr col_7_8
}






