********************************************************************************
*
*						Table A3 - Replication
*
********************************************************************************


***********************************************
* SUMMARY STATISTICS IN WORKER SAMPLE   
***********************************************

use "${data}\summary_stat_individual.dta", clear
cap drop tenure_y hcpi

***** Wage 
*create wage definition (copy from previous files)
merge m:1 anno_riferimento mese_riferimento using "${data}\hcpiseries.dta" // time-series of the HCPI (base 100 in Jan 2015)
drop if _merge == 2  
drop _merge
*merge list id differenze accredito (need to define "events" happening in the year to redefine giorni retribuiti)
merge m:1 id_lavoratore codice_fiscale anno_riferimento mese_riferimento using "${data}\accredito_2011.dta"
drop if _merge == 2
gen event = 1 if _merge == 3
drop _merge
* Censor giorni retribuiti at 26  
gen giorni_retribuiti_clean = giorni_retribuiti
replace giorni_retribuiti_clean = 26 if giorni_retribuiti > 26 & giorni_retribuiti != . // censor at 26
gen giorni_retribuiti_imponibile = giorni_retribuiti_clean
*adjust giorni retribuiti for cases where we find events in differenze accredito
bysort id_lavoratore codice_fiscale: egen temp = mean(giorni_retribuiti) if event != 1
bysort id_lavoratore codice_fiscale: egen temp1 = max(temp) 
replace giorni_retribuiti_clean = temp1 if event == 1 & giorni_retribuiti == 0
drop temp temp1
* dwage1: daily wage based on retribuzione teorica; dwage2: daily wage based on imponibile
gen dwage = (retribuzione_teorica/giorni_retribuiti_clean)*(num_mensilita/12000)*(100/hcpi)
egen pc = pctile(dwage), p(99.9)
gen dwage_tr = dwage
replace dwage_tr = pc if dwage > pc & dwage != .


gen open_ended = (qual3 == 1)

gen full_time  = (qual2 == 1)

*** Years since first time entered the labor market (merging row demographics data)
gen id_soggetto = id_lavoratore 
merge m:1 id_soggetto using "${data}\visitinps_anagrafica_v4b.dta", keep(1 3) keepusing(anno_inizio_lavoro)
gen years_since_entrance = 2011 - anno_inizio_lavoro
drop id_soggetto

*time variable
gen time = 0
replace time = anno_riferimento - 2008

*Baseline characteristics interacted with time dummies
#delimit;
global baseline bl_emp bl_age_worker bl_male_sh bl_firm_age
                bl_firm_age2 bl_mean_dwage bl_ateco07 bl_prov bl_reg
				bl_share_young bl_share_middle bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

    
  *sample restrictions 
  keep if bl_emp >= 10 & bl_emp <= 200 & ${reducing_sample}  // keep only firms within baseline employment range  
  keep if always_full_time == 1 & always_permanent == 1 // keep only core workers
  keep if  bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1
  
  gen not_affected     = 0 if sample3 == 1
  replace not_affected = 1 if not_affected != 0
  
    * keep the last observation for every worker
     bysort id_lavoratore: egen last_month = max(mese_riferimento)
     drop if mese_riferimento != last_month
     duplicates drop id_lavoratore, force 
  

  bys not_affected: gen  Nobs          =  _N 
  
  
  local vars_stat male age tenure_corr experience_corr years_since_entrance blue_collar white_collar manager dwage_tr Nobs
	
label var dyear                    "Treatment"
label var male                     "Gender (1 = male)"
label var age                      "Age"
label var tenure_corr              "Tenure"
label var experience_corr          "Experience in Private Sector"
label var years_since_entrance     "Years Since Entered Labor Market"
label var blue_collar              "Blue collar"
label var white_collar             "White collar"
label var manager                  "Manager"
label var dwage_tr                 "Daily gross real wage"	
label var Nobs                     "N. workers"
				

  est clear
  bys not_affected: eststo: estpost tabstat dyear `vars_stat', columns(statistics) statistics(mean sd) 
   

  esttab est1 est2 using "${directory_out}\table_app_3.tex" , cells("mean(fmt(2)) sd(fmt(2))") label replace
   
 
