********************************************************************************
*
*						Table A2 - Replication
*
********************************************************************************


***********************************************
* SUMMARY STATISTICS  
***********************************************


use  "${data}\baseline_panel.dta", clear


keep codice_fiscale anno_riferimento flag_balanced_cm sample_period_p_ft emp_ty cambiamento_medio_ft_p med_bl_* bl_firm_age bl_age_worker bl_male_sh bl_mean_dwage bl_ateco07_2d bl_emp* bl_prov bl_reg aff_${sample}_firm_ft_p bl_emp bl_flag_single_matricola fflag_single_matricola_ty


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7

duplicates drop codice_fiscale, force


* merge further covariates at baseline
merge m:1 codice_fiscale using "${data}\firm_emp_ft_perm_2009.dta", keep(1 3) ///
keepusing(y_emp_ft y_emp_oe)
drop _merge

merge m:1 codice_fiscale using "${data}\firm_controls_baseline_year.dta", keep(1 3) ///
keepusing(bl__emp_pos*)
drop _merge
   
* merge info about tenure and experience at the firm-level 
merge 1:m codice_fiscale using "${data}\tenure_experience_firm_level_2009.dta", keepusing(mean_tenure mean_experience)
drop if _merge == 2
drop    _merge


rename mean_tenure bl_tenure
rename mean_experience bl_experience


*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07_2d bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

* gen covariates 
gen bl_emp_y_sh          = bl_emp_y / bl_emp
gen bl_emp_m_sh          = bl_emp_m / bl_emp
gen bl_emp_o_sh          = bl_emp_o / bl_emp
gen bl_temporary_sh = 1 - y_emp_oe/bl_emp
gen bl_fulltime_sh = y_emp_ft/bl_emp
gen bl_blue_sh = bl__emp_pos2/bl_emp
gen bl_white_sh = bl__emp_pos34/bl_emp
gen bl_mngm_sh = bl__emp_pos56/bl_emp
gen bl_primary_sec       = (bl_ateco07_2d < 10)
gen bl_manufacturing     = (bl_ateco07_2d >= 10 & bl_ateco07_2d <= 39)
gen bl_services          = (bl_ateco07_2d >= 41)
replace bl_tenure        = bl_tenure/12 // express tenure in years
gen sh_ctr = aff_${sample}_firm_ft_p/emp_ty   
replace sh_ctr = 0 if sh_ctr==.


label var bl_emp               "Firm size"
label var bl_firm_age          "Firm age"
label var bl_manufacturing     "Share in manufacturing"
label var bl_services          "Share in services" 
label var bl_male_sh           "Share male workforce"
label var bl_age_worker        "Avg. workforce age"
label var bl_emp_y_sh          "Share workforce aged <= 35"
label var bl_emp_m_sh          "Share workforce aged (35-55]"
label var bl_emp_o_sh          "Share workforce aged > 55"
label var bl_tenure          "Avg. workforce tenure"
label var bl_experience      "Avg. workforce experience"
label var bl_blue_sh           "Share blue collars"
label var bl_white_sh          "Share white collars"
label var bl_mngm_sh           "Share managers"
label var bl_fulltime_sh       "Share full-time contracts"
label var bl_temporary_sh      "Share temporary contracts"
label var bl_mean_dwage        "Avg. real daily wage"
 
			   
*gen stats for the two samples
local stat_var bl_emp bl_firm_age bl_manufacturing bl_services ///
               bl_male_sh bl_age_worker bl_emp_y_sh bl_emp_m_sh bl_emp_o_sh ///
			   bl_tenure bl_experience ///
			   bl_blue_sh bl_white_sh bl_mngm_sh ///
			   bl_fulltime_sh bl_temporary_sh bl_mean_dwage sh_ctr
		   

foreach l of numlist 10  {
 foreach u of numlist 200  {
  foreach s of numlist 3  {
   forvalues v = 1(1)1 {
  
   if `v' == 0 global add
   if `v' == 1 global add & ${reducing_sample}
   
   
   if `v' == 0 global suff  balanced_firms
   if `v' == 1 global suff  balanced_nomiss_firms
   

	preserve

	keep if bl_emp >= `l' & bl_emp <= `u' ${add} // keep firms in our sample
	keep if bl_flag_single_matricola==1 & fflag_single_matricola_ty==1  & flag_balanced_cm==1 

	gen     not_affected_`s'_`l'_`u' = 0 if aff_${sample}_firm_ft_p > 0 & aff_${sample}_firm_ft_p != .
	replace not_affected_`s'_`l'_`u' = 1 if not_affected_`s'_`l'_`u' != 0


	eststo: estpost tabstat `stat_var', ///
		  statistics(mean sd) columns(statistics)  
	eststo: estpost tabstat `stat_var' if not_affected_`s'_`l'_`u' == 0, ///
		  statistics(mean sd) columns(statistics)  
	eststo: estpost tabstat `stat_var' if not_affected_`s'_`l'_`u' == 1, ///
		  statistics(mean sd) columns(statistics) 

	esttab est1 est2 est3 using "${directory_out}\table_app_2.tex", ///
	cells("mean(fmt(2)) sd(fmt(2))") label replace

	estimates clear


	restore




	}
  }
 }
}
  			  
