********************************************************************************
*
*						Table A16 - Replication
*
********************************************************************************


***********************************************
* ANALYSIS BY ACCESS TO CREDIT 
***********************************************

use  "${data}\baseline_panel.dta", clear

*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\firm_emp_growth_pctiles.dta"
drop if _merge == 2
drop _merge

*rename long vars 
rename bl_liq_ta liq_ta
rename bl_cf_ta cf_ta 
rename share_risky_firms sh_risk

*global for liquidity vars
global liquidity sh_risk 

*Keep imprese open thoughout the period
drop if sample_period_p_ft!= $sample_period
bysort codice_fiscale: gen cc = _n 


#delimit;
global out cambiamento_medio_ft_p  ;
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm     = dyear_${sample}_firm_ft_p/bl_emp 
replace treat_norm = 0 if treat_norm == .

forvalues i = 1(1)7 {
		gen d`i'_treat = t`i' * treat_norm
}

global tlist_treat d1_treat d2_treat d4_treat d5_treat d6_treat d7_treat

gen treat_post           = post*treat_norm



*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

             
*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


rename cambiamento_medio_ft_p cm_ft_p

				   
global out_did cm_ft_p
global aff_sample 
local sr

forvalues i = 1(1)2 {
foreach x in terc {
foreach q in ft_p {
foreach y of global out_did {
foreach z of global liquidity {

	cumul avg_change_emp if cc == 1 & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 /// 
	                        & bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample}, gen(temp)
	bysort codice_fiscale: egen cdf_emp_growth = max(temp)
	drop   temp
	
	*gen quantiles of liquidity var
	xtile temp = `z' if cc == 1 & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 /// 
	                        & bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample}, n(2)
	bysort codice_fiscale: egen `z'_med = max(temp)
	replace `z'_med = 0 if `z'_med == 2  
	replace `z'_med = 1 if `z'_med == 1
	drop   temp
	
	*gen quartile and tercile
	gen     emp_growth_tercile = 1 if cdf_emp_growth <= 0.3333334
	replace emp_growth_tercile = 2 if cdf_emp_growth >  0.3333334 & cdf_emp_growth <= 0.6666667
	replace emp_growth_tercile = 3 if cdf_emp_growth >  0.6666667 & cdf_emp_growth != .
	
	*gen treat interaction
     gen eg_top_terc  = (emp_growth_tercile==3)
     gen eg_med_terc  = (emp_growth_tercile==2)
     gen eg_bot_terc  = (emp_growth_tercile==1)


    gen treat_post_top_eg_`x'  = post*treat_norm*eg_top_`x'
    gen treat_post_bot_eg_`x'  = post*treat_norm*eg_bot_`x'
	
	gen treat_post_liq_`x'  = post*treat_norm*`z'_med
	
	gen treat_post_top_eg_liq_`x'  = post*treat_norm*eg_top_`x'*`z'_med
    gen treat_post_bot_eg_liq_`x'  = post*treat_norm*eg_bot_`x'*`z'_med
   
	gen post_liq_`x'  = post*`z'_med
   
    gen post_top_`x' = post*eg_top_`x'
    gen post_bot_`x' = post*eg_bot_`x'
	
	gen post_top_liq_`x' = post*eg_top_`x'*`z'_med
    gen post_bot_liq_`x' = post*eg_bot_`x'*`z'_med
   
    global treat_ddd_`x' treat_post_top_eg_liq_`x' treat_post_bot_eg_liq_`x' ///
						 treat_post_top_eg_`x' treat_post_bot_eg_`x' treat_post_liq_`x' post_top_liq_`x' post_bot_liq_`x' ///
						 treat_post post_top_`x' post_bot_`x' post_liq_`x'



	reghdfe `y' ${treat_ddd_`x'} ///
	if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale) 
	estimates store Ec`y'`x'`sr'`z'
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*test for coeff inequality
	test treat_post_bot_eg_`x' - treat_post_top_eg_`x' = 0
	local sign = sign(_b[treat_post_bot_eg_`x']-_b[treat_post_top_eg_`x'])
	estadd local pval_med0 = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	
	test treat_post_bot_eg_`x' + treat_post_bot_eg_liq_`x' - treat_post_top_eg_`x' - treat_post_top_eg_liq_`x' = 0
	local sign = sign(_b[treat_post_bot_eg_`x']+_b[treat_post_bot_eg_liq_`x']-_b[treat_post_top_eg_`x']-_b[treat_post_top_eg_liq_`x'])
	estadd local pval_med1 = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1 & eg_top_`x'==1 & `z'_med==0
	estadd local sd_treat_top_med0 = round(r(sd), 0.01) 
	estadd local mean_treat_top_med0 = round(r(mean), 0.01)

	qui sum treat_norm if e(sample) & cc_firm == 1 & eg_bot_`x'==1 & `z'_med==0
	estadd local sd_treat_bot_med0 = round(r(sd), 0.01) 
	estadd local mean_treat_bot_med0 = round(r(mean), 0.01)
	drop cc_firm
	
	
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1 & eg_top_`x'==1 & `z'_med==1
	estadd local sd_treat_top_med1 = round(r(sd), 0.01) 
	estadd local mean_treat_top_med1 = round(r(mean), 0.01)

	qui sum treat_norm if e(sample) & cc_firm == 1 & eg_bot_`x'==1 & `z'_med==1
	estadd local sd_treat_bot_med1 = round(r(sd), 0.01) 
	estadd local mean_treat_bot_med1 = round(r(mean), 0.01)
	drop cc_firm
	
	
	

	*Add effect of treatment on top and bottom
	lincom treat_post_bot_eg_`x' + treat_post 
	estadd local mean_dd_bot_med0=round(r(estimate), 0.01)
	estadd local sd_dd_bot_med0=round(r(se), 0.01)
	estadd local pval_dd_bot_med0=2*ttail(r(df),abs(r(estimate)/r(se)))	

	lincom treat_post_top_eg_`x' + treat_post 
	estadd local mean_dd_top_med0=round(r(estimate), 0.01)
	estadd local sd_dd_top_med0=round(r(se), 0.01)
	estadd local pval_dd_top_med0=2*ttail(r(df),abs(r(estimate)/r(se)))
	
	lincom treat_post_bot_eg_`x' + treat_post + treat_post_liq_`x' + treat_post_bot_eg_liq_`x'
	estadd local mean_dd_bot_med1=round(r(estimate), 0.01)
	estadd local sd_dd_bot_med1=round(r(se), 0.01)
	estadd local pval_dd_bot_med1=2*ttail(r(df),abs(r(estimate)/r(se)))	

	lincom treat_post_top_eg_`x' + treat_post + treat_post_liq_`x' + treat_post_top_eg_liq_`x'
	estadd local mean_dd_top_med1=round(r(estimate), 0.01)
	estadd local sd_dd_top_med1=round(r(se), 0.01)
	estadd local pval_dd_top_med1=2*ttail(r(df),abs(r(estimate)/r(se)))

	estadd local controls "Yes"
	
	
	
	drop       `z'_med cdf_emp_growth emp_growth_tercile *eg_top* *eg_bot* *eg_med* *post_top* *post_bot* *post_liq*
	macro drop treat_ddd_`x'


	
}
}
}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	
	
	
}





*Gen Tables
#delimit ;
	estout Eccm_ft_ptercsh_risk Eccm_ft_pterc_srsh_risk
	using "${directory_out}\table_app_16.tex", replace style(tex) label
	keep(treat_post_bot_eg_liq_`x' treat_post_top_eg_liq_`x')
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform 
	mean_treat_top_med0 sd_treat_top_med0 mean_treat_top_med1 sd_treat_top_med1 
	mean_treat_bot_med0 sd_treat_bot_med0 mean_treat_bot_med1 sd_treat_bot_med1
	pval_med0 pval_med1 
	mean_dd_bot_med0 sd_dd_bot_med0 pval_dd_bot_med0 mean_dd_bot_med1 sd_dd_bot_med1 pval_dd_bot_med1
	mean_dd_top_med0 sd_dd_top_med0 pval_dd_top_med0 mean_dd_top_med1 sd_dd_top_med1 pval_dd_top_med1 
	controls, 
	fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" 
	"Treatment Mean - Top and High Liquidity" "Treatment SD - Top and High Liquidity" "Treatment Mean - Top and Low Liquidity" "Treatment SD - Top and Low Liquidity"
	"Treatment Mean - Bottom and High Liquidity" "Treatment SD - Bottom and High Liquidity" "Treatment Mean - Bottom and Low Liquidity" "Treatment SD - Bottom and Low Liquidity" 
	"p-value Bottom < Top for High Liquidity" "p-value Bottom < Top for Low Liquidity" 
	"ATE on Bottom and High Liquidity" "SE ATE on Bottom and High Liquidity" "p-value ATE on Bottom and High Liquidity" "ATE on Bottom and Low Liquidity" "SE ATE on Bottom and Low Liquidity" "p-value ATE on Bottom and Low Liquidity"
	"ATE on Top and High Liquidity" "SE ATE on Top and High Liquidity" "p-value ATE on Top and High Liquidity" "ATE on Top and Low Liquidity" "SE ATE on Top and Low Liquidity" "p-value ATE on Top and Low Liquidity" 
	"Controls"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post_top_`x' "Treatment X Top X Post" treat_post_bot_`x' "Treatment X Bottom X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr


estimates clear 
