********************************************************************************
*
*						Table A15 - Replication
*
********************************************************************************


***********************************************
* EFFECTS OF CTR WAGE BILL ON BASELINE OUTCOMES
***********************************************

use "${data}\calibration_wage_ctr_terciles.dta", clear
qui sum wage_ctr_bot
global wage_ctr_bot = r(mean)
qui sum wage_ctr_mid
global wage_ctr_mid = r(mean)
qui sum wage_ctr_top
global wage_ctr_top = r(mean)
qui sum wage_ctr_botmid
global wage_ctr_botmid = r(mean)



*-------------------------------------------------------------------------------
*					    	Columns 1, 2, 5, and 6
*-------------------------------------------------------------------------------

*upload data
use  "${data}\baseline_panel.dta", clear

*merge treatment reweighted 
drop dyear_3_firm_top_terc_ft_p dyear_3_firm_bot_terc_ft_p dyear_3_firm_mid_terc_ft_p 
merge m:1 codice_fiscale using "${data}\treatment_wage_terciles_weighted.dta", keep(1 3)
drop _merge


*Keep imprese open thoughout the period
drop if sample_period_p_ft!= $sample_period

*rename outcome variables
rename (cambiamento_medio_ft_p d_teorica_adj_ft_p_ter1 d_teorica_adj_ft_p_ter2 d_teorica_adj_ft_p_ter3) ///
       (camb_medio_ft_p d_teo_adj_ter1_ft_p d_teo_adj_ter2_ft_p d_teo_adj_ter3_ft_p)

*gen global outcomes
#delimit;
global out d_teo_adj_ter1_ft_p 
		   camb_medio_ft_p
		   ;
#delimit cr

*drop if non-full distribution of tertiles
gen temp = 1 if d_teo_adj_ter1_ft_p==.
bysort codice_fiscale: egen temp2 = max(temp)
drop if temp2>0 & temp2!=.
drop temp temp2

gen d_teo_midbot_ft_p = (d_teo_adj_ter1_ft_p + d_teo_adj_ter2_ft_p)/2

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)


*gen treatment normalized
foreach x in terc {
	*remember that we constructed dyear as a mean so do not need to divide by total number
	gen treat_top_`x' = dyear_t_${sample}_firm_top_`x'_ft_p/10000/bl_emp
	gen treat_mid_`x' = dyear_t_${sample}_firm_mid_`x'_ft_p/10000/bl_emp
	gen treat_bot_`x' = dyear_t_${sample}_firm_bot_`x'_ft_p/10000/bl_emp
	gen treat_botmid_`x' = dyear_t_${sample}_firm_botmid_`x'_ft_p/10000/bl_emp
	gen treat_topmid_`x' = dyear_t_${sample}_firm_topmid_`x'_ft_p/10000/bl_emp
	replace treat_top_`x' = 0 if treat_top_`x' == .
	replace treat_bot_`x' = 0 if treat_bot_`x' == .
	replace treat_mid_`x' = 0 if treat_mid_`x' == .
	replace treat_botmid_`x' = 0 if treat_botmid_`x' == .
	replace treat_topmid_`x' = 0 if treat_topmid_`x' == .
}


gen dtop_post = post*treat_top_terc
gen dmid_post = post*treat_mid_terc
gen dbot_post = post*treat_bot_terc
gen dbotmid_post = post*treat_botmid_terc
gen dtopmid_post = post*treat_topmid_terc



*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*globals treatment
global treat_post1      dtop_post dmid_post dbot_post
global treat_post2      dtop_post dbotmid_post
global treat_post3      dtopmid_post dbot_post

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
forvalues q = 1(1)1 {
foreach y of global out {


	reghdfe `y' ${treat_post`q'} if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1  ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	estimates store Ec`sr'`q'`y'
	
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*test difference bw coeff
	if `q'==1 {
		lincom dtop_post - dbot_post
		estadd local top_bot_est = r(estimate)
		estadd local top_bot_p = r(p)
		lincom dtop_post - dmid_post
		estadd local top_mid_est = r(estimate)
		estadd local top_mid_p = r(p)
		lincom dmid_post - dbot_post 
		estadd local mid_bot_est = r(estimate)
		estadd local mid_bot_p = r(p)
		
		*treat mean and sd
		bys codice_fiscale: gen cc_firm = _n
		sum treat_bot_terc if e(sample) & cc_firm == 1
		estadd local sd_bot = round(r(sd), 0.01) 
		estadd local mean_bot = round(r(mean), 0.01)
		sum treat_mid_terc if e(sample) & cc_firm == 1
		estadd local sd_mid = round(r(sd), 0.01) 
		estadd local mean_mid = round(r(mean), 0.01)
		sum treat_top_terc if e(sample) & cc_firm == 1
		estadd local sd_top = round(r(sd), 0.01) 
		estadd local mean_top = round(r(mean), 0.01)
		drop cc_firm
		
	}
	
	if `q'==2 {
		lincom dtop_post - dbotmid_post
		estadd local top_botmid_est = r(estimate)
		estadd local top_botmid_p = r(p)
		
		*treat mean and sd
		bys codice_fiscale: gen cc_firm = _n
		sum treat_botmid_terc if e(sample) & cc_firm == 1
		estadd local sd_botmid = round(r(sd), 0.01) 
		estadd local mean_botmid = round(r(mean), 0.01)
		sum treat_top_terc if e(sample) & cc_firm == 1
		estadd local sd_top = round(r(sd), 0.01) 
		estadd local mean_top = round(r(mean), 0.01)
		drop cc_firm
	}
	

	if `q'==3 {
		lincom dtopmid_post - dbot_post
		estadd local topmid_bot_est = r(estimate)
		estadd local topmid_bot_p = r(p)
		
		*treat mean and sd
		bys codice_fiscale: gen cc_firm = _n
		sum treat_topmid_terc if e(sample) & cc_firm == 1
		estadd local sd_topmid = round(r(sd), 0.01) 
		estadd local mean_topmid = round(r(mean), 0.01)
		sum treat_bot_terc if e(sample) & cc_firm == 1
		estadd local sd_bot = round(r(sd), 0.01) 
		estadd local mean_bot = round(r(mean), 0.01)
		drop cc_firm
	}
	
	
	
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables
#delimit ;
	estout Ec1camb_medio_ft_p Ec1d_teo_adj_ter1_ft_p Ec_sr1camb_medio_ft_p Ec_sr1d_teo_adj_ter1_ft_p
	using "${directory_out}\table_app_15_col_1_2_5_6.tex", replace style(tex) label
	keep(dtop_post dmid_post dbot_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform 
	top_bot_est top_bot_p top_mid_est top_mid_p mid_bot_est mid_bot_p
	mean_top sd_top mean_mid sd_mid mean_bot sd_bot 
	controls ss, fmt(%18.0gc) 
	label("Observations" "R-squared" "Mean Outcome (pre 2012)" 
	"Top - Bottom Estimate" "Top - Bottom P-value" "Top - Middle Estimate" "Top - Middle P-value" "Middle - Bottom Estimate" "Middle - Bottom P-value"
	"Treatment Mean - Top" "Treatment SD - Top" "Treatment Mean - Middle" "Treatment SD - Middle" "Treatment Mean - Bottom" "Treatment SD - Bottom"
	"Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr

estimates clear



*-------------------------------------------------------------------------------
*					    	Columns 3, 4, 7, and 8
*-------------------------------------------------------------------------------

use "${data}\baseline_panel.dta", clear

*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\emp_by_qual.dta", keepusing(emp_bc_2011 emp_wc_2011 emp_mng_2011)
drop if _merge == 2
drop _merge

*flags for at least two units
gen flag_sample_wc = (emp_bc_2011>0 & emp_wc_2011>0)
gen flag_sample_mng = ((emp_bc_2011>0 & emp_mng_2011>0) | (emp_wc_2011>0 & emp_mng_2011>0)) 

*merge treatment reweighted 
drop dyear_3_firm_bc_ft_p dyear_3_firm_wc_ft_p dyear_3_firm_mng_ft_p 
cap drop dyear_3_firm_bcwc_ft_p
merge m:1 codice_fiscale using "${data}\treatment_by_qual_weighted.dta", keep(1 3)
drop _merge

*Keep imprese open thoughout the period
drop if sample_period_p_ft != $sample_period

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)


*gen treatment normalized
gen treat_norm_bc = dyear_t_${sample}_firm_bc_ft_p/10000/bl_emp
gen treat_norm_wc = dyear_t_${sample}_firm_wc_ft_p/10000/bl_emp
gen treat_norm_mng = dyear_t_${sample}_firm_mng_ft_p/10000/bl_emp
gen treat_norm_bcwc = dyear_t_${sample}_firm_bcwc_ft_p/10000/bl_emp

*gen treat interaction
replace treat_norm_bc   = 0  if treat_norm_bc == .
replace treat_norm_wc   = 0  if treat_norm_wc == .
replace treat_norm_mng  = 0  if treat_norm_mng == .
replace treat_norm_bcwc = 0 if treat_norm_bcwc == .
forvalues i = 1(1)7 {
		gen d`i'_bc = t`i' * treat_norm_bc
		gen d`i'_wc = t`i' * treat_norm_wc
		gen d`i'_mng = t`i' * treat_norm_mng
		gen d`i'_bcwc = t`i' * treat_norm_bcwc
}
gen dpost_bc    = post*treat_norm_bc
gen dpost_wc    = post*treat_norm_wc
gen dpost_bcwc  = post*treat_norm_bcwc
gen dpost_mng   = post*treat_norm_mng

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list_wc d1_bc d2_bc d4_bc d5_bc d6_bc d7_bc d1_wc d2_wc d4_wc d5_wc d6_wc d7_wc 
global treat_list_mng d1_bcwc d2_bcwc d4_bcwc d5_bcwc d6_bcwc d7_bcwc d1_mng d2_mng d4_mng d5_mng d6_mng d7_mng 
global treat_post_wc dpost_bc dpost_wc
global treat_post_mng dpost_bcwc dpost_mng

*global baseline controls
#delimit;
global contr_baseline num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old  ;
#delimit cr
  

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global out_wc      up_qualifica_wc_naf_ft_p 
global out_mng     up_qualifica_dir_naf_ft_p 
global out_did_wc  up_qualifica_wc_naf
global out_did_mng up_qualifica_dir_naf



local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample}
local sample_restr 

forvalues i = 1(1)2 {   //with and without sample restriction

  foreach q in ft_p {
  foreach var in wc mng {

   global qual `var'

   local counter=0

   foreach y of global out_did_`var' {


	reghdfe `y'_`q' ${treat_post_`var'} if `sample_reg' & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	estimates store Ec`sample_restr'`q'`var'
	
	
	*test inequality between coeff
	if "`var'" == "wc" {
		test dpost_wc - dpost_bc = 0 
		local sign = sign(_b[dpost_wc]-_b[dpost_bc])
		estadd local pval_wc = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	if "`var'" == "mng" {
		test dpost_mng - dpost_bcwc = 0 
		local sign = sign(_b[dpost_mng]-_b[dpost_bcwc])
		estadd local pval_mng = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	
	global nobs = e(N)
					
								
	sum `y'_`q' if e(sample)
	estadd local ymean = round(r(mean), 0.001)
	
					
	sum `y'_`q' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.001)
	
	
	bys codice_fiscale: gen cc_firm = 1
	sum treat_norm_bc if e(sample) & cc_firm == 1
	estadd local sd_bc = round(r(sd), 0.001) 
	estadd local mean_bc = round(r(mean), 0.001)
	sum treat_norm_wc if e(sample) & cc_firm == 1
	estadd local sd_wc = round(r(sd), 0.001) 
	estadd local mean_wc = round(r(mean), 0.001)
	sum treat_norm_mng if e(sample) & cc_firm == 1
	estadd local sd_mng = round(r(sd), 0.001) 
	estadd local mean_mng = round(r(mean), 0.001)
	sum treat_norm_bcwc if e(sample) & cc_firm == 1
	estadd local sd_bcwc = round(r(sd), 0.001) 
	estadd local mean_bcwc = round(r(mean), 0.001)
	drop cc_firm
	
	estadd local controls "Yes"
	
}

}
}

	local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. & ${reducing_sample}
	local sample_restr _sr

}




*** Gen tables
#delimit ;
	estout Ecft_pwc Ecft_pmng Ec_srft_pwc Ec_srft_pmng 
	using "${directory_out}\table_app_15_col_3_4_7_8.tex", replace style(tex) label
	keep(dpost_bc dpost_wc dpost_mng dpost_bcwc)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_bc sd_bc mean_wc sd_wc mean_mng sd_mng mean_bcwc sd_bcwc controls pval_wc pval_mng, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean Blue Collar" "Treatment SD Blue Collar" "Treatment Mean White Collar" "Treatment SD White Collar" "Treatment Mean Manager" "Treatment SD Manager"  "Treatment Mean Blue and White Collar" "Treatment SD Blue and White Collar" "Controls" "p-value White Collar < Blue Collar" "p-value Manager < Blue and White Collar"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(dpost_bc "Treatment BC X Post" dpost_wc "Treatment WC X Post" dpost_mng "Treatment Manager X Post" dpost_bcwc "Treatment BC and WC X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr

estimates clear
