********************************************************************************
*
*						Table A13 - Replication
*
********************************************************************************


***********************************************
* ANALYSIS ON FIRM PERFORMANCE
***********************************************

use  "${data}\baseline_panel.dta", clear

merge 1:1 codice_fiscale anno_riferimento using "${data}\cerved_performance.dta", keep(1 3)
drop _merge 

*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7


*rename outcomes
rename (ricavi_esercizio valore_della_produzione valore_aggiunto_operativo risultato_ante_gestione_finanzia utile_perdita_esercizio roe roi roa mol_su_valore_della_produzione) ///
		(ricavi val_prod va ebit profit roe roi roa mol_prod) 

*gen log outcomes
foreach x in ricavi val_prod va {
	gen l_`x' = log(`x')
	replace l_`x'=0 if `x'==0 
}

*normalize by total assets
foreach x in ricavi val_prod va ebit profit {
	gen `x'_ta = `x'/totale_attivo
}

#delimit;
global out ricavi_ta va_ta ebit_ta roe roi roa;   
#delimit cr

*set global for tables
global out_table 
foreach x of global out {
	local sr
	forvalues i = 1(1)2 {
	
		global out_table ${out_table} Ec`sr'`x'
		local sr _sr
		
	}
}

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp 


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7       

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale



global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach y of global out {


	reghdfe `y' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline} )  vce(cluster codice_fiscale)
	estimates store Ec`sr'`y'
	
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	estadd local name_var "`y'"
	

}


	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables
#delimit ;
	estout Ecricavi_ta Ecva_ta Ecebit_ta Ecroe Ecroi Ecroa
	using "${directory_out}\table_app_13.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss name_var, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample" "Name Variable"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr


estimates clear

     
