********************************************************************************
*
*						Table A12 - Replication
*
********************************************************************************


***********************************************
* ANALYSIS BY AGE GROUP
***********************************************


use  "${data}\baseline_panel.dta", clear


*Keep imprese open thoughout the period
drop if sample_period_p_ft!= $sample_period


#delimit;
global out d_teorica_adj_ft_p_age1 
           d_teorica_adj_ft_p_age2 
           d_teorica_adj_ft_p_age3 ;
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7 

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


	
rename (d_teorica_adj_p_ter1 d_teorica_adj_p_ter2 d_teorica_adj_p_ter3) ///
           (d_teorica_adj_ter1_p d_teorica_adj_ter2_p d_teorica_adj_ter3_p)

rename (d_teorica_adj_ft_p_ter1 d_teorica_adj_ft_p_ter2 d_teorica_adj_ft_p_ter3) ///
           (d_teorica_adj_ter1_ft_p d_teorica_adj_ter2_ft_p d_teorica_adj_ter3_ft_p)
		   
rename (d_teorica_adj_p_age1 d_teorica_adj_p_age2 d_teorica_adj_p_age3) ///
           (d_teorica_adj_age1_p d_teorica_adj_age2_p d_teorica_adj_age3_p)

rename (d_teorica_adj_ft_p_age1 d_teorica_adj_ft_p_age2 d_teorica_adj_ft_p_age3) ///
           (d_teorica_adj_age1_ft_p d_teorica_adj_age2_ft_p d_teorica_adj_age3_ft_p)
		   	   


global out_did d_teorica_adj_age1 d_teorica_adj_age2 d_teorica_adj_age3 
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach q in ft_p {
foreach y of global out_did {


	reghdfe `y'_`q' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	estimates store Ec`sr'`q'`y'
	
	sum `y'_`q' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y'_`q' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables
#delimit ;
	estout Ecft_pd_teorica_adj_age1 Ecft_pd_teorica_adj_age2 Ecft_pd_teorica_adj_age3 Ec_srft_pd_teorica_adj_age1 Ec_srft_pd_teorica_adj_age2 Ec_srft_pd_teorica_adj_age3
	using "${directory_out}\table_app_12.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr


estimates clear
