********************************************************************************
*
*						Table A11 - Replication
*
********************************************************************************


***********************************************
* ANALYSIS BY EMPLOYMENT GROWTH AND SPAN OF CONTROL
***********************************************


*-------------------------------------------------------------------------------
*					    Columns 1 and 3
*-------------------------------------------------------------------------------


use  "${data}\baseline_panel.dta", clear

*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\firm_emp_growth_pctiles.dta"
drop if _merge == 2
drop _merge

*Keep imprese open thoughout the period
drop if sample_period_p_ft!= $sample_period 
bysort codice_fiscale: gen cc = _n 


#delimit;
global out cambiamento_medio_ft_p ;
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm     = dyear_${sample}_firm_ft_p/bl_emp
replace treat_norm = 0 if treat_norm == .

forvalues i = 1(1)7 {
		gen d`i'_treat = t`i' * treat_norm
}

global tlist_treat d1_treat d2_treat d4_treat d5_treat d6_treat d7_treat

gen treat_post           = post*treat_norm



*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}
     
*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale



rename cambiamento_medio_ft_p cm_ft_p	   
global out_did cm_ft_p 
global aff_sample 
local sr

forvalues i = 1(1)2 {
foreach x in terc {
foreach q in ft_p {
foreach y of global out_did {

    cumul avg_change_emp if cc == 1 & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 /// 
	                        & bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample}, gen(temp)
	bysort codice_fiscale: egen cdf_emp_growth = max(temp)
	drop   temp
	
	*gen quartile and tercile
	gen     emp_growth_quartile = 1 if cdf_emp_growth <= 0.25
	replace emp_growth_quartile = 2 if cdf_emp_growth > 0.25 & cdf_emp_growth <= 0.5
	replace emp_growth_quartile = 3 if cdf_emp_growth > 0.5  & cdf_emp_growth <= 0.75
	replace emp_growth_quartile = 4 if cdf_emp_growth > 0.75 & cdf_emp_growth != .
	
	gen     emp_growth_tercile = 1 if cdf_emp_growth <= 0.3333334
	replace emp_growth_tercile = 2 if cdf_emp_growth >  0.3333334 & cdf_emp_growth <= 0.6666667
	replace emp_growth_tercile = 3 if cdf_emp_growth >  0.6666667 & cdf_emp_growth != .
	
	*gen treat interaction
     gen eg_top_terc  = (emp_growth_tercile==3)
     gen eg_med_terc  = (emp_growth_tercile==2)
     gen eg_bot_terc  = (emp_growth_tercile==1)
     gen eg_top_quar  = (emp_growth_quartile==4)
     gen eg_med2_quar = (emp_growth_quartile==3)
     gen eg_med1_quar = (emp_growth_quartile==2)
     gen eg_bot_quar  = (emp_growth_quartile==1)

    gen treat_post_top_`x'  = post*treat_norm*eg_top_`x'
    gen treat_post_bot_`x'  = post*treat_norm*eg_bot_`x'
   
    gen post_top_`x' = post*eg_top_`x'
    gen post_bot_`x' = post*eg_bot_`x'
   
    global treat_ddd_`x' treat_post_top_`x' treat_post_bot_`x' treat_post post_top_`x' post_bot_`x'


	reghdfe `y' ${treat_ddd_`x'} ///
	if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale) 
	estimates store Ec`y'`x'`sr'
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*test for coeff inequality
	test treat_post_bot_`x' - treat_post_top_`x' = 0
	local sign = sign(_b[treat_post_bot_`x']-_b[treat_post_top_`x'])
	estadd local pval = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1 & eg_top_`x'==1
	estadd local sd_treat_top = round(r(sd), 0.01) 
	estadd local mean_treat_top = round(r(mean), 0.01)

	qui sum treat_norm if e(sample) & cc_firm == 1 & eg_bot_`x'==1
	estadd local sd_treat_bot = round(r(sd), 0.01) 
	estadd local mean_treat_bot = round(r(mean), 0.01)
	drop cc_firm

	*Add effect of treatment on top and bottom
	lincom treat_post_bot_`x' + treat_post
	estadd local mean_dd_bot=round(r(estimate), 0.01)
	estadd local sd_dd_bot=round(r(se), 0.01)
	estadd local pval_dd_bot=2*ttail(r(df),abs(r(estimate)/r(se)))	

	lincom treat_post_top_`x' + treat_post
	estadd local mean_dd_top=round(r(estimate), 0.01)
	estadd local sd_dd_top=round(r(se), 0.01)
	estadd local pval_dd_top=2*ttail(r(df),abs(r(estimate)/r(se)))

	estadd local controls "Yes"
	drop       cdf_emp_growth emp_growth_quartile emp_growth_tercile *eg_top* *eg_bot* *eg_med* *post_top* *post_bot*
	macro drop treat_ddd_`x'
	
}
}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	
	
	
}





*Gen Tables
#delimit ;
	estout Eccm_ft_pterc Eccm_ft_pterc_sr
	using "${directory_out}\table_app_11_col_1_3.tex", replace style(tex) label
	keep(treat_post_bot_`x' treat_post_top_`x' treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat_top sd_treat_top mean_treat_bot sd_treat_bot pval mean_dd_bot sd_dd_bot pval_dd_bot mean_dd_top sd_dd_top pval_dd_top controls, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean - Top" "Treatment SD - Top" "Treatment Mean - Bottom" "Treatment SD - Bottom" "p-value Bottom < Top" "ATE on Bottom" "SE ATE on Bottom" "p-value ATE on Bottom" "ATE on Top" "SE ATE on Top" "p-value ATE on Top" "Controls"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post_top_`x' "Treatment X Top X Post" treat_post_bot_`x' "Treatment X Bottom X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr
	
estimates clear



*-------------------------------------------------------------------------------
*					    Columns 2 and 4 
*-------------------------------------------------------------------------------

use  "${data}\baseline_panel.dta", clear

*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\flag_span_wage.dta"
drop if _merge == 2
drop _merge

*gen variables for span
gen tbsp = tot_top_sec_prov_med/tot_bot_sec_prov_med
gen btsp = tot_bot_sec_prov_med/tot_top_sec_prov_med
gen shtsp  = tot_top_sec_prov_med/tot_emp

gen tbspe = tot_top_sec_prov_emp_med/tot_bot_sec_prov_emp_med
gen btspe = tot_bot_sec_prov_emp_med/tot_top_sec_prov_emp_med
gen shtspe  = tot_top_sec_prov_emp_med/tot_emp

global flag_span shtspe

*rename outcomes
rename cambiamento_medio_ft_p cm_ft_p
rename d_teorica_adj_ft_p_age1 d_adj_1
rename d_teorica_adj_ft_p_age2 d_adj_2
rename d_teorica_adj_ft_p_age3 d_adj_3

#delimit;
global out cm_ft_p ;
#delimit cr

*gen global for table
foreach y of global out {
	global out_table_`y' 
foreach x of global flag_span {
	local sr
	forvalues i = 1(1)2 {
	
		global out_table_`y' ${out_table_`y'} Ec`y'`x'`sr'
		local sr _sr
		
	}
}
}


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7
bysort codice_fiscale: gen cc = _n 


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm     = dyear_${sample}_firm_ft_p/bl_emp 
replace treat_norm = 0 if treat_norm == .

forvalues i = 1(1)7 {
		gen d`i'_treat = t`i' * treat_norm
}

global tlist_treat d1_treat d2_treat d4_treat d5_treat d6_treat d7_treat

gen treat_post           = post*treat_norm



*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}       

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global aff_sample 
local sr

forvalues i = 1(1)2 {
foreach x in terc {
foreach q in ft_p {
foreach y of global out {
foreach zz of global flag_span {

    xtile temp = `zz' if cc == 1 /// 
	                        & bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample}, nq(2)
	bysort codice_fiscale: egen `zz'_med = max(temp)
	drop   temp
	
	*gen flag for interaction
	gen `zz'_above_median = (`zz'_med==2)
	replace `zz'_above_median = . if `zz'_med==.
	
	*gen treat interactions
    gen treat_post_top  = post*treat_norm*`zz'_above_median
   
    gen post_top = post*`zz'_above_median

   
    global treat_ddd treat_post_top treat_post post_top


	reghdfe `y' ${treat_ddd} ///
	if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale) 
	estimates store Ec`y'`zz'`sr'
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1 & `zz'_above_median==1
	estadd local sd_treat_top = round(r(sd), 0.01) 
	estadd local mean_treat_top = round(r(mean), 0.01)

	qui sum treat_norm if e(sample) & cc_firm == 1 & `zz'_above_median==0
	estadd local sd_treat_bot = round(r(sd), 0.01) 
	estadd local mean_treat_bot = round(r(mean), 0.01)
	drop cc_firm
	

	*Add effect of treatment on top and bottom
	lincom treat_post
	estadd local mean_dd_bot=round(r(estimate), 0.01)
	estadd local sd_dd_bot=round(r(se), 0.01)
	estadd local pval_dd_bot=2*ttail(r(df),abs(r(estimate)/r(se)))	

	lincom treat_post_top + treat_post
	estadd local mean_dd_top=round(r(estimate), 0.01)
	estadd local sd_dd_top=round(r(se), 0.01)
	estadd local pval_dd_top=2*ttail(r(df),abs(r(estimate)/r(se)))

	estadd local controls "Yes"
	estadd local name_flag "`zz'"
	drop       *_above_median   *post_top* `zz'_med
	macro drop treat_ddd_`x'
	
}
}
}
}

	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	
	
	
}



*Gen Tables
foreach y of global out {

	#delimit ;
	estout ${out_table_`y'}
	using "${directory_out}\table_app_11_col_2_4.tex", replace style(tex) label
	keep(treat_post_top treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat_top sd_treat_top mean_treat_bot sd_treat_bot mean_dd_bot sd_dd_bot pval_dd_bot mean_dd_top sd_dd_top pval_dd_top controls name_flag, fmt(%18.0gc) 
	label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean - Top" "Treatment SD - Top" "Treatment Mean - Bottom" "Treatment SD - Bottom" "ATE on Bottom" "SE ATE on Bottom" "p-value ATE on Bottom" "ATE on Top" "SE ATE on Top" "p-value ATE on Top" "Controls" "Name Flag"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post_top_`x' "Treatment X Top X Post" treat_post_bot_`x' "Treatment X Bottom X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr
	
}

