********************************************************************************
*
*						Table 4 - Replication
*
********************************************************************************


***********************************************
* ANALYSIS ON EMPLOYMENT AND TURNOVER MARGIN 
***********************************************


*-------------------------------------------------------------------------------
*					    Columns 2, 3, 5, and 7 
*-------------------------------------------------------------------------------

use  "${data}\baseline_panel.dta", clear


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7

*gen fire not affected 
gen y_fire_dur1_noaff = y_fire_dur1_y + y_fire_dur1_m_noaff + y_fire_dur1_o_noaff

#delimit;
global out y_hire 
		   y_fire_dur1_noaff y_fire_dur1 
		   y_emp 
#delimit cr

global out_table y_hire y_fire_dur1 

*fill outcomes with missing to preserve simmetry
gen y_hire_o_noaff = 0 
gen y_hire_noaff = 0 
gen y_emp_o_noaff = 0
gen y_ren_all_o_noaff = 0 


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7 

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


*With baseline controls
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach y of global out {


	reghdfe `y' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline} )  vce(cluster codice_fiscale)
	estimates store Ec`sr'`y'
	
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}


	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables
#delimit;
global out y_hire 
		   y_fire_dur1_noaff y_fire_dur1 
		   y_emp 
#delimit cr

#delimit ;
	estout Ecy_fire_dur1_noaff Ecy_fire_dur1 Ecy_hire Ecy_emp
	using "${directory_out}/table_4_panel_A_col_2_3_5_7.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr


#delimit ;
	estout Ec_sry_fire_dur1_noaff Ec_sry_fire_dur1 Ec_sry_hire Ec_sry_emp
	using "${directory_out}/table_4_panel_B_col_2_3_5_7.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr


estimates clear



*-------------------------------------------------------------------------------
*					   Columns 4 and 6 
*-------------------------------------------------------------------------------

use  "${data}\final_panel_unit.dta", clear

*merge flag no missing in cambiamento_medio
merge m:1 codice_fiscale anno_riferimento using "${data}\baseline_panel.dta", keep(1 3) keepusing(flag_balanced_cm)
drop _merge

*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7


*drop apprendisti and manager (classified as qualif3 missing, see merge_dataset_firm_units, they have suffix 1)
drop if qualif3 == . 

*gen unit employment at baseline
gen bl_emp_unit = y_emp_pos if anno_riferimento == 2009

*dummy if at least two units with at least 3 employees in 2009
gen temp = (bl_emp_unit>=3 & bl_emp_unit!=.)
bysort codice_fiscale: egen temp2 = total(temp)
gen sample_reg = (temp2>=2)
drop temp temp2


*global with outcomes
global out y_hire_pos y_fire_dur1_pos 


*encode unit of analysis
egen long temp = group(codice_fiscale qualif3)
rename codice_fiscale codice_fiscale_str
rename temp id_unit
egen long unit_time = group(anno_riferimento qualif3)


*firm-unit counter
bysort codice_fiscale qualif3: gen cc = _n


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment 
*gen in-unit treatment                                     
gen treat_unit = tot_dyeartyFT_sample${sample}_u/bl_emp 
	
*gen other unit treatment (subtract from total of the firm)
gen treat_emp_other            = blty_totempFT_ylr${sample}    - blty_totempFT_ylr${sample}_u
gen treat_dyear_other          = tot_dyeartyFT_sample${sample} - tot_dyeartyFT_sample${sample}_u
gen treat_other  = treat_dyear_other/bl_emp 
	
*replace missing cases in firms included in our sample
replace treat_unit       = 0 if treat_unit  == .
replace treat_other      = 0 if treat_other == .

*gen treat interaction
gen treat_unit_post = post*treat_unit
gen treat_other_post = post*treat_other


*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_mean_dwage bl_ateco07 bl_prov 
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list treat_unit_post treat_other_post

                   

*With baseline controls
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach y of global out {


	reghdfe `y' ${treat_list} if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.time i.id_unit i.unit_time ${contr_baseline} )  vce(cluster codice_fiscale)
	estimates store Ec`sr'`y'
	
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	
	*stats for treatment in unit
	qui sum treat_unit_post if cc == 1 & e(sample)
	estadd local sd_treat   = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01)
						
    *stats for treatment in other units
	qui sum treat_other_post if cc == 1 & e(sample)
	estadd local sd_oth_treat   = round(r(sd), 0.01) 
	estadd local mean_oth_treat = round(r(mean), 0.01)
									
	*test inequality between coeff
	test treat_unit_post - treat_other_post = 0 
	estadd local pval_simm = r(p)
	local sign = sign(_b[treat_unit_post]-_b[treat_other_post])
					
	if "`y'"=="y_fire_dur1_pos" { 
			estadd local pval_diff = ttail(r(df_r),`sign'*sqrt(r(F)))
	}
					
	if "`y'"=="y_hire_pos" { 
			estadd local pval_diff = 1-ttail(r(df_r),`sign'*sqrt(r(F)))
	}
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}


	global aff_sample & blty_totempFT_ylr${sample}>0 & blty_totempFT_ylr${sample}!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables

#delimit ;
	estout Ecy_fire_dur1_pos Ecy_hire_pos 
	using "${directory_out}/table_4_panel_A_col_4_6.tex", replace style(tex) label
	keep(treat_unit_post treat_other_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform 
	mean_treat sd_treat mean_oth_treat sd_oth_treat 
	pval_simm pval_diff
	controls ss, fmt(%18.0gc) 
	label("Observations" "R-squared" "Mean Outcome (pre 2012)" 
	"Treatment Mean - within Unit" "Treatment SD - within Unit" "Treatment Mean - other Unit" "Treatment SD - other Unit" 
	"P-value Double-sided Test" "P-value One-sided Test"
	"Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr


#delimit ;
	estout  Ec_sry_fire_dur1_pos Ec_sry_hire_pos   
	using "${directory_out}/table_4_panel_B_col_4_6.tex", replace style(tex) label
	keep(treat_unit_post treat_other_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform 
	mean_treat sd_treat mean_oth_treat sd_oth_treat 
	pval_simm pval_diff
	controls ss, fmt(%18.0gc) 
	label("Observations" "R-squared" "Mean Outcome (pre 2012)" 
	"Treatment Mean - within Unit" "Treatment SD - within Unit" "Treatment Mean - other Unit" "Treatment SD - other Unit" 
	"P-value Double-sided Test" "P-value One-sided Test"
	"Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
	#delimit cr


estimates clear




*-------------------------------------------------------------------------------
*					    	Column 1
*-------------------------------------------------------------------------------

use  "${data}\baseline_panel.dta", clear

*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7


#delimit;
global out quit_firm_naf_ft_p ;   
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7      

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale



*With baseline controls
global aff_sample 
local sr
global samp No

forvalues i = 1(1)2 {
foreach y of global out {


	reghdfe `y' treat_post if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline} )  vce(cluster codice_fiscale)
	estimates store Ec`sr'`y'
	
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	
					
	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*treat mean and sd
	bys codice_fiscale: gen cc_firm = _n
	qui sum treat_norm if e(sample) & cc_firm == 1
	estadd local sd_treat = round(r(sd), 0.01) 
	estadd local mean_treat = round(r(mean), 0.01) 
	drop cc_firm
	
	estadd local controls "Yes"
	estadd local ss "${samp}"
	

}


	global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
	local sr _sr
	global samp Yes
	
}


*** gen tables


#delimit ;
	estout Ecquit_firm_naf_ft_p
	using "${directory_out}/table_4_panel_A_col_1.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr

#delimit ;
	estout Ec_srquit_firm_naf_ft_p
	using "${directory_out}/table_4_panel_B_col_1.tex", replace style(tex) label
	keep(treat_post)
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(3)) se(par fmt(3)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N r2 ymean_prereform mean_treat sd_treat controls ss, fmt(%18.0gc) label("Observations" "R-squared" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "Controls" "Restricted Sample"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(treat_post "Treatment X Post")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		    "\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the individual-level.}"
		 "\end{tabular}")
	;
#delimit cr

estimates clear
