********************************************************************************
*
*						Table 1 - Replication
*
********************************************************************************


***********************************************
* PRE-TREND ANALYSIS   
***********************************************

use  "${data}\baseline_panel.dta", clear

 
*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7

drop if anno_riferimento>2011


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)


*gen treatment normalized
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp

*gen treatment normalized
gen treat_norm_bc = dyear_${sample}_firm_bc_ft_p/bl_emp
gen treat_norm_wc = dyear_${sample}_firm_wc_ft_p/bl_emp
gen treat_norm_mng = dyear_${sample}_firm_mng_ft_p/bl_emp
gen treat_norm_bcwc = (dyear_${sample}_firm_bc_ft_p + dyear_${sample}_firm_wc_ft_p)/(bl_emp)

*gen treat interaction
replace treat_norm_bc = 0 if treat_norm_bc == .
replace treat_norm_wc = 0 if treat_norm_wc == .
replace treat_norm_mng = 0 if treat_norm_mng == .
replace treat_norm_bcwc = 0 if treat_norm_bcwc == .
forvalues i = 1(1)3 {
		gen d`i'_bc = t`i' * treat_norm_bc
		gen d`i'_wc = t`i' * treat_norm_wc
		gen d`i'_mng = t`i' * treat_norm_mng
		gen d`i'_bcwc = t`i' * treat_norm_bcwc
}


*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)3 {
		gen d`i' = t`i' * treat_norm
}

gen treat_linear_trend = time * treat_norm
gen treat_quadratic_trend = time^2*treat_norm

gen treat_linear_trend_wc = time * treat_norm_wc
gen treat_quadratic_trend_wc = time^2*treat_norm_wc

gen treat_linear_trend_mng = time * treat_norm_mng
gen treat_quadratic_trend_mng = time^2*treat_norm_mng

gen treat_linear_trend_bc = time * treat_norm_bc
gen treat_quadratic_trend_bc = time^2*treat_norm_bc

gen treat_linear_trend_bcwc = time * treat_norm_bcwc
gen treat_quadratic_trend_bcwc = time^2*treat_norm_bcwc

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2  
global treat_list_bc d1_bc d2_bc 
global treat_list_bcwc d1_bcwc d2_bcwc 
global treat_list_wc d1_wc d2_wc 
global treat_list_mng d1_mng d2_mng 


*global with alternative baseline controls
#delimit;
global contr_baseline3 num_med_bl_age_worker num_med_bl_male_sh 
				       num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					   num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old;				//all controls 
#delimit cr

#delimit;
global contr_baseline2 num_med_bl_male_sh 
				       num_med_bl_firm_age num_bl_ateco07 num_med_bl_mean_dwage   ; //without age and size controls 
#delimit cr
    
#delimit;
global contr_baseline1  ;
#delimit cr
    

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale

rename up_qualifica_wc_naf_p up_qualifica_wc_p
rename up_qualifica_wc_naf_ft_p up_qualifica_wc_ft_p
rename up_qualifica_dir_naf_p up_qualifica_dir_p
rename up_qualifica_dir_naf_ft_p up_qualifica_dir_ft_p

global out cambiamento_medio_ft_p up_qualifica_wc_ft_p up_qualifica_dir_ft_p



*************************
* Run regressions
*************************

*globals for sample restrictions 
global aff_sample 
local sr
local treatment

forvalues i = 1(1)2 {
local counter=0
forvalues ccc = 1(1)3 { //change set of controls 

foreach y of global out {

if "`y'"=="cambiamento_medio_ft_p" local treatment 
if "`y'"=="up_qualifica_wc_ft_p" local treatment _wc
if "`y'"=="up_qualifica_dir_ft_p" local treatment _mng

if "`ccc'"=="1" local no controls
if "`ccc'"=="2" local no size and age controls
if "`ccc'"=="3" local all controls

	reghdfe `y' ${treat_list`treatment'} if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline`ccc'})  vce(cluster codice_fiscale) 
	estimates store Ec`sr'`y'`ccc'
 	
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	estadd local ymean = round(r(mean), 0.01)
	estadd local controls "`con'"

	sum `y' if e(sample) & anno_riferimento <= 2011
	estadd local ymean_prereform = round(r(mean), 0.01)
	
	*test joint significance
	testparm ${treat_list`treatment'}
	estadd local pval_joint = r(p)
	
	bys codice_fiscale: gen cc_firm = _n 
	sum treat_norm`treatment' if e(sample) & cc_firm == 1
	estadd local xmean  = round(r(mean), 0.01)
	estadd local sdmean = round(r(sd), 0.01)
	drop cc_firm
	
	
}
}


global aff_sample & aff_${sample}_firm_ft_p>0 & aff_${sample}_firm_ft_p!=. 
local sr _sr

}



*-------------------------------------------------------------------------------
*					    	Panel A
*-------------------------------------------------------------------------------
#delimit ;
	estout Eccambiamento_medio_ft_p1 Ecup_qualifica_wc_ft_p1 Ecup_qualifica_dir_ft_p1 Ec_srcambiamento_medio_ft_p1 Ec_srup_qualifica_wc_ft_p1 Ec_srup_qualifica_dir_ft_p1
	using "${directory_out}/table_2_panel_A.tex", replace style(tex) label
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform xmean sdmean pval_joint controls, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "P-value Joint Significance" "Controls"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(d1 "Treatment X Year 2009" d2 "Treatment X Year 2010" d1_wc "Treatment wc X Year 2009" d2_wc "Treatment wc X Year 2010" d1_mng "Treatment mng X Year 2009" d2_mng "Treatment mng X Year 2010")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the firm-level.}"
		 "\end{tabular}")
	;
#delimit cr



*-------------------------------------------------------------------------------
*					    	Panel B
*-------------------------------------------------------------------------------
#delimit ;
	estout Eccambiamento_medio_ft_p2 Ecup_qualifica_wc_ft_p2 Ecup_qualifica_dir_ft_p2 Ec_srcambiamento_medio_ft_p2 Ec_srup_qualifica_wc_ft_p2 Ec_srup_qualifica_dir_ft_p2
	using "${directory_out}/table_2_panel_B.tex", replace style(tex) label
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform xmean sdmean pval_joint controls, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "P-value Joint Significance" "Controls"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(d1 "Treatment X Year 2009" d2 "Treatment X Year 2010" d1_wc "Treatment wc X Year 2009" d2_wc "Treatment wc X Year 2010" d1_mng "Treatment mng X Year 2009" d2_mng "Treatment mng X Year 2010")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the firm-level.}"
		 "\end{tabular}")
	;
#delimit cr



*-------------------------------------------------------------------------------
*					    	Panel C
*-------------------------------------------------------------------------------
#delimit ;
	estout Eccambiamento_medio_ft_p3 Ecup_qualifica_wc_ft_p3 Ecup_qualifica_dir_ft_p3 Ec_srcambiamento_medio_ft_p3 Ec_srup_qualifica_wc_ft_p3 Ec_srup_qualifica_dir_ft_p3
	using "${directory_out}/table_2_panel_C.tex", replace style(tex) label
	mlabels(,none)
	numbers(\multicolumn{@span}{c}{( )})
	collabels(none)
	cells(b(star fmt(a2)) se(par fmt(a2)))
	starlevels(* 0.1 ** 0.05 *** 0.01)
	stats(N ymean_prereform xmean sdmean pval_joint controls, fmt(%18.0gc) label("Observations" "Mean Outcome (pre 2012)" "Treatment Mean" "Treatment SD" "P-value Joint Significance" "Controls"))
	substitute(_ \_   % \% ~ _ (!) %)
	extracols(1)
	varlabels(d1 "Treatment X Year 2009" d2 "Treatment X Year 2010" d1_wc "Treatment wc X Year 2009" d2_wc "Treatment wc X Year 2010" d1_mng "Treatment mng X Year 2009" d2_mng "Treatment mng X Year 2010")
	prehead("\begin{tabular}{l l @{\extracolsep{\fill}} *{@M}{r}}" 
		"\hline\hline")	
	posthead(\hline)
	prefoot(\hline)
	postfoot("\hline\hline" 
		 "\multicolumn{@span}{l}{ *** p$<$0.01, ** p$<$0.05, * p$<$0.1}\\"
		 "\multicolumn{@span}{l}{ SE clustered at the firm-level.}"
		 "\end{tabular}")
	;
#delimit cr

estimates clear
		
