********************************************************************************
*
*						Table 1 - Replication
*
********************************************************************************


***********************************************
* SUMMARY STATISTICS ON PROMOTIONS AND TURNOUT  
***********************************************


use "${data}/baseline_panel.dta", clear

*Keep firms open thoughout the period
drop if sample_period_p_ft!=7

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*gen treatment normalized
gen treat_norm     = dyear_${sample}_firm_ft_p/aff_${sample}_firm_ft_p
replace treat_norm = 0 if treat_norm == .

* gen further variables
gen num_retired_ft_p     = retired_firm_ft_p



**** Create table with column (1)
eststo clear
eststo: estpost sum   retired_firm_ft_p openings_ft_p cambiamento_medio_ft_p up_qualifica_wc_naf_ft_p up_qualifica_dir_naf_ft_p ///
					  if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} & anno_riferimento<=2011 & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1
esttab using "${directory_out}/table_1_col_1.xls", cells("mean(fmt(4)) sd(fmt(4))") ///
replace nomtitles onecell nonumbers


**** Create table with column (2)
eststo clear
eststo: estpost sum   retired_firm_ft_p openings_ft_p cambiamento_medio_ft_p up_qualifica_wc_naf_ft_p up_qualifica_dir_naf_ft_p ///
					  if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} & anno_riferimento>2011 & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1
esttab using "${directory_out}/table_1_col_2.xls", cells("mean(fmt(4)) sd(fmt(4))") ///
replace nomtitles onecell nonumbers





