********************************************************************************
*
*					   Replication Package for:
*				Career Spillovers in Internal Labor Markets 
*
********************************************************************************


*** Set useful globals 
global data ""  /*INCLUDE THE PATH TO FOLDER WITH DATA*/
global code ""  /*INCLUDE THE PATH TO CODE FOLDER HERE*/
global directory_out "" /*INCLUDE THE PATH TO FOLDER WHERE YOU WANT THE RESULTS. ALL THE OUTPUT FIGURES AND TABLES ARE ALSO IN THE "RESULTS" FOLDER IN THE REPLICATION PACKAGE*/

*global defining sample restrictions
global sample 3
global ub_emp = 200
global lb_emp = 10
global sample_period = 7
global reducing_sample (num_med_bl_age_worker!=. & num_med_bl_male_sh!=. & num_med_bl_firm_age!=. & num_bl_ateco07!=. & num_med_bl_share_young!=. & ///
						num_med_bl_share_middle!=. & num_med_bl_share_old!=. & num_med_bl_emp!=. & num_med_bl_mean_dwage!=. & flag_balanced_cm==1)
*global baseline controls
#delimit;
global contr_baseline num_med_bl_age_worker num_med_bl_male_sh 
				      num_med_bl_firm_age num_bl_ateco07 num_med_bl_emp num_med_bl_mean_dwage
					  num_med_bl_share_young num_med_bl_share_middle num_med_bl_share_old  ;
#delimit cr


*------------------------------------------
*********** Run replication code **********
*------------------------------------------

*-----------------------------------
*************** Figures ************
*-----------------------------------

** Figure 1 - creates two files: "figure_1_panel_A", "figure_1_panel_B"
do "${code}/figure_1.do" 

** Figure 2 - creates one file: "figure_2"
do "${code}/figure_2.do" 

** Figure 3 - creates two files: "figure_3_panel_A", "figure_3_panel_B"
do "${code}/figure_3.do" 

** Figure 4 - creates two files: "figure_4_panel_A", "figure_4_panel_B"
do "${code}/figure_4.do"


*-----------------------------------
*************** Tables *************
*-----------------------------------

** Table 1 - creates two files: "table_1_col_1.xls" with column (1), "table_1_col_2.xls" with column (2)
do "${code}/table_1.do" 

** Table 2 - creates three files: "table_2_panel_A.tex" with panel A of table 2, "table_2_panel_B.tex" with panel B of table 2, "table_2_panel_C.tex" with panel C of table 2, 
do "${code}/table_2.do" 

** Table 3 - creates two files: "table_3_col_1_4.tex" with columns (1) and (4), "table_3_col_2_3_5_6.tex" with columns (2), (3), (5), (6)
do "${code}/table_3.do" 

** Table 4 - creates six files: "table_4_panel_A_col_1.tex", "table_4_panel_B_col_1.tex", "table_4_panel_A_col_2_3_5_7.tex", "table_4_panel_B_col_2_3_5_7.tex", "table_4_panel_A_col_4_6.tex", "table_4_panel_B_col_4_6.tex"
do "${code}/table_4.do" 



*-----------------------------------
****** Appendix Figures ************
*-----------------------------------

** Appendix Figure 1-4 do not use data but describe policy-driven change in retirement eligibility

** Appendix Figure 5 - creates three file: "figure_app_5_panel_A", "figure_app_5_panel_B", "figure_app_5_panel_C"
do "${code}/figure_app_5.do" 

*-----------------------------------
****** Appendix Tables *************
*-----------------------------------

** Appendix Table 1 does not use data but describes policy-driven change in retirement eligibility

** Appendix Table 2 - creates one file: "table_app_2"
do "${code}/table_app_2.do" 

** Appendix Table 3 - creates one file: "table_app_3"
do "${code}/table_app_3.do" 

** Appendix Table 4 - creates four files: "table_app_4_col_1_2", "table_app_4_col_3_4", "table_app_4_col_5_6", "table_app_4_col_7_8"
do "${code}/table_app_4.do" 

** Appendix Table 5 - creates one file: "table_app_5"
do "${code}/table_app_5.do" 

** Appendix Table 6 - creates two files: "table_app_6_panel_A" and "table_app_6_panel_B"
do "${code}/table_app_6.do" 

** Appendix Table 7 - creates six files: "table_app_7_col_1", "table_app_7_col_2", "table_app_7_col_3", "table_app_7_col_4", "table_app_7_col_5", "table_app_7_col_6",
do "${code}/table_app_7.do" 

** Appendix Table 8 - creates two files: "table_app_8_col_1_4" and "table_app_8_col_2_3_5_6"
do "${code}/table_app_8.do" 

** Appendix Table 9 - creates two files: "table_app_9_col_1_4" and "table_app_9_col_2_3_5_6"
do "${code}/table_app_9.do" 

** Appendix Table 10 - creates one file: "table_app_10"
do "${code}/table_app_10.do" 

** Appendix Table 11 - creates two files: "table_app_11_col_1_3" and "table_app_11_col_2_4"
do "${code}/table_app_11.do" 

** Appendix Table 12 - creates one file: "table_app_12"
do "${code}/table_app_12.do" 

** Appendix Table 13 - creates one file: "table_app_13"
do "${code}/table_app_13.do" 

** Appendix Table 14 - back-of-the-envelope calculations that do not use new data. Formulas in footnote 34 of the manuscript

** Appendix Table 15 - creates two files: "table_app_15_col_1_2_5_6" and "table_app_15_col_3_4_7_8"
do "${code}/table_app_15.do" 

** Appendix Table 16 - creates one file: "table_app_16"
do "${code}/table_app_16.do" 
