********************************************************************************
*
*						Figure 4 - Replication
*
********************************************************************************


***********************************************
* BASELINE RESULT ON EMPLOYMENT GROWTH TERTILES 
***********************************************

use  "${data}\baseline_panel.dta", clear

*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\firm_emp_growth_pctiles.dta"
drop if _merge == 2
drop _merge

*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7
bysort codice_fiscale: gen cc = _n 


#delimit;
global out cambiamento_medio_ft_p ;
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized
gen treat_norm     = dyear_${sample}_firm_ft_p/bl_emp
replace treat_norm = 0 if treat_norm == .

forvalues i = 1(1)7 {
		gen d`i'_treat = t`i' * treat_norm
}

global tlist_treat d1_treat d2_treat d4_treat d5_treat d6_treat d7_treat

gen treat_post           = post*treat_norm



*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}
                      

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


*************************
* Run regressions
*************************

*globals for sample restrictions 
global aff_sample 
global sr

foreach y of global out {

	global controls ctrl
	local x terc
	
	cumul avg_change_emp if cc == 1 & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 /// 
	                        & bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample}, gen(temp)
	bysort codice_fiscale: egen cdf_emp_growth = max(temp)
	drop   temp
	
	*gen quartile and tercile
	gen     emp_growth_quartile = 1 if cdf_emp_growth <= 0.25
	replace emp_growth_quartile = 2 if cdf_emp_growth > 0.25 & cdf_emp_growth <= 0.5
	replace emp_growth_quartile = 3 if cdf_emp_growth > 0.5  & cdf_emp_growth <= 0.75
	replace emp_growth_quartile = 4 if cdf_emp_growth > 0.75 & cdf_emp_growth != .
	
	gen     emp_growth_tercile = 1 if cdf_emp_growth <= 0.3333334
	replace emp_growth_tercile = 2 if cdf_emp_growth >  0.3333334 & cdf_emp_growth <= 0.6666667
	replace emp_growth_tercile = 3 if cdf_emp_growth >  0.6666667 & cdf_emp_growth != .
	
		
	*gen treat interaction
     gen eg_top_terc  = (emp_growth_tercile==3)
     gen eg_med_terc  = (emp_growth_tercile==2)
     gen eg_bot_terc  = (emp_growth_tercile==1)
     gen eg_top_quar  = (emp_growth_quartile==4)
     gen eg_med2_quar = (emp_growth_quartile==3)
     gen eg_med1_quar = (emp_growth_quartile==2)
     gen eg_bot_quar  = (emp_growth_quartile==1)
	 
	 forvalues i = 1(1)7 {
		gen d`i'_treat_eg_top_`x' = t`i' * treat_norm * eg_top_`x'
		gen d`i'_treat_eg_bot_`x' = t`i' * treat_norm * eg_bot_`x'
		
		gen d`i'_eg_top_`x' = t`i' * eg_top_`x'
		gen d`i'_eg_bot_`x' = t`i' * eg_bot_`x'
		
      }
	  
	 *global treatment
      global tlist_treat_eg_top_`x' d1_treat_eg_top_`x' d2_treat_eg_top_`x' d4_treat_eg_top_`x' d5_treat_eg_top_`x' d6_treat_eg_top_`x' d7_treat_eg_top_`x' 
      global tlist_treat_eg_bot_`x' d1_treat_eg_bot_`x' d2_treat_eg_bot_`x' d4_treat_eg_bot_`x' d5_treat_eg_bot_`x' d6_treat_eg_bot_`x' d7_treat_eg_bot_`x'
      
      global tlist_eg_top_`x' d1_eg_top_`x' d2_eg_top_`x' d4_eg_top_`x' d5_eg_top_`x' d6_eg_top_`x' d7_eg_top_`x'
      global tlist_eg_bot_`x' d1_eg_bot_`x' d2_eg_bot_`x' d4_eg_bot_`x' d5_eg_bot_`x' d6_eg_bot_`x' d7_eg_bot_`x'
    

	reghdfe `y' ${treat_list} ${tlist_treat_eg_top_`x'} ${tlist_treat_eg_bot_`x'} ${tlist_treat} ${tlist_eg_top_`x'} ${tlist_eg_bot_`x'} ///
	if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} ${aff_sample} & ${reducing_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale) 
	
	
	*store useful statistics
	global nobs = e(N)
					
	sum `y' if e(sample)
	global ymean = round(r(mean), 0.01)
	estadd ysumm
			
	sum `y' if e(sample) & anno_riferimento <= 2011
	global ymean_prereform = round(r(mean), 0.01)
	di "${ymean_prereform}"
	
	bys codice_fiscale: gen cc_firm = _n 
	sum treat_norm if e(sample) & cc_firm == 1 
	global xmean  = round(r(mean), 0.01)
	global sdmean = round(r(sd), 0.01)
	drop cc_firm

	
	
	global outcome `y'
	global pct_opt `x'
	global weight
	global sm _sm
	
	
	**** Plot graphs 
	preserve
	clear

	tempfile d1_bot d2_bot d4_bot d5_bot d6_bot d7_bot d1_top d2_top d4_top d5_top d6_top d7_top 
	est store est_${outcome}

	foreach i in 1 2 4 5 6 7 {
		lincomest _b[d`i'_treat]+_b[d`i'_treat_eg_top_${pct_opt}]  
		parmest,label saving(`d`i'_top', replace)
		estimate restore est_${outcome}
		lincomest _b[d`i'_treat]+_b[d`i'_treat_eg_bot_${pct_opt}]
		parmest,label saving(`d`i'_bot', replace)
		estimate restore est_${outcome}

	}

	dsconcat `d1_bot' `d2_bot' `d4_bot' `d5_bot' `d6_bot' `d7_bot' `d1_top' `d2_top' `d4_top' `d5_top' `d6_top' `d7_top' 


	gen temp = _n
	gen line_num = 1 if temp<=6
	replace line_num = 2 if temp>6 & temp<=12

	gen year = 2009 if temp==1 | temp==7
	replace year = 2010 if temp==2 | temp==8
	replace year = 2012 if temp==3 | temp==9
	replace year = 2013 if temp==4 | temp==10
	replace year = 2014 if temp==5 | temp==11
	replace year = 2015 if temp==6 | temp==12

	rename min95 ci_lower
	rename max95 ci_upper
	rename estimate coef

	local nn=_N+2
	set obs `nn'
	replace year=2011 if year==. 


	replace coef = 0 if year==2011
	replace ci_upper = 0 if year==2011
	replace ci_lower = 0 if year==2011
	drop temp
	bysort year: gen temp = _n if year==2011
	replace line_num = temp if year==2011

	
	
*-------------------------------------------------------------------------------
*					    	Panel B
*-------------------------------------------------------------------------------


	if "${pct_opt}" == "terc" global label_graph "tertile"
	if "${pct_opt}" == "quar" global label_graph "quartile"

	graph twoway (rcap ci_upper ci_lower year if line_num==1, color(black) lpattern(dash)) ///
				 (connected coef year if line_num==1, color(black) lpattern(solid)) ///
				 (rcap ci_upper ci_lower year if line_num==2, color(red) lpattern(dash) msize(medlarge)) ///
				 (connected coef year if line_num==2, color(red) lpattern(dash)), ///
	xtitle("Year") xlabel(2009(1)2015, labsize(small)) ylabel(#10, labsize(small) angle(0) glcolor(gs16)) yline(0, lcolor(black)) ///
	xline(2011, lcolor(red)) graphregion(color(white)) plotregion(color(white)) ///
	legend(order(2 4) col(1) label(2 "Bottom ${label_graph}") label(4 "Top ${label_graph}")) //


	graph export "${directory_out}\figure_4_panel_B.pdf", replace
	restore	



*-------------------------------------------------------------------------------
*					    	Panel A
*-------------------------------------------------------------------------------

	preserve
	regsave, ci level(95)

	keep if regexm(var, "d")

	gen     line_num = 1 if var=="d1_treat_eg_top_${pct_opt}" | var=="d2_treat_eg_top_${pct_opt}" | var=="d4_treat_eg_top_${pct_opt}" | var=="d5_treat_eg_top_${pct_opt}" | var=="d6_treat_eg_top_${pct_opt}" | var=="d7_treat_eg_top_${pct_opt}"
	replace line_num = 2 if var=="d1_treat_eg_bot_${pct_opt}" | var=="d2_treat_eg_bot_${pct_opt}" | var=="d4_treat_eg_bot_${pct_opt}" | var=="d5_treat_eg_bot_${pct_opt}" | var=="d6_treat_eg_bot_${pct_opt}" | var=="d7_treat_eg_bot_${pct_opt}"

	replace var="2009" if var=="d1_treat_eg_top_${pct_opt}"
	replace var="2010" if var=="d2_treat_eg_top_${pct_opt}"
	replace var="2012" if var=="d4_treat_eg_top_${pct_opt}"
	replace var="2013" if var=="d5_treat_eg_top_${pct_opt}"
	replace var="2014" if var=="d6_treat_eg_top_${pct_opt}"
	replace var="2015" if var=="d7_treat_eg_top_${pct_opt}"

	replace var="2009" if var=="d1_treat_eg_bot_${pct_opt}"
	replace var="2010" if var=="d2_treat_eg_bot_${pct_opt}"
	replace var="2012" if var=="d4_treat_eg_bot_${pct_opt}"
	replace var="2013" if var=="d5_treat_eg_bot_${pct_opt}"
	replace var="2014" if var=="d6_treat_eg_bot_${pct_opt}"
	replace var="2015" if var=="d7_treat_eg_bot_${pct_opt}"

	destring var, replace force
	drop if var==.

	local nn=_N+2
	set obs `nn'
	replace var=2011 if var==. 
	replace coef = 0 if var==2011
	replace ci_upper = 0 if var==2011
	replace ci_lower = 0 if var==2011
	bysort var: gen temp = _n 
	replace line_num = temp if var==2011
	sort var



	graph twoway (rcap ci_upper ci_lower var if line_num==1, color(red) lpattern(dash)) ///
				 (connected coef var if line_num==1, color(red) lpattern(dash)) ///
				 (rcap ci_upper ci_lower var if line_num==2, color(black) lpattern(dash) msize(medlarge)) ///
				 (connected coef var if line_num==2, color(black) lpattern(solid)), ///
	xtitle("Year") xlabel(2009(1)2015, labsize(small)) ylabel(#10, labsize(small) angle(0) glcolor(gs16)) yline(0, lcolor(black)) ///
	xline(2011, lcolor(red)) graphregion(color(white)) plotregion(color(white)) ///
	legend(order(2 4) col(1) label(2 "Top vs. middle ${label_graph}") label(4 "Bottom vs. middle ${label_graph}")) //
		
	graph export "${directory_out}\figure_4_panel_A.pdf", replace
	restore	
		
	
    drop        cdf_emp_growth emp_growth_quartile emp_growth_tercile *eg_top* *eg_med* *eg_bot*
	macro drop  tlist_treat_eg_top_`x' tlist_treat_eg_bot_`x' tlist_eg_top_`x' tlist_eg_bot_`x' 
}

