********************************************************************************
*
*						Figure 3 - Replication
*
********************************************************************************


***********************************************
* BASELINE RESULT ON CATEGORICAL PROMOTIONS
***********************************************

use "${data}\baseline_panel.dta", clear


*merge emp_growth percentiles
merge m:1 codice_fiscale using "${data}\emp_by_qual.dta", keepusing(emp_bc_2011 emp_wc_2011 emp_mng_2011)
drop if _merge == 2
drop _merge

*flags for at least two units
gen flag_sample_wc = (emp_bc_2011>0 & emp_wc_2011>0)
gen flag_sample_mng = ((emp_bc_2011>0 & emp_mng_2011>0) | (emp_wc_2011>0 & emp_mng_2011>0)) 


*Keep imprese open thoughout the period
drop if sample_period_p_ft !=7

*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)


*gen treatment normalized
gen treat_norm_bc = dyear_${sample}_firm_bc_ft_p/bl_emp
gen treat_norm_wc = dyear_${sample}_firm_wc_ft_p/bl_emp
gen treat_norm_mng = dyear_${sample}_firm_mng_ft_p/bl_emp
gen treat_norm_bcwc = (dyear_${sample}_firm_bc_ft_p + dyear_${sample}_firm_wc_ft_p)/bl_emp

*gen treat interaction
replace treat_norm_bc   = 0  if treat_norm_bc == .
replace treat_norm_wc   = 0  if treat_norm_wc == .
replace treat_norm_mng  = 0  if treat_norm_mng == .
replace treat_norm_bcwc = 0 if treat_norm_bcwc == .
forvalues i = 1(1)7 {
		gen d`i'_bc = t`i' * treat_norm_bc
		gen d`i'_wc = t`i' * treat_norm_wc
		gen d`i'_mng = t`i' * treat_norm_mng
		gen d`i'_bcwc = t`i' * treat_norm_bcwc
}
gen dpost_bc    = post*treat_norm_bc
gen dpost_wc    = post*treat_norm_wc
gen dpost_bcwc  = post*treat_norm_bcwc
gen dpost_mng   = post*treat_norm_mng

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list_wc d1_bc d2_bc d4_bc d5_bc d6_bc d7_bc d1_wc d2_wc d4_wc d5_wc d6_wc d7_wc 
global treat_list_mng d1_bcwc d2_bcwc d4_bcwc d5_bcwc d6_bcwc d7_bcwc d1_mng d2_mng d4_mng d5_mng d6_mng d7_mng 
global treat_post_wc dpost_bc dpost_wc
global treat_post_mng dpost_bcwc dpost_mng


*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


global out_wc      up_qualifica_wc_naf_ft_p 
global out_mng     up_qualifica_dir_naf_ft_p 


*sample restrictions 
local sample_reg bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample}
local sample_restr 





*-------------------------------------------------------------------------------
*					    	Panel A
*-------------------------------------------------------------------------------


foreach y of global out_wc {

	global controls ctrl
	global qual wc

	reghdfe `y' ${treat_list_${qual}} if `sample_reg' & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	global ymean = round(r(mean), 0.01)
	estadd ysumm

					
	sum `y' if e(sample) & anno_riferimento <= 2011
	global ymean_prereform = round(r(mean), 0.01)
	di "${ymean_prereform}"
	
	bys codice_fiscale: gen cc_firm = _n 
	sum treat_norm_`var' if e(sample) & cc_firm == 1 
	global xmean  = round(r(mean), 0.01)
	global sdmean = round(r(sd), 0.01)
	drop cc_firm
	

	
	global outcome `y'
	global sr `sample_restr'_sm
	global weight 
	
	*plot graph
	preserve
	regsave, ci level(95)

	keep if regexm(var, "d")

	gen line_num = 1 if var=="d1_${qual}" | var=="d2_${qual}" | var=="d4_${qual}" | var=="d5_${qual}" | var=="d6_${qual}" | var=="d7_${qual}"
	replace line_num = 2 if var=="d1_bc" | var=="d2_bc" | var=="d4_bc" | var=="d5_bc" | var=="d6_bc" | var=="d7_bc"


	replace var="2009" if var=="d1_${qual}"
	replace var="2010" if var=="d2_${qual}"
	replace var="2012" if var=="d4_${qual}"
	replace var="2013" if var=="d5_${qual}"
	replace var="2014" if var=="d6_${qual}"
	replace var="2015" if var=="d7_${qual}"

	replace var="2009" if var=="d1_bc"
	replace var="2010" if var=="d2_bc"
	replace var="2012" if var=="d4_bc"
	replace var="2013" if var=="d5_bc"
	replace var="2014" if var=="d6_bc"
	replace var="2015" if var=="d7_bc"

	destring var, replace force
	drop if var==.

	local nn=_N+2
	set obs `nn'
	replace var=2011 if var==. 
	replace coef = 0 if var==2011
	replace ci_upper = 0 if var==2011
	replace ci_lower = 0 if var==2011
	bysort var: gen temp = _n 
	replace line_num = temp if var==2011
	sort var



	graph twoway (rcap ci_upper ci_lower var if line_num==1, color(black) lpattern(dash)) ///
	(connected coef var if line_num==1, color(black) lpattern(solid))  ///
	(rcap ci_upper ci_lower var if line_num==2, color(red) msize(medlarge) lpattern(dash)) ///
	(connected coef var if line_num==2, color(red) lpattern(dash)), ///
	xtitle("Year") xlabel(2009(1)2015, labsize(small)) ylabel(#10, labsize(small) angle(0) glcolor(gs16)) ///
	yline(0, lcolor(black)) ///
	xline(2011, lcolor(red)) graphregion(color(white)) plotregion(color(white)) ///
	legend(order(2 4) col(1) label(2 "White collar") label(4 "Blue collar")) //
	
	graph export "${directory_out}\figure_3_panel_A.pdf", replace		

	restore	
	
}



*-------------------------------------------------------------------------------
*					    	Panel B 
*-------------------------------------------------------------------------------



foreach y of global out_mng {

	global controls ctrl
	global qual mng

	reghdfe `y' ${treat_list_${qual}} if `sample_reg' & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline})  vce(cluster codice_fiscale)
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	global ymean = round(r(mean), 0.01)
	estadd ysumm

					
	sum `y' if e(sample) & anno_riferimento <= 2011
	global ymean_prereform = round(r(mean), 0.01)
	di "${ymean_prereform}"
	
	bys codice_fiscale: gen cc_firm = _n 
	sum treat_norm_`var' if e(sample) & cc_firm == 1 
	global xmean  = round(r(mean), 0.01)
	global sdmean = round(r(sd), 0.01)
	drop cc_firm
	

	
	global outcome `y'
	global sr `sample_restr'_sm
	global weight 
	
	*plot graph
	preserve
	regsave, ci level(95)

	keep if regexm(var, "d")

	gen line_num = 1 if var=="d1_${qual}" | var=="d2_${qual}" | var=="d4_${qual}" | var=="d5_${qual}" | var=="d6_${qual}" | var=="d7_${qual}"
	replace line_num = 2 if var=="d1_bcwc" | var=="d2_bcwc" | var=="d4_bcwc" | var=="d5_bcwc" | var=="d6_bcwc" | var=="d7_bcwc"

	replace var="2009" if var=="d1_${qual}"
	replace var="2010" if var=="d2_${qual}"
	replace var="2012" if var=="d4_${qual}"
	replace var="2013" if var=="d5_${qual}"
	replace var="2014" if var=="d6_${qual}"
	replace var="2015" if var=="d7_${qual}"

	replace var="2009" if var=="d1_bcwc"
	replace var="2010" if var=="d2_bcwc"
	replace var="2012" if var=="d4_bcwc"
	replace var="2013" if var=="d5_bcwc"
	replace var="2014" if var=="d6_bcwc"
	replace var="2015" if var=="d7_bcwc"


	destring var, replace force
	drop if var==.

	local nn=_N+2
	set obs `nn'
	replace var=2011 if var==. 
	replace coef = 0 if var==2011
	replace ci_upper = 0 if var==2011
	replace ci_lower = 0 if var==2011
	bysort var: gen temp = _n 
	replace line_num = temp if var==2011
	sort var



	graph twoway (rcap ci_upper ci_lower var if line_num==1, color(black) lpattern(dash)) ///
	(connected coef var if line_num==1, color(black) lpattern(solid)) ///
	(rcap ci_upper ci_lower var if line_num==2, color(red) lpattern(dash) msize(medlarge) ) ///
	(connected coef var if line_num==2, color(red) lpattern(dash)), ///
	xtitle("Year") xlabel(2009(1)2015, labsize(small)) ylabel(#10, labsize(small) angle(0) glcolor(gs16)) ///
	yline(0, lcolor(black)) ///
	xline(2011, lcolor(red)) graphregion(color(white)) plotregion(color(white)) ///
	legend(order(2 4) col(1) label(2 "Manager") label(4 "Blue/white collar")) //
	
	graph export "${directory_out}\figure_3_panel_B.pdf", replace		

	restore	
	
}



