********************************************************************************
*
*						Figure 2 - Replication
*
********************************************************************************


***********************************************
* BASELINE WAGE GROWTH RESULT 
***********************************************


use  "${data}\baseline_panel.dta", clear


*Keep imprese open thoughout the period
drop if sample_period_p_ft!=7


#delimit;
global out cambiamento_medio_ft_p ; //this is monthly wage growth for full-time permanent workers
#delimit cr


*time variable
gen time = 0
replace time = anno_riferimento - 2008
qui tab time, gen(t)
gen post = (anno_riferimento>=2012)

*gen treatment normalized (divide by total employment)
gen treat_norm = dyear_${sample}_firm_ft_p/bl_emp

*gen share ctr
gen sh_ctr = aff_${sample}_firm_ft_p/emp_ty
replace sh_ctr = 0 if sh_ctr==. 

*gen treat interaction
replace treat_norm = 0 if treat_norm == .
forvalues i = 1(1)7 {
		gen d`i' = t`i' * treat_norm
}
gen treat_post = post*treat_norm

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}

*global treatment
global treat_list d1 d2 d4 d5 d6 d7 
    

*encode codice_fiscale
egen temp = group(codice_fiscale)
rename codice_fiscale codice_fiscale_str
rename temp codice_fiscale


*************************
* Run regressions
*************************

*globals for sample restrictions 
global aff_sample 
global sr _sm
foreach y of global out {

	global controls ctrl

	reghdfe `y' ${treat_list} if bl_emp>=${lb_emp} & bl_emp<=${ub_emp} & ${reducing_sample} ${aff_sample} & bl_flag_single_matricola==1 & fflag_single_matricola_ty == 1 ///
	, absorb(i.codice_fiscale i.time ${contr_baseline} )  vce(cluster codice_fiscale)
	
	global nobs = e(N)
					
	sum `y' if e(sample)
	global ymean = round(r(mean), 0.01)
	estadd ysumm

					
	sum `y' if e(sample) & anno_riferimento <= 2011
	global ymean_prereform = round(r(mean), 0.01)
	di "${ymean_prereform}"
	
	bys codice_fiscale: gen cc_firm = _n
	sum treat_norm if e(sample) & cc_firm == 1
	global xmean  = round(r(mean), 0.01)
	global sdmean = round(r(sd), 0.01)
	drop cc_firm

	
	global outcome `y'
	global weight 
	
	

	
	
	*plot graph
	preserve
	regsave, ci level(95)

	keep if regexm(var, "d")

	replace var="2009" if var=="d1"
	replace var="2010" if var=="d2"
	replace var="2012" if var=="d4"
	replace var="2013" if var=="d5"
	replace var="2014" if var=="d6"
	replace var="2015" if var=="d7"

	destring var, replace force
	drop if var==.

	local nn=_N+1
	set obs `nn'
	replace var=2011 if var==. 
	replace coef = 0 if var==2011
	replace ci_upper = 0 if var==2011
	replace ci_lower = 0 if var==2011
	sort var



	graph twoway (rcap ci_upper ci_lower var, color(black) lpattern(dash)) ///
	(connected coef var, color(black) lpatter(solid)), ///
	xtitle("Year") xlabel(2009(1)2015, labsize(small)) ylabel(#10, labsize(small) angle(0) glcolor(gs16)) legend(off) ///
	yline(0, lcolor(black)) ///
	xline(2011, lcolor(red)) graphregion(color(white)) plotregion(color(white)) ///
	note("Firms between ${lb_emp} and ${ub_emp} employees." "N.obs = $nobs" "Mean outcome pre-reform = ${ymean_prereform}") //	
	graph export "${directory_out}\figure_2.pdf", replace	
	restore	

}

